/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.demo;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;

public class DemoReportListDataPlugin
extends AbstractReportListDataPlugin {
    private static final String BOS_FORM_CORE = "bos-form-core";
    private static final LocaleString width = new LocaleString("100px");
    private static final String CURRENCY_COLUMN = "currencyColumn";

    private static LocaleString getDebitAmt() {
        return ResManager.getLocaleString((String)"\u501f\u65b9", (String)"DemoReportListDataPlugin_0", (String)BOS_FORM_CORE);
    }

    private static LocaleString getCreditAmt() {
        return ResManager.getLocaleString((String)"\u8d37\u65b9", (String)"DemoReportListDataPlugin_1", (String)BOS_FORM_CORE);
    }

    private static LocaleString getEndAmt() {
        return ResManager.getLocaleString((String)"\u671f\u672b\u4f59\u989d", (String)"DemoReportListDataPlugin_2", (String)BOS_FORM_CORE);
    }

    private static LocaleString getForAmt() {
        return ResManager.getLocaleString((String)"\u539f\u5e01", (String)"DemoReportListDataPlugin_3", (String)BOS_FORM_CORE);
    }

    private static LocaleString getLocalAmt() {
        return ResManager.getLocaleString((String)"\u672c\u4f4d\u5e01", (String)"DemoReportListDataPlugin_4", (String)BOS_FORM_CORE);
    }

    private static LocaleString getRptAmt() {
        return ResManager.getLocaleString((String)"\u62a5\u544a\u5e01", (String)"DemoReportListDataPlugin_5", (String)BOS_FORM_CORE);
    }

    public DataSet query(ReportQueryParam queryParam, Object selectedObj) {
        ArrayList<Object> params = new ArrayList<Object>();
        FilterInfo filter = queryParam.getFilter();
        Long bookId = filter.getLong("book");
        Object accountPK = null;
        Object currencyPK = null;
        if (selectedObj instanceof DynamicObject) {
            DynamicObject selObj = (DynamicObject)selectedObj;
            accountPK = ((DynamicObject)selObj.get("account")).getPkValue();
            currencyPK = ((DynamicObject)selObj.get("currency")).getPkValue();
        }
        StringBuilder oql = new StringBuilder();
        oql.append("select id,booktype,period,account,currency,beginfor,beginlocal,debitfor,debitlocal,creditfor,creditlocal,endfor,endlocal from gl_balance ");
        if (bookId.doubleValue() != 0.0) {
            oql.append(" where book =? ");
            params.add(bookId);
            if (accountPK != null) {
                oql.append(" and account = ? ");
                params.add(accountPK);
            }
            if (currencyPK != null) {
                oql.append(" and currency = ? ");
                params.add(currencyPK);
            }
        }
        ORM orm = ORM.create();
        return orm.queryDataSet("gl.accountbalance.report", oql.toString(), params.toArray(new Object[0]));
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        ORM orm;
        DynamicObject book;
        Long bookId = this.getQueryParam().getFilter().getLong("book");
        int localScale = 2;
        int rptScale = 2;
        if (bookId.doubleValue() != 0.0 && (book = (orm = ORM.create()).getById("bd_accountbooks", (Object)bookId)) != null) {
            DynamicObject bookType;
            DynamicObject accpolice = (DynamicObject)book.get("accountingpolicie");
            DynamicObject localCurrency = (DynamicObject)(accpolice = orm.getById("gl_accountingpolicie", accpolice.getPkValue())).get("basecurrency");
            if (localCurrency != null && book != null) {
                localCurrency = orm.getById("bd_currency", book.getPkValue());
                localScale = (Integer)localCurrency.get("amtprecision");
            }
            if ((bookType = (DynamicObject)book.get("bookstype")) != null) {
                bookType = orm.getById("bd_accountbookstype", bookType.getPkValue());
                DynamicObject rptCurrency = (DynamicObject)bookType.get("reportcurrency");
                rptCurrency = orm.getById("bd_currency", rptCurrency.getPkValue());
                rptScale = (Integer)rptCurrency.get("amtprecision");
            }
        }
        ReportColumnGroup debitGroup = new ReportColumnGroup();
        debitGroup.setCaption(DemoReportListDataPlugin.getDebitAmt());
        columns.add((AbstractReportColumn)debitGroup);
        ReportColumn debitFor = new ReportColumn();
        debitFor.setCaption(DemoReportListDataPlugin.getForAmt());
        debitFor.setWidth(width);
        debitFor.setFieldKey("debitfor");
        debitFor.setFieldType("amount");
        debitFor.setCurrencyField(CURRENCY_COLUMN);
        debitGroup.getChildren().add(debitFor);
        ReportColumn debitLocal = new ReportColumn();
        debitLocal.setCaption(DemoReportListDataPlugin.getLocalAmt());
        debitLocal.setWidth(width);
        debitLocal.setFieldKey("debitlocal");
        debitLocal.setFieldType("decimal");
        debitLocal.setScale(localScale);
        debitGroup.getChildren().add(debitLocal);
        ReportColumn debitRpt = new ReportColumn();
        debitRpt.setCaption(DemoReportListDataPlugin.getRptAmt());
        debitRpt.setWidth(width);
        debitRpt.setFieldKey("debitrpt");
        debitRpt.setFieldType("decimal");
        debitRpt.setScale(rptScale);
        debitGroup.getChildren().add(debitRpt);
        ReportColumnGroup creditGroup = new ReportColumnGroup();
        creditGroup.setCaption(DemoReportListDataPlugin.getCreditAmt());
        columns.add((AbstractReportColumn)creditGroup);
        ReportColumn creditFor = new ReportColumn();
        creditFor.setCaption(DemoReportListDataPlugin.getForAmt());
        creditFor.setWidth(width);
        creditFor.setFieldKey("creditfor");
        creditFor.setFieldType("amount");
        creditFor.setCurrencyField(CURRENCY_COLUMN);
        creditGroup.getChildren().add(creditFor);
        ReportColumn creditLocal = new ReportColumn();
        creditLocal.setCaption(DemoReportListDataPlugin.getLocalAmt());
        creditLocal.setWidth(width);
        creditLocal.setFieldKey("creditlocal");
        creditLocal.setFieldType("decimal");
        creditLocal.setScale(localScale);
        creditGroup.getChildren().add(creditLocal);
        ReportColumn creditRpt = new ReportColumn();
        creditRpt.setCaption(DemoReportListDataPlugin.getRptAmt());
        creditRpt.setWidth(width);
        creditRpt.setFieldKey("creditrpt");
        creditRpt.setFieldType("decimal");
        creditRpt.setScale(rptScale);
        creditGroup.getChildren().add(creditRpt);
        ReportColumnGroup endGroup = new ReportColumnGroup();
        endGroup.setCaption(DemoReportListDataPlugin.getEndAmt());
        columns.add((AbstractReportColumn)endGroup);
        ReportColumn endFor = new ReportColumn();
        endFor.setCaption(DemoReportListDataPlugin.getForAmt());
        endFor.setWidth(width);
        endFor.setFieldKey("endfor");
        endFor.setFieldType("amount");
        endFor.setCurrencyField(CURRENCY_COLUMN);
        endGroup.getChildren().add(endFor);
        ReportColumn endlocal = new ReportColumn();
        endlocal.setCaption(DemoReportListDataPlugin.getLocalAmt());
        endlocal.setWidth(width);
        endlocal.setFieldKey("endlocal");
        endlocal.setFieldType("decimal");
        endlocal.setScale(localScale);
        endGroup.getChildren().add(endlocal);
        ReportColumn endRpt = new ReportColumn();
        endRpt.setCaption(DemoReportListDataPlugin.getRptAmt());
        endRpt.setWidth(width);
        endRpt.setFieldKey("endrpt");
        endRpt.setFieldType("decimal");
        endRpt.setScale(rptScale);
        endGroup.getChildren().add(endRpt);
        return columns;
    }
}

