/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.events;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFSheet;

@SdkPublic
public class MergeColumnRule
implements Serializable {
    private static final long serialVersionUID = -8623306967246267070L;
    private List<String> groupColumns = new ArrayList<String>(10);
    private List<String> mergeColumns = new ArrayList<String>(10);
    private Map<String, Object> lastValue;
    private Integer lastRowIndex;
    private Map<String, Integer> mergeColumnIndex = new HashMap<String, Integer>(this.mergeColumns.size());

    public MergeColumnRule() {
    }

    public MergeColumnRule(List<String> groupColumns, List<String> mergeColumns) {
        this.groupColumns = groupColumns;
        this.mergeColumns = mergeColumns;
    }

    public List<String> getGroupColumns() {
        return this.groupColumns;
    }

    public void addGroupColumn(String ... groupColumns) {
        for (String groupColumn : groupColumns) {
            this.groupColumns.add(groupColumn);
        }
    }

    public List<String> getMergeColumns() {
        return this.mergeColumns;
    }

    public void addMergeColumn(String ... mergeColumns) {
        for (String mergeColumn : mergeColumns) {
            this.mergeColumns.add(mergeColumn);
        }
    }

    @SdkInternal
    public void init() {
        this.lastValue = new HashMap<String, Object>(this.groupColumns.size());
        this.groupColumns.forEach(o -> this.lastValue.put((String)o, null));
    }

    @SdkInternal
    public void addMergedRegion(String col, Object value, int rowIndex, int columnIndex, SXSSFSheet sheet) {
        if (this.lastValue.containsKey(col)) {
            if (!this.isSameValue(this.lastValue.get(col), value)) {
                this.addMergeRegion(rowIndex, sheet);
                this.lastRowIndex = rowIndex;
                this.lastValue.put(col, value);
            } else if (this.lastRowIndex == null) {
                this.lastRowIndex = rowIndex;
            }
        }
        if (this.mergeColumns.contains(col)) {
            this.mergeColumnIndex.put(col, columnIndex);
        }
    }

    public void setBlank(SXSSFSheet sheet, int rowIndex, int columnIndex) {
        if (this.lastRowIndex != null && rowIndex - this.lastRowIndex > 0) {
            sheet.getRow(rowIndex).getCell(columnIndex).setBlank();
        }
    }

    @SdkInternal
    public void end(int rowIndex, SXSSFSheet sheet) {
        this.addMergeRegion(rowIndex, sheet);
    }

    private boolean isSameValue(Object oldValue, Object value) {
        if (oldValue == null && value == null) {
            return true;
        }
        if (oldValue != null && value != null) {
            return StringUtils.equals((CharSequence)oldValue.toString(), (CharSequence)value.toString());
        }
        return false;
    }

    private void addMergeRegion(Integer rowIndex, SXSSFSheet sheet) {
        if (this.lastRowIndex != null && rowIndex - this.lastRowIndex > 1) {
            for (String column : this.mergeColumns) {
                Integer columnIndex = this.mergeColumnIndex.get(column);
                if (columnIndex == null) continue;
                sheet.addMergedRegion(new CellRangeAddress(this.lastRowIndex.intValue(), rowIndex - 1, columnIndex.intValue(), columnIndex.intValue()));
            }
        }
    }
}

