/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.export;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.Task;
import kd.bos.service.KDDateUtils;

public class AutoDeleteReportFileTask
implements Task {
    private static Log logger = LogFactory.getLog(AutoDeleteReportFileTask.class);
    private String taskId;

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        String tableName = "t_bas_report_files_path";
        Date currentDate = new Date();
        int deleteBeforeHour = -2;
        if (params != null && StringUtils.isNotBlank((Object)params.get("deleteBeforeHour"))) {
            deleteBeforeHour = Integer.parseInt(params.get("deleteBeforeHour").toString());
        }
        if (deleteBeforeHour < 0 || deleteBeforeHour > 24) {
            deleteBeforeHour = -2;
        }
        Date beforeHourDate = KDDateUtils.addHours((Date)currentDate, (int)(-deleteBeforeHour));
        String sql = String.format("select top 10000 FID,FPATH from %s where FCREATETIME <=? and FISDELETED = ?", tableName);
        Object[] sqlParams = new SqlParameter[]{new SqlParameter(":FCREATETIME", 93, (Object)beforeHourDate), new SqlParameter(":FISDELETED", 1, (Object)"0")};
        HashMap<Object, String> paths = new HashMap<Object, String>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"AutoDeleteReportFileTask", (DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])sqlParams);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                paths.put(row.get("FID"), row.getString("FPATH"));
            }
        }
        ArrayList<String> deletePath = new ArrayList<String>(paths.size());
        ArrayList<String> notDeletePath = new ArrayList<String>(paths.size());
        HashSet notDeleteFileIds = new HashSet(paths.size());
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        for (Map.Entry data : paths.entrySet()) {
            String url = (String)data.getValue();
            try {
                if (!StringUtils.isNotBlank((CharSequence)url) || !fileService.exists(url)) continue;
                fileService.delete(url);
                deletePath.add(url);
            }
            catch (Exception e) {
                notDeletePath.add(url);
                notDeleteFileIds.add(data.getKey());
            }
        }
        if (!CollectionUtils.isEmpty(notDeletePath)) {
            logger.info(String.format("delete report file fail, total: %s, files: %s", notDeletePath.size(), Arrays.toString(notDeletePath.toArray())));
        }
        if (!CollectionUtils.isEmpty(deletePath)) {
            logger.info(String.format("delete report file, total: %s, files: %s", deletePath.size(), Arrays.toString(deletePath.toArray())));
        }
        Set<Object> allPath = paths.keySet();
        allPath.removeAll(notDeleteFileIds);
        this.updateDeletedStatus(allPath, currentDate);
        this.deleteRecord(currentDate);
    }

    private void updateDeletedStatus(Set<Object> idList, Date date) {
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        ArrayList<SqlParameter[]> params = new ArrayList<SqlParameter[]>(idList.size());
        String update = "update t_bas_report_files_path set FISDELETED = ?, FDELETETIME = ? where FID = ? ";
        for (Object id : idList) {
            SqlParameter[] sqlParams = new SqlParameter[]{new SqlParameter(":FISDELETED", 1, (Object)"1"), new SqlParameter(":FDELETETIME", 93, (Object)date), new SqlParameter(":FID", -5, id)};
            params.add(sqlParams);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)update, params);
    }

    private void deleteRecord(Date currentDate) {
        Date monthAgo = KDDateUtils.addMonths((Date)currentDate, (int)-1);
        String deleteSql = "delete from t_bas_report_files_path where FCREATETIME <=? and FISDELETED = ?";
        Object[] sqlParams = new SqlParameter[]{new SqlParameter(":FCREATETIME", 93, (Object)monthAgo), new SqlParameter(":FISDELETED", 1, (Object)"1")};
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)deleteSql, (Object[])sqlParams);
    }

    public void stop() throws KDException {
    }
}

