/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.export;

import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportBatchQueryInfo;
import kd.bos.entity.report.ReportSysPublicParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.export.ExportDataProvider;

public class ExportDataFromCache
implements ExportDataProvider {
    private static final Log log = LogFactory.getLog(ExportDataFromCache.class);
    private AbstractReportListModel listModel;
    private Boolean largeData;
    private int maxExportSize;
    private boolean isExceededExportLimit = false;

    public ExportDataFromCache(AbstractReportListModel listModel) {
        this.listModel = listModel;
    }

    @Override
    public DynamicObjectCollection getRowData(int startIndex, int length) {
        if (startIndex >= this.getMaxExportSize()) {
            this.isExceededExportLimit = true;
            return null;
        }
        int realLength = this.getMaxExportSize() - startIndex;
        if (realLength > length) {
            realLength = length;
        }
        return this.listModel.getRowData(startIndex, realLength);
    }

    @Override
    public boolean isLast(int currentCount) {
        return currentCount > this.getMaxExportSize() || currentCount >= this.listModel.getRowCount();
    }

    @Override
    public int getRowCount() {
        return this.listModel.getRowCount();
    }

    @Override
    public boolean isExceededExportLimit() {
        return this.isExceededExportLimit;
    }

    @Override
    public boolean isWriteFileByRedis() {
        return !this.isLargeData() && this.getRowCount() <= ExportDataFromCache.getExportFileBatchSize() && this.getRowCount() <= this.getMaxExportSize();
    }

    @Override
    public String getSheetName() {
        return "sheet1";
    }

    private boolean isLargeData() {
        if (this.largeData == null) {
            this.largeData = ((ReportBatchQueryInfo)this.listModel.getReportQueryParam().byBatchInfo()).isLargeData();
        }
        return this.largeData;
    }

    private static int getExportFileBatchSize() {
        return Integer.getInteger("bos.reportList.exportFileBatchSize", 1000000);
    }

    private int getMaxExportSize() {
        if (this.maxExportSize == 0) {
            Object size = ThreadCache.get((Object)"report_export_maxExportSize");
            this.maxExportSize = size instanceof Integer ? (Integer)size : ReportSysPublicParameter.getMaxExportLimit() * 10000;
        }
        return this.maxExportSize;
    }
}

