/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.export;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportExportDataResult;
import kd.bos.report.ReportList;
import kd.bos.report.export.ExportDataFromDataSet;

public class ExportDataFromDataSetWithSheet
extends ExportDataFromDataSet {
    private List<ReportExportDataResult> dataSetBySheet;
    private Map<String, Integer> sheetNameMap;
    private int current;

    @Override
    public DataSet getDataSet() {
        if (this.current >= this.dataSetBySheet.size() - 1) {
            return this.dataSet;
        }
        if (this.dataSet == null || !this.dataSet.hasNext()) {
            this.setNexSheetData(++this.current);
            return this.getDataSet();
        }
        return this.dataSet;
    }

    public ExportDataFromDataSetWithSheet(List<ReportExportDataResult> dataSet, MainEntityType entityType, List<ReportColumn> columns, String pageId, String ctrlId, ReportList reportList) {
        super(dataSet.get(0).getDataSet(), dataSet.get(0).getSheetName(), entityType, columns, pageId, ctrlId, reportList);
        String sheetName = dataSet.get(0).getSheetName();
        this.sheetNameMap = new HashMap<String, Integer>(dataSet.size());
        if (StringUtils.isBlank((CharSequence)sheetName)) {
            sheetName = "sheet";
        }
        this.sheetNameMap.put(sheetName, 1);
        this.dataSetBySheet = dataSet;
    }

    @Override
    public boolean moveToNextSheet() {
        do {
            if (this.isExceededExportLimit() || this.current >= this.dataSetBySheet.size() - 1) {
                return false;
            }
            this.setNexSheetData(++this.current);
        } while (this.dataSet == null || !this.dataSet.hasNext());
        if (this.readCount >= this.getMaxExportSize()) {
            this.isExceededExportLimit = true;
            return false;
        }
        return true;
    }

    private void setNexSheetData(int index) {
        Integer integer;
        ReportExportDataResult data = this.dataSetBySheet.get(index);
        this.dataSet = data.getDataSet();
        String sheetName = data.getSheetName();
        if (StringUtils.isBlank((CharSequence)sheetName)) {
            sheetName = "sheet";
            integer = this.sheetNameMap.getOrDefault(sheetName, 1);
        } else {
            integer = this.sheetNameMap.getOrDefault(sheetName, 0);
        }
        this.sheetNameMap.put(sheetName, integer + 1);
        if (integer > 0) {
            sheetName = sheetName + integer;
        }
        this.setSheetName(sheetName);
    }
}

