/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.api.BizAppService;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IFilterModel;
import kd.bos.entity.filter.BuildBaseDataPropertyQFiltersResult;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.format.CurrencyFormatObject;
import kd.bos.entity.format.DateFormatObject;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.NumberFormatObject;
import kd.bos.entity.format.TimeFormatObject;
import kd.bos.entity.list.column.DateColumnDesc;
import kd.bos.entity.list.column.DateTimeColumnDesc;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportBaseDataFilterInfo;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportFilterDefaultField;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.queryds.ReportFilterFieldConfig;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.export.IExportExcelOperate;
import kd.bos.filter.FilterSchemeService;
import kd.bos.filter.FilterSchemeUIProxy;
import kd.bos.filter.SchemeCodeType;
import kd.bos.form.BindingContext;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.SingleOrgContextHelper;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.RadioEdit;
import kd.bos.form.field.TimeRangeEdit;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.inte.api.IInteService;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.svc.attach.IAttachmentEdit;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.PermissionService;
import kd.bos.report.IReportView;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.events.QueryEvent;
import kd.bos.report.events.SearchEvent;
import kd.bos.report.filter.SearchListener;
import kd.bos.report.plugin.ReportViewPluginProxy;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.time.TimeService;
import kd.bos.util.JSONUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ReportFilter
extends Container
implements ICloseCallBack {
    private static final Log log = LogFactory.getLog(ReportFilter.class);
    private static final String FLEX_FILTER_CTRL = "entryentity";
    private static final String FLEX_FIELD = "flexfield";
    private static final String BOS_FORM_CORE = "bos-form-core";
    private static final String SELECT_SCHEME = "selectScheme";
    private static final String VALUE = "value";
    private static final String VALUEDESC = "valuedesc";
    private static final String REPORT_FILTER_8 = "ReportFilter_8";
    private static final String FIELD_NAME = "fieldName";
    private static final String ITEMS = "items";
    private static final String REPORT_MORE_FILTER_PANEl = "reportmorefilterpanelap";
    private static final String REPORT_COMM_FILTE_RPANEL = "reportcommfilterpanelap";
    private static final String ID = "id";
    private IReportCache reportCache;
    private String title;
    private String showFilterFields;
    private List<FilterScheme> filterSchemes;
    private List<SearchListener> searchListeners = new ArrayList<SearchListener>();
    private ReportFilterFieldConfig reportFilterFieldConfig = new ReportFilterFieldConfig();
    private boolean userConfiguration = false;
    private boolean filterMustInput = false;
    private List<ReportFilterDefaultField> defaultHiddenFields = new ArrayList<ReportFilterDefaultField>();

    private static String getDateConvertError() {
        return ResManager.loadKDString((String)"\u65e5\u671f\u65f6\u95f4\u8f6c\u6362\u5931\u8d25\u3002", (String)"ReportFilter_21", (String)BOS_FORM_CORE, (Object[])new Object[0]);
    }

    @ComplexPropertyAttribute
    public ReportFilterFieldConfig getReportFilterFieldConfig() {
        return this.reportFilterFieldConfig;
    }

    @SimplePropertyAttribute(name="FilterMustInput")
    @DefaultValueAttribute(value="false")
    public boolean isFilterMustInput() {
        return this.filterMustInput;
    }

    public void setFilterMustInput(boolean filterMustInput) {
        this.filterMustInput = filterMustInput;
    }

    public void setReportFilterFieldConfig(ReportFilterFieldConfig reportFilterFieldConfig) {
        this.reportFilterFieldConfig = reportFilterFieldConfig;
    }

    @SimplePropertyAttribute(name="UserConfiguration")
    @DefaultValueAttribute(value="false")
    public boolean isUserConfiguration() {
        return this.userConfiguration;
    }

    public void setUserConfiguration(boolean userConfiguration) {
        this.userConfiguration = userConfiguration;
    }

    @CollectionPropertyAttribute(name="DefaultHiddenFields", collectionItemPropertyType=ReportFilterDefaultField.class)
    public List<ReportFilterDefaultField> getDefaultHiddenFields() {
        return this.defaultHiddenFields;
    }

    public void setDefaultHiddenFields(List<ReportFilterDefaultField> defaultHiddenFields) {
        this.defaultHiddenFields = defaultHiddenFields;
    }

    public void addSearchListener(SearchListener l) {
        this.searchListeners.add(l);
    }

    private void setFlexFilter(FilterInfo filterInfo) {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(FLEX_FILTER_CTRL);
        if (dynamicObjectCollection != null) {
            filterInfo.setFlexFilterItems(this.getFlexFilter(dynamicObjectCollection));
        }
    }

    public void bindData(BindingContext bctx) {
        super.bindData(bctx);
        this.updateControlMeta();
    }

    private void updateControlMeta() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getKey());
        list.add(this.createClientConfig());
        this.clientViewProxy.addAction("updateControlMetadata", list);
    }

    @SdkInternal
    public Map<String, Object> createClientConfig() {
        List<Map<String, Object>> item;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.getKey() != null) {
            map.put(ID, this.getKey().toLowerCase());
        }
        if (FilterSchemeUIProxy.isNeedShareScheme()) {
            map.put("isNeedShareScheme", true);
        }
        if ((item = this.renderControl(null)) != null) {
            map.put(ITEMS, item);
        }
        return map;
    }

    private void getCommonFilterKeySet(Container control, Set<String> commonFilterKeySet) {
        List controls = control.getItems();
        for (Control c : controls) {
            if (c instanceof FieldEdit) {
                if (c instanceof DateRangeEdit) {
                    commonFilterKeySet.add(((DateRangeEdit)c).getStartDateFieldKey());
                    commonFilterKeySet.add(((DateRangeEdit)c).getEndDateFieldKey());
                    continue;
                }
                if (c instanceof TimeRangeEdit) {
                    commonFilterKeySet.add(((TimeRangeEdit)c).getStartDateFieldKey());
                    commonFilterKeySet.add(((TimeRangeEdit)c).getEndDateFieldKey());
                    continue;
                }
                if (c instanceof IAttachmentEdit) continue;
                commonFilterKeySet.add(c.getKey());
                continue;
            }
            if (!(c instanceof Container)) continue;
            this.getCommonFilterKeySet((Container)c, commonFilterKeySet);
        }
    }

    private boolean checkMustInput(IDataModel model) {
        if (this.isFilterMustInput()) {
            List controlList = this.getItems();
            HashSet<String> commonFilterKeySet = new HashSet<String>(16);
            for (Control control : controlList) {
                if (!StringUtils.equals((CharSequence)REPORT_COMM_FILTE_RPANEL, (CharSequence)control.getKey()) && !StringUtils.equals((CharSequence)REPORT_MORE_FILTER_PANEl, (CharSequence)control.getKey())) continue;
                this.getCommonFilterKeySet((Container)control, commonFilterKeySet);
            }
            if (!CollectionUtils.isEmpty(commonFilterKeySet)) {
                StringBuilder sb = new StringBuilder();
                Map dataEntityPropertyMap = model.getDataEntityType().getFields();
                for (Map.Entry entry : dataEntityPropertyMap.entrySet()) {
                    if (entry.getValue() instanceof FieldProp && ((FieldProp)entry.getValue()).getMustInputCondition() != null || !commonFilterKeySet.contains(entry.getKey()) || !this.isMustInput((IDataEntityProperty)entry.getValue())) continue;
                    Object obj = model.getValue((String)entry.getKey());
                    if (entry.getValue() instanceof BasedataProp && obj instanceof DynamicObject) {
                        obj = ((DynamicObject)obj).get(ID);
                    }
                    if (!(entry.getValue() instanceof IValidatorHanlder) || !((IValidatorHanlder)entry.getValue()).getValueComparator().compareValue(obj)) continue;
                    sb.append("\u201c").append(((IDataEntityProperty)entry.getValue()).getDisplayName().toString()).append("\u201d").append("\u3001");
                }
                if (sb.length() > 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"ReportFilter_20", (String)BOS_FORM_CORE, (Object[])new Object[0]), sb.deleteCharAt(sb.length() - 1)));
                    return false;
                }
            }
        }
        return true;
    }

    private void addLog(AppLogInfo logInfo) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        logService.addLog(logInfo);
    }

    @SdkInternal
    public void search() {
        if (!this.hasRight()) {
            String msg = ResManager.loadResFormat((String)"\u65e0\u201c%1\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FormOperate_13", (String)BOS_FORM_CORE, (Object[])new Object[]{FormMetadataCache.getFormConfig((String)this.getView().getEntityId()).getCaption().toString()});
            this.getView().showErrorNotification(msg);
            AppLogInfo appLogInfo = new AppLogInfo();
            appLogInfo.setOpName("search");
            appLogInfo.setModifyBillNo("No_Query_Permission,Report_EntityId:" + this.getView().getEntityId());
            appLogInfo.setStatus("0");
            this.addLog(appLogInfo);
            return;
        }
        IFormView filerView = this.getView();
        IDataModel model = filerView.getModel();
        boolean isMustInput = this.checkMustInput(model);
        if (!isMustInput) {
            return;
        }
        ReportQueryParam reportParam = ReportCacheManager.getInstance().getCache().getReportQueryParam(filerView.getPageId());
        if (reportParam == null) {
            reportParam = new ReportQueryParam();
        }
        FilterInfo filterInfo = this.toFilterInfo();
        EntryProp entryProp = (EntryProp)model.getDataEntityType().getProperty(FLEX_FILTER_CTRL);
        if (entryProp != null) {
            this.setFlexFilter(filterInfo);
        }
        HashSet<String> keySet = new HashSet<String>();
        this.initFilterFieldKeySet(keySet, this);
        MainEntityType type = model.getDataEntityType();
        DataEntityPropertyCollection props = model.getDataEntityType().getProperties();
        ArrayList<String> illegalFiled = new ArrayList<String>(5);
        model.beginInit();
        for (IDataEntityProperty prop : type.getProperties()) {
            Object val;
            if (!keySet.contains(prop.getName()) || !props.containsKey((Object)prop.getName()) || this.isLegalData(prop, val = model.getValue(prop.getName()), this.getModel().getDataEntity())) continue;
            model.setValue(prop.getName(), null);
            illegalFiled.add(String.format("\u3010%s\u3011", prop.getDisplayName().toString()));
        }
        model.endInit();
        if (!CollectionUtils.isEmpty(illegalFiled)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8fc7\u6ee4\u5b57\u6bb5%s\u5b58\u5728\u65e0\u6743\u9009\u9879\uff0c\u5df2\u81ea\u52a8\u6e05\u9664\u3002", (String)"ReportFilter_14", (String)BOS_FORM_CORE, (Object[])new Object[0]), String.join((CharSequence)"\u3001", illegalFiled)));
            this.getView().updateView(this.getKey());
            return;
        }
        this.setDefaultQFilters(type, keySet, filterInfo);
        if (!reportParam.getFilter().getTableHeadFilterItems().isEmpty()) {
            filterInfo.setTableHeadFilterItems(reportParam.getFilter().getTableHeadFilterItems());
        }
        filterInfo.copyCol2ndFilterOption(reportParam.getFilter());
        reportParam.setReportFilterFieldConfig(this.getReportFilterFieldConfig());
        reportParam.setFilter(filterInfo);
        if (this.getView().getPageCache().get("DirectExportExcel") != null) {
            reportParam.getFilter().setCol2ndFilterOption("reportlistap", null);
        }
        for (SearchListener l : this.searchListeners) {
            SearchEvent evt = new SearchEvent((Object)this);
            evt.setRepotParam(reportParam);
            l.search(evt);
        }
        this.updateSearchCondition(filerView, model, filterInfo);
    }

    @SdkInternal
    public void exportExcelNoQuery() {
        try {
            if (((IReportView)this.getView()).isAsynQuery()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f02\u6b65\u67e5\u8be2\u6682\u4e0d\u652f\u6301\u6b64\u529f\u80fd\u3002", (String)"ReportFilter_22", (String)BOS_FORM_CORE, (Object[])new Object[0]));
            }
            boolean isMustInput = this.checkMustInput(this.getModel());
            if (!isMustInput) {
                return;
            }
            this.getView().getPageCache().put("DirectExportExcel", "exportExcelNoQuery");
            this.search();
            if (this.getView() instanceof IExportExcelOperate) {
                ((IExportExcelOperate)this.getView()).exportExcel();
            }
        }
        finally {
            this.getView().getPageCache().remove("DirectExportExcel");
        }
    }

    public ReportQueryParam getReportQueryParam() {
        ReportQueryParam reportParam = ReportCacheManager.getInstance().getCache().getReportQueryParam(this.getView().getPageId());
        if (reportParam == null) {
            reportParam = new ReportQueryParam();
        }
        FilterInfo filterInfo = this.toFilterInfo();
        reportParam.setReportFilterFieldConfig(this.getReportFilterFieldConfig());
        reportParam.setFilter(filterInfo);
        reportParam.setTreeReportList(Boolean.parseBoolean(this.getView().getPageCache().get("isTreeReportList")));
        return reportParam;
    }

    private boolean hasRight() {
        Boolean hasRight = (Boolean)this.getView().getFormShowParameter().getCustomParam("isHasRight");
        if (hasRight != null && hasRight.booleanValue()) {
            return true;
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        return permissionService.checkPermission(userId, this.getView().getFormShowParameter().getCheckRightAppId(), this.getView().getEntityId(), "47150e89000000ac");
    }

    @SdkInternal
    public void setSchemeList(List<FilterScheme> filterSchemes) {
        this.filterSchemes = filterSchemes;
    }

    @SdkInternal
    public void setDefaultScheme(String schemeId, boolean isDefault) {
        FilterSchemeUIProxy filterSchemeUIProxy = this.createFilterSchemeUIProxy();
        filterSchemeUIProxy.setDefaultScheme(schemeId, isDefault);
    }

    private FilterSchemeUIProxy createFilterSchemeUIProxy() {
        return new FilterSchemeUIProxy(this.view, this.getFilterModel(), this.getView().getEntityId(), this.getKey(), new HashMap(), this.getView().getEntityId());
    }

    @SdkInternal
    public void saveScheme(Map<String, String> param) {
        IFormView filerView = this.getView();
        IDataModel model = filerView.getModel();
        boolean isMustInput = this.checkMustInput(model);
        if (!isMustInput) {
            return;
        }
        param.put("schemeName", param.get("name"));
        HashMap<String, String> filterSchemeMap = new HashMap<String, String>(16);
        filterSchemeMap.putAll(param);
        FilterSchemeUIProxy filterSchemeUIProxy = this.createFilterSchemeUIProxy();
        filterSchemeUIProxy.saveScheme(filterSchemeMap, t -> this.clientViewProxy.invokeControlMethod(this.getKey(), SELECT_SCHEME, new Object[]{t.getSchemeId()}), t -> this.verifyAndPutSchemeToMap(filterSchemeMap));
    }

    private void verifyAndPutSchemeToMap(Map<String, Object> param) {
        DynamicObject filterObj = this.getView().getModel().getDataEntity();
        ReportQueryParam repotParam = new ReportQueryParam();
        FilterInfo filterInfo = this.toFilterInfo();
        EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().getProperty(FLEX_FILTER_CTRL);
        if (entryProp != null) {
            this.setFlexFilter(filterInfo);
        }
        this.setOtherEntryFilter(filterInfo);
        repotParam.setFilter(filterInfo);
        if (this.verifyScheme(repotParam)) {
            param.put("scheme", this.toJson(filterObj));
        }
    }

    private void setOtherEntryFilter(FilterInfo filterInfo) {
        ReportViewPluginProxy pluginProxy = this.getReportViewPluginProxy();
        if (pluginProxy != null) {
            pluginProxy.fireSetOtherEntryFilter(filterInfo);
        }
    }

    private void loadOtherEntryFilter(DynamicObject scheme) {
        ReportViewPluginProxy pluginProxy = this.getReportViewPluginProxy();
        if (pluginProxy != null) {
            pluginProxy.fireLoadOtherEntryFilter(scheme);
        }
    }

    @SdkInternal
    public void loadScheme(String id) {
        DynamicObjectCollection dynamicObjectCollection;
        IFilterModel filterModel = this.getFilterModel();
        FilterScheme filterScheme = filterModel.load(id);
        FilterSchemeUIProxy.checkFilterSchemeNull((FilterScheme)filterScheme);
        DynamicObject scheme = this.toDynamicObject(filterScheme);
        FilterInfo filter = new FilterInfo();
        EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().getProperty(FLEX_FILTER_CTRL);
        if (entryProp != null && (dynamicObjectCollection = scheme.getDynamicObjectCollection(FLEX_FILTER_CTRL)) != null) {
            filter.setFlexFilterItems(this.getFlexFilter(dynamicObjectCollection));
        }
        this.loadQuerySchemeData(scheme, filter);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.preInvokeControlMethod(this.getKey(), SELECT_SCHEME, new Object[]{id});
    }

    @SdkInternal
    public void deleteScheme(String id) {
        FilterSchemeUIProxy filterSchemeUIProxy = this.createFilterSchemeUIProxy();
        filterSchemeUIProxy.deleteScheme(id);
    }

    @SdkInternal
    public void shareScheme(String schemeId) {
        FilterSchemeUIProxy filterSchemeUIProxy = this.createFilterSchemeUIProxy();
        filterSchemeUIProxy.shareScheme(schemeId);
    }

    @SdkInternal
    public void updateShareScheme(String schemeId) {
        FilterSchemeUIProxy filterSchemeUIProxy = this.createFilterSchemeUIProxy();
        filterSchemeUIProxy.updateShareScheme(schemeId);
    }

    @SdkInternal
    public void closedCallBack(ClosedCallBackEvent e) {
        String[] actionIds = e.getActionId().split("\\$");
        if ("shareScheme".equals(actionIds[0])) {
            FilterScheme filterScheme = this.getFilterModel().getScheme(actionIds[1]);
            FilterSchemeUIProxy.checkFilterSchemeNull((FilterScheme)filterScheme);
            this.clientViewProxy.invokeControlMethod(this.getKey(), "updateScheme", new Object[]{FilterSchemeService.createSchemeMap((FilterScheme)filterScheme, (boolean)true, (SchemeCodeType)SchemeCodeType.JSON)});
        }
    }

    @SdkInternal
    public void loadQuerySchemeData(DynamicObject scheme, FilterInfo filterInfo) {
        HashSet<String> keySet = new HashSet<String>();
        this.initFilterFieldKeySet(keySet, this);
        IDataModel model = this.getModel();
        MainEntityType type = model.getDataEntityType();
        model.beginInit();
        DataEntityPropertyCollection props = scheme.getDynamicObjectType().getProperties();
        ArrayList<String> illegalFiled = new ArrayList<String>(5);
        ArrayList<IDataEntityProperty> propertyList = new ArrayList<IDataEntityProperty>(type.getProperties().size());
        for (IDataEntityProperty prop : type.getProperties()) {
            if (prop instanceof ItemClassProp) {
                propertyList.add(prop);
                continue;
            }
            this.setModelValue(prop, keySet, scheme, props, model, illegalFiled);
        }
        for (IDataEntityProperty prop : propertyList) {
            this.setModelValue(prop, keySet, scheme, props, model, illegalFiled);
        }
        model.endInit();
        if (!CollectionUtils.isEmpty(illegalFiled)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8fc7\u6ee4\u5b57\u6bb5%s\u5b58\u5728\u65e0\u6743\u9009\u9879\uff0c\u5df2\u81ea\u52a8\u6e05\u9664\u3002", (String)"ReportFilter_14", (String)BOS_FORM_CORE, (Object[])new Object[0]), String.join((CharSequence)"\u3001", illegalFiled)));
        }
        this.getView().updateView();
        ReportViewPluginProxy pluginProxy = this.getReportViewPluginProxy();
        if (pluginProxy != null) {
            pluginProxy.fireAfterSetModelValue(scheme);
        }
        this.loadFlexFilter(filterInfo, type, model);
        this.loadOtherEntryFilter(scheme);
    }

    private void setModelValue(IDataEntityProperty prop, Set<String> keySet, DynamicObject scheme, DataEntityPropertyCollection props, IDataModel model, List<String> illegalFiled) {
        if (keySet.contains(prop.getName()) && props.containsKey((Object)prop.getName())) {
            Object val = scheme.get(prop.getName());
            if (this.isLegalData(prop, val, scheme)) {
                model.setValue(prop.getName(), val);
            } else {
                scheme.set(prop.getName(), null);
                model.setValue(prop.getName(), null);
                illegalFiled.add(String.format("\u3010%s\u3011", prop.getDisplayName().toString()));
            }
        }
    }

    private void loadFlexFilter(FilterInfo filterInfo, MainEntityType entityType, IDataModel model) {
        if (filterInfo == null) {
            return;
        }
        List flexFilter = filterInfo.getFlexFilterItems();
        EntryProp entryProp = (EntryProp)entityType.getProperty(FLEX_FILTER_CTRL);
        if (entryProp != null) {
            model.deleteEntryData(FLEX_FILTER_CTRL);
            for (FilterItemInfo item : flexFilter) {
                DynamicObject asstType;
                String flex = item.getPropName();
                if (kd.bos.util.StringUtils.isEmpty((String)flex)) continue;
                Map asstTypes = BusinessDataReader.loadFromCache((String)"bd_asstacttype", (QFilter[])new QFilter(FLEX_FIELD, "=", (Object)flex).toArray());
                DynamicObject dynamicObject = asstType = asstTypes == null || asstTypes.isEmpty() ? null : (DynamicObject)asstTypes.entrySet().iterator().next().getValue();
                if (asstType == null) continue;
                String entityNumber = null;
                String valueType = asstType.getString("valuetype");
                if ("2".equals(valueType)) {
                    entityNumber = "bos_assistantdata_detail";
                } else if ("1".equals(valueType)) {
                    DynamicObject valueSource = asstType.getDynamicObject("valuesource");
                    if (valueSource == null) continue;
                    entityNumber = valueSource.getString(ID);
                }
                int rowIndex = model.createNewEntryRow(FLEX_FILTER_CTRL);
                model.setValue("fieldname", asstType.getPkValue(), rowIndex);
                DynamicProperty value = entryProp.getDynamicCollectionItemPropertyType().getProperty(VALUE);
                if (value instanceof MulBasedataProp) {
                    if (entityNumber == null) continue;
                    MulBasedataProp prop = (MulBasedataProp)entryProp.getDynamicCollectionItemPropertyType().getProperty(VALUE);
                    prop.setBaseEntityId(entityNumber);
                    BasedataProp baseProp = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
                    baseProp.setBaseEntityId(entityNumber);
                    baseProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber));
                    if (!(item.getValue() instanceof Set)) continue;
                    Set pkSet = (Set)item.getValue();
                    model.setValue(VALUE, (Object)pkSet.toArray(new Object[0]), rowIndex);
                    continue;
                }
                if (!(value instanceof TextProp) || !(item.getValue() instanceof Set)) continue;
                LinkedHashSet<String> pkSet = (LinkedHashSet<String>)item.getValue();
                if (pkSet == null || pkSet.isEmpty()) {
                    model.setValue(VALUE, (Object)"", rowIndex);
                    model.setValue(VALUEDESC, null, rowIndex);
                    continue;
                }
                String json = SerializationUtils.toJsonString((Object)pkSet);
                if (!"3".equals(valueType)) {
                    LinkedHashSet<String> list = new LinkedHashSet<String>();
                    ORM orm = ORM.create();
                    try (DataSet set = orm.queryDataSet("get_assist_name", entityNumber, "name", new QFilter(ID, "in", (Object)pkSet).toArray(), null);){
                        while (set.hasNext()) {
                            list.add(set.next().getString(0));
                        }
                    }
                    pkSet = list;
                }
                String str = ((Object)pkSet).toString().replace("[", "").replace("]", "").replace(",", ";");
                model.setValue(VALUE, (Object)str, rowIndex);
                model.setValue(VALUEDESC, (Object)json, rowIndex);
            }
        }
    }

    @SdkInternal
    public void loadQuerySchemeData(ReportQueryParam queryParam) {
        this.initFilterScheme();
        if (queryParam == null) {
            return;
        }
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject scheme = this.toDynamicObject(filterInfo);
        this.loadQuerySchemeData(scheme, filterInfo);
    }

    public void initDefaultQueryScheme() {
        FilterScheme defaultScheme = this.initFilterScheme();
        if (defaultScheme != null) {
            ReportShowParameter rptShowParam;
            DynamicObjectCollection dynamicObjectCollection;
            DynamicObject scheme = this.toDynamicObject(defaultScheme);
            FilterInfo filter = new FilterInfo();
            EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().getProperty(FLEX_FILTER_CTRL);
            if (entryProp != null && (dynamicObjectCollection = scheme.getDynamicObjectCollection(FLEX_FILTER_CTRL)) != null) {
                filter.setFlexFilterItems(this.getFlexFilter(dynamicObjectCollection));
            }
            if (filter.getFlexFilterItems().isEmpty()) {
                filter = null;
            }
            this.loadQuerySchemeData(scheme, filter);
            FormShowParameter shwoParam = this.getView().getFormShowParameter();
            if (shwoParam instanceof ReportShowParameter && (rptShowParam = (ReportShowParameter)shwoParam).getReportQueryParam() == null) {
                this.search();
            }
        } else {
            ReportViewPluginProxy pluginProxy = this.getReportViewPluginProxy();
            ReportQueryParam queryParam = new ReportQueryParam();
            FilterInfo filter = new FilterInfo();
            queryParam.setFilter(filter);
            if (pluginProxy != null) {
                pluginProxy.fireInitDefaultQueryParam(queryParam);
            }
            if (queryParam.getFilter() != null && !queryParam.getFilter().getFilterItems().isEmpty()) {
                this.loadQuerySchemeData(this.toDynamicObject(queryParam.getFilter()), filter);
            }
        }
    }

    private void initFilterFieldKeySet(Set<String> keySet, Container container) {
        for (Control control : container.getItems()) {
            if (control instanceof FieldEdit) {
                keySet.addAll(((FieldEdit)control).getFilterKeys());
                continue;
            }
            if (!(control instanceof Container)) continue;
            this.initFilterFieldKeySet(keySet, (Container)control);
        }
    }

    private String toJson(DynamicObject filterObj) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(filterObj.getDynamicObjectType());
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        binder.setOnlyDbProperty(false);
        String custFilter = jser.serializeToString((Object)filterObj, null);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("custfilters", custFilter);
        param.put("commfilters", this.getFilterConditions());
        return SerializationUtils.toJsonString(param);
    }

    private DynamicObject toDynamicObject(FilterScheme filterScheme) {
        String entityId = filterScheme.getFormId();
        String schemeJson = filterScheme.getScheme();
        Map filterMap = (Map)SerializationUtils.fromJsonString((String)schemeJson, HashMap.class);
        String custfilters = (String)filterMap.get("custfilters");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityId);
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        DynamicObject scheme = (DynamicObject)jser.deserializeFromString(custfilters, null);
        BusinessDataReader.loadRefence((Object[])new DynamicObject[]{scheme}, (IDataEntityType)type);
        Map commfilters = (Map)filterMap.get("commfilters");
        this.loadFilterConditions(commfilters);
        return scheme;
    }

    private DynamicObject toDynamicObject(FilterInfo filterInfo) {
        MainEntityType entityType = this.getModel().getDataEntityType();
        DynamicObject dynamicObj = (DynamicObject)entityType.createInstance();
        if (filterInfo == null) {
            return dynamicObj;
        }
        List items = filterInfo.getFilterItems();
        IDataModel model = this.getModel();
        for (FilterItemInfo item : items) {
            String propName = item.getPropName();
            DynamicProperty prop = entityType.getProperty(propName);
            if (prop == null) continue;
            this.setPropValue(model, dynamicObj, item, prop);
        }
        BusinessDataReader.loadRefence((Object[])new DynamicObject[]{dynamicObj}, (IDataEntityType)entityType);
        return dynamicObj;
    }

    private void setPropValue(IDataModel model, DynamicObject dynamicObj, FilterItemInfo item, DynamicProperty prop) {
        Object val = item.getValue();
        if (prop instanceof MulBasedataProp) {
            MulBasedataProp bdp = (MulBasedataProp)prop;
            if (val instanceof Long || val instanceof Integer || val instanceof String) {
                Object[] pks = new Object[]{val};
                bdp.setFieldValue(model, (Object)dynamicObj, (Object)pks);
            } else if (val instanceof DynamicObject) {
                DynamicObject obj = (DynamicObject)val;
                Object[] pks = new Object[]{obj.getPkValue()};
                bdp.setFieldValue(model, (Object)dynamicObj, (Object)pks);
            } else if (val instanceof Collection) {
                Collection coll = (Collection)val;
                Object[] pks = new Object[coll.size()];
                int i = 0;
                for (Object v : coll) {
                    if (v instanceof Long || v instanceof Integer || v instanceof String) {
                        pks[i] = v;
                    } else if (v instanceof DynamicObject) {
                        pks[i] = ((DynamicObject)v).getPkValue();
                    }
                    ++i;
                }
                bdp.setFieldValue(model, (Object)dynamicObj, (Object)pks);
            }
        } else if (prop instanceof BasedataProp) {
            BasedataProp bdp = (BasedataProp)prop;
            if (val instanceof Long || val instanceof Integer || val instanceof String) {
                bdp.getRefIdProp().setValue((Object)dynamicObj, (Object)Long.valueOf(val.toString()));
            } else if (val instanceof DynamicObject) {
                bdp.getRefIdProp().setValue((Object)dynamicObj, ((DynamicObject)val).getPkValue());
            }
        } else {
            prop.setValue((Object)dynamicObj, val);
        }
    }

    private FilterScheme initFilterScheme() {
        List<FilterScheme> schemeList = this.getSchemeList();
        List<FilterScheme> sharedSchemeList = this.getSharedSchemeList();
        FilterSchemeUIProxy filterSchemeUIProxy = this.createFilterSchemeUIProxy();
        filterSchemeUIProxy.loadSchemeList(this.filterSchemes, sharedSchemeList, true, SchemeCodeType.JSON);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter instanceof ReportShowParameter && ((ReportShowParameter)formShowParameter).isLinkQuery()) {
            return null;
        }
        FilterScheme filterScheme = FilterSchemeService.getDefaultSchemeFromAll(schemeList);
        if (filterScheme != null) {
            this.clientViewProxy.invokeControlMethod(this.getKey(), SELECT_SCHEME, new Object[]{filterScheme.getId()});
        }
        return filterScheme;
    }

    private void updateSearchCondition(IFormView filerView, IDataModel model, FilterInfo filter) {
        List<String> fields = this.getShowFilterFieldList();
        if (fields == null || fields.isEmpty()) {
            return;
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)filerView.getService(IClientViewProxy.class);
        SingleOrgContextHelper.createReportSearchConditionSingleOrgContext(fields, filerView);
        String msg = this.formatShowFilter(fields, model);
        String filterMsg = String.format(ResManager.loadKDString((String)"%s", (String)"ReportFilter_23", (String)BOS_FORM_CORE, (Object[])new Object[0]), msg);
        ReportViewPluginProxy pluginProxy = this.getReportViewPluginProxy();
        if (pluginProxy != null) {
            FormatShowFilterEvent evt = new FormatShowFilterEvent(this.getKey(), filter, filterMsg);
            pluginProxy.fireFormatDisplayFilterField(evt);
            filterMsg = evt.getFormatedFilterString();
        }
        this.getView().getPageCache().put("searchCondition", filterMsg);
        clientViewProxy.preInvokeControlMethod(this.getKey(), "updateSearchCondition", new Object[]{filterMsg});
    }

    private Object getValueDesc(Object dataEntity, Object value, IDataEntityProperty prop) {
        Object valDesc = "";
        if (value == null) {
            return valDesc;
        }
        if (prop instanceof BasedataProp || prop instanceof MulBasedataProp) {
            if (value instanceof ArrayList) {
                ArrayList<String> valueDescList = new ArrayList<String>();
                for (Object valueArray : (List)value) {
                    Object[] valArray = (Object[])valueArray;
                    String newValueDesc = null;
                    if (valArray.length >= 2) {
                        String string = newValueDesc = valArray[1] == null ? "" : valArray[1].toString();
                    }
                    if (!kd.bos.util.StringUtils.isNotEmpty(newValueDesc)) continue;
                    valueDescList.add(newValueDesc);
                }
                valDesc = String.join((CharSequence)";", valueDescList);
            } else {
                Object[] valArray = (Object[])value;
                if (valArray.length >= 2) {
                    valDesc = valArray[1] == null ? "" : valArray[1].toString();
                }
            }
        } else if (prop instanceof ComboProp) {
            valDesc = ((ComboProp)prop).getItemByName(value.toString());
        } else if (prop instanceof DateProp) {
            DateProp dateProp = (DateProp)prop;
            try {
                DateColumnDesc colDesc = new DateColumnDesc(this.getKey(), dateProp, (IDataEntityProperty)dateProp);
                colDesc.setUserFormat(this.getFormat());
                colDesc.setDisplayFormatString(dateProp.getDisplayFormatString());
                colDesc.setMask(dateProp.getMask());
                if (dataEntity instanceof DynamicObject) {
                    Object newVal = colDesc.getValue((DynamicObject)dataEntity);
                    if (newVal instanceof Object[]) {
                        Object[] valArray = (Object[])newVal;
                        valDesc = valArray[0];
                    }
                    valDesc = newVal;
                }
                valDesc = dateProp.format(dataEntity, value instanceof Date ? (Date)value : dateProp.parse(dataEntity, value.toString()));
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)ReportFilter.getDateConvertError(), (String)REPORT_FILTER_8, (String)BOS_FORM_CORE, (Object[])new Object[0])), new Object[0]);
            }
        } else if (prop instanceof DateTimeProp) {
            DateTimeProp dateTimeProp = (DateTimeProp)prop;
            try {
                DateTimeColumnDesc colDesc = new DateTimeColumnDesc(this.getKey(), dateTimeProp, (IDataEntityProperty)dateTimeProp);
                colDesc.setUserFormat(this.getFormat());
                colDesc.setDisplayFormatString(dateTimeProp.getDisplayFormatString());
                colDesc.setMask(dateTimeProp.getMask());
                if (dataEntity instanceof DynamicObject) {
                    Object newVal = colDesc.getValue((DynamicObject)dataEntity);
                    if (newVal instanceof Object[]) {
                        Object[] valArray = (Object[])newVal;
                        valDesc = valArray[0];
                    }
                    valDesc = newVal;
                }
                valDesc = dateTimeProp.format(dataEntity, value instanceof Date ? (Date)value : dateTimeProp.parse(dataEntity, value.toString()));
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)ReportFilter.getDateConvertError(), (String)REPORT_FILTER_8, (String)BOS_FORM_CORE, (Object[])new Object[0])), new Object[0]);
            }
        } else if (prop instanceof TimeProp) {
            TimeProp timeProp = (TimeProp)prop;
            try {
                valDesc = timeProp.getBasePropDisplayValue((Object)((DynamicObject)dataEntity));
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)ReportFilter.getDateConvertError(), (String)REPORT_FILTER_8, (String)BOS_FORM_CORE, (Object[])new Object[0])), new Object[0]);
            }
        } else {
            valDesc = prop instanceof BooleanProp ? (Boolean.parseBoolean(value.toString()) ? ResManager.loadKDString((String)"\u662f", (String)"ReportFilter_9", (String)BOS_FORM_CORE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ReportFilter_10", (String)BOS_FORM_CORE, (Object[])new Object[0])) : value;
        }
        return valDesc;
    }

    private FormatObject getFormat() {
        String fmt;
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        Map userFormat = inteService.getUserFormat(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        FormatObject result = new FormatObject();
        Map numberFormat = (Map)userFormat.get("numberFormat");
        Map timeFormat = (Map)userFormat.get("timeFormat");
        Map currencyFormat = (Map)userFormat.get("currencyFormat");
        if (!numberFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)numberFormat);
            result.setNumberFormat((NumberFormatObject)SerializationUtils.fromJsonString((String)fmt, NumberFormatObject.class));
        }
        if (!timeFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)timeFormat);
            result.setTimeFormat((TimeFormatObject)SerializationUtils.fromJsonString((String)fmt, TimeFormatObject.class));
        }
        if (!currencyFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)currencyFormat);
            result.setCurrencyFormat((CurrencyFormatObject)SerializationUtils.fromJsonString((String)fmt, CurrencyFormatObject.class));
        }
        result.setDateFormat(new DateFormatObject(userFormat.get("dateFormat").toString()));
        return result;
    }

    private String formatShowFilter(List<String> fields, IDataModel model) {
        StringBuilder msg = new StringBuilder();
        BindingContext bindingContext = new BindingContext((Object)model.getDataEntity());
        for (String field : fields) {
            Object valDesc;
            FieldEdit fieldEdit = (FieldEdit)this.getView().getControl(field);
            if (fieldEdit == null) continue;
            Object value = fieldEdit.getBindingValue(bindingContext);
            String displayName = "";
            if (fieldEdit instanceof DateRangeEdit) {
                DateRangeEdit dateRangeEdit = (DateRangeEdit)fieldEdit;
                valDesc = this.getDateFormatShowFilterMsg(bindingContext.getDataEntity(), value, dateRangeEdit.getStartDateFieldKey(), dateRangeEdit.getEndDateFieldKey());
            } else if (fieldEdit instanceof TimeRangeEdit) {
                TimeRangeEdit timeRangeEdit = (TimeRangeEdit)fieldEdit;
                valDesc = this.getDateFormatShowFilterMsg(bindingContext.getDataEntity(), value, timeRangeEdit.getStartDateFieldKey(), timeRangeEdit.getEndDateFieldKey());
            } else {
                if (fieldEdit instanceof DateTimeEdit) {
                    DateTimeProp property = (DateTimeProp)fieldEdit.getProperty();
                    property.setDisplayFormatString(((DateTimeEdit)fieldEdit).getDisplayFormatString());
                    property.setMask(((DateTimeEdit)fieldEdit).getMask());
                }
                valDesc = this.getValueDesc(bindingContext.getDataEntity(), value, fieldEdit.getProperty());
                String propDisplayName = ((DynamicProperty)fieldEdit.getProperty()).getDisplayName().toString();
                displayName = String.format(ResManager.loadKDString((String)"%s\uff1a", (String)"ReportFilter_15", (String)BOS_FORM_CORE, (Object[])new Object[0]), propDisplayName);
            }
            if (valDesc == null || !kd.bos.util.StringUtils.isNotEmpty((String)valDesc.toString())) continue;
            if (msg.length() > 0) {
                msg.append(";  ");
            }
            msg.append(displayName).append(valDesc);
        }
        return msg.toString();
    }

    private Object getDateFormatShowFilterMsg(Object dataEntity, Object value, String startDateFieldKey, String endDateFieldKey) {
        String msg = "";
        IDataEntityProperty beginProp = ((IDataModel)this.view.getService(IDataModel.class)).getProperty(startDateFieldKey);
        Object beginDesc = this.getValueDesc(dataEntity, value, beginProp);
        IDataEntityProperty endProp = ((IDataModel)this.view.getService(IDataModel.class)).getProperty(endDateFieldKey);
        Object endDesc = this.getValueDesc(dataEntity, value, endProp);
        if (beginDesc != null && kd.bos.util.StringUtils.isNotEmpty((String)beginDesc.toString()) && endDesc != null && kd.bos.util.StringUtils.isNotEmpty((String)endDesc.toString())) {
            String beginStr = new LocaleString(ResManager.loadKDString((String)".\u5f00\u59cb", (String)"DateRangeField_0", (String)"bos-metadata", (Object[])new Object[0])).getLocaleValue();
            String str = ((DynamicProperty)beginProp).getDisplayName().getLocaleValue().replace(beginStr, "");
            msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u3010%2$s  %3$s\u3011", (String)"ReportFilter_16", (String)BOS_FORM_CORE, (Object[])new Object[0]), str, beginDesc, endDesc);
        }
        return msg;
    }

    private List<String> getShowFilterFieldList() {
        try {
            if (!kd.bos.util.StringUtils.isEmpty((String)this.showFilterFields)) {
                return (List)JSONUtils.cast((String)this.showFilterFields, ArrayList.class, (Class[])new Class[]{String.class});
            }
        }
        catch (Exception ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
        return null;
    }

    private boolean verifyScheme(ReportQueryParam repotParam) {
        ReportViewPluginProxy pluginProxy = this.getReportViewPluginProxy();
        if (pluginProxy != null) {
            QueryEvent queryEvt = new QueryEvent();
            queryEvt.setQueryParam(repotParam);
            pluginProxy.fireVerifyQuery(queryEvt);
            if (queryEvt.isCancel()) {
                return false;
            }
        }
        return true;
    }

    private ReportViewPluginProxy getReportViewPluginProxy() {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        if (pluginProxy instanceof ReportViewPluginProxy) {
            return (ReportViewPluginProxy)pluginProxy;
        }
        return null;
    }

    @SdkInternal
    protected List<FilterScheme> getSchemeList() {
        if (this.filterSchemes == null) {
            IFilterModel filterModel = this.getFilterModel();
            filterModel.setFormId(this.getView().getEntityId());
            this.filterSchemes = filterModel.getSchemeList();
        }
        return this.filterSchemes;
    }

    private List<FilterScheme> getSharedSchemeList() {
        IFilterModel filterModel = this.getFilterModel();
        filterModel.setFormId(this.getView().getEntityId());
        return filterModel.getSharedSchemeList();
    }

    private List<FilterItemInfo> getFlexFilter(DynamicObjectCollection dynamicObjectCollection) {
        ArrayList<FilterItemInfo> filterItemInfos = new ArrayList<FilterItemInfo>();
        if (dynamicObjectCollection != null) {
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                Iterator filterItemInfo;
                Object val;
                DynamicObject assisType = dynamicObject.getDynamicObject("fieldname");
                if (assisType == null) continue;
                String flexfield = assisType.getString(FLEX_FIELD);
                IDataEntityProperty valueType = (IDataEntityProperty)dynamicObject.getDataEntityType().getProperties().get((Object)VALUE);
                if (valueType instanceof TextProp) {
                    val = new HashSet();
                    String valueDesc = dynamicObject.getString(VALUEDESC);
                    if (!kd.bos.util.StringUtils.isEmpty((String)valueDesc)) {
                        val = (Set)SerializationUtils.fromJsonString((String)valueDesc, Set.class);
                    }
                    filterItemInfo = this.getFlexFilterItemInfo(flexfield, (Set<Object>)val, dynamicObject);
                    filterItemInfos.add((FilterItemInfo)filterItemInfo);
                    continue;
                }
                val = dynamicObject.get(VALUE);
                HashSet<Object> pkSet = new HashSet<Object>();
                if (val instanceof DynamicObjectCollection) {
                    for (DynamicObject obj : (DynamicObjectCollection)val) {
                        pkSet.add(obj.get("fbasedataid_id"));
                    }
                } else if (val instanceof DynamicObject) {
                    pkSet.add(((DynamicObject)val).getPkValue());
                } else if (val != null) {
                    pkSet.add(val);
                }
                filterItemInfo = this.getFlexFilterItemInfo(flexfield, pkSet, dynamicObject);
                filterItemInfos.add((FilterItemInfo)filterItemInfo);
            }
        }
        return filterItemInfos;
    }

    protected FilterItemInfo getFlexFilterItemInfo(String flexfield, Set<Object> val, DynamicObject row) {
        return new FilterItemInfo(flexfield, val, "in");
    }

    private FilterInfo toFilterInfo() {
        FilterInfo filter = new FilterInfo();
        ArrayList<FieldEdit> fieldList = new ArrayList<FieldEdit>();
        ArrayList<FilterGrid> filterGridList = new ArrayList<FilterGrid>();
        this.findFilterField(this, fieldList, filterGridList);
        for (FieldEdit fieldEdit : fieldList) {
            filter.addDefaultFilters(fieldEdit.getDefaultFilters());
        }
        ITimeService timeService = (ITimeService)this.getView().getService(ITimeService.class);
        IUserService userService = (IUserService)this.getView().getService(IUserService.class);
        for (FilterGrid f : filterGridList) {
            if (f.getEntityNumber() == null) continue;
            filter.addCommFilter(f.getEntityNumber(), f.getFilterGridState().getFilterCondition(), timeService, userService);
        }
        return filter;
    }

    private Map<String, String> getFilterConditions() {
        HashMap<String, String> conds = new HashMap<String, String>(16);
        ArrayList<FilterGrid> filterGridList = new ArrayList<FilterGrid>();
        ArrayList<FieldEdit> fieldList = new ArrayList<FieldEdit>();
        this.findFilterField(this, fieldList, filterGridList);
        for (FilterGrid f : filterGridList) {
            FilterCondition cond = f.getFilterGridState().getFilterCondition();
            conds.put(f.getKey(), this.toJson(cond));
        }
        return conds;
    }

    private void loadFilterConditions(Map<String, String> conds) {
        for (Map.Entry<String, String> entry : conds.entrySet()) {
            String ctrlId = entry.getKey();
            String condJson = entry.getValue();
            FilterCondition cond = this.toFilterCondition(condJson);
            FilterGrid grid = (FilterGrid)this.getView().getControl(ctrlId);
            if (grid == null) continue;
            grid.SetValue(cond);
        }
    }

    private String toJson(FilterCondition cond) {
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        return ser.serializeToString((Object)cond, null);
    }

    private FilterCondition toFilterCondition(String json) {
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        return (FilterCondition)ser.deserializeFromString(json, null);
    }

    private void findFilterField(Container cont, List<FieldEdit> fieldList, List<FilterGrid> filterGridList) {
        for (Control ctrl : cont.getItems()) {
            if (ctrl instanceof FieldEdit) {
                fieldList.add((FieldEdit)ctrl);
                continue;
            }
            if (ctrl instanceof FilterGrid) {
                filterGridList.add((FilterGrid)ctrl);
                continue;
            }
            if (!(ctrl instanceof Container) || ctrl instanceof EntryGrid) continue;
            this.findFilterField((Container)ctrl, fieldList, filterGridList);
        }
    }

    @SimplePropertyAttribute
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @SimplePropertyAttribute(name="ShowFilterFields")
    public String getShowFilterFields() {
        return this.showFilterFields;
    }

    public void setShowFilterFields(String showFilterFields) {
        this.showFilterFields = showFilterFields;
    }

    private IFilterModel getFilterModel() {
        IFilterModel filterModel = (IFilterModel)TypesContainer.createInstance((String)"kd.bos.filter.FilterModel");
        filterModel.setFormId(this.view.getEntityId());
        return filterModel;
    }

    public void reset(Map<String, Object> map) {
        String schemeId;
        String string = schemeId = map.get("schemeId") == null ? "" : map.get("schemeId").toString();
        if (kd.bos.util.StringUtils.isBlank((String)schemeId)) {
            this.getView().invokeOperation("reset");
            this.resetFilterGrid(this.getItems());
        } else {
            this.loadScheme(schemeId);
        }
    }

    private AppLogInfo buildLogInfo(String msg, Long orgId) {
        AppInfo appInfo;
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        String appNumber = this.getView().getFormShowParameter().getAppId();
        String appId = "";
        if (kd.bos.util.StringUtils.isNotEmpty((String)appNumber) && null != (appInfo = AppMetadataCache.getAppInfo((String)appNumber))) {
            appId = appInfo.getId();
        }
        if (kd.bos.util.StringUtils.isBlank((String)appId)) {
            BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
            appId = bizAppService.getAppIdByFormNum(this.getView().getEntityId());
        }
        logInfo.setBizAppID(appId);
        logInfo.setBizObjID(this.getView().getEntityId());
        if (orgId != null && Long.compare(0L, orgId) != 0) {
            logInfo.setOrgID(orgId);
        } else {
            logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        }
        TimeService timeService = new TimeService();
        logInfo.setOpTime(timeService.getCurrentSystemTime());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(ResManager.loadKDString((String)"\u67e5\u8be2", (String)"ReportFilter_12", (String)BOS_FORM_CORE, (Object[])new Object[0]));
        logInfo.setOpDescription(msg);
        return logInfo;
    }

    @SdkInternal
    public void getReportFilterConfig() {
        HashMap<String, ReportFilterDefaultField> defaultFieldsMap = new HashMap();
        if (!CollectionUtils.isEmpty(this.getDefaultHiddenFields())) {
            defaultFieldsMap = this.getDefaultHiddenFields().stream().collect(Collectors.toMap(ReportFilterDefaultField::getFieldKey, Function.identity()));
        }
        ArrayList<FieldEdit> filterField = new ArrayList<FieldEdit>(16);
        this.getFilterField(this.getItems(), filterField, new HashMap<String, String>(16));
        List<Map<String, Object>> rows = this.createCommonFilterConfig(filterField, defaultFieldsMap);
        HashMap<String, List<Map<String, Object>>> factoryConfig = new HashMap<String, List<Map<String, Object>>>(2);
        factoryConfig.put("rows", rows);
        HashMap<String, Map<String, Object>> reportFilterConfig = new HashMap<String, Map<String, Object>>(2);
        reportFilterConfig.put("user", this.getFilterCurrUserSetting());
        reportFilterConfig.put("factory", factoryConfig);
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setReportFilterConfig", new Object[]{reportFilterConfig});
    }

    @SdkInternal
    public void setReportFilterConfig(Map<String, Object> commonFilterConfig) {
        List<Map<String, Object>> items;
        String setting = SerializationUtils.toJsonString(commonFilterConfig);
        long currUserId = RequestContext.getOrCreate().getCurrUserId();
        if (!this.getModel().setCurrUserSetting(currUserId, this.getReportFilterConfigKey(), setting)) {
            log.info(String.format("setCommonFilterConfig has failed,key:%s,userId:%s,setting:%s", this.getReportFilterConfigKey(), currUserId, setting));
        }
        if ((items = this.renderControl(commonFilterConfig)) == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        if (this.getKey() != null) {
            map.put(ID, this.getKey().toLowerCase());
        }
        map.put(ITEMS, items);
        ArrayList<Object> list = new ArrayList<Object>(2);
        list.add(this.getKey());
        list.add(map);
        this.clientViewProxy.addAction("updateControlMetadata", list);
    }

    private String getReportFilterConfigKey() {
        return this.view.getEntityId() + "_reportfilter";
    }

    private void getFilterField(List<Control> allFilterColumn, List<FieldEdit> filterField, Map<String, String> radioGroupField) {
        for (Control control : allFilterColumn) {
            if (control instanceof Container) {
                this.getFilterField(((Container)control).getItems(), filterField, radioGroupField);
                continue;
            }
            if (control instanceof RadioEdit && radioGroupField.containsKey(((RadioEdit)control).getGroup()) || !(control instanceof FieldEdit)) continue;
            filterField.add((FieldEdit)control);
            if (!(control instanceof ComboEdit)) continue;
            radioGroupField.put(control.getId(), control.getKey());
        }
    }

    private List<Map<String, Object>> createCommonFilterConfig(List<FieldEdit> filterField, Map<String, ReportFilterDefaultField> filterDefaultFieldMap) {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(filterField.size());
        for (FieldEdit field : filterField) {
            HashMap<String, Object> commonFilterConfig = new HashMap<String, Object>(4);
            ReportFilterDefaultField reportFilterDefaultField = filterDefaultFieldMap.get(field.getFieldKey());
            int userHide = this.isMustInput(field.getProperty()) || reportFilterDefaultField == null ? 0 : (reportFilterDefaultField.isUserHide() ? 1 : 0);
            commonFilterConfig.put("h", userHide);
            commonFilterConfig.put("v", userHide == 0 ? 1 : (reportFilterDefaultField != null && !reportFilterDefaultField.isInitialHide() ? 1 : 0));
            commonFilterConfig.put("n", field.getKey());
            commonFilterConfig.put("c", field.getProperty().getDisplayName());
            rows.add(commonFilterConfig);
        }
        return rows;
    }

    private boolean isMustInput(IDataEntityProperty property) {
        if (property instanceof FieldProp) {
            return ((FieldProp)property).isMustInput();
        }
        if (property instanceof BasedataProp) {
            return ((BasedataProp)property).isMustInput();
        }
        if (property instanceof MulBasedataProp) {
            return ((MulBasedataProp)property).isMustInput();
        }
        return false;
    }

    private Map<String, Object> getFilterCurrUserSetting() {
        String setting = this.getModel().getCurrUserSetting(this.getReportFilterConfigKey());
        if (kd.bos.util.StringUtils.isNotEmpty((String)setting)) {
            return (Map)SerializationUtils.fromJsonString((String)setting, Map.class);
        }
        return new HashMap<String, Object>(0);
    }

    private List<Map<String, Object>> renderControl(Map<String, Object> userFilterConfig) {
        HashMap<String, Integer> userFilter;
        if (!this.isUserConfiguration()) {
            return null;
        }
        if (CollectionUtils.isEmpty(userFilterConfig)) {
            userFilterConfig = this.getFilterCurrUserSetting();
        }
        if (CollectionUtils.isEmpty(userFilterConfig) && CollectionUtils.isEmpty(this.getDefaultHiddenFields())) {
            return null;
        }
        if (!CollectionUtils.isEmpty(userFilterConfig)) {
            List rows = (List)userFilterConfig.get("rows");
            userFilter = new HashMap(rows.size());
            for (Map row : rows) {
                userFilter.put(row.get("n").toString(), (Integer)row.get("v"));
            }
        } else {
            userFilter = new HashMap<String, Integer>(0);
        }
        List<Map<String, Object>> itemList = new ArrayList<Map<String, Object>>(1);
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String str = metadataService.loadFormRuntimeMeta(this.getView().getEntityId(), RuntimeMetaType.Form.getValue(), "ReportFilter");
        if (kd.bos.util.StringUtils.isBlank((String)str)) {
            return itemList;
        }
        String reportFilter = (String)((Map)SerializationUtils.fromJsonString((String)str, Map.class)).get("ReportFilterAp");
        Map reportFilterMap = (Map)SerializationUtils.fromJsonString((String)reportFilter, Map.class);
        itemList = (List)reportFilterMap.get(ITEMS);
        Map<Object, Object> defaultFieldsMap = !CollectionUtils.isEmpty(this.getDefaultHiddenFields()) ? this.getDefaultHiddenFields().stream().collect(Collectors.toMap(ReportFilterDefaultField::getFieldKey, Function.identity())) : new HashMap(0);
        this.resetFilterFieldByUserConfig(this.getItems(), itemList, defaultFieldsMap, userFilter);
        return itemList;
    }

    private List<Map<String, Object>> resetFilterFieldByUserConfig(List<Control> items, List<Map<String, Object>> metaList, Map<String, ReportFilterDefaultField> defaultFieldsMap, Map<String, Integer> userFilter) {
        if (CollectionUtils.isEmpty(items) || CollectionUtils.isEmpty(metaList)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> newMetaList = new ArrayList<Map<String, Object>>(metaList.size());
        Map itemKeysMap = metaList.stream().collect(Collectors.toMap(item -> item.get(ID).toString(), Function.identity()));
        for (Control item2 : items) {
            String key = item2.getKey();
            Map itemMap = (Map)itemKeysMap.get(key);
            if (itemMap == null) continue;
            if (item2 instanceof Container) {
                List<Map<String, Object>> newItemList = this.resetFilterFieldByUserConfig(((Container)item2).getItems(), (List)itemMap.get(ITEMS), defaultFieldsMap, userFilter);
                itemMap.put(ITEMS, newItemList);
            } else if (item2 instanceof FieldEdit) {
                ReportFilterDefaultField reportFilterDefaultField;
                Integer value;
                Object group;
                if (item2 instanceof RadioEdit && (group = ((Map)itemMap.get("item")).get("group")) != null) {
                    key = group.toString();
                }
                if ((value = userFilter.get(key)) != null ? value == 0 : (reportFilterDefaultField = defaultFieldsMap.get(key)) != null && reportFilterDefaultField.isInitialHide()) continue;
            }
            newMetaList.add(itemMap);
        }
        return newMetaList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isLegalData(IDataEntityProperty prop, Object value, DynamicObject scheme) {
        try (EntityTraceSpan span = EntityTracer.create((String)"reportFilter", (String)"isLegalData");){
            DynamicObjectType dt;
            DynamicObject data;
            span.addTag("prop", prop.getName());
            span.addLocaleTag(VALUE, value);
            span.addLocaleTag("scheme", (Object)scheme);
            QFilter idFilter = null;
            int currentCount = 0;
            if (prop instanceof BasedataProp && value instanceof DynamicObject) {
                data = (DynamicObject)value;
                BasedataProp basedataProp = (BasedataProp)prop;
                currentCount = 1;
                dt = (DynamicObjectType)basedataProp.getComplexType((Object)scheme);
                if (data.getPkValue() != null) {
                    idFilter = new QFilter(dt.getPrimaryKey().getName(), "=", data.getPkValue());
                }
            } else if (prop instanceof MulBasedataProp && value instanceof DynamicObjectCollection) {
                data = (DynamicObjectCollection)value;
                MulBasedataProp mulBasedataProp = (MulBasedataProp)prop;
                ArrayList<Object> pkList = new ArrayList<Object>(data.size());
                for (DynamicObject row : data) {
                    pkList.add(row.get(mulBasedataProp.getRefIdProp()));
                    ++currentCount;
                }
                dt = (DynamicObjectType)mulBasedataProp.getComplexType();
                if (!CollectionUtils.isEmpty(pkList)) {
                    idFilter = new QFilter(dt.getPrimaryKey().getName(), "in", pkList);
                }
            } else {
                boolean data2 = true;
                return data2;
            }
            span.addLocaleTag("idFilter", idFilter);
            if (idFilter == null) {
                boolean data2 = true;
                return data2;
            }
            List<QFilter> qFilters = this.getPermissionFilters(prop, scheme);
            if (qFilters == null || qFilters.size() == 0) {
                boolean mulBasedataProp = true;
                return mulBasedataProp;
            }
            qFilters.add(idFilter);
            ORM orm = ORM.create();
            int count = orm.count(((Object)((Object)this)).getClass().getName(), dt.getName(), dt.getPrimaryKey().getName(), qFilters.toArray(new QFilter[0]), (Distinctable)WithDistinctable.get());
            boolean bl = count == currentCount;
            return bl;
        }
        catch (Exception e) {
            log.error("ReportFilter.isLegalData() error", (Throwable)e);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<QFilter> getPermissionFilters(IDataEntityProperty prop, DynamicObject scheme) {
        try (EntityTraceSpan span = EntityTracer.create((String)"reportFilter", (String)"getPermissionFilters");){
            QFilter dataRuleFilter;
            QFilter baseDataPropertyQFilters;
            span.addTag("prop", prop.getName());
            if (!(prop instanceof IBasedataField)) {
                List<QFilter> list = null;
                return list;
            }
            String appId = this.getView().getFormShowParameter().getAppId();
            span.addTag("appId", appId);
            IBasedataField basedataProp = (IBasedataField)prop;
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
            BuildBaseDataPropertyQFiltersResult controlOrgFilter = FilterUtil.buildBaseDataPropertyQFiltersWithoutControlOrgFilter((IDataModel)this.getModel(), (IBasedataField)basedataProp, (String)appId, (String)this.getView().getFormShowParameter().getPermissionItemId());
            span.addLocaleTag("controlOrgFilter", (Object)controlOrgFilter.getQFilters());
            qFilters.addAll(controlOrgFilter.getQFilters());
            if (controlOrgFilter.isNeedControlOrgFilter() && (baseDataPropertyQFilters = this.buildBaseDataPropertyQFilters(basedataProp, scheme)) != null) {
                span.addLocaleTag("baseDataPropertyQFilters", (Object)baseDataPropertyQFilters);
                qFilters.add(baseDataPropertyQFilters);
            }
            if ((dataRuleFilter = this.getDataRuleForBdPropFilter(basedataProp, scheme)) != null) {
                span.addLocaleTag("dataRuleFilter", (Object)dataRuleFilter);
                qFilters.add(dataRuleFilter);
            }
            QFilter permissionFilter = null;
            if (kd.bos.util.StringUtils.isNotEmpty((String)basedataProp.getBaseEntityId())) {
                permissionFilter = PermissionFilterUtil.getSpecialDataPermissionFilter((String)appId, (String)basedataProp.getBaseEntityId(), (String)"view");
                qFilters.add(permissionFilter);
            }
            span.addLocaleTag("permissionFilter", permissionFilter);
            qFilters.removeIf(Objects::isNull);
            ArrayList<QFilter> arrayList = qFilters;
            return arrayList;
        }
        catch (Exception e) {
            log.error("ReportFilter.getPermissionFilters() error", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private QFilter getDataRuleForBdPropFilter(IBasedataField prop, DynamicObject scheme) {
        try (EntityTraceSpan span = EntityTracer.create((String)"reportFilter", (String)"getDataRuleForBdPropFilter");){
            IDataEntityType complexType;
            MainEntityType dataEntityType = this.getModel().getDataEntityType();
            span.addTag("orgProp", prop.getOrgProp());
            List<Long> orgIds = null;
            if (kd.bos.util.StringUtils.isEmpty((String)prop.getOrgProp())) {
                orgIds = this.getMainOrgIds(dataEntityType, scheme);
            } else {
                Long usedOrgId = this.getUsedOrgId(prop.getOrgProp(), scheme);
                if (usedOrgId != null) {
                    orgIds = new ArrayList<Long>(2);
                    orgIds.add(usedOrgId);
                }
            }
            span.addLocaleTag("orgIds", orgIds);
            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("isLookUp", true);
            if (prop instanceof ItemClassProp && (complexType = ((ItemClassProp)prop).getComplexType((Object)scheme)) != null) {
                customParams.put("itemClassType", complexType.getName());
                span.addLocaleTag("itemClassType", (Object)complexType.getName());
            }
            QFilter dataRuleFilter = permissionService.getDataRuleForBdProp(RequestContext.get().getCurrUserId(), this.getView().getFormShowParameter().getAppId(), (IDataEntityType)dataEntityType, prop.getName(), this.getView().getFormShowParameter().getPermissionItemId(), orgIds, customParams);
            span.addLocaleTag("dataRuleFilter", (Object)dataRuleFilter);
            QFilter qFilter = dataRuleFilter;
            return qFilter;
        }
        catch (Exception e) {
            log.warn("ReportFilter.getDataRuleForBdPropFilter", (Throwable)e);
            return null;
        }
    }

    private Long getUsedOrgId(String prop, DynamicObject scheme) {
        Object value;
        Long orgId = null;
        if (kd.bos.util.StringUtils.isNotEmpty((String)prop) && (value = scheme.get(prop + "_id")) != null) {
            orgId = (Long)value;
        }
        return orgId;
    }

    private List<Long> getMainOrgIds(MainEntityType dataEntityType, DynamicObject scheme) {
        ArrayList<Long> useOrgIds = null;
        try (EntityTraceSpan span = EntityTracer.create((String)"reportFilter", (String)"getMainOrgIds");){
            PermissionControlType pct = dataEntityType.getPermissionControlType();
            span.addLocaleTag("dataEntityType", (Object)dataEntityType);
            span.addLocaleTag("permissionControlType", (Object)pct);
            if (pct != null && !"DIM_NULL".equals(pct.getDimension()) && kd.bos.util.StringUtils.isNotEmpty((String)pct.getDataDimensionField())) {
                useOrgIds = new ArrayList<Long>(10);
                String dataDimensionField = pct.getDataDimensionField();
                Object value = scheme.get(dataDimensionField);
                if (value instanceof DynamicObjectCollection) {
                    DynamicObjectCollection collection = (DynamicObjectCollection)value;
                    for (DynamicObject dynamicObject : collection) {
                        useOrgIds.add(dynamicObject.getLong("fbasedataid_id"));
                    }
                } else if (value instanceof DynamicObject) {
                    Object pkValue = ((DynamicObject)value).getPkValue();
                    if (pkValue instanceof Long) {
                        useOrgIds.add((Long)pkValue);
                    }
                } else if (value instanceof Long) {
                    useOrgIds.add((Long)value);
                }
            }
        }
        catch (Exception e) {
            log.warn("ReportFilter.getMainOrgIds", (Throwable)e);
        }
        return useOrgIds;
    }

    private void resetFilterGrid(List<Control> items) {
        if (CollectionUtils.isEmpty(items)) {
            return;
        }
        for (Control item : items) {
            if (item instanceof FilterGrid) {
                ((FilterGrid)item).SetValue(new FilterCondition());
                continue;
            }
            if (!(item instanceof Container)) continue;
            this.resetFilterGrid(((Container)item).getItems());
        }
    }

    private QFilter buildBaseDataPropertyQFilters(IBasedataField basedataField, DynamicObject data) {
        try (EntityTraceSpan span = EntityTracer.create((String)"ReportFilter", (String)"buildBaseDataPropertyQFilters");){
            span.addTag("entityId", basedataField.getBaseEntityId());
            span.addTag("orgProp", basedataField.getOrgProp());
            Long usedOrgId = this.getUsedOrgId(basedataField.getOrgProp(), data);
            span.addLocaleTag("usedOrgId", (Object)usedOrgId);
            if (usedOrgId != null) {
                QFilter baseDataControlOrgQFilter;
                IBaseDataService baseDataService = (IBaseDataService)this.getModel().getService(IBaseDataService.class);
                QFilter qFilter = baseDataControlOrgQFilter = baseDataService.getLookUpListFilter(basedataField.getBaseEntityId(), usedOrgId, null);
                return qFilter;
            }
            QFilter qFilter = null;
            return qFilter;
        }
    }

    private void setDefaultQFilters(MainEntityType type, Set<String> filterFields, FilterInfo filterInfo) {
        try {
            for (IDataEntityProperty prop : type.getProperties()) {
                if (!filterFields.contains(prop.getName())) continue;
                Object val = this.getModel().getValue(prop.getName());
                if (!(prop instanceof IBasedataField) || val != null && (!(val instanceof MulBasedataDynamicObjectCollection) || !((MulBasedataDynamicObjectCollection)val).isEmpty())) continue;
                EntityTraceSpan span = EntityTracer.create((String)"reportFilter", (String)"setDefaultQFilters");
                Throwable throwable = null;
                try {
                    span.addTag("prop", prop.getName());
                    String entityNumber = ((IBasedataField)prop).getBaseEntityId(this.getModel());
                    span.addTag("entityNumber", entityNumber);
                    if (kd.bos.util.StringUtils.isBlank((String)entityNumber)) continue;
                    ArrayList<QFilter> permissionFilter = new ArrayList<QFilter>(10);
                    BuildBaseDataPropertyQFiltersResult controlOrgFilter = FilterUtil.buildBaseDataPropertyQFiltersWithoutControlOrgFilter((IDataModel)this.getModel(), (IBasedataField)((IBasedataField)prop), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getFormShowParameter().getPermissionItemId());
                    span.addLocaleTag("controlOrgFilter", (Object)controlOrgFilter.getQFilters());
                    permissionFilter.addAll(controlOrgFilter.getQFilters());
                    QFilter dataRuleFilter = this.getDataRuleForBdPropFilter((IBasedataField)prop, this.getModel().getDataEntity());
                    if (dataRuleFilter != null) {
                        permissionFilter.add(dataRuleFilter);
                        span.addLocaleTag("dataRuleFilter", (Object)dataRuleFilter);
                    }
                    permissionFilter.removeIf(Objects::isNull);
                    filterInfo.addBdRightQFilters(new ReportBaseDataFilterInfo(prop.getName(), entityNumber, permissionFilter));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
        catch (Exception e) {
            log.error("ReportFilter.setDefaultQFilters() error", (Throwable)e);
        }
    }
}

