/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.processor;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.report.ReportColumn;
import kd.bos.report.processor.IReportColumnProcessor;
import kd.bos.report.processor.RefPropProcessor;

public class ReportColumnProcessorFactory {
    private static Map<String, String> processorMap = new HashMap<String, String>();

    private ReportColumnProcessorFactory() {
        throw new IllegalStateException("Utility class");
    }

    public static IReportColumnProcessor createReportColumnProcessor(String columnType) {
        String className = processorMap.get(columnType);
        if (className == null) {
            className = processorMap.get("default");
        }
        return (IReportColumnProcessor)TypesContainer.createInstance((String)className);
    }

    public static IReportColumnProcessor createReportColumnProcessor(ReportColumn column) {
        IReportColumnProcessor processor = null;
        String fieldType = column.getFieldType();
        String className = processorMap.get(fieldType);
        if (className != null) {
            processor = (IReportColumnProcessor)TypesContainer.createInstance((String)className);
            processor.setReportColumn(column);
            return processor;
        }
        if (StringUtils.isNotBlank((CharSequence)column.getRefBasedataProp()) && column.getFieldProperty() instanceof IBasedataField) {
            processor = new RefPropProcessor();
            processor.setReportColumn(column);
            return processor;
        }
        className = processorMap.get("default");
        return (IReportColumnProcessor)TypesContainer.createInstance((String)className);
    }

    static {
        String prefix = "kd.bos.report.processor.";
        String textProcessor = "TextProcessor";
        String defaultProcessor = "DefaultProcessor";
        String dateProcessor = "DateProcessor";
        String enumProcessor = "EnumProcessor";
        String numberProcessor = "NumberProcessor";
        processorMap.put("text", prefix + textProcessor);
        processorMap.put("basedata", prefix + textProcessor);
        processorMap.put("user", prefix + textProcessor);
        processorMap.put("currency", prefix + textProcessor);
        processorMap.put("unit", prefix + textProcessor);
        processorMap.put("decimal", prefix + numberProcessor);
        processorMap.put("amount", prefix + numberProcessor);
        processorMap.put("qty", prefix + numberProcessor);
        processorMap.put("price", prefix + numberProcessor);
        processorMap.put("integer", prefix + numberProcessor);
        processorMap.put("date", prefix + dateProcessor);
        processorMap.put("boolean", prefix + enumProcessor);
        processorMap.put("checkbox", prefix + enumProcessor);
        processorMap.put("combofield", prefix + enumProcessor);
        processorMap.put("picture", prefix + defaultProcessor);
        processorMap.put("flex", prefix + defaultProcessor);
        processorMap.put("formula", prefix + defaultProcessor);
        processorMap.put("default", prefix + defaultProcessor);
    }
}

