/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.selection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportList;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class ReportRowSelectWrapper {
    private static final String SELECT_ROWS = "selRows";
    private static final String NOT_SELECT_ROWS = "notSelRows";
    private static final String CONTROL_STATES = "controlstates";
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private ReportList reportList;
    private List<RowClickEventListener> rowClickEventListeners;
    private IClientViewProxy clientViewProxy;

    public ReportRowSelectWrapper(ReportList reportList, IClientViewProxy clientViewProxy) {
        this.reportList = reportList;
        this.clientViewProxy = clientViewProxy;
        this.rowClickEventListeners = reportList.getReportListProxy().getRowClickListeners();
    }

    @SdkInternal
    public void selectAllRows() {
        AbstractGrid.GridState entryState = this.reportList.getEntryState();
        entryState.put("selDatas", null);
        entryState.put(SELECT_ROWS, new ArrayList(0));
        entryState.put(NOT_SELECT_ROWS, new ArrayList(0));
        entryState.setSelectAllRows(true);
        this.saveEntryStates(entryState.getState());
        HashMap<String, Integer> selectedDataInfo = new HashMap<String, Integer>(1);
        int totalCount = this.reportList.getReportModel().getRowCount();
        selectedDataInfo.put("selectedRowsCount", totalCount);
        this.clientViewProxy.invokeControlMethod(this.reportList.getKey(), "setSelectedDataInfo", new Object[]{selectedDataInfo});
        IPageCache pageCache = this.reportList.getView().getPageCache();
        String startIndexStr = pageCache.get("lastGetVirtualDataStartIndex");
        String lengthStr = pageCache.get("lastGetVirtualDataLength");
        if (StringUtils.isNotBlank((CharSequence)startIndexStr) && StringUtils.isNotBlank((CharSequence)lengthStr)) {
            String[] startIndex = startIndexStr.split(",");
            int length = Integer.parseInt(lengthStr) > totalCount ? totalCount : Integer.parseInt(lengthStr);
            int[] selectedRowKeys = new int[startIndex.length * length];
            int index = 0;
            for (String indexStr : startIndex) {
                int start = Integer.parseInt(indexStr);
                for (int i = 0; i < length; ++i) {
                    selectedRowKeys[index++] = ++start;
                }
            }
            if (this.isSupportSplitPage()) {
                this.clientViewProxy.invokeControlMethod(this.reportList.getKey(), "selectRows", new Object[]{selectedRowKeys});
            } else {
                this.clientViewProxy.invokeControlMethod(this.reportList.getKey(), "updateSelectRows", new Object[]{selectedRowKeys});
            }
        }
    }

    @SdkInternal
    public void clearSelection() {
        this.reportList.clearEntryState();
        HashMap<String, Integer> selectedDataInfo = new HashMap<String, Integer>(1);
        selectedDataInfo.put("selectedRowsCount", 0);
        this.clientViewProxy.invokeControlMethod(this.reportList.getKey(), "setSelectedDataInfo", new Object[]{selectedDataInfo});
    }

    @SdkInternal
    public void addRowSelection(List<Integer> rowKeys, List<List<Object>> rowData) {
        if (CollectionUtils.isEmpty(rowKeys)) {
            return;
        }
        this.addOrRemoveSelectRow(rowKeys, true);
        this.reportList.clickCell(this.reportList.getEntryState().getFocusField(), rowKeys.get(0));
        RowClickEvent evt = new RowClickEvent((Object)this, rowKeys.get(0).intValue());
        if (this.rowClickEventListeners != null) {
            for (RowClickEventListener l : this.rowClickEventListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".entryRowClick"));
                Throwable throwable = null;
                try {
                    l.entryRowClick(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @SdkInternal
    public void clearRowSelection(List<Integer> rowKeys, List<List<Object>> rowData) {
        if (CollectionUtils.isEmpty(rowKeys)) {
            return;
        }
        this.addOrRemoveSelectRow(rowKeys, false);
        this.reportList.clickCell(this.reportList.getEntryState().getFocusField(), rowKeys.get(0));
        RowClickEvent evt = new RowClickEvent((Object)this, rowKeys.get(0).intValue());
        if (this.rowClickEventListeners != null) {
            for (RowClickEventListener l : this.rowClickEventListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".entryRowClick"));
                Throwable throwable = null;
                try {
                    l.entryRowClick(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @SdkInternal
    public void doubleClickRow(List<Integer> rowKeys, List<List<Object>> rowData) {
        if (CollectionUtils.isEmpty(rowKeys)) {
            return;
        }
        this.addOrRemoveSelectRow(rowKeys, true);
        this.reportList.doubleClickCell(this.reportList.getEntryState().getFocusField(), rowKeys.get(0));
        RowClickEvent evt = new RowClickEvent((Object)this, rowKeys.get(0).intValue());
        if (this.rowClickEventListeners != null) {
            for (RowClickEventListener l : this.rowClickEventListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".entryRowDoubleClick"));
                Throwable throwable = null;
                try {
                    l.entryRowDoubleClick(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    private List<Integer> addOrRemoveSelectRow(List<Integer> rowKeys, boolean isAdd) {
        List<Integer> rows;
        AbstractGrid.GridState entryState = this.reportList.getEntryState();
        if (entryState.isSelectAllRows()) {
            ArrayList<Integer> notSelectRows = (ArrayList<Integer>)entryState.get(NOT_SELECT_ROWS);
            if (notSelectRows == null) {
                notSelectRows = new ArrayList<Integer>();
            }
            if (isAdd) {
                notSelectRows.removeAll(rowKeys);
            } else {
                notSelectRows.addAll(rowKeys);
            }
            rows = notSelectRows.stream().distinct().collect(Collectors.toList());
            entryState.put(NOT_SELECT_ROWS, rows);
        } else {
            ArrayList<Integer> selectedRows = (ArrayList<Integer>)entryState.get(SELECT_ROWS);
            if (selectedRows == null) {
                selectedRows = new ArrayList<Integer>();
            }
            if (isAdd) {
                selectedRows.addAll(rowKeys);
            } else {
                selectedRows.removeAll(rowKeys);
            }
            rows = selectedRows.stream().distinct().collect(Collectors.toList());
            entryState.put(SELECT_ROWS, rows);
        }
        this.invokeSelectRowsCount(rows, entryState.isSelectAllRows());
        return rows;
    }

    private void invokeSelectRowsCount(List<Integer> selectedRows, boolean isSelectAllRows) {
        long selectedRowsCount = isSelectAllRows ? (long)(this.reportList.getReportModel().getRowCount() - selectedRows.size()) : (long)selectedRows.size();
        HashMap<String, Long> selectedDataInfo = new HashMap<String, Long>(1);
        selectedDataInfo.put("selectedRowsCount", selectedRowsCount);
        this.clientViewProxy.invokeControlMethod(this.reportList.getKey(), "setSelectedDataInfo", new Object[]{selectedDataInfo});
    }

    private void saveEntryStates(Map<String, Object> state) {
        if (StringUtils.isBlank(state)) {
            return;
        }
        IPageCache pageCache = this.reportList.getView().getPageCache();
        String states = pageCache.get(CONTROL_STATES);
        Object controlViewStates = StringUtils.isBlank((CharSequence)states) ? new CaseInsensitiveMap() : (Map)SerializationUtils.fromJsonString((String)states, CaseInsensitiveMap.class);
        controlViewStates.put(this.reportList.getEntryKey(), state);
        pageCache.put(CONTROL_STATES, SerializationUtils.toJsonString((Object)controlViewStates));
    }

    private boolean isSupportSplitPage() {
        return !Boolean.parseBoolean(this.reportList.getView().getPageCache().get("isTreeReportList")) && this.reportList.isSplitPage();
    }
}

