/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.systree;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.NodeInfo;
import kd.bos.entity.tree.TreeNode;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.systree.SystemTree;

class EntityTree
extends SystemTree {
    private static Log log = LogFactory.getLog(EntityTree.class);

    EntityTree() {
    }

    @Override
    public TreeNode loadTree(BiFunction<String, NodeInfo, TreeNode> biFunction) {
        TreeNode rootNode = this.loadRootNode(biFunction);
        this.loadCloudNode(biFunction);
        this.loadAppNode(biFunction);
        this.loadEntityNode(biFunction);
        return rootNode;
    }

    private void loadEntityNode(BiFunction<String, NodeInfo, TreeNode> biFunction) {
        Map<String, List<EntityInfo>> appEntityMap = this.getAllEntityNumbers();
        for (Map.Entry<String, List<EntityInfo>> entry : appEntityMap.entrySet()) {
            String appId = entry.getKey();
            String appNum = (String)this.deployAppIdNumMap.get(appId);
            TreeNode appNode = (TreeNode)this.treeNodeMap.get(appNum);
            if (appNode == null) continue;
            for (EntityInfo entityInfo : entry.getValue()) {
                TreeNode node = this.createTreeNode(appNum, entityInfo, biFunction);
                appNode.addChild(node);
            }
        }
    }

    private void loadTileEntityNode(BiFunction<String, NodeInfo, TreeNode> biFunction) {
        Map appMenuInfoMap = AppMetadataCache.getAllAppMenus();
        for (Map.Entry entry : appMenuInfoMap.entrySet()) {
            String appId = (String)entry.getKey();
            TreeNode appNode = (TreeNode)this.treeNodeMap.get(appId);
            if (appNode == null) continue;
            List list = (List)entry.getValue();
            for (AppMenuInfo info : list) {
                this.createTreeNode(appId, (NodeInfo)info, biFunction);
            }
        }
    }

    private Map<String, List<EntityInfo>> getAllEntityNumbers() {
        String sql = "SELECT a.FID, b.FNAME, a.FBIZAPPID from t_meta_mainentityinfo a inner join t_meta_mainentityinfo_l b on a.FID = b.FID and b.FLOCALEID = ?";
        final HashMap<String, List<EntityInfo>> appEntityMap = new HashMap<String, List<EntityInfo>>();
        ResultSetHandler<Object> action = new ResultSetHandler<Object>(){

            public Object handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String appId = rs.getString("FBIZAPPID");
                    List entityInfoList = appEntityMap.computeIfAbsent(appId, k -> new ArrayList());
                    EntityInfo entityInfo = new EntityInfo();
                    entityInfo.setId(rs.getString("FID"));
                    entityInfo.setName(new LocaleString(rs.getString("FNAME")));
                    entityInfo.setParentId(appId);
                    entityInfoList.add(entityInfo);
                }
                return null;
            }
        };
        DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{Lang.get().toString()}, (ResultSetHandler)action);
        return appEntityMap;
    }

    static class EntityInfo
    implements NodeInfo {
        private String id;
        private int order;
        private String number;
        private LocaleString name;
        private LocaleString description;
        private String parentId;

        EntityInfo() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public LocaleString getName() {
            return this.name;
        }

        public void setName(LocaleString name) {
            this.name = name;
        }

        public LocaleString getDescription() {
            return this.description;
        }

        public void setDescription(LocaleString description) {
            this.description = description;
        }

        public String getParentId() {
            return this.parentId;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public String getNodeType() {
            return "entity";
        }
    }
}

