/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.form;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.api.AsynMessage;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingMeta;
import kd.bos.entity.qing.model.Template;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBackWraper;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormConfigService;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.QingCachedFormParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.IQingAnalysis;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.ExceptionHandler;
import kd.bos.mservice.form.FormService;
import kd.bos.mservice.svc.attach.IAttachmentModelProxy;
import kd.bos.mservice.sysparam.SystemParamServiceImpl;
import kd.bos.mutex.AutoReleaseLock;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.cache.RootPageCache;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.form.IFormController;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.pushservice.AsynMessageConsumer;
import kd.bos.report.ReportShowParameter;
import kd.bos.response.ResponseHeader;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.service.ServiceFactory;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.thread.ManagedThreadFeature;
import kd.bos.thread.ThreadTruck;
import kd.bos.utils.LogPrintUtil;
import org.apache.commons.beanutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class FormServiceImpl
implements FormService,
FormConfigService {
    private static final String TYPE_FORM_SERVICE = "FormService";
    private static final String KEY_BOS_ERROR = "bos_error";
    private static final String KEY_BOS_ERROR_MOBILE = "bos_error_mobile";
    private static final String PAGE_ID = "pageId";
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private static final String CAPTION = "caption";
    private static final String CANCEL = "cancel";
    private static final String CANCEL_MESSAGE = "cancelMessage";
    private static final String GET_CONFIG = "getConfig";
    private static final String RELEASE = "release";
    private static final String REFLESH_ROOTPAGE = "refleshrootpage";
    private static final String GET_QING_DATA = "getQingData";
    private static final String METHOD_NAME = "methodName";
    private static final String CONTROL_WITH_KEY = "Control with key ";
    private static final String IS_NOT_INSTANCEOF_IQING_ANALYSIS = " is not instanceof IQingAnalysis";
    private static final String IS_FILTER_CHANGED = "isFilterChanged";
    private static final String SPAN_TAG_RETURN = "return";
    private static final String SPAN_TAG_CTSY_RETURN = "ctsyreturn";
    private static Log log = LogFactory.getLog(FormServiceImpl.class);
    private static final Timer releaseRootPageTimer = new Timer();
    private static Set<String> auditFirst = new HashSet<String>();
    public static final String FORM_VIEW_NOT_FIND = ":FormView not find.";
    private static final String KEY_ERRORINFO = "bos_errorinfo";
    private static final String KEY_ERRORINFO_MOBILE = "bos_errorinfo_mobile";
    private static String[] guestFormWhiteList = new String[]{"srm_portal", "bos_portal_setlayout", "bos_assistantdata_detail", "bd_admindivision", "bos_admindivisionf7", "bd_country", "bd_taxrate", "bd_invoicetype", "bos_templatetreelistf7", "bd_settlementtype", "bd_paycondition", "bd_taxcategory", "bd_bebank", "bd_resinlistf7", "bos_list", "bos_org", "bos_orgtreelistf7", "bd_currency", "bos_listf7", "bos_treelistf7", "bos_moblistf7", "bos_mobtreelistf7", "bos_customlistf7", "bos_moblisttabf7", "bos_dateselect", "bos_moblist", "bos_moblistmodalf7", "rebm_announcement", "resp_registered", "resp_org_alias", "bd_suppliergroup", "bd_datagrouptreelistf7", "resp_message", "resm_suppliernaturef7"};
    private static final String TARGET_FORM_ID = "targetFormId";
    private static final String STATUS = "Status";
    private static final String STATUS_L = "status";
    private static final String STATUS_EDIT = "edit";
    private static final String TH_INVOKE_COUNT = "thInvokeCount";
    private static final String FUNCTION_AUDIT_NAME = "function";
    private static final String SERVICE_AUDIT_PREFIX_NAME = "function_";

    public String getAppId(String formId) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_FORM_SERVICE, (String)"getAppId");){
            String appId = FormMetadataCache.getFormAppId((String)formId);
            this.logInfo(String.format("formid:%s - FormMetadataCache.getFormAppId=%s", formId, appId), "getAppId()");
            span.addTag("formId", formId);
            span.addTag("appId", appId);
            String string = appId;
            return string;
        }
    }

    private void setOperationContext(String appId, String formId, String formname, String method, String opKey) {
        OperationContext oc = new OperationContext();
        oc.setAppId(appId);
        oc.setFormId(formId);
        oc.setFormName(formname);
        oc.setOpKey(opKey);
        oc.setOpMethod(method);
        OperationContext.set((OperationContext)oc);
    }

    private void clearAPMOperationContext() {
        OperationContext.remove();
    }

    /*
     * Exception decompiling
     */
    public String getConfig(Map<String, Object> params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 8 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkListShowUrlConfig(Map<String, Object> openParameter) {
        boolean result;
        AppParam param = new AppParam();
        param.setAppId("83bfebc800003dac");
        param.setViewType("15");
        param.setOrgId(Long.valueOf(((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId()));
        Map appParams = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param);
        Boolean isCheck = appParams.getOrDefault("checkurl", false);
        String type = (String)openParameter.get("type");
        boolean isPcList = "list".equals(type);
        boolean isMobList = "mobilelist".equals(type);
        boolean isList = isPcList || isMobList;
        String billFormId = (String)openParameter.get("billFormId");
        String formId = (String)openParameter.get("formId");
        if (StringUtils.isBlank((CharSequence)formId) && isList) {
            formId = isMobList ? "bos_moblist" : "bos_list";
        }
        try {
            FormConfig listFormConfig;
            if (StringUtils.isBlank((CharSequence)type) && StringUtils.isNotBlank((CharSequence)formId) && StringUtils.isNotBlank((CharSequence)billFormId) && (listFormConfig = FormMetadataCache.getFormConfig((String)formId)) != null) {
                isPcList = "list".equals(listFormConfig.getModelType());
                isMobList = "mobilelist".equals(listFormConfig.getModelType());
            }
            boolean bl = isList = isPcList || isMobList;
            if (!Boolean.parseBoolean(String.valueOf(isCheck)) || !isList) {
                return true;
            }
            FormConfig billFormConfig = FormMetadataCache.getFormConfig((String)billFormId);
            FormConfig listFormConfig2 = FormMetadataCache.getFormConfig((String)formId);
            String billModelType = billFormConfig.getModelType();
            String listModelType = listFormConfig2.getModelType();
            result = billModelType == null || listModelType == null ? true : !"mobilebill".equals(billModelType) || !isPcList;
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            result = true;
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public String getConfigByParameter(String cacheId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    public List<Object> closeCallBack(CloseCallBackWraper closeCallBackWraper) {
        IFormController srv = null;
        try {
            try (EntityTraceSpan span = EntityTracer.create((String)TYPE_FORM_SERVICE, (String)"closeCallBack");){
                span.addLocaleTag("closeCallBackWraper", (Object)closeCallBackWraper);
                FormView formView = (FormView)SessionManager.getCurrent().getView(closeCallBackWraper.getPageId());
                srv = (IFormController)formView.getService(IFormController.class);
                srv.formClosedCallBack(closeCallBackWraper);
                List list = formView.getActionResult();
                return list;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (srv != null) {
                srv.destory();
            }
        }
    }

    public void sessionEnd(String sessionId) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_FORM_SERVICE, (String)"sessionEnd");){
            span.addTag("sessionId", sessionId);
            AutoReleaseLock.create().clearLoseLock(sessionId);
            RootPageCache.clearSessionPageCache((String)sessionId);
            TaskClientProxy.sessionEnd();
        }
    }

    public String getConfigByPageId(String pageId) {
        String formConfig = "";
        try {
            Locale.setDefault(Locale.CHINA);
            PageCache pageCache = new PageCache(pageId);
            RootPageCache.removeDelayClearPageId((String)pageId);
            formConfig = pageCache.get("formconfig") == null ? "" : pageCache.get("formconfig");
            return formConfig;
        }
        catch (Exception ex) {
            String error = FormServiceImpl.isShowStackTrace() ? formConfig : this.getNormalError();
            throw new KDException(error);
        }
    }

    private String getNormalError() {
        RequestContext requestContext = RequestContext.get();
        String msg = "";
        if (requestContext != null) {
            msg = "TraceId:" + requestContext.getTraceId() + "\r\n";
        }
        msg = msg + " getConfigByPageId.do  error ";
        return msg;
    }

    public String getMetadata(String id) {
        InputStream in = FormServiceImpl.class.getResourceAsStream("/form.meta.json");
        return this.getFile(in);
    }

    private boolean excludeMethod(List<Map<String, Object>> params) {
        return params.get(0).get(METHOD_NAME).equals("afterConfirm") || params.get(0).get(METHOD_NAME).equals(RELEASE) || params.get(0).get(METHOD_NAME).equals("itemClick") && params.get(0).get("args").toString().contains("close") || params.get(0).get(METHOD_NAME).equals("close");
    }

    private String handleCancelDataRight(String pageId, String str_params) {
        String cancelMsg = ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"FormServiceImpl_10", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]);
        this.logWarn(String.format("%s:pageId=%s,accountId=%s,client=%s", cancelMsg, pageId, CacheKeyUtil.getAcctId(), RequestContext.get().getClient()), "handleCancelDataRight()");
        return SerializationUtils.toJsonString(this.showTimeOutMessage(cancelMsg, "showErr"));
    }

    private String handleCancelRight(FormShowParameter formShowParamter, String pageId, String str_params) {
        FormConfig config = formShowParamter.getFormConfig();
        String formName = config.getCaption().toString();
        String permItem = formShowParamter.getPermissionItemId();
        String msg = "47156aff000000ac".equals(permItem) ? String.format(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\"%1$s\"\u65b0\u589e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"FormServiceImpl_17", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), formName) : ("4715a0df000000ac".equals(permItem) ? String.format(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\"%1$s\"\u4fee\u6539\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"FormServiceImpl_18", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), formName) : String.format(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\"%1$s\"\u67e5\u8be2\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"FormServiceImpl_19", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), formName));
        this.logWarn(String.format("%s:pageId=%s,accountId=%s,client=%s", msg, pageId, CacheKeyUtil.getAcctId(), RequestContext.get().getClient()), "handleCancelRight()");
        return SerializationUtils.toJsonString(this.showTimeOutMessage(msg, "showErr"));
    }

    private String handleReCheckRight(List<Map<String, Object>> params, IFormView formView, String dataParams) {
        if (!this.excludeMethod(params)) {
            FormShowParameter showParameter = formView.getFormShowParameter();
            if (showParameter.getCancelRight() == 1) {
                long userId = RequestContext.get().getCurrUserId();
                HashMap ret = new HashMap();
                FormConfigFactory.checkShowFormRightByUserID((FormShowParameter)showParameter, ret, (long)userId);
                if (ret.containsKey(CANCEL)) {
                    showParameter.setCancelRight(2);
                } else {
                    showParameter.setCancelRight(0);
                }
                formView.cacheFormShowParameter();
            }
            if (showParameter.getCancelRight() == 2) {
                return this.handleCancelRight(showParameter, showParameter.getPageId(), dataParams);
            }
            if (showParameter.isCancelDataRight()) {
                return this.handleCancelDataRight(showParameter.getPageId(), dataParams);
            }
        }
        return "";
    }

    public String batchInvokeAction(String pageId, String dataParams) {
        return this.batchInvokeAction(pageId, dataParams, new HashMap<String, Object>());
    }

    /*
     * Exception decompiling
     */
    public String batchInvokeAction(String pageId, String dataParams, Map<String, Object> actionParams) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [21[TRYBLOCK]], but top level block is 65[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateCsrfToken(IFormController srv, boolean isWeb, List<Object> results) {
        if (isWeb) {
            String csrfToken = srv.updateCsrfToken();
            this.addCsrfTokenAction(csrfToken, results);
        }
    }

    private String handleLoginOut(String pageId, String sessionid, String str_params, List<Map<String, Object>> params) {
        String actionId = "loginout";
        if (!params.isEmpty()) {
            for (Map<String, Object> param : params) {
                String methodName = (String)param.get(METHOD_NAME);
                if (RELEASE.equals(methodName)) {
                    actionId = "release_confirm";
                    continue;
                }
                if (!"afterConfirm".equals(methodName)) continue;
                List args = (List)param.get("args");
                if ("loginout".equals(args.get(0))) {
                    return SerializationUtils.toJsonString(this.logOff(pageId, sessionid));
                }
                if (REFLESH_ROOTPAGE.equals(args.get(0))) {
                    return SerializationUtils.toJsonString((Object)this.refleshRootPage());
                }
                if (!"release_confirm".equals(args.get(0))) continue;
                return "[]";
            }
        }
        this.logWarn(String.format("handleLoginOut, userId: %s, pageId: %s", RequestContext.get().getCurrUserId(), pageId), "handleLoginOut()");
        ResponseHeader.get().error(new ErrorCode("FormServiceImpl.handleLoginOut", "session is different."));
        String type = RequestContext.get().getClient();
        if (type.equalsIgnoreCase("mobile")) {
            this.logWarn(String.format(ResManager.loadKDString((String)"\u4f1a\u8bdd\u5df2\u53d1\u751f\u6539\u53d8\uff0c\u8868\u5355\u5c06\u5237\u65b0:pageId=%1$s,accountId=%2$s,client=%3$s", (String)"FormServiceImpl_24", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), pageId, CacheKeyUtil.getAcctId(), type), "handleLoginOut()");
            return SerializationUtils.toJsonString(this.showTimeOutMessage(ResManager.loadKDString((String)"\u4f1a\u8bdd\u5df2\u53d1\u751f\u6539\u53d8\uff0c\u8868\u5355\u5c06\u5237\u65b0", (String)"FormServiceImpl_6", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), REFLESH_ROOTPAGE));
        }
        this.logWarn(String.format(ResManager.loadKDString((String)"\u4f1a\u8bdd\u5df2\u53d1\u751f\u6539\u53d8\uff0c\u5c06\u91cd\u65b0\u767b\u5f55:pageId=%1$s,accountId=%2$s,client=%3$s", (String)"FormServiceImpl_25", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), pageId, CacheKeyUtil.getAcctId(), type), "handleLoginOut()");
        return SerializationUtils.toJsonString(this.showTimeOutMessage(ResManager.loadKDString((String)"\u957f\u65f6\u95f4\u672a\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55", (String)"FormServiceImpl_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), REFLESH_ROOTPAGE));
    }

    private String handleTimeout(String pageId, String str_params, List<Map<String, Object>> params) {
        if (params.size() > 0) {
            for (Map<String, Object> param : params) {
                String methodName = (String)param.get(METHOD_NAME);
                if (RELEASE.equals(methodName)) {
                    return "[]";
                }
                if (!"afterConfirm".equals(methodName)) continue;
                List args = (List)param.get("args");
                if ("pagetimeout".equals(args.get(0))) {
                    return SerializationUtils.toJsonString((Object)this.closePage(pageId));
                }
                if (!REFLESH_ROOTPAGE.equals(args.get(0))) continue;
                return SerializationUtils.toJsonString((Object)this.refleshRootPage());
            }
        }
        ResponseHeader.get().error(new ErrorCode("FormServiceImpl.handleTimeout", "login is timeout."));
        log.warn("handleTimeOut, userId: {}, pageId: {}, params: {}", new Object[]{RequestContext.get().getCurrUserId(), pageId, str_params});
        if (pageId.startsWith("root")) {
            this.logWarn(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355\u4f1a\u8bdd\u8d85\u65f6\uff0c\u8868\u5355\u5c06\u5237\u65b0:pageId=%1$s,accountId=%2$s", (String)"FormServiceImpl_26", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), pageId, CacheKeyUtil.getAcctId()), "handleTimeout()");
            return SerializationUtils.toJsonString(this.showTimeOutMessage(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355\u4f1a\u8bdd\u8d85\u65f6\uff0c\u8868\u5355\u5c06\u5237\u65b0\u3002", (String)"FormServiceImpl_2", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), REFLESH_ROOTPAGE));
        }
        this.logWarn(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355\u4f1a\u8bdd\u8d85\u65f6\uff0c\u8868\u5355\u5c06\u5173\u95ed:pageId=%1$s,accountId=%2$s", (String)"FormServiceImpl_27", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), pageId, CacheKeyUtil.getAcctId()), "handleTimeout()");
        return SerializationUtils.toJsonString(this.showTimeOutMessage(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355\u4f1a\u8bdd\u8d85\u65f6\uff0c\u8868\u5355\u5c06\u5173\u95ed\u3002", (String)"FormServiceImpl_3", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), "pagetimeout"));
    }

    private Object closePage(String pageId) {
        ArrayList<Map<String, Object>> acts = new ArrayList<Map<String, Object>>();
        HashMap<String, String> invalidPageAct = new HashMap<String, String>();
        invalidPageAct.put(PAGE_ID, pageId);
        acts.add(this.createAction("invalidPage", invalidPageAct));
        HashMap<String, String> arg = new HashMap<String, String>();
        arg.put(PAGE_ID, pageId);
        acts.add(this.createAction("closeWindow", arg));
        return acts;
    }

    private Object refleshRootPage() {
        ArrayList<Map<String, Object>> acts = new ArrayList<Map<String, Object>>();
        acts.add(this.createAction("f5Refresh", null));
        return acts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> invokeAction(IFormView formView, String key, String methodName, Object[] args, List<Map<String, Object>> postData, Map<String, Object> actionParams) {
        Object ctl;
        String pageId = formView.getPageId();
        Locale.setDefault(Locale.CHINA);
        IFormController srv = (IFormController)formView.getService(IFormController.class);
        if (this.isParallelRequest(actionParams)) {
            formView.getModel().putContextVariable("formaction_parallelwebrequest", (Object)true);
        }
        List actionResult = new ArrayList();
        try {
            srv.postData(postData);
            if (StringUtils.isBlank((CharSequence)key)) {
                Map<String, Object> firstData;
                OperationContext.get().setOpKey(formView.getClass().getSimpleName());
                Object[] newArgs = args;
                if (postData != null && postData.size() > 0 && (firstData = postData.get(0)) != null && firstData.containsKey("_LocalStorage_")) {
                    newArgs = ArrayUtils.add((Object[])args, (Object)firstData.get("_LocalStorage_"));
                }
                FormServiceImpl.invokeMethod(formView, srv, methodName, newArgs);
            } else {
                srv.registerListener();
                ctl = formView.getControl(key);
                if (ctl != null) {
                    OperationContext.get().setOpKey(ctl.getOpKey(methodName, args));
                    FormServiceImpl.invokeMethod(formView, ctl, methodName, args);
                }
            }
            actionResult = formView.getActionResult();
            SessionManager.getCurrent().commitCache();
            ctl = actionResult;
        }
        catch (Throwable throwable) {
            try {
                Object cnt = ThreadTruck.get((Object)TH_INVOKE_COUNT);
                if (cnt instanceof Integer) {
                    ThreadTruck.put((Object)TH_INVOKE_COUNT, (Object)((Integer)cnt - 1));
                }
                srv.destory();
                throw throwable;
            }
            catch (Exception e) {
                List<Object> errStr;
                if (e instanceof InvocationTargetException) {
                    errStr = this.createJSONObjectException(pageId, methodName, ((InvocationTargetException)e).getTargetException(), key);
                    log.error(key + "." + methodName, ((InvocationTargetException)e).getTargetException());
                } else {
                    errStr = this.createJSONObjectException(pageId, methodName, e, key);
                    log.error(key + "." + methodName, (Throwable)e);
                }
                EntityTracer.error((Throwable)e);
                String errPageCacheKey = "invokeAction_errStr";
                String errStrJson = formView.getPageCache().get(errPageCacheKey);
                if (StringUtils.isNotBlank((CharSequence)errStrJson)) {
                    errStr = (List<Object>)SerializationUtils.fromJsonString((String)errStrJson, List.class);
                    return FormServiceImpl.isShowStackTrace() ? errStr : this.showError(formView, errStr);
                }
                if (StringUtils.isNotBlank((CharSequence)methodName) && "loadData".equals(methodName)) {
                    formView.getPageCache().put(errPageCacheKey, SerializationUtils.toJsonString(errStr));
                }
                return FormServiceImpl.isShowStackTrace() ? errStr : this.showError(formView, errStr);
            }
        }
        Object cnt = ThreadTruck.get((Object)TH_INVOKE_COUNT);
        if (cnt instanceof Integer) {
            ThreadTruck.put((Object)TH_INVOKE_COUNT, (Object)((Integer)cnt - 1));
        }
        srv.destory();
        return ctl;
    }

    private boolean isParallelRequest(Map<String, Object> actionParams) {
        if (actionParams == null || !actionParams.containsKey("parallel")) {
            return false;
        }
        Object result = actionParams.get("parallel");
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return result == null ? false : Boolean.parseBoolean(result.toString());
    }

    private static boolean isShowStackTrace() {
        Object isShowStackTrace;
        String showStackTrace = System.getProperty("exception_showstacktrace");
        if (showStackTrace != null && "true".equals(showStackTrace)) {
            return true;
        }
        Map cache = ParameterReader.loadPublicParameterFromCache();
        if (cache != null && cache.size() > 0 && (isShowStackTrace = cache.get("showstacktrace")) != null) {
            return (Boolean)isShowStackTrace;
        }
        return false;
    }

    private List<Object> showError(IFormView formView, List<Object> errStr) {
        Map errorMap = (Map)errStr.get(0);
        String action = (String)errorMap.get("a");
        if ("showErrMsg".equals(action)) {
            FormShowParameter parameter = new FormShowParameter();
            String client = RequestContext.get().getClient();
            boolean isWeb = !"mobile".equals(client) && !(formView instanceof IMobileView);
            String formId = isWeb ? KEY_BOS_ERROR : KEY_BOS_ERROR_MOBILE;
            String subFormId = isWeb ? KEY_ERRORINFO : KEY_ERRORINFO_MOBILE;
            ShowType showType = isWeb ? ShowType.Modal : ShowType.Floating;
            parameter.setFormId(formId);
            parameter.setCustomParam(subFormId, errStr);
            parameter.getOpenStyle().setShowType(showType);
            formView.showForm(parameter);
            return formView.getActionResult();
        }
        return errStr;
    }

    private Map<String, Object> createAuditWarnMsg(String audit) {
        String methodName;
        String formName;
        HashMap<String, String> jo = new HashMap<String, String>();
        OperationContext oc = OperationContext.get();
        if (oc != null) {
            formName = oc.getFormName();
            methodName = oc.getOpMethod();
        } else {
            formName = "";
            methodName = "";
        }
        jo.put("msg", String.format(ResManager.loadKDString((String)"%1$s\u6027\u80fd\u5ba1\u8ba1\u4e0d\u8fbe\u6807\u3002\u65b9\u6cd5\u540d:%2$s", (String)"FormServiceImpl_4", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), formName, methodName));
        jo.put("detail", audit);
        jo.put("messageType", (String)MessageTypes.Default);
        return this.createAction("showMessage", jo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public String invokeAction(String pageId, String key, String methodName, Object[] args, List<Map<String, Object>> postData) {
        try {
            Throwable throwable = null;
            try (EntityTraceSpan span = EntityTracer.create((String)TYPE_FORM_SERVICE, (String)"invokeAction");){
                String string;
                if (span.isRealtime()) {
                    span.addTag(PAGE_ID, pageId);
                    span.addTag("key", key);
                    span.addTag(METHOD_NAME, methodName);
                    span.addTag("args", args == null ? null : SerializationUtils.toJsonString((Object)args));
                    span.addTag("postData", postData == null ? null : SerializationUtils.toJsonString(postData));
                    span.fireEvent("invokeAction");
                }
                Locale.setDefault(Locale.CHINA);
                IFormView formView = SessionManager.getCurrent().getView(pageId);
                IFormController srv = (IFormController)formView.getService(IFormController.class);
                String formId = formView.getFormShowParameter().getFormId();
                String appId = formView.getFormShowParameter().getFormConfig().getAppId();
                this.setOperationContext(appId, formId, formView.getFormShowParameter().getFormName(), methodName, key);
                try {
                    srv.postData(postData);
                    if (StringUtils.isBlank((CharSequence)key)) {
                        FormServiceImpl.invokeMethod(formView, srv, methodName, args);
                    } else {
                        Control ctl = formView.getControl(key);
                        FormServiceImpl.invokeMethod(formView, ctl, methodName, args);
                    }
                    List actionResult = formView.getActionResult();
                    string = SerializationUtils.toJsonString((Object)actionResult);
                }
                catch (Throwable throwable2) {
                    try {
                        srv.destory();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                srv.destory();
                return string;
            }
        }
        catch (Exception e) {
            String errStr = SerializationUtils.toJsonString(this.createJSONObjectException(pageId, methodName, e, key));
            log.error(errStr, (Throwable)e);
            String string = errStr;
            return string;
        }
    }

    public List<Object> logOff(String pageId, String sessionid) {
        ArrayList<Object> acts = new ArrayList<Object>();
        HashMap<String, String> mpURL = new HashMap<String, String>();
        mpURL.put("url", "auth/logout.do");
        mpURL.put("openStyle", "0");
        acts.add(this.createAction("openUrl", mpURL));
        return acts;
    }

    private Map<String, Object> createAction(String actionName, Object arg) {
        HashMap<String, Object> action = new HashMap<String, Object>();
        action.put("a", actionName);
        ArrayList<Object> paras = new ArrayList<Object>(1);
        paras.add(arg);
        action.put("p", paras);
        return action;
    }

    private List<Object> showTimeOutMessage(String msg, String timeoutType) {
        ArrayList<Object> acts = new ArrayList<Object>();
        HashMap<String, Object> jo = new HashMap<String, Object>();
        jo.put("msg", msg);
        jo.put("detail", "");
        jo.put("id", timeoutType);
        jo.put("messageType", MessageTypes.Default);
        jo.put("confirmType", ConfirmTypes.Default.getValue());
        jo.put("button_type", MessageBoxOptions.None.getValue());
        acts.add(this.createAction("showConfirm", jo));
        return acts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFile(InputStream in) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            in.close();
            String string = sb.toString();
            return string;
        }
        catch (Throwable t) {
            String string = "";
            return string;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }

    private List<Object> createJSONObjectException(String pageId, String method, Throwable ex, String key) {
        try {
            TX.setResponseException((Throwable)ex);
            ArrayList<Object> acts = new ArrayList<Object>();
            Map<String, Object> action = ExceptionHandler.HandlerErr(ex, key);
            acts.add(action);
            if ("close".equals(method)) {
                HashMap<String, String> arg = new HashMap<String, String>();
                arg.put(PAGE_ID, pageId);
                action = new HashMap<String, Object>();
                action.put("a", "closeWindow");
                ArrayList<HashMap<String, String>> paras = new ArrayList<HashMap<String, String>>(1);
                paras.add(arg);
                action.put("p", paras);
                acts.add(action);
            }
            ResponseHeader.get().error(new ErrorCode("FormServiceInvoke/", ex.getMessage()));
            return acts;
        }
        catch (Throwable ex2) {
            if (ex != null) {
                log.error(ex);
            }
            throw ex2;
        }
    }

    public String yzjChatCallbackAction(Map<String, String> map) {
        String groupId = "";
        if (!StringUtils.isBlank((CharSequence)map.get("groupId"))) {
            groupId = map.get("groupId");
        }
        String formid = "";
        if (!StringUtils.isBlank((CharSequence)map.get("formid"))) {
            formid = map.get("formid");
        }
        String pkid = "";
        if (!StringUtils.isBlank((CharSequence)map.get("pkid"))) {
            pkid = map.get("pkid");
        }
        String eid = "";
        if (!StringUtils.isBlank((CharSequence)map.get("eid"))) {
            eid = map.get("eid");
        }
        String rtn = "{\"data\":\"id=3dsfj7322jfnbg20s3d2\",\"error\": null,\"errorCode\":0,\"success\":true}";
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getQingDataOfObject(String pageId, String key, int startRow, int limit) {
        String formId = "";
        String appId = "";
        try {
            IFormView formView = SessionManager.getCurrent().getView(pageId);
            formId = formView.getFormShowParameter().getFormId();
            appId = formView.getFormShowParameter().getFormConfig().getAppId();
            this.setOperationContext(appId, formId, formView.getFormShowParameter().getFormName(), GET_QING_DATA, key);
            if (StringUtils.isBlank((CharSequence)key)) {
                IFormController srv = (IFormController)formView.getService(IFormController.class);
                try {
                    Object object = FormServiceImpl.invokeMethod(formView, srv, GET_QING_DATA, new Object[]{startRow, limit});
                    return object;
                }
                finally {
                    srv.destory();
                }
            }
            Control ctrl = formView.getControl(key);
            if (!(ctrl instanceof IQingAnalysis)) {
                return SerializationUtils.toJsonString((Object)(CONTROL_WITH_KEY + key + IS_NOT_INSTANCEOF_IQING_ANALYSIS));
            }
            QingData data = ((IQingAnalysis)ctrl).getQingData(pageId, startRow, limit);
            if (data == null) return new QingData();
            return data;
        }
        catch (Exception e) {
            String debugInfo = String.format(ResManager.loadKDString((String)"\u8f7b\u5206\u6790\u53d6\u6570\u5f02\u5e38,pageId:%1$s,key:%2$s,startRow:%3$s,limit:%4$s", (String)"FormServiceImpl_5", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), pageId, key, startRow, limit);
            log.error(debugInfo, (Throwable)e);
            return SerializationUtils.toJsonString(this.createJSONObjectException(pageId, GET_QING_DATA, e, ""));
        }
    }

    public String getQingCtrlPlugin(String pageId, String ctrKey) {
        if (ctrKey == null || ctrKey.isEmpty()) {
            return "UNKOWN_PLUGIN";
        }
        IFormView formView = SessionManager.getCurrent().getView(pageId);
        Control ctrl = formView.getControl(ctrKey);
        String plugin = null;
        if (ctrl instanceof IQingAnalysis) {
            IQingAnalysis analysis = (IQingAnalysis)ctrl;
            plugin = analysis.getQingDatasourcePlugin();
        }
        if (null == plugin) {
            plugin = "UNKOWN_PLUGIN";
        }
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object newQingAnalysisTemplate(String pageId, String ctrlKey) {
        block5: {
            IFormView formView = SessionManager.getCurrent().getView(pageId);
            String formId = formView.getFormShowParameter().getFormId();
            String appId = formView.getFormShowParameter().getFormConfig().getAppId();
            this.setOperationContext(appId, formId, formView.getFormShowParameter().getFormName(), "getQingAnalysisTemplate", ctrlKey);
            Control ctrl = formView.getControl(ctrlKey);
            if (!(ctrl instanceof IQingAnalysis)) break block5;
            Template template = ((IQingAnalysis)ctrl).newTemplate(pageId);
            return template;
        }
        try {
            Object var7_9 = null;
            return var7_9;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            Object var4_5 = null;
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getQingColumnsOfObject(String pageId, String key) {
        try {
            IFormView formView = SessionManager.getCurrent().getView(pageId);
            String formId = formView.getFormShowParameter().getFormId();
            String appId = formView.getFormShowParameter().getFormConfig().getAppId();
            this.setOperationContext(appId, formId, formView.getFormShowParameter().getFormName(), "getQingColumnsOfObject", key);
            if (StringUtils.isBlank((CharSequence)key)) {
                IFormController srv = (IFormController)formView.getService(IFormController.class);
                try {
                    Object object = FormServiceImpl.invokeMethod(formView, srv, "getQingColumns", new Object[0]);
                    return object;
                }
                finally {
                    srv.destory();
                }
            }
            Control ctrl = formView.getControl(key);
            if (!(ctrl instanceof IQingAnalysis)) {
                return SerializationUtils.toJsonString((Object)(CONTROL_WITH_KEY + key + IS_NOT_INSTANCEOF_IQING_ANALYSIS));
            }
            QingMeta meta = ((IQingAnalysis)ctrl).getQingColumns(pageId);
            if (meta == null) return SerializationUtils.toJsonString((Object)("QingMeta is null at Control " + key));
            return meta;
        }
        catch (Exception e) {
            String errStr = SerializationUtils.toJsonString(this.createJSONObjectException(pageId, "getQingColumns", e, ""));
            log.error((Throwable)e);
            return errStr;
        }
    }

    public String getQingData(String pageId, String key, int startRow, int limit) {
        return SerializationUtils.toJsonString((Object)this.getQingDataOfObject(pageId, key, startRow, limit));
    }

    public String getQingColumns(String pageId, String key) {
        return SerializationUtils.toJsonString((Object)this.getQingColumnsOfObject(pageId, key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String isFilterChanged(String pageId) {
        String string;
        String formId = "";
        String appId = "";
        IFormView formView = SessionManager.getCurrent().getView(pageId);
        IFormController srv = (IFormController)formView.getService(IFormController.class);
        formId = formView.getFormShowParameter().getFormId();
        appId = formView.getFormShowParameter().getFormConfig().getAppId();
        this.setOperationContext(appId, formId, formView.getFormShowParameter().getFormName(), IS_FILTER_CHANGED, "");
        try {
            string = SerializationUtils.toJsonString((Object)FormServiceImpl.invokeMethod(formView, srv, IS_FILTER_CHANGED, new Object[0]));
        }
        catch (Throwable throwable) {
            try {
                srv.destory();
                throw throwable;
            }
            catch (Exception e) {
                String errStr = SerializationUtils.toJsonString(this.createJSONObjectException(pageId, IS_FILTER_CHANGED, e, ""));
                log.error(errStr, (Throwable)e);
                String string2 = errStr;
                return string2;
            }
        }
        srv.destory();
        return string;
    }

    public void pushAICommand(String aitoken, String userId, String command) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            userId = RequestContext.get().getUserId();
        }
        RequestContext newRc = RequestContext.copyAndSet((RequestContext)RequestContext.get());
        newRc.setGlobalSessionId(aitoken);
        if (StringUtils.isBlank((CharSequence)newRc.getUserId()) && StringUtils.isNotBlank((CharSequence)userId)) {
            newRc.setUserId(userId);
        }
        Map cmd = (Map)SerializationUtils.fromJsonString((String)command, Map.class);
        HashMap cmdData = new HashMap();
        Map<String, String> param = cmd.get("para") != null ? (Map)cmd.get("para") : new HashMap();
        param.put("userId", userId);
        cmdData.put("actionName", cmd.get("type"));
        cmdData.put("parameter", param);
        AsynMessage asynFormMessage = new AsynMessage();
        asynFormMessage.setBody(SerializationUtils.toJsonString(cmdData));
        asynFormMessage.setMessageType("ai");
        this.logInfo(String.format(ResManager.loadKDString((String)"\u5c06AI\u547d\u4ee4 \u63a8\u5165\u5f02\u6b65\u6d88\u606f-\u961f\u5217    \u6d88\u606f\u4f53\uff1a%s", (String)"FormServiceImpl_28", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), SerializationUtils.toJsonString((Object)asynFormMessage)), "pushAICommand()");
        AsynMessageConsumer asynMessageConsumer = new AsynMessageConsumer();
        asynMessageConsumer.process(asynFormMessage);
    }

    private void setReleaseOpContextByPageId(String pageId) {
        FormShowParameter fs = SessionManager.getCurrent().getFormShowParameter(pageId);
        OperationContext oc = new OperationContext();
        if (fs != null) {
            oc.setAppId(fs.getAppId());
            oc.setFormId(fs.getFormId());
            oc.setFormName(fs.getFormName());
        }
        oc.setOpKey(RELEASE);
        OperationContext.set((OperationContext)oc);
    }

    public void releaseRootPage(String rootPageId, boolean byPage) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_FORM_SERVICE, (String)"releaseRootPage");){
            span.addTag("rootPageId", rootPageId);
            span.addTag("byPage", String.valueOf(byPage));
            if (Boolean.getBoolean("bos.formaction.releasecheck.enable") && !this.checkPageSessionOwner(rootPageId)) {
                return;
            }
            this.logInfo(String.format("releaseRootPage, rootPageId: %s, byPage: %s", rootPageId, byPage), "releaseRootPage()");
            if (byPage) {
                RootPageCache.clearRootChildrenCahe((String)rootPageId);
                RootPageCache.addDelayClearPageId((String)rootPageId);
                releaseRootPageTimer.schedule((TimerTask)new ReleaseTask(RequestContext.get(), rootPageId), 30000L);
            } else {
                RootPageCache.clearRootCahe((String)rootPageId);
            }
        }
    }

    public void releaseRootChildrenPage(String pageId) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_FORM_SERVICE, (String)"releaseRootChildrenPage");){
            span.addTag(PAGE_ID, pageId);
            this.logInfo(String.format("releaseRootChildrenPage, pageId: %s", pageId), "releaseRootChildrenPage()");
            this.setReleaseOpContextByPageId(pageId);
            RootPageCache.clearPageCache((String)pageId);
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u6e05\u9664\u5b50\u9875\u9762\u5931\u8d25,pageId: %s .", (String)"FormServiceImpl_20", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), pageId);
            LogPrintUtil.printExceptionMessage((Exception)e, (String)msg);
        }
    }

    public String getThemeCSS(String themeNum) {
        String css = null;
        css = UserServiceHelper.getThemeCSS((String)themeNum);
        return css;
    }

    private static Object invokeMethod(IFormView formView, Object object, String methodName, Object[] args) throws Exception {
        String serviceName = object.getClass().getName() + "." + methodName + '@' + formView.getFormShowParameter().getFormId();
        try (Auditable audit = Audit.audit((String)("function,function_" + serviceName), (Object[])new Object[]{serviceName, args});){
            Object object2 = MethodUtils.invokeMethod((Object)object, (String)methodName, (Object[])args);
            return object2;
        }
    }

    public Map<String, Object> createConfig(FormShowParameter formParameter) {
        Map ret = FormConfigFactory.createConfigInCurrentAppService((FormShowParameter)formParameter);
        Boolean saas = SystemParamServiceImpl.checkIsPrivateCloud(RequestContext.get().getAccountId());
        ret.put("saas", saas);
        ret.put("userId", RequestContext.get().getUserId());
        ret.put("cloudUserId", RequestContext.get().getUid());
        if (SystemParamServiceImpl.isEnableKdWeiBo(RequestContext.get().getAccountId())) {
            ret.put("yzjUrl", SystemParamServiceImpl.getYzjUrl(RequestContext.get().getAccountId()));
        }
        ret.put("appImageUrl", formParameter.getCustomParam("appImageUrl"));
        Object formId = ret.get("formId");
        if ("bos_devpn_businessobj".equals(formId) || "ide_formdesigner".equals(formId)) {
            AppParam param = new AppParam();
            param.setAppId("83bfebc800003dac");
            long rootOrgId = ((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId();
            param.setOrgId(Long.valueOf(rootOrgId));
            param.setViewType("15");
            Map devParam = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param);
            ret.put("kdesignerRefType", devParam.get("fieldcreateway"));
        }
        if ("bos_modelasset_designer".equals(formId)) {
            ret.put("showTrayMenu", false);
        }
        return ret;
    }

    public List<Object> postChildFormStates(String pageId, List<Map<String, Object>> postDatas) {
        IFormView childForm = SessionManager.getCurrent().getView(pageId);
        if (childForm != null) {
            IFormController controller = (IFormController)childForm.getService(IFormController.class);
            controller.postData(postDatas);
            childForm.getModel().updateCache();
            return childForm.getActionResult();
        }
        return new ArrayList<Object>(0);
    }

    public List<Object> invokeOperation(String pageId, String operation) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view != null) {
            view.invokeOperation(operation);
            return view.getActionResult();
        }
        throw new RuntimeException(pageId + FORM_VIEW_NOT_FIND);
    }

    @Deprecated
    public String invokeResultOperation(String pageId, String operation) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view != null) {
            OperationResult operationResult = view.invokeOperation(operation);
            DataEntitySerializerOption option = new DataEntitySerializerOption();
            option.setIncludeComplexProperty(true);
            return DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        }
        throw new RuntimeException(pageId + FORM_VIEW_NOT_FIND);
    }

    public Map<String, Object> invokeOperationFromService(String pageId, String operation) {
        return this.invokeOperationFromService(pageId, operation, null);
    }

    public Map<String, Object> invokeOperationFromService(String pageId, String operation, Map<String, String> variables) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view != null) {
            OperateOption operationOption = OperateOption.create();
            if (variables != null && variables.size() > 0) {
                Set<Map.Entry<String, String>> entrySet = variables.entrySet();
                for (Map.Entry<String, String> entry : entrySet) {
                    operationOption.setVariableValue(entry.getKey(), entry.getValue());
                }
            }
            if (StringUtils.isBlank((CharSequence)view.getPageCache().get("bos_open_done")) && !"close".equals(operation)) {
                String msg = ResManager.loadKDString((String)"\u9875\u9762\u672a\u52a0\u8f7d\u5b8c\u6210\uff0c\u8bf7\u7b49\u5f85\u3002", (String)"FormServiceImpl_15", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]);
                OperationResult operationResult = new OperationResult();
                operationResult.setSuccess(false);
                operationResult.setMessage(msg);
                this.logInfo(String.format("Concurrent requests: The page has not completed loading.%s,%s", operation, operationOption), "invokeOperationFromService()");
            }
            OperationResult operationResult = view.invokeOperation(operation, operationOption);
            Map<String, Object> ret = FormServiceImpl.getOperationResultMap(view, operationResult);
            return ret;
        }
        throw new RuntimeException(pageId + FORM_VIEW_NOT_FIND);
    }

    @NotNull
    private static Map<String, Object> getOperationResultMap(IFormView view, OperationResult operationResult) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String resultStr = "";
        if (operationResult != null) {
            DataEntitySerializerOption option = new DataEntitySerializerOption();
            option.setIncludeComplexProperty(true);
            resultStr = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        }
        if (view != null) {
            ret.put("actionResult", view.getActionResult());
        } else {
            ret.put("actionResult", "[]");
        }
        ret.put("operationResult", resultStr);
        return ret;
    }

    public String createPage(String qingShowParameterString) {
        QingCachedFormParameter qingCachedormParameter = QingCachedFormParameter.deSerialize((String)qingShowParameterString);
        DB.beginThreadRead((String)"qing");
        FormShowParameter listShowParameter = qingCachedormParameter.createFormShowParameter();
        Map items = FormConfigFactory.createConfig((FormShowParameter)listShowParameter);
        if (items.get(CANCEL) != null) {
            log.warn(items.toString());
            throw new KDException(BosErrorCode.methodInvocation, new Object[]{items.get(CANCEL_MESSAGE)});
        }
        String pageId = (String)items.get(PAGE_ID);
        IFormView formView = SessionManager.getCurrent().getView(pageId);
        IFormController srv = (IFormController)formView.getService(IFormController.class);
        try {
            if (StringUtils.isBlank((CharSequence)qingCachedormParameter.getControlKey())) {
                FormServiceImpl.invokeMethod(formView, srv, "restoreQingQueryFilterParameter", new Object[]{qingCachedormParameter});
                srv.loadData();
            } else {
                Control ctrl = formView.getControl(qingCachedormParameter.getControlKey());
                if (!(ctrl instanceof IQingAnalysis)) {
                    throw new KDException(BosErrorCode.beanNotOfRequiredType, new Object[]{SerializationUtils.toJsonString((Object)(CONTROL_WITH_KEY + qingCachedormParameter.getControlKey() + IS_NOT_INSTANCEOF_IQING_ANALYSIS))});
                }
                ((IQingAnalysis)ctrl).setFilterParameter(qingCachedormParameter.getSerializedFilterString());
                srv.loadData();
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.methodInvocation, new Object[]{e});
        }
        finally {
            srv.destory();
            DB.endThreadReadWrite();
        }
        return pageId;
    }

    public String getQingQueryFilterParameter(String pageId, String controlKey) {
        IFormView formView = SessionManager.getCurrent().getView(pageId);
        IFormController srv = (IFormController)formView.getService(IFormController.class);
        try {
            Object ctrl;
            if (StringUtils.isBlank((CharSequence)controlKey)) {
                Object returnValue = FormServiceImpl.invokeMethod(formView, srv, "getQingQueryFilterParameter", new Object[0]);
                if (returnValue != null) {
                    String string = returnValue.toString();
                    return string;
                }
            } else {
                ctrl = formView.getControl(controlKey);
                if (ctrl instanceof IQingAnalysis) {
                    QingCachedFormParameter qingCachedFormParameter = formView.getFormShowParameter().createQingCachedFormParameter();
                    qingCachedFormParameter.setSerializedFilterString(((IQingAnalysis)ctrl).getFilterParameter());
                    qingCachedFormParameter.setControlKey(controlKey);
                    String string = qingCachedFormParameter.serialize();
                    return string;
                }
                String string = SerializationUtils.toJsonString((Object)(CONTROL_WITH_KEY + controlKey + IS_NOT_INSTANCEOF_IQING_ANALYSIS));
                return string;
            }
            ctrl = "";
            return ctrl;
        }
        catch (Exception e) {
            log.error(e.getMessage() + ",controlKey:" + controlKey, (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.methodInvocation, new Object[]{e});
        }
        finally {
            srv.destory();
        }
    }

    public Object getListViewFilterParameter(String pageId) {
        IFormView formView = SessionManager.getCurrent().getView(pageId);
        IFormController srv = (IFormController)formView.getService(IFormController.class);
        try {
            Object returnValue = FormServiceImpl.invokeMethod(formView, srv, "getListViewFilterParameter", new Object[0]);
            if (returnValue != null) {
                Object object = returnValue;
                return object;
            }
            String string = "";
            return string;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.methodInvocation, new Object[]{e});
        }
        finally {
            srv.destory();
        }
    }

    public Object getQingQueryContext(String pageId) {
        IFormView formView = SessionManager.getCurrent().getView(pageId);
        IFormController srv = (IFormController)formView.getService(IFormController.class);
        try {
            Object returnValue = FormServiceImpl.invokeMethod(formView, srv, "getQingQueryContext", new Object[0]);
            if (returnValue != null) {
                Object object = returnValue;
                return object;
            }
            String string = "";
            return string;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.methodInvocation, new Object[]{e});
        }
        finally {
            srv.destory();
        }
    }

    public String getCustomCtlVersion(String schemaId) {
        QFilter filter = new QFilter("schemaid", "=", (Object)schemaId);
        DynamicObject data = BusinessDataServiceHelper.loadSingleFromCache((String)"ide_controlschema", (String)"version", (QFilter[])new QFilter[]{filter});
        if (data != null) {
            return data.getString("version");
        }
        return "";
    }

    public List<Map<String, Object>> getAttachmentUrlsByPkId(String pkId) {
        if (StringUtils.isEmpty((CharSequence)pkId)) {
            return Collections.EMPTY_LIST;
        }
        IAttachmentModelProxy attachmentProxyService = (IAttachmentModelProxy)ServiceFactory.getService(IAttachmentModelProxy.class);
        return attachmentProxyService.getAttachments("ide_controlschema", (Object)pkId, "attachmentpanelap");
    }

    public boolean checkGuestAccess(String formId) {
        if ("-1".equalsIgnoreCase(RequestContext.get().getUserId())) {
            if (this.isGuestWhiteList(formId)) {
                return true;
            }
            try {
                String entityTypeId = FormMetadataCache.getFormConfig((String)formId).getEntityTypeId();
                PermissionControlType permControlType = EntityMetadataCache.getPermissionControlType((String)entityTypeId);
                if (permControlType != null && permControlType.isAnonymousUserControl()) {
                    return true;
                }
            }
            catch (KDBizException e) {
                log.info(e.getMessage(), (Object)e);
                return false;
            }
            catch (Exception e) {
                log.error((Throwable)e);
                return false;
            }
        }
        return false;
    }

    private boolean isGuestWhiteList(String formId) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_FORM_SERVICE, (String)"isGuestWhiteList");){
            if (span.isRealtime()) {
                span.addTag("formId", formId);
            }
            for (String form : guestFormWhiteList) {
                if (!form.equals(formId)) continue;
                boolean bl = true;
                return bl;
            }
            String tenantId = RequestContext.get().getTenantId();
            String guestForms = SystemPropertyUtils.getProptyByTenant((String)"security.meta.guestwhitelist", (String)tenantId);
            if (span.isRealtime()) {
                span.addTag("tenantId", tenantId);
                span.addTag("guestForms", guestForms);
            }
            if (StringUtils.isNotBlank((CharSequence)guestForms)) {
                String[] guestFormArray;
                for (String form : guestFormArray = guestForms.split(",")) {
                    if (!form.equals(formId)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            int n = 0;
            return n != 0;
        }
    }

    private boolean checkPageSessionOwner(String pageId) {
        SessionManager sm = SessionManager.getCurrent();
        IFormView formView = sm.getViewNoPlugin(pageId);
        if (formView != null) {
            String sessionId = formView.getFormShowParameter().getSessionId();
            if (!RequestContext.get().getGlobalSessionId().equals(sessionId)) {
                return false;
            }
        }
        return true;
    }

    private String showConfigErrMsg(String errorType, String msg) {
        HashMap<String, Object> clientPageAction = new HashMap<String, Object>();
        HashMap<String, Object> clientActionParas = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> paras = new ArrayList<HashMap<String, Object>>();
        clientPageAction.put("p", paras);
        clientPageAction.put("a", "showErrMsg");
        clientActionParas.put("type", 1);
        clientActionParas.put("errorTitle", ResManager.loadKDString((String)"\u52a0\u8f7d\u5931\u8d25", (String)"FormServiceImpl_9", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
        clientActionParas.put("errorInfo", msg);
        clientActionParas.put("errorType", errorType);
        paras.add(clientActionParas);
        ArrayList<HashMap<String, Object>> acts = new ArrayList<HashMap<String, Object>>();
        acts.add(clientPageAction);
        return SerializationUtils.toJsonString(acts);
    }

    private void addCsrfTokenAction(String csrfToken, List<Object> actionResult) {
        if (StringUtils.isNotBlank((CharSequence)csrfToken)) {
            HashMap<String, String> csrfMap = new HashMap<String, String>();
            csrfMap.put("p", csrfToken);
            csrfMap.put("a", "setCsrf");
            actionResult.add(0, csrfMap);
        }
    }

    private boolean isWebAction(Map<String, Object> actionParams) {
        Object isWeb = actionParams.get("web");
        return isWeb != null && (Boolean)isWeb != false;
    }

    private void setCheckRightAppIdByParentPageId(Map<String, Object> params) {
        IFormView parentView;
        String parentPageId;
        String string = parentPageId = params.get("parentPageId") == null ? "" : (String)params.get("parentPageId");
        if (StringUtils.isBlank((Object)params.get("appId")) && StringUtils.isBlank((Object)params.get("appid")) && StringUtils.isBlank((Object)params.get("app")) && StringUtils.isBlank((Object)params.get("checkRightAppId")) && StringUtils.isNotBlank((CharSequence)parentPageId) && (parentView = SessionManager.getCurrent().getView(parentPageId)) != null && parentView.getFormShowParameter() != null && StringUtils.isNotBlank((CharSequence)parentView.getFormShowParameter().getAppId())) {
            params.put("checkRightAppId", parentView.getFormShowParameter().getAppId());
        }
    }

    private void logInfo(String content, String method) {
        log.info(String.format("method %s: %s", method, content));
    }

    private void logWarn(String content, String method) {
        log.warn(String.format("method %s: %s", method, content));
    }

    public String getListSelectedRows(String pageId) {
        ListSelectedRowCollection selectedRows;
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view instanceof AbstractListView && !(selectedRows = ((AbstractListView)view).getSelectedRows()).isEmpty()) {
            return SerializationUtils.toJsonString((Object)selectedRows);
        }
        return "[]";
    }

    static {
        FormShowParameter.putPTypes((String)"report", ReportShowParameter.class);
    }

    class ReleaseTask
    extends TimerTask {
        private String rootPageId;
        private RequestContext context;

        public ReleaseTask(RequestContext context, String rootPageId) {
            this.rootPageId = rootPageId;
            this.context = context;
        }

        @Override
        public void run() {
            ManagedThreadFeature mt = new ManagedThreadFeature();
            try {
                mt.start();
                RequestContext.copyAndSet((RequestContext)this.context);
                FormServiceImpl.this.setReleaseOpContextByPageId(this.rootPageId);
                if (RootPageCache.isExistDelayClearPageId((String)this.rootPageId)) {
                    RootPageCache.removeDelayClearPageId((String)this.rootPageId);
                    RootPageCache.clearRootCahe((String)this.rootPageId);
                }
            }
            catch (Throwable e) {
                log.error(e);
            }
            finally {
                mt.end();
            }
        }
    }
}

