/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.form.auditlog;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.auditlog.ContextParam;
import kd.bos.mservice.form.auditlog.CreateBugResult;
import kd.bos.mservice.form.auditlog.IAuditLogHandler;
import kd.bos.mservice.form.auditlog.LoginResult;
import kd.bos.mservice.form.auditlog.TokenResult;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class DevopsMsgHandler
implements IAuditLogHandler {
    private static final int HTTP_CONNECTION_TIMEOUT = Integer.getInteger("monitor.http.connect.timeout", 5000);
    private static final int HTTP_REQUEST_TIMEOUT = Integer.getInteger("monitor.http.request.timeout", 5000);
    protected ContextParam cp;
    private static String DEFAULTDEVOPS_HOST = "https://feature.kingdee.com:1026/patchother/";
    private static final String QUERY_MODULEID = "kapi/sys/dmp_module_org/query";
    private static final String DMPBUG_URL = "/kapi/app/dmp/DmpBugApi";
    private static final String TOKEN_URL = "/api/getAppToken.do";
    private static final String LOGIN_URL = "/api/login.do";
    private static Log log = LogFactory.getLog(DevopsMsgHandler.class);
    private final String WEBAPI_APPID = "AuditLog";
    private final String DMP_ACCOUNTID = "201912130132588999";
    private final String DMP_TENANTID = "patchother";
    private final String DMP_USER = "17299999999";
    private final String DMP_PRODUCT = ResManager.loadKDString((String)"\u82cd\u7a79\u5355\u5143\u6d4b\u8bd5", (String)"DevopsMsgHandler_0", (String)"bos-mservice-form", (Object[])new Object[0]);

    public DevopsMsgHandler(ContextParam cp) {
        this.cp = cp;
    }

    private String getDMPAPPID() {
        String appid = System.getProperty("devops.auditlog.appid");
        if (StringUtils.isNotEmpty((CharSequence)appid)) {
            return appid;
        }
        return "AuditLog";
    }

    private String getDMPAppSecuret() {
        String appsecuret = System.getProperty("devops.auditlog.appsecuret");
        if (StringUtils.isNotEmpty((CharSequence)appsecuret)) {
            return appsecuret;
        }
        return "";
    }

    private String getDMPAccountID() {
        String accountid = System.getProperty("devops.auditlog.accountid");
        if (StringUtils.isNotEmpty((CharSequence)accountid)) {
            return accountid;
        }
        return "201912130132588999";
    }

    private String getDMPUSER() {
        String user = System.getProperty("devops.auditlog.user");
        if (StringUtils.isNotEmpty((CharSequence)user)) {
            return user;
        }
        return "17299999999";
    }

    private String getDMPTenantID() {
        String tenantid = System.getProperty("devops.auditlog.tenantid");
        if (StringUtils.isNotEmpty((CharSequence)tenantid)) {
            return tenantid;
        }
        return "patchother";
    }

    private String getDMPHost() {
        String devopshost = System.getProperty("devops.host");
        if (StringUtils.isNotEmpty((CharSequence)devopshost)) {
            return devopshost;
        }
        return DEFAULTDEVOPS_HOST;
    }

    private String getDMPProduct() {
        String product = System.getProperty("devops.product");
        if (StringUtils.isNotEmpty((CharSequence)product)) {
            return product;
        }
        return this.DMP_PRODUCT;
    }

    @Override
    public CreateBugResult createBugs(String appid, String formid, String formName, String formMethod, String msg) {
        CreateBugResult result = new CreateBugResult();
        try {
            JSONArray bugDatas;
            int pos;
            String accessToken = this.getAccessToken();
            String moduleID = this.getModuleID(appid, accessToken, result);
            if (!result.isSuccess()) {
                return result;
            }
            JSONObject param = new JSONObject();
            param.put("action", (Object)"insert");
            JSONObject dataResult = new JSONObject();
            dataResult.put("product", (Object)this.getDMPProduct());
            dataResult.put("route", (Object)moduleID);
            String title = "";
            if (msg != null && (pos = msg.indexOf(ResManager.loadKDString((String)"\u6027\u80fd\u5ba1\u8ba1", (String)"DevopsMsgHandler_1", (String)"bos-mservice-form", (Object[])new Object[0]))) > 0) {
                title = msg.substring(pos);
                title = title.substring(0, title.indexOf(41) + 1);
            }
            dataResult.put("name", (Object)String.format(ResManager.loadKDString((String)"\u3010\u6027\u80fd\u5ba1\u8ba1\u8d85\u6807\u3011%1$s%2$s", (String)"DevopsMsgHandler_2", (String)"bos-mservice-form", (Object[])new Object[0]), title, formMethod));
            dataResult.put("dataenv", (Object)this.cp.getDomainUrl());
            String contextMsg = " Tenantid:" + this.cp.getTenantid() + " Accountid:" + this.cp.getAccountId() + " TraceID:" + this.cp.getTraceId() + " UserName:" + this.cp.getUserId();
            dataResult.put("bugdes", (Object)(contextMsg + " \n" + msg));
            JSONArray ja = new JSONArray();
            ja.add((Object)dataResult);
            param.put("data", (Object)ja);
            StringBuilder posturl = new StringBuilder();
            posturl.append(this.getDMPHost());
            posturl.append(DMPBUG_URL);
            String resultData = this.doPostJson(posturl.toString(), param.toJSONString(), accessToken);
            JSONObject jo = (JSONObject)JSONObject.parseObject((String)resultData, JSONObject.class);
            result.setSuccess(Boolean.parseBoolean(jo.getString("success")));
            result.setMessage(jo.getString("message"));
            if (!result.isSuccess()) {
                log.error(jo.getString("stack"));
            }
            if ((bugDatas = jo.getJSONArray("data")).size() > 0) {
                JSONObject bugInfo = bugDatas.getJSONObject(0);
                result.setBugCode(bugInfo.getString("number"));
            }
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Object)e);
        }
        return result;
    }

    public String getAccessToken() throws Exception {
        String token_param = "{\"appId\": \"" + this.getDMPAPPID() + "\",\"appSecuret\": \"" + this.getDMPAppSecuret() + "\",\"tenantid\": \"" + this.getDMPTenantID() + "\",\"accountId\": \"" + this.getDMPAccountID() + "\",\"language\": \"zh_CN\"}";
        String token_result = this.doPostJson(this.getDMPHost() + TOKEN_URL, token_param, "");
        TokenResult tokenResult = (TokenResult)JSONObject.parseObject((String)token_result, TokenResult.class);
        if (tokenResult.getData() == null || tokenResult.getData().getApp_token() == null || StringUtils.isEmpty((CharSequence)tokenResult.getData().getApp_token())) {
            throw new KDException(BosErrorCode.methodInvocation, new Object[]{"no accessToken returned"});
        }
        String appToken = tokenResult.getData().getApp_token();
        String accessToken_param = "{\"apptoken\": \"" + appToken + "\",\"user\": \"" + this.getDMPUSER() + "\",\"logintype\": \"2\",\"appSecuret\": \"" + this.getDMPAppSecuret() + "\",\"tenantid\": \"" + this.getDMPTenantID() + "\",\"accountId\": \"" + this.getDMPAccountID() + "\",\"language\": \"zh_CN\"}";
        String accessToken_result = this.doPostJson(this.getDMPHost() + LOGIN_URL, accessToken_param, "");
        LoginResult accessData = (LoginResult)JSONObject.parseObject((String)accessToken_result, LoginResult.class);
        return accessData.getData().getAccess_token();
    }

    public String doPostJson(String url, String json, String accessToken) throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(HTTP_REQUEST_TIMEOUT).setConnectTimeout(HTTP_CONNECTION_TIMEOUT).build()).build();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-Type", "application/json");
            httpPost.addHeader("access_token", accessToken);
            StringEntity entity = new StringEntity(json, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return resultString;
    }

    private String getModuleID(String appid, String accessToken, CreateBugResult result) throws Exception {
        JSONArray returnData;
        JSONObject data;
        StringBuilder posturl = new StringBuilder();
        posturl.append(this.getDMPHost());
        posturl.append(QUERY_MODULEID);
        posturl.append("?select=id,number,useorg&detailquery=true&filter=modulecode%20EQ%20");
        posturl.append(appid);
        JSONObject param = new JSONObject();
        String moduleResult = this.doPostJson(posturl.toString(), param.toJSONString(), accessToken);
        JSONObject jo = (JSONObject)JSONObject.parseObject((String)moduleResult, JSONObject.class);
        if (jo != null && (data = (JSONObject)jo.get((Object)"data")) != null && (returnData = (JSONArray)((JSONObject)jo.get((Object)"data")).get((Object)"rows")).size() > 0) {
            return ((JSONObject)returnData.get(0)).get((Object)"id").toString();
        }
        result.setSuccess(false);
        result.setMessage(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5e94\u7528\u5bf9\u5e94\u7684\u6a21\u5757,\u6a21\u5757\u7b80\u7801:%s", (String)"DevopsMsgHandler_3", (String)"bos-mservice-form", (Object[])new Object[0]), appid));
        return null;
    }
}

