/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.metatemplate.fragment;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.mservice.metatemplate.fragment.MetaFragmentTemplate;
import kd.bos.mservice.metatemplate.fragment.MetaFragmentTemplateGroupTreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class MetaFragmentTemplateServiceImpl {
    private static final String ID_NUMBER_NAME = "id,number,name,";
    private static final String SELECT_FIELDS = "longnumber,level,isleaf,parent.number,order";
    private static final String ENABLE = "enable";
    private static final String LEVEL = "level";
    private static final String METAFRAGTPLCAT_ORDERBY = "level,order";
    private static final String SELECT_FIELDS_2 = "id,number,name,group.number,";
    private static final String BOS_METAFRAGTPLCAT = "bos_metafragtplcat";
    private static final String BOS_METAFRAGTPL = "bos_metafragtpl";

    private DynamicObjectCollection[] loadFragments() {
        DynamicObjectCollection categories = QueryServiceHelper.query((String)BOS_METAFRAGTPLCAT, (String)"id,number,name,longnumber,level,isleaf,parent.number,order,type", (QFilter[])new QFilter[]{new QFilter(ENABLE, "=", (Object)"1")}, (String)METAFRAGTPLCAT_ORDERBY);
        DynamicObjectCollection fragments = QueryServiceHelper.query((String)BOS_METAFRAGTPL, (String)"id,number,name,group.number,src", (QFilter[])new QFilter[]{new QFilter(ENABLE, "=", (Object)"1")});
        return new DynamicObjectCollection[]{categories, fragments};
    }

    public String getFragmentTemplates() {
        int i;
        MetaFragmentTemplateGroupTreeNode node;
        DynamicObjectCollection[] result = null;
        try {
            result = this.loadFragments();
        }
        catch (Exception e) {
            return "[]";
        }
        DynamicObjectCollection categories = result[0];
        DynamicObjectCollection templates = result[1];
        List nodes = categories.stream().map(MetaFragmentTemplateGroupTreeNode::of).collect(Collectors.toList());
        Map<String, MetaFragmentTemplateGroupTreeNode> nodeMap = nodes.stream().collect(Collectors.toMap(MetaFragmentTemplateGroupTreeNode::getGroupId, item -> item));
        MetaFragmentTemplateGroupTreeNode root = new MetaFragmentTemplateGroupTreeNode();
        for (int i2 = 0; i2 < nodes.size(); ++i2) {
            int level = ((DynamicObject)categories.get(i2)).getInt(LEVEL);
            if (level == 1) {
                root.createOrGetChildren().add((MetaFragmentTemplateGroupTreeNode)nodes.get(i2));
                continue;
            }
            node = nodeMap.get(((DynamicObject)categories.get(i2)).getString("parent.number"));
            if (node == null) continue;
            node.createOrGetChildren().add((MetaFragmentTemplateGroupTreeNode)nodes.get(i2));
        }
        List metaFragmentTemplates = templates.stream().map(MetaFragmentTemplate::of).collect(Collectors.toList());
        for (i = 0; i < metaFragmentTemplates.size(); ++i) {
            String groupId = ((DynamicObject)templates.get(i)).getString("group.number");
            MetaFragmentTemplateGroupTreeNode node2 = nodeMap.get(groupId);
            if (node2 == null) continue;
            node2.createOrGetTempFragments().add((MetaFragmentTemplate)metaFragmentTemplates.get(i));
        }
        for (i = nodes.size() - 1; i >= 0; --i) {
            MetaFragmentTemplateGroupTreeNode parent;
            node = (MetaFragmentTemplateGroupTreeNode)nodes.get(i);
            if (node.getTempFragments() != null && node.getTempFragments().size() > 0 || node.getChildren() != null && node.getChildren().size() > 0 || (parent = nodeMap.get(((DynamicObject)categories.get(i)).getString("parent.number"))) == null) continue;
            parent.getChildren().remove(node);
        }
        return SerializationUtils.toJsonString(root.createOrGetChildren());
    }

    public String getDesignerFragmentMetadata(String fragmentId) {
        DynamicObject fragment = QueryServiceHelper.queryOne((String)BOS_METAFRAGTPL, (String)"id,number,name,group.number,src,data_tag", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)fragmentId), new QFilter(ENABLE, "=", (Object)"1")});
        String result = fragment.getString("data_tag");
        if (result == null) {
            result = "";
        }
        return result;
    }
}

