/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.notification;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.exception.ErrorCode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.ExceptionHandler;
import kd.bos.mservice.notification.NotificationFormService;
import kd.bos.mvc.SessionManager;
import kd.bos.notification.NotificationClickProxy;
import kd.bos.response.ResponseHeader;
import kd.bos.servicehelper.notification.NotificationServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class NotificationFormServiceImpl
implements NotificationFormService {
    private static Log log = LogFactory.getLog(NotificationFormServiceImpl.class);

    public String notificationButtonClick(String pageId, String notificationId, String buttonKey, String params) {
        try {
            IFormView formView = SessionManager.getCurrent().getView(pageId);
            if (formView == null) {
                return "{\"success\":false,\"error_desc\":\"pageId timeout\",\"error_code\":100}";
            }
            NotificationClickProxy notificationClickProxy = new NotificationClickProxy(formView, notificationId);
            notificationClickProxy.click(buttonKey);
            if ("ignore".equals(buttonKey)) {
                NotificationServiceHelper.sendIgnoreNotification((String)RequestContext.get().getUserId(), (String)notificationId);
            }
            List results = formView == null ? new ArrayList() : formView.getActionResult();
            String str_result = SerializationUtils.toJsonString(results);
            return str_result;
        }
        catch (Exception ex) {
            List<Object> results = this.createJSONObjectException("", ex);
            String jsonString = SerializationUtils.toJsonString(results);
            log.error(jsonString);
            return jsonString;
        }
    }

    public String clearNotifications(String s, List<String> list) {
        return null;
    }

    public String clearNotifications(String pageId, List<String> notificationIds, int level) {
        try {
            IFormView mainView = SessionManager.getCurrent().getView(pageId);
            for (String notificationId : notificationIds) {
                NotificationClickProxy notificationClickProxy = new NotificationClickProxy(mainView, notificationId);
                notificationClickProxy.close();
            }
            NotificationServiceHelper.sendClearNotification((String)RequestContext.get().getUserId(), notificationIds, (int)level);
            List results = mainView == null ? new ArrayList() : mainView.getActionResult();
            String str_result = SerializationUtils.toJsonString(results);
            return str_result;
        }
        catch (Exception ex) {
            List<Object> results = this.createJSONObjectException("", ex);
            String jsonString = SerializationUtils.toJsonString(results);
            log.error(jsonString);
            return jsonString;
        }
    }

    public String getAppId(String pageId) {
        if (StringUtils.isBlank((CharSequence)pageId)) {
            return "";
        }
        FormShowParameter parameter = SessionManager.getCurrent().getFormShowParameter(pageId);
        if (parameter != null) {
            return parameter.getServiceAppId();
        }
        return "";
    }

    private List<Object> createJSONObjectException(String method, Throwable ex) {
        TX.setResponseException((Throwable)ex);
        ArrayList<Object> acts = new ArrayList<Object>();
        Map<String, Object> action = ExceptionHandler.HandlerErr(ex, "");
        acts.add(action);
        ResponseHeader.get().error(new ErrorCode("NotificationServiceInvoke/" + method, ex.getMessage()));
        return acts;
    }
}

