/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.preheat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.framework.lifecycle.Service;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.jetbrains.annotations.Nullable;

public class DataPreHeatService
implements Service {
    private static Log log = LogFactory.getLog(DataPreHeatService.class);

    public String getName() {
        return DataPreHeatService.class.getSimpleName();
    }

    public void start() {
        log.info("Preheating basedata...");
        String[] appIds = Instance.getAppIds();
        if (appIds == null || appIds.length == 0) {
            appIds = new String[]{DBRoute.basedata.getRouteKey()};
        }
        if ("bos-up".equals(appIds[0])) {
            log.info("Preheat basedata finish(bos-up node does not preheat)");
            return;
        }
        Map<String, Object> preHeatCfg = this.getPreHeatDataParameter();
        if (preHeatCfg.isEmpty()) {
            log.info("Preheat basedata finish(has not preheat config)");
            return;
        }
        List<HeatAccountGroupInfo> heatAccountGroupList = this.getHeatInfo(appIds, preHeatCfg);
        this.preHeatCache(heatAccountGroupList);
        log.info("Preheat basedata finish");
    }

    public void stop() {
    }

    public boolean isStarted() {
        return false;
    }

    private Map<String, Object> getPreHeatDataParameter() {
        String[] appIds = Instance.getAppIds();
        String preheartCfg = System.getProperty("kd.data.preheat");
        if (preheartCfg != null && preheartCfg.length() > 0) {
            try {
                return (Map)SerializationUtils.fromJsonString((String)preheartCfg, Map.class);
            }
            catch (Exception e) {
                log.error("Get Preheatdata parameter error", (Throwable)e);
            }
        }
        return new HashMap<String, Object>();
    }

    private List<HeatAccountGroupInfo> getHeatInfo(String[] appIds, Map<String, Object> preHeatCfg) {
        ArrayList<HeatAccountGroupInfo> accountGroupInfoList = new ArrayList<HeatAccountGroupInfo>(2);
        for (Account account : this.getAllAccountsOfCurrentEnv()) {
            try {
                Map appPreHeatMap = (Map)preHeatCfg.get(account.getAccountId());
                if (appPreHeatMap == null) continue;
                HeatAccountGroupInfo accountGroupInfo = new HeatAccountGroupInfo(account);
                for (String appId : appIds) {
                    Map entityPreHeatMap = (Map)appPreHeatMap.get(appId);
                    if (entityPreHeatMap == null) continue;
                    HeatAppGroupInfo heatAppGroupInfo = new HeatAppGroupInfo(appId);
                    List<HeatEntityInfo> heatEntityInfoList = this.convertHeatEntityInfo(account.getAccountId(), entityPreHeatMap);
                    heatAppGroupInfo.addAll(heatEntityInfoList);
                    accountGroupInfo.add(heatAppGroupInfo);
                }
                accountGroupInfoList.add(accountGroupInfo);
            }
            catch (Exception e) {
                log.error("Preheat data convert error", (Throwable)e);
            }
        }
        return accountGroupInfoList;
    }

    private void preHeatCache(List<HeatAccountGroupInfo> heatAccountGroupList) {
        try {
            Integer preheatLimitSize = this.getPreHeatLimit();
            int preheatSize = 0;
            for (HeatAccountGroupInfo heatAccountGroup : heatAccountGroupList) {
                ArrayList<Object> entityNumbers = new ArrayList<Object>(16);
                for (HeatAppGroupInfo heatAppGroup : heatAccountGroup.HeatAppInfos) {
                    for (HeatEntityInfo heatEntityInfo : heatAppGroup.HeatEntityInfos) {
                        entityNumbers.add(heatEntityInfo.entityName);
                    }
                }
                heatAccountGroup.connectToAccount();
                List<String> existEntityNumbers = this.queryEntityKeys(entityNumbers);
                for (HeatAppGroupInfo heatAppGroup : heatAccountGroup.HeatAppInfos) {
                    for (HeatEntityInfo heatEntityInfo : heatAppGroup.HeatEntityInfos) {
                        if (!existEntityNumbers.contains(heatEntityInfo.entityName)) continue;
                        if (preheatLimitSize != null && (preheatSize += heatEntityInfo.pks.length) > preheatLimitSize) {
                            log.info("The preheat data exceeds param (kd.data.preheatlimit) limit.");
                            return;
                        }
                        heatEntityInfo.preHeatCache();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Preheating data error", (Throwable)e);
        }
    }

    private List<HeatEntityInfo> convertHeatEntityInfo(String accountId, Map<String, Object> entityPreHeatMap) {
        ArrayList<HeatEntityInfo> heatEntityInfoList = new ArrayList<HeatEntityInfo>(16);
        for (Map.Entry<String, Object> entityItem : entityPreHeatMap.entrySet()) {
            Map typeValueMap = (Map)entityItem.getValue();
            for (Map.Entry entry : typeValueMap.entrySet()) {
                List<String> fields = Arrays.asList(((String)entry.getKey()).split(","));
                HeatEntityInfo entityInfo = new HeatEntityInfo(entityItem.getKey(), fields, ((List)entry.getValue()).toArray(new Object[0]));
                heatEntityInfoList.add(entityInfo);
            }
        }
        return heatEntityInfoList;
    }

    private List<String> queryEntityKeys(List<Object> entityNumbers) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("/*dialect*/select distinct fnumber from t_meta_entity where ftype = 11 and ", new Object[0]);
        builder.appendIn("fnumber", entityNumbers);
        return (List)DB.query((DBRoute)DBRoute.of((String)"sys.meta"), (SqlBuilder)builder, rs -> {
            ArrayList<String> result = new ArrayList<String>(entityNumbers.size());
            while (rs.next()) {
                result.add(rs.getString(1));
            }
            return result;
        });
    }

    private List<Account> getAllAccountsOfCurrentEnv() {
        try {
            return AccountUtils.getAllAccountsOfCurrentEnv();
        }
        catch (Exception ignored) {
            log.warn("Current env don't have tenant");
            return Collections.emptyList();
        }
    }

    @Nullable
    private Integer getPreHeatLimit() {
        Integer preheatLimitSize = null;
        String preheatLimitString = System.getProperty("kd.data.preheatlimit");
        if (preheatLimitString != null) {
            try {
                preheatLimitSize = Integer.parseInt(preheatLimitString);
            }
            catch (Exception e) {
                log.error("The preheat data config error(kd.data.preheatlimit).");
            }
        }
        return preheatLimitSize;
    }

    static class HeatEntityInfo {
        String entityName;
        Collection<String> fields;
        Object[] pks;

        HeatEntityInfo(String entityName, Collection<String> fields, Object[] pks) {
            this.entityName = entityName;
            this.fields = fields;
            this.pks = pks;
        }

        DynamicObjectType getEntityType() {
            return EntityMetadataCache.getSubDataEntityType((String)this.entityName, this.fields);
        }

        void preHeatCache() {
            BusinessDataServiceHelper.loadFromCache((Object[])this.pks, (DynamicObjectType)this.getEntityType());
        }
    }

    static class HeatAppGroupInfo {
        String appId;
        List<HeatEntityInfo> HeatEntityInfos;

        String getAppId() {
            return this.appId;
        }

        HeatAppGroupInfo(String appId) {
            this.appId = appId;
            this.HeatEntityInfos = new ArrayList<HeatEntityInfo>(16);
        }

        void add(HeatEntityInfo heatEntityInfo) {
            this.HeatEntityInfos.add(heatEntityInfo);
        }

        void addAll(List<HeatEntityInfo> heatEntityInfoList) {
            this.HeatEntityInfos.addAll(heatEntityInfoList);
        }
    }

    static class HeatAccountGroupInfo {
        Account account;
        List<HeatAppGroupInfo> HeatAppInfos;

        HeatAccountGroupInfo(Account accout) {
            this.account = accout;
            this.HeatAppInfos = new ArrayList<HeatAppGroupInfo>(16);
        }

        void add(HeatAppGroupInfo heatAppInfo) {
            this.HeatAppInfos.add(heatAppInfo);
        }

        void addAll(List<HeatAppGroupInfo> heatAppInfoList) {
            this.HeatAppInfos.addAll(heatAppInfoList);
        }

        String connectToAccount() {
            String tenantId = this.account.getTenantId();
            String accountId = this.account.getAccountId();
            RequestContextCreator.createForPreheat((String)tenantId, (String)accountId);
            return accountId;
        }
    }
}

