/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.sysparam;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.param.ParameterReader;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.service.ServiceSvcFactory;

public class SystemParamServiceImpl
implements SystemParamService {
    private static final String FALSE = "false";
    private static final String YZJURL = "https://www.yunzhijia.com";
    private static Log log = LogFactory.getLog(SystemParamServiceImpl.class);
    private static final DistributeSessionlessCache saasCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("config-saascache", new DistributeCacheHAPolicy());

    public Object getBillParameter(String formId, String key) {
        DynamicObject o = ParameterReader.getBillParameter((String)formId);
        return o.get(key);
    }

    public Object getBillTypeParameter(String formId, String paramFormId, long billTypeId) {
        return ParameterReader.getBillTypeParameter((String)formId, (String)paramFormId, (long)billTypeId);
    }

    public List<String> getGroupControlFields(String formId) {
        return ParameterReader.getGroupControlFields((String)formId);
    }

    public Object loadPublicParameterFromCache(String key) {
        return this.loadPublicParametersFromCache().get(key);
    }

    public Map<String, Object> loadPublicParametersFromCache() {
        return ParameterReader.loadPublicParameterFromCache();
    }

    public Map<String, Object> loadSystemParameterFromCache(String cloudId, String appId, String viewType, long orgId, long acctBookId) {
        return ParameterReader.loadSystemParameterFromCache((String)cloudId, (String)appId, (String)viewType, (long)orgId, (long)acctBookId);
    }

    public static Boolean checkIsPrivateCloud(String accountId) {
        String saas = FALSE;
        int timeOut = 60;
        try {
            String cacheKey = accountId + "-config-saascache";
            saas = (String)saasCache.get(cacheKey);
            if (StringUtils.isEmpty((CharSequence)saas) || !saas.equals("true") && !saas.equals(FALSE)) {
                JSONObject result;
                Account account = AccountUtils.getAccountById((String)accountId);
                if (StringUtils.isNotEmpty((CharSequence)account.getUserSourceTypeOutput())) {
                    log.info("mc:" + account.getUserSourceTypeOutput());
                    if (account.getUserSourceTypeOutput().contains("0")) {
                        saas = FALSE;
                    } else if (account.getUserSourceTypeOutput().contains("1")) {
                        saas = "true";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)saas)) {
                        saasCache.put(cacheKey, (Object)saas, timeOut);
                    }
                }
                if ((StringUtils.isEmpty((CharSequence)account.getUserSourceTypeOutput()) || !account.getUserSourceTypeOutput().contains("0") && !account.getUserSourceTypeOutput().contains("1")) && null != (result = SystemParamServiceImpl.getBasSysparameter(accountId)) && StringUtils.isNotEmpty((CharSequence)result.getString("yzjdeploymentmode"))) {
                    saas = result.getString("yzjdeploymentmode").equals("1") ? FALSE : "true";
                    saasCache.put(cacheKey, (Object)saas, timeOut);
                }
            }
        }
        catch (Exception e) {
            log.error("checkIsPublic\u5f02\u5e38:", (Throwable)e);
        }
        return Boolean.parseBoolean(saas);
    }

    public static String getYzjUrl(String accountId) {
        int timeOut = 60;
        String yzjurl = "";
        try {
            String cacheKey = accountId + "-config-yzjurl";
            yzjurl = (String)saasCache.get(cacheKey);
            if (StringUtils.isEmpty((CharSequence)yzjurl)) {
                JSONObject result = SystemParamServiceImpl.getBasSysparameter(accountId);
                if (null != result && StringUtils.isNotEmpty((CharSequence)result.getString("yzjurl"))) {
                    yzjurl = result.getString("yzjurl");
                    if (yzjurl.endsWith("/")) {
                        yzjurl = yzjurl.substring(0, yzjurl.length() - 1);
                    }
                    saasCache.put(cacheKey, (Object)yzjurl, timeOut);
                } else {
                    yzjurl = YZJURL;
                    saasCache.put(cacheKey, (Object)yzjurl, timeOut);
                }
            }
        }
        catch (Exception e) {
            log.error("getYzjUrl\u5f02\u5e38:", (Throwable)e);
        }
        return yzjurl;
    }

    public static boolean isEnableKdWeiBo(String accountId) {
        boolean flag = false;
        int timeOut = 60;
        try {
            String cacheKey = accountId + "-config-syncmode";
            String syncmode = (String)saasCache.get(cacheKey);
            if (StringUtils.isEmpty((CharSequence)syncmode)) {
                JSONObject result = SystemParamServiceImpl.getBasSysparameter(accountId);
                if (null != result && (StringUtils.isEmpty((CharSequence)result.getString("syncmode")) || "1".equals(result.getString("syncmode")))) {
                    saasCache.put(cacheKey, (Object)String.valueOf(flag), timeOut);
                } else {
                    flag = true;
                    saasCache.put(cacheKey, (Object)String.valueOf(flag), timeOut);
                }
                return flag;
            }
            flag = Boolean.parseBoolean(syncmode);
        }
        catch (Exception e) {
            log.error("isEnableKdWeiBo\u5f02\u5e38:", (Throwable)e);
            flag = true;
        }
        return flag;
    }

    public static JSONObject getBasSysparameter(String accountId) {
        JSONObject result = new JSONObject();
        long paramRootOrgId = ((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId();
        String sql = " SELECT fdata from t_bas_sysparameter WHERE fviewtypeid='15' AND forgid=%s AND fsubsystem='application/SYS/base' ";
        sql = String.format(sql, paramRootOrgId);
        String algoKey = "kd.bos.mservice.sysparam.query_t_bas_sysparameter";
        try (DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.basedata, (String)sql);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                String data = row.getString("fdata");
                result = JSONObject.parseObject((String)data);
            }
        }
        return result;
    }
}

