/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.domaindefine;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.domaindefine.DMImportAPI;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.metadata.domainmodel.define.DomainModelTypeFactory;
import kd.bos.service.domaindefine.DMDeployService;

public class DMDeployServiceImpl
implements DMDeployService {
    public String deploy(String deployInfo) {
        Map params = (Map)SerializationUtils.fromJsonString((String)deployInfo, Map.class);
        DeployResult result = new DeployResult();
        String tenantId = (String)params.get("tenant");
        String accountId = (String)params.get("accountid");
        if (StringUtils.isBlank((CharSequence)tenantId) || StringUtils.isBlank((CharSequence)accountId)) {
            result.setError(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u5408\u6cd5\u7684\u79df\u6237\uff08tenant\uff09|| \u8d26\u5957\uff08accountid\uff09", (String)"DMDeployServiceImpl_0", (String)"bos-mservice-form", (Object[])new Object[0]));
            result.setSuccess(false);
            return SerializationUtils.toJsonString((Object)result);
        }
        RequestContext ctxOld = null;
        if (!accountId.equals(RequestContext.get().getAccountId()) || !tenantId.equals(RequestContext.get().getTenantId())) {
            ctxOld = RequestContext.get();
            RequestContext ctxNew = RequestContext.create();
            ctxNew.setAccountId(accountId);
            ctxNew.setTenantId(tenantId);
            RequestContext.set((RequestContext)ctxNew);
        }
        List jarZips = (List)params.get("args");
        DMImportAPI api = new DMImportAPI();
        for (Map jarZip : jarZips) {
            String url = (String)jarZip.get("url");
            try {
                InputStream inputStream = this.getInputStream(url);
                Throwable throwable = null;
                try {
                    api.importZip(url, ResManager.loadKDString((String)"\u90e8\u7f72", (String)"DMDeployServiceImpl_1", (String)"bos-mservice-form", (Object[])new Object[0]), inputStream, list -> list.forEach(this::removeDomainModelCache));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (Exception ex) {
                result.setError(this.getExceptionStackTraceMessage(ex));
                result.setSuccess(false);
                break;
            }
        }
        if (ctxOld != null) {
            RequestContext.set((RequestContext)ctxOld);
        }
        return SerializationUtils.toJsonString((Object)result);
    }

    private void removeDomainModelCache(DynamicObject row) {
        String modelTypeIds;
        if (row.getDynamicObjectType().getName().equals("bos_devp_element") && !StringUtils.isBlank((CharSequence)(modelTypeIds = row.getBoolean("issys") ? row.getString("modeltype") : row.getString("applynumber")))) {
            String[] domainTypeIds;
            for (String domainTypeId : domainTypeIds = modelTypeIds.split(",")) {
                if (StringUtils.isBlank((CharSequence)domainTypeId)) continue;
                DomainModelTypeFactory.removeCache((String)domainTypeId);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private String getExceptionStackTraceMessage(Throwable ex) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private InputStream getInputStream(String url) throws IOException {
        String path = this.getParam(url, "path");
        URL urlfile = null;
        HttpURLConnection httpUrl = null;
        InputStream is = null;
        if (StringUtils.isNotBlank((CharSequence)path)) {
            is = FileServiceFactory.getAttachmentFileService().getInputStream(path);
        } else {
            urlfile = new URL(url);
            httpUrl = (HttpURLConnection)urlfile.openConnection();
            httpUrl.connect();
            is = httpUrl.getInputStream();
        }
        return is;
    }

    private String getParam(String url, String name) {
        String params = url.substring(url.indexOf("?") + 1);
        if (url.equals(params)) {
            return null;
        }
        Map split = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)params);
        return (String)split.get(name);
    }

    public static class DeployResult
    implements Serializable {
        private static final long serialVersionUID = 627039829396810062L;
        private boolean success = true;
        private String error;

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public void setError(String error) {
            this.error = error;
        }

        public boolean getSuccess() {
            return this.success;
        }

        public String getError() {
            return this.error;
        }
    }
}

