/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata;

import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetaRedisCacheUtils;
import kd.bos.entity.CloudInfo;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.framework.gray.GrayStrategy;
import kd.bos.instance.AppGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.mservice.runmode.RunModeService;
import kd.bos.product.ICoreProductSettingService;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import org.jetbrains.annotations.NotNull;

class AppMetadataServiceReader {
    private static final String FAPPID = ":FAPPID";
    private static final String ERROR_S = "Error:%s";
    private static final String DESCRIPTION = "description";
    private static final String NOCODE_CLOUD_ID = "2HGKCE94QELW";
    private static final String NOCODE_SYS_APP_ID = "2HGKTA7HH43C";
    private static final String FKEY = ":FKEY";
    private static Log log = LogFactory.getLog(AppMetadataServiceReader.class);

    AppMetadataServiceReader() {
    }

    synchronized Map<String, String> loadAllCloudInfo() {
        String key;
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("cloudmeta", new DistributeCacheHAPolicy());
        LinkedHashMap<String, String> val = cache.getAll(key = CacheKeyUtil.getAcctId() + "_cloud");
        if (val == null || val.isEmpty()) {
            List<CloudInfo> allCloudInfoList = this.queryAllCloudInfo();
            val = new LinkedHashMap<String, String>(allCloudInfoList.size());
            for (CloudInfo cloudInfo : allCloudInfoList) {
                val.put(cloudInfo.getNumber(), SerializationUtils.toJsonString((Object)cloudInfo));
            }
            log.info("db query: loadAllCloudInfo.");
            cache.put(key, val);
        }
        return val;
    }

    synchronized Map<String, String> loadAllAppInfo() {
        LinkedHashMap<String, String> val = AppMetaRedisCacheUtils.getAllAppCache();
        if (val == null || val.isEmpty()) {
            RequestContext rc;
            Map map;
            List<AppInfo> allAppInfoList = this.queryAllAppInfo(AppGroupUtils.getCurrentAppGroup());
            if (AppGroup.isGrayUpgrade() && !(map = GrayStrategy.getUserAppGroup((String)(rc = RequestContext.get()).getUserId(), (String)rc.getAccountId())).isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    String appGroup = (String)entry.getValue();
                    String appId = (String)entry.getKey();
                    if (!StringUtils.isNotBlank((CharSequence)appGroup) || "defaultGroup".equals(appGroup)) continue;
                    List<AppInfo> grayAppInfoList = this.queryAllAppInfo(appGroup);
                    allAppInfoList.addAll(grayAppInfoList);
                }
            }
            val = new LinkedHashMap<String, String>(allAppInfoList.size());
            for (AppInfo appInfo : allAppInfoList) {
                val.put(appInfo.getAppId(), SerializationUtils.toJsonString((Object)appInfo));
            }
            log.info("db query: loadAllAppInfo.");
            AppMetaRedisCacheUtils.putAppCache(val);
        }
        return val;
    }

    synchronized Map<String, String> loadAllAppMenusInfo() {
        LinkedHashMap val = AppMetaRedisCacheUtils.getAllMenuCache();
        if (val == null || val.isEmpty()) {
            RequestContext rc;
            Map map;
            LinkedHashMap<String, List> menuInfoMap = new LinkedHashMap<String, List>();
            List<AppMenuInfo> allAppMenuInfoList = this.queryAllAppMenuInfo(AppGroupUtils.getCurrentAppGroup());
            if (AppGroup.isGrayUpgrade() && !(map = GrayStrategy.getUserAppGroup((String)(rc = RequestContext.get()).getUserId(), (String)rc.getAccountId())).isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    String appGroup = (String)entry.getValue();
                    String appId = (String)entry.getKey();
                    if (!StringUtils.isNotBlank((CharSequence)appGroup) || "defaultGroup".equals(appGroup)) continue;
                    List<AppMenuInfo> grayAppMenuInfoList = this.queryAllAppMenuInfo(appGroup);
                    allAppMenuInfoList.addAll(grayAppMenuInfoList);
                }
            }
            for (AppMenuInfo appMenuInfo : allAppMenuInfoList) {
                List list = menuInfoMap.computeIfAbsent(appMenuInfo.getAppId(), p -> new ArrayList());
                list.add(appMenuInfo);
            }
            val = new LinkedHashMap(menuInfoMap.size());
            for (Map.Entry entry : menuInfoMap.entrySet()) {
                val.put(entry.getKey(), SerializationUtils.toJsonString(entry.getValue()));
            }
            log.info("db query: loadAllAppMenusInfo.");
            AppMetaRedisCacheUtils.putMenuCache(val);
        }
        return val;
    }

    List<CloudInfo> queryAllCloudInfo() {
        Set<String> cloudBlacklistSet = this.getDisabledCloudIds();
        String langsql = "SELECT FID,FLOCALEID,FNAME,FDESCRIPTION FROM T_META_BIZCLOUD_L ";
        HashMap mapCloudLang = new HashMap();
        DB.query((DBRoute)DBRoute.meta, (String)langsql, rs -> {
            while (rs.next()) {
                String id = rs.getString("FID");
                if (cloudBlacklistSet.contains(id)) continue;
                String localeid = rs.getString("FLOCALEID");
                LocaleString[] localeStrings = (LocaleString[])mapCloudLang.get(id);
                if (localeStrings == null) {
                    localeStrings = new LocaleString[]{new LocaleString(), new LocaleString()};
                    mapCloudLang.put(id, localeStrings);
                }
                String name = rs.getString("FNAME");
                localeStrings[0].setItem(localeid, (Object)name);
                String desc = rs.getString("FDESCRIPTION");
                localeStrings[1].setItem(localeid, (Object)desc);
            }
            return null;
        });
        String sql = "SELECT FID,FSEQ,FNUMBER FROM T_META_BIZCLOUD WHERE FVISIBLE = '1' ORDER BY FSEQ ";
        ArrayList<CloudInfo> list = new ArrayList<CloudInfo>();
        DB.query((DBRoute)DBRoute.meta, (String)sql, rs -> {
            while (rs.next()) {
                String id = rs.getString("FID");
                if (cloudBlacklistSet.contains(id)) continue;
                CloudInfo cloudInfo = new CloudInfo();
                cloudInfo.setId(id);
                int seq = rs.getInt("FSEQ");
                cloudInfo.setOrder(seq);
                String number = rs.getString("FNUMBER");
                cloudInfo.setNumber(number);
                LocaleString[] localeStrings = (LocaleString[])mapCloudLang.get(id);
                cloudInfo.setName(localeStrings[0]);
                cloudInfo.setDescription(localeStrings[1]);
                list.add(cloudInfo);
            }
            return null;
        });
        return list;
    }

    List<AppInfo> queryAllAppInfo(String appGroup) {
        try {
            return this.queryAllAppInfoV2(appGroup);
        }
        catch (Exception ex) {
            if (!DB.existColumn((DBRoute)DBRoute.meta, (String)AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_APPRUNTIME"), (String)"FVISIBLE")) {
                log.error("Read T_META_APPRUNTIME_V2 error.", (Throwable)ex);
                return this.queryAllAppInfoV1(appGroup);
            }
            throw ex;
        }
    }

    List<AppMenuInfo> queryAllAppMenuInfo(String appGroup) {
        ArrayList<AppMenuInfo> menuInfoList = new ArrayList<AppMenuInfo>();
        ICoreProductSettingService productService = (ICoreProductSettingService)ServiceFactory.getService(ICoreProductSettingService.class);
        List blackMenuIds = productService.getAllAppMenuBlackList();
        RunModeService runModeService = (RunModeService)ServiceFactory.getService(RunModeService.class);
        int product = runModeService.getRunModeCode();
        Collection entityBlackList = runModeService.loadEntityBlacklist(product).values();
        entityBlackList.addAll(productService.getFormBlackList());
        Set<String> disabledBizAppIds = this.getDisabledAppIds();
        Set<String> disabledCloudIds = this.getDisabledCloudIds();
        Set disableAppNumbers = (Set)DB.query((DBRoute)DBRoute.meta, (String)"select FID, FNUMBER, FBIZCLOUDID from T_META_BIZAPP ", null, rs -> {
            HashSet<String> disabledIds = new HashSet<String>();
            while (rs.next()) {
                String cloudId = rs.getString("FBIZCLOUDID");
                if (disabledCloudIds.contains(cloudId)) {
                    disabledIds.add(rs.getString("FNUMBER"));
                    continue;
                }
                String appId = rs.getString("FID");
                if (!disabledBizAppIds.contains(appId)) continue;
                disabledIds.add(rs.getString("FNUMBER"));
            }
            return disabledIds;
        });
        String sql = String.format("SELECT A.FID,A.FAPPID,A.FSEQ,A.FFORMID,A.FPARAMTYPE,A.FPARAMS,A.FOPENTYPE,A.FPERMISSION,A.FPARENTID,A.FNAVIVECTOR,A.FSHORTCUTICON,A.FDATA,C.FNUMBER FROM %s A left join %s B ON A.FFORMID = B.FNUMBER left join %s C ON B.FENTITYID = C.FID ORDER BY FSEQ,FID ", AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_MENURUNTIME"), AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_FORMDESIGN"), AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_ENTITYDESIGN"));
        LinkedHashMap allAppMenuInfoMap = new LinkedHashMap();
        DB.query((DBRoute)DBRoute.meta, (String)sql, null, rs -> {
            try {
                while (rs.next()) {
                    String data;
                    String shortcutIcon;
                    String naviVector;
                    String parentId;
                    String permission;
                    String openType;
                    String parameters;
                    String paramType;
                    String entityNumber;
                    String formId;
                    Short seq;
                    String appId = rs.getString("FAPPID");
                    if (disableAppNumbers.contains(appId)) continue;
                    AppMenuInfo appMenuInfo = new AppMenuInfo();
                    String id = rs.getString("FID");
                    appMenuInfo.setId(id);
                    if (StringUtils.isNotBlank((CharSequence)appId)) {
                        appMenuInfo.setAppId(appId);
                    }
                    if (StringUtils.isNotBlank((Object)(seq = Short.valueOf(rs.getShort("FSEQ"))))) {
                        appMenuInfo.setSeq(seq);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(formId = rs.getString("FFORMID")))) {
                        appMenuInfo.setFormId(formId);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(entityNumber = rs.getString("FNUMBER")))) {
                        appMenuInfo.setEntityNumber(entityNumber);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(paramType = rs.getString("FPARAMTYPE")))) {
                        appMenuInfo.setParamType(paramType);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(parameters = rs.getString("FPARAMS")))) {
                        appMenuInfo.setParams(parameters);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(openType = rs.getString("FOPENTYPE")))) {
                        appMenuInfo.setOpenType(openType);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(permission = rs.getString("FPERMISSION")))) {
                        appMenuInfo.setPermission(permission);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(parentId = rs.getString("FPARENTID")))) {
                        appMenuInfo.setParentId(parentId);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(naviVector = rs.getString("FNAVIVECTOR")))) {
                        appMenuInfo.setNaviVector(naviVector);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(shortcutIcon = rs.getString("FSHORTCUTICON")))) {
                        appMenuInfo.setShortcutIcon(shortcutIcon);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(data = rs.getString("FDATA")))) {
                        appMenuInfo.setData(data);
                    }
                    if (!StringUtils.isBlank((CharSequence)formId) && (entityBlackList.contains(formId) || blackMenuIds.contains(id))) continue;
                    allAppMenuInfoMap.put(id, appMenuInfo);
                    menuInfoList.add(appMenuInfo);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
            }
            return null;
        });
        String langSql = String.format("SELECT FID,FLOCALEID,FNAME,FDESCRIPTION,FFORMNAME FROM %s ", AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_MENURUNTIME_L"));
        DB.query((DBRoute)DBRoute.meta, (String)langSql, null, rs -> {
            try {
                while (rs.next()) {
                    String formName;
                    LocaleString formNameLocale;
                    String description;
                    LocaleString descLocale;
                    String name;
                    String localeId = rs.getString("FLOCALEID");
                    String id = rs.getString("FID");
                    AppMenuInfo menuInfo = (AppMenuInfo)allAppMenuInfoMap.get(id);
                    if (menuInfo == null) continue;
                    LocaleString menuName = menuInfo.getName();
                    if (menuName == null) {
                        menuName = new LocaleString();
                        menuInfo.setName(menuName);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(name = rs.getString("FNAME")))) {
                        menuName.setItem(localeId, (Object)name);
                    }
                    if ((descLocale = menuInfo.getDescription()) == null) {
                        descLocale = new LocaleString();
                        menuInfo.setDescription(descLocale);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(description = rs.getString("FDESCRIPTION")))) {
                        descLocale.setItem(localeId, (Object)description);
                    }
                    if ((formNameLocale = menuInfo.getFormName()) == null) {
                        formNameLocale = new LocaleString();
                        menuInfo.setFormName(formNameLocale);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)(formName = rs.getString("FFORMNAME")))) continue;
                    formNameLocale.setItem(localeId, (Object)formName);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
            }
            return null;
        });
        return menuInfoList;
    }

    Map<String, String> getAppNumbers() {
        Map<String, String> val = AppMetaRedisCacheUtils.getAllNumberCache();
        if (val == null || val.isEmpty()) {
            RequestContext rc;
            Map map;
            val = this.queryAppNumbers(AppGroupUtils.getCurrentAppGroup());
            if (AppGroup.isGrayUpgrade() && !(map = GrayStrategy.getUserAppGroup((String)(rc = RequestContext.get()).getUserId(), (String)rc.getAccountId())).isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    String appGroup = (String)entry.getValue();
                    String appId = (String)entry.getKey();
                    if (!StringUtils.isNotBlank((CharSequence)appGroup) || "defaultGroup".equals(appGroup)) continue;
                    val.putAll(this.queryAppNumbers(appGroup));
                }
            }
            log.info("db query: all app id_number.");
            AppMetaRedisCacheUtils.putAllNumberCache(val);
        }
        return val;
    }

    @NotNull
    private Set<String> getDisabledCloudIds() {
        HashSet<String> disabledSet = new HashSet<String>();
        disabledSet.addAll(RunModeServiceHelper.getCloudBlacklist().keySet());
        ProductSettingService productService = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        disabledSet.addAll(productService.getCloudIdBlackList());
        disabledSet.addAll(this.queryDisabledCloudId());
        disabledSet.add(NOCODE_CLOUD_ID);
        return disabledSet;
    }

    private Set<String> queryDisabledCloudId() {
        String sql = "SELECT FBIZClOUDID FROM T_SMC_APPCONFIG WHERE FENABLE = '0' AND FTYPE = 'bizcloud'";
        return (Set)DB.query((DBRoute)DBRoute.basedata, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> cloudIds = new HashSet<String>(16);
                while (rs.next()) {
                    String cloudId = rs.getString("FBIZClOUDID");
                    if (!StringUtils.isNotBlank((CharSequence)cloudId)) continue;
                    cloudIds.add(cloudId);
                }
                return cloudIds;
            }
        });
    }

    @NotNull
    private Set<String> getDisabledAppIds() {
        HashSet<String> disabledSet = new HashSet<String>();
        disabledSet.addAll(RunModeServiceHelper.getAppBlacklist().keySet());
        ProductSettingService productService = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        disabledSet.addAll(productService.getAppIdBlackList());
        disabledSet.addAll(this.queryDisabledAppId());
        disabledSet.add(NOCODE_SYS_APP_ID);
        return disabledSet;
    }

    private Set<String> queryDisabledAppId() {
        String sql = "SELECT FBIZAPPID FROM T_SMC_APPCONFIG WHERE FENABLE = '0' AND FTYPE = 'bizapp'";
        return (Set)DB.query((DBRoute)DBRoute.basedata, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> appIds = new HashSet<String>(16);
                while (rs.next()) {
                    String appId = rs.getString("FBIZAPPID");
                    if (!StringUtils.isNotBlank((CharSequence)appId)) continue;
                    appIds.add(appId);
                }
                return appIds;
            }
        });
    }

    private Map<String, String> queryAppNumbers(String appGroup) {
        String sql = String.format("SELECT FNUMBER,FID from %s WHERE FType != '2' ", AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_BIZAPP"));
        ResultSetHandler<Map<String, String>> action = new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws Exception {
                HashMap<String, String> list = new HashMap<String, String>(16);
                while (rs.next()) {
                    list.put(rs.getString("FID"), rs.getString("FNUMBER"));
                }
                return list;
            }
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)action);
    }

    List<AppInfo> queryAllAppInfoV2(String appGroup) {
        Set<String> disabledAppIds = this.getDisabledAppIds();
        Set<String> disabledCloudIds = this.getDisabledCloudIds();
        String sql = "SELECT FAPPID,FID,FSEQ,FCLOUDID,FCLOUDNUM,FDBROUTE,FIMAGE,FHOMEID,FHOMENUM,FOPENTYPE,FALLUSERAPP,FUSERTYPE,FORGFUNC,FDATA,FVISIBLE,FDEPLOYSTATUS FROM " + AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_APPRUNTIME") + " order by FSEQ";
        ArrayList<AppInfo> allAppInfoList = new ArrayList<AppInfo>();
        HashMap allAppInfoMap = new HashMap();
        DB.query((DBRoute)DBRoute.meta, (String)sql, rs -> {
            while (rs.next()) {
                String data;
                String orgFunc;
                String userType;
                boolean allUserApp;
                String openType;
                String homeNum;
                String homeId;
                String cloudId = rs.getString("FCLOUDID");
                String id = rs.getString("FID");
                if (disabledCloudIds.contains(cloudId) || disabledAppIds.contains(id)) continue;
                AppInfo appInfo = new AppInfo();
                String appId = rs.getString("FAPPID");
                appInfo.setAppId(appId);
                appInfo.setNumber(appId);
                appInfo.setId(id);
                appInfo.setSeq(Short.valueOf(rs.getShort("FSEQ")));
                appInfo.setCloudId(cloudId);
                appInfo.setCloudNum(rs.getString("FCLOUDNUM"));
                appInfo.setDbRoute(rs.getString("FDBROUTE"));
                String image = rs.getString("FIMAGE");
                if (StringUtils.isNotBlank((CharSequence)image)) {
                    appInfo.setImage(image);
                }
                if (StringUtils.isNotBlank((CharSequence)(homeId = rs.getString("FHOMEID")))) {
                    appInfo.setHomeId(homeId);
                }
                if (StringUtils.isNotBlank((CharSequence)(homeNum = rs.getString("FHOMENUM")))) {
                    appInfo.setHomeNum(homeNum);
                }
                if (StringUtils.isNotBlank((CharSequence)(openType = rs.getString("FOPENTYPE")))) {
                    appInfo.setOpenType(openType);
                }
                if (StringUtils.isNotBlank((Object)(allUserApp = rs.getBoolean("FALLUSERAPP")))) {
                    appInfo.setAllUserApp(allUserApp);
                }
                if (StringUtils.isNotBlank((CharSequence)(userType = rs.getString("FUSERTYPE")))) {
                    appInfo.setUserType(userType);
                }
                if (StringUtils.isNotBlank((CharSequence)(orgFunc = rs.getString("FORGFUNC")))) {
                    appInfo.setOrgFunc(orgFunc);
                }
                if (StringUtils.isNotBlank((CharSequence)(data = rs.getString("FDATA")))) {
                    appInfo.setData(data);
                }
                boolean visible = rs.getBoolean("FVISIBLE");
                appInfo.setVisible(visible);
                String deployStatus = rs.getString("FDEPLOYSTATUS");
                appInfo.setDeployStatus(deployStatus);
                allAppInfoList.add(appInfo);
                allAppInfoMap.put(appId, appInfo);
            }
            return null;
        });
        String langSql = "SELECT FAPPID,FLOCALEID,FNAME,FDESCRIPTION FROM " + AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_APPRUNTIME_L");
        ResultSetHandler callBackLangHanlder = rs -> {
            try {
                while (rs.next()) {
                    String description;
                    String localeId;
                    LocaleString descLocale;
                    String appId = rs.getString("FAPPID");
                    AppInfo appInfo = (AppInfo)allAppInfoMap.get(appId);
                    if (appInfo == null) continue;
                    LocaleString nameLocale = appInfo.getName();
                    if (nameLocale == null) {
                        nameLocale = new LocaleString();
                        appInfo.setName(nameLocale);
                    }
                    if ((descLocale = appInfo.getDescription()) == null) {
                        descLocale = new LocaleString();
                        appInfo.setDescription(descLocale);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)(localeId = rs.getString("FLOCALEID")))) continue;
                    String name = rs.getString("FNAME");
                    if (StringUtils.isNotBlank((CharSequence)name)) {
                        nameLocale.setItem(localeId, (Object)name);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)(description = rs.getString("FDESCRIPTION")))) continue;
                    descLocale.setItem(localeId, (Object)description);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
            }
            return null;
        };
        DB.query((DBRoute)DBRoute.meta, (String)langSql, null, (ResultSetHandler)callBackLangHanlder);
        return allAppInfoList;
    }

    @Deprecated
    List<AppInfo> queryAllAppInfoV1(String appGroup) {
        Set<String> disabledAppIds = this.getDisabledAppIds();
        Set<String> disabledCloudIds = this.getDisabledCloudIds();
        String sql = "SELECT FAPPID,FID,FSEQ,FCLOUDID,FCLOUDNUM,FDBROUTE,FIMAGE,FHOMEID,FHOMENUM,FOPENTYPE,FALLUSERAPP,FUSERTYPE,FORGFUNC,FDATA FROM " + AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_APPRUNTIME") + " order by FSEQ";
        ArrayList<AppInfo> allAppInfoList = new ArrayList<AppInfo>();
        HashMap allAppInfoMap = new HashMap();
        DB.query((DBRoute)DBRoute.meta, (String)sql, rs -> {
            while (rs.next()) {
                String data;
                String orgFunc;
                String userType;
                boolean allUserApp;
                String openType;
                String homeNum;
                String homeId;
                String cloudId = rs.getString("FCLOUDID");
                String id = rs.getString("FID");
                if (disabledCloudIds.contains(cloudId) || disabledAppIds.contains(id)) continue;
                AppInfo appInfo = new AppInfo();
                String appId = rs.getString("FAPPID");
                appInfo.setAppId(appId);
                appInfo.setNumber(appId);
                appInfo.setId(id);
                AppReader.updateAppNumberAndIdCache((String)id, (String)appId);
                appInfo.setSeq(Short.valueOf(rs.getShort("FSEQ")));
                appInfo.setCloudId(cloudId);
                appInfo.setCloudNum(rs.getString("FCLOUDNUM"));
                appInfo.setDbRoute(rs.getString("FDBROUTE"));
                String image = rs.getString("FIMAGE");
                if (StringUtils.isNotBlank((CharSequence)image)) {
                    appInfo.setImage(image);
                }
                if (StringUtils.isNotBlank((CharSequence)(homeId = rs.getString("FHOMEID")))) {
                    appInfo.setHomeId(homeId);
                }
                if (StringUtils.isNotBlank((CharSequence)(homeNum = rs.getString("FHOMENUM")))) {
                    appInfo.setHomeNum(homeNum);
                }
                if (StringUtils.isNotBlank((CharSequence)(openType = rs.getString("FOPENTYPE")))) {
                    appInfo.setOpenType(openType);
                }
                if (StringUtils.isNotBlank((Object)(allUserApp = rs.getBoolean("FALLUSERAPP")))) {
                    appInfo.setAllUserApp(allUserApp);
                }
                if (StringUtils.isNotBlank((CharSequence)(userType = rs.getString("FUSERTYPE")))) {
                    appInfo.setUserType(userType);
                }
                if (StringUtils.isNotBlank((CharSequence)(orgFunc = rs.getString("FORGFUNC")))) {
                    appInfo.setOrgFunc(orgFunc);
                }
                if (StringUtils.isNotBlank((CharSequence)(data = rs.getString("FDATA")))) {
                    appInfo.setData(data);
                }
                allAppInfoList.add(appInfo);
                allAppInfoMap.put(appId, appInfo);
            }
            return null;
        });
        String langSql = "SELECT FAPPID,FLOCALEID,FNAME,FDESCRIPTION FROM " + AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_APPRUNTIME_L");
        ResultSetHandler callBackLangHanlder = rs -> {
            try {
                while (rs.next()) {
                    String description;
                    String localeId;
                    LocaleString descLocale;
                    String appId = rs.getString("FAPPID");
                    AppInfo appInfo = (AppInfo)allAppInfoMap.get(appId);
                    if (appInfo == null) continue;
                    LocaleString nameLocale = appInfo.getName();
                    if (nameLocale == null) {
                        nameLocale = new LocaleString();
                        appInfo.setName(nameLocale);
                    }
                    if ((descLocale = appInfo.getDescription()) == null) {
                        descLocale = new LocaleString();
                        appInfo.setDescription(descLocale);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)(localeId = rs.getString("FLOCALEID")))) continue;
                    String name = rs.getString("FNAME");
                    if (StringUtils.isNotBlank((CharSequence)name)) {
                        nameLocale.setItem(localeId, (Object)name);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)(description = rs.getString("FDESCRIPTION")))) continue;
                    descLocale.setItem(localeId, (Object)description);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
            }
            return null;
        };
        DB.query((DBRoute)DBRoute.meta, (String)langSql, null, (ResultSetHandler)callBackLangHanlder);
        return allAppInfoList;
    }

    @Deprecated
    String loadAppInfo(String appGroup, String number) {
        String metaStr = this.queryAppMeta(number, number, RuntimeMetaType.App, appGroup);
        if (StringUtils.isBlank((CharSequence)metaStr)) {
            try {
                metaStr = BizAppServiceHelp.getAppRuntimeInfo((String)number);
            }
            catch (KDException ex) {
                log.error("\u4f7f\u7528AppMetadataCache\u83b7\u53d6\u975e\u8fd0\u884c\u65f6\u5e94\u7528\u5143\u6570\u636e\uff01number=" + number, (Throwable)ex);
            }
        }
        return metaStr;
    }

    String loadAppMenuInfo(String appGroup, String number) {
        String metaStr = this.queryAppMeta(number, number + ".menus", RuntimeMetaType.AppMenu, AppGroupUtils.getCurrentAppGroup());
        if (StringUtils.isBlank((CharSequence)metaStr)) {
            try {
                metaStr = BizAppServiceHelp.getAppRuntimeMenusInfo((String)number);
            }
            catch (KDException ex) {
                log.error("\u4f7f\u7528AppMetadataCache\u83b7\u53d6\u975e\u8fd0\u884c\u65f6\u5e94\u7528\u5143\u6570\u636e\uff01number=" + number, (Throwable)ex);
            }
        }
        return metaStr;
    }

    private String queryAppMeta(String number, String key, RuntimeMetaType type, String appGroup) {
        String val = MetaCacheUtils.getAppmetaDistributeCache((String)number, (String)key, (int)type.getValue());
        if (StringUtils.isBlank((CharSequence)val)) {
            if (RuntimeMetaType.App.equals((Object)type)) {
                if (AppGroupUtils.isOutLog()) {
                    log.info("queryAppMeta -- appGroup:{}", (Object)appGroup);
                }
                if (StringUtils.isBlank((CharSequence)(val = this.doQueryAppMeta(appGroup, number))) && this.isGrayGroup()) {
                    if (AppGroupUtils.isOutLog()) {
                        log.info("queryAppMeta -- isGrayGroup:{}", (Object)this.isGrayGroup());
                    }
                    val = this.doQueryAppMeta("defaultGroup", number);
                }
            } else if (RuntimeMetaType.AppMenu.equals((Object)type)) {
                if (AppGroupUtils.isOutLog()) {
                    log.info("queryAppMeta -- AppMenu appGroup:{}", (Object)appGroup);
                }
                if ((StringUtils.isBlank((CharSequence)(val = this.doQueryAppMenuMetaByAppId(appGroup, number))) || "[]".equals(val)) && this.isGrayGroup()) {
                    if (AppGroupUtils.isOutLog()) {
                        log.info("queryAppMeta -- AppMenu isGrayGroup:{}", (Object)this.isGrayGroup());
                    }
                    val = this.doQueryAppMenuMetaByAppId("defaultGroup", number);
                }
            }
            if (val != null) {
                MetaCacheUtils.putAppmetaDistributeCache((String)number, (String)key, (int)type.getValue(), (String)val);
            }
        }
        return val;
    }

    private String doQueryAppMeta(String appGroup, String number) {
        try {
            return this.doQueryAppMetaV2(appGroup, number);
        }
        catch (Exception ex) {
            if (!DB.existColumn((DBRoute)DBRoute.meta, (String)AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_APPRUNTIME"), (String)"FVISIBLE")) {
                log.error("Read T_META_APPRUNTIME_V2 error.", (Throwable)ex);
                return this.doQueryAppMetaV1(appGroup, number);
            }
            throw ex;
        }
    }

    private String doQueryAppMetaV2(String appGroup, String number) {
        String selectFields = "FAPPID,FID,FSEQ,FCLOUDID,FCLOUDNUM,FDBROUTE,FIMAGE,FHOMEID,FHOMENUM,FOPENTYPE,FALLUSERAPP,FUSERTYPE,FORGFUNC,FDATA, FVISIBLE, FDEPLOYSTATUS";
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ").append(selectFields).append(" FROM ").append(AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_APPRUNTIME")).append(" WHERE FAPPID = ?");
        String sql = sb.toString();
        Object[] params = new SqlParameter[]{new SqlParameter(FAPPID, 12, (Object)number)};
        ResultSetHandler callBackHanlder = rs -> {
            JSONObject obj = null;
            try {
                if (rs.next()) {
                    String data;
                    String orgFunc;
                    String userType;
                    boolean allUserApp;
                    String openType;
                    String homeNum;
                    String homeId;
                    String image;
                    String dbRoute;
                    String cloudNum;
                    String cloudId;
                    Short seq;
                    String id;
                    obj = new JSONObject();
                    String appId = rs.getString("FAPPID");
                    if (StringUtils.isNotBlank((CharSequence)appId)) {
                        obj.put("number", (Object)appId);
                        obj.put("appId", (Object)appId);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(id = rs.getString("FID")))) {
                        obj.put("id", (Object)id);
                    }
                    if (StringUtils.isNotBlank((Object)(seq = Short.valueOf(rs.getShort("FSEQ"))))) {
                        obj.put("seq", (Object)seq);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(cloudId = rs.getString("FCLOUDID")))) {
                        obj.put("cloudId", (Object)cloudId);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(cloudNum = rs.getString("FCLOUDNUM")))) {
                        obj.put("cloudNum", (Object)cloudNum);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(dbRoute = rs.getString("FDBROUTE")))) {
                        obj.put("dbRoute", (Object)dbRoute);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(image = rs.getString("FIMAGE")))) {
                        obj.put("image", (Object)image);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(homeId = rs.getString("FHOMEID")))) {
                        obj.put("homeId", (Object)homeId);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(homeNum = rs.getString("FHOMENUM")))) {
                        obj.put("homeNum", (Object)homeNum);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(openType = rs.getString("FOPENTYPE")))) {
                        obj.put("openType", (Object)openType);
                    }
                    if (StringUtils.isNotBlank((Object)(allUserApp = rs.getBoolean("FALLUSERAPP")))) {
                        obj.put("allUserApp", (Object)allUserApp);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(userType = rs.getString("FUSERTYPE")))) {
                        obj.put("userType", (Object)userType);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(orgFunc = rs.getString("FORGFUNC")))) {
                        obj.put("orgFunc", (Object)orgFunc);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(data = rs.getString("FDATA")))) {
                        obj.put("data", (Object)data);
                    }
                    boolean visible = rs.getBoolean("FVISIBLE");
                    obj.put("visible", (Object)visible);
                    String deployStatus = rs.getString("FDEPLOYSTATUS");
                    obj.put("deployStatus", (Object)deployStatus);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
            }
            return obj;
        };
        JSONObject sRet = (JSONObject)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
        if (StringUtils.isNotBlank((Object)sRet)) {
            String langSql = "SELECT FLOCALEID,FNAME,FDESCRIPTION FROM " + AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_APPRUNTIME_L") + " WHERE FAPPID = ?";
            Object[] parameters = new SqlParameter[]{new SqlParameter(FAPPID, 12, (Object)number)};
            ResultSetHandler callBackLangHanlder = rs -> {
                try {
                    while (rs.next()) {
                        String description;
                        String localeId = rs.getString("FLOCALEID");
                        if (!StringUtils.isNotBlank((CharSequence)localeId)) continue;
                        String name = rs.getString("FNAME");
                        if (StringUtils.isNotBlank((CharSequence)name)) {
                            LocaleString langObj = (LocaleString)sRet.get((Object)"name");
                            if (langObj != null) {
                                langObj.setItem(localeId, (Object)name);
                            } else {
                                langObj = new LocaleString(localeId, name);
                                sRet.put("name", (Object)langObj);
                            }
                        }
                        if (!StringUtils.isNotBlank((CharSequence)(description = rs.getString("FDESCRIPTION")))) continue;
                        LocaleString langObj = (LocaleString)sRet.get((Object)DESCRIPTION);
                        if (langObj != null) {
                            langObj.setItem(localeId, (Object)description);
                            continue;
                        }
                        langObj = new LocaleString(localeId, description);
                        sRet.put(DESCRIPTION, (Object)langObj);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
                }
                return null;
            };
            DB.query((DBRoute)DBRoute.meta, (String)langSql, (Object[])parameters, (ResultSetHandler)callBackLangHanlder);
        }
        return sRet != null && sRet.size() > 0 ? sRet.toJSONString() : null;
    }

    private String doQueryAppMetaV1(String appGroup, String number) {
        String selectFields = "FAPPID,FID,FSEQ,FCLOUDID,FCLOUDNUM,FDBROUTE,FIMAGE,FHOMEID,FHOMENUM,FOPENTYPE,FALLUSERAPP,FUSERTYPE,FORGFUNC,FDATA";
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ").append(selectFields).append(" FROM ").append(AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_APPRUNTIME")).append(" WHERE FAPPID = ?");
        String sql = sb.toString();
        Object[] params = new SqlParameter[]{new SqlParameter(FAPPID, 12, (Object)number)};
        ResultSetHandler callBackHanlder = rs -> {
            JSONObject obj = null;
            try {
                if (rs.next()) {
                    String data;
                    String orgFunc;
                    String userType;
                    boolean allUserApp;
                    String openType;
                    String homeNum;
                    String homeId;
                    String image;
                    String dbRoute;
                    String cloudNum;
                    String cloudId;
                    String id;
                    obj = new JSONObject();
                    String appId = rs.getString("FAPPID");
                    if (StringUtils.isNotBlank((CharSequence)appId)) {
                        obj.put("number", (Object)appId);
                        obj.put("appId", (Object)appId);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(id = rs.getString("FID")))) {
                        obj.put("id", (Object)id);
                    }
                    AppReader.updateAppNumberAndIdCache((String)id, (String)number);
                    Short seq = rs.getShort("FSEQ");
                    if (StringUtils.isNotBlank((Object)seq)) {
                        obj.put("seq", (Object)seq);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(cloudId = rs.getString("FCLOUDID")))) {
                        obj.put("cloudId", (Object)cloudId);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(cloudNum = rs.getString("FCLOUDNUM")))) {
                        obj.put("cloudNum", (Object)cloudNum);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(dbRoute = rs.getString("FDBROUTE")))) {
                        obj.put("dbRoute", (Object)dbRoute);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(image = rs.getString("FIMAGE")))) {
                        obj.put("image", (Object)image);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(homeId = rs.getString("FHOMEID")))) {
                        obj.put("homeId", (Object)homeId);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(homeNum = rs.getString("FHOMENUM")))) {
                        obj.put("homeNum", (Object)homeNum);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(openType = rs.getString("FOPENTYPE")))) {
                        obj.put("openType", (Object)openType);
                    }
                    if (StringUtils.isNotBlank((Object)(allUserApp = rs.getBoolean("FALLUSERAPP")))) {
                        obj.put("allUserApp", (Object)allUserApp);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(userType = rs.getString("FUSERTYPE")))) {
                        obj.put("userType", (Object)userType);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(orgFunc = rs.getString("FORGFUNC")))) {
                        obj.put("orgFunc", (Object)orgFunc);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(data = rs.getString("FDATA")))) {
                        obj.put("data", (Object)data);
                    }
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
            }
            return obj;
        };
        JSONObject sRet = (JSONObject)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
        if (StringUtils.isNotBlank((Object)sRet)) {
            String langSql = "SELECT FLOCALEID,FNAME,FDESCRIPTION FROM " + AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_APPRUNTIME_L") + " WHERE FAPPID = ?";
            Object[] parameters = new SqlParameter[]{new SqlParameter(FAPPID, 12, (Object)number)};
            ResultSetHandler callBackLangHanlder = rs -> {
                try {
                    while (rs.next()) {
                        String description;
                        String localeId = rs.getString("FLOCALEID");
                        if (!StringUtils.isNotBlank((CharSequence)localeId)) continue;
                        String name = rs.getString("FNAME");
                        if (StringUtils.isNotBlank((CharSequence)name)) {
                            LocaleString langObj = (LocaleString)sRet.get((Object)"name");
                            if (langObj != null) {
                                langObj.setItem(localeId, (Object)name);
                            } else {
                                langObj = new LocaleString(localeId, name);
                                sRet.put("name", (Object)langObj);
                            }
                        }
                        if (!StringUtils.isNotBlank((CharSequence)(description = rs.getString("FDESCRIPTION")))) continue;
                        LocaleString langObj = (LocaleString)sRet.get((Object)DESCRIPTION);
                        if (langObj != null) {
                            langObj.setItem(localeId, (Object)description);
                            continue;
                        }
                        langObj = new LocaleString(localeId, description);
                        sRet.put(DESCRIPTION, (Object)langObj);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
                }
                return null;
            };
            DB.query((DBRoute)DBRoute.meta, (String)langSql, (Object[])parameters, (ResultSetHandler)callBackLangHanlder);
        }
        return sRet != null && sRet.size() > 0 ? sRet.toJSONString() : null;
    }

    private String doQueryAppMenuMetaByAppId(String appGroup, String appNumber) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT A.FID,A.FAPPID,A.FSEQ,A.FFORMID,A.FPARAMTYPE,A.FPARAMS,A.FOPENTYPE,A.FPERMISSION,A.FPARENTID,A.FNAVIVECTOR,A.FSHORTCUTICON,A.FDATA,A.FMENUTYPE,A.FLINKURL,C.FNUMBER ").append(" FROM ").append(AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_MENURUNTIME")).append(" A left join ").append(AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_FORMDESIGN")).append(" B ON A.FFORMID = B.FNUMBER left join ").append(AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_ENTITYDESIGN")).append(" C ON B.FENTITYID = C.FID WHERE FAPPID = ? ORDER BY FSEQ,FID");
        String sql = sb.toString();
        Object[] params = new SqlParameter[]{new SqlParameter(FAPPID, 12, (Object)appNumber)};
        ResultSetHandler callBackHanlder = rs -> {
            LinkedHashMap<String, JSONObject> objs = null;
            try {
                while (rs.next()) {
                    String linkUrl;
                    String menuType;
                    String data;
                    String shortcutIcon;
                    String naviVector;
                    String parentId;
                    String permission;
                    String openType;
                    String parameters;
                    String paramType;
                    String entityNumber;
                    String formId;
                    Short seq;
                    String appId;
                    JSONObject obj = new JSONObject();
                    String id = rs.getString("FID");
                    if (StringUtils.isNotBlank((CharSequence)id)) {
                        obj.put("id", (Object)id);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(appId = rs.getString("FAPPID")))) {
                        obj.put("appId", (Object)appId);
                    }
                    if (StringUtils.isNotBlank((Object)(seq = Short.valueOf(rs.getShort("FSEQ"))))) {
                        obj.put("seq", (Object)seq);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(formId = rs.getString("FFORMID")))) {
                        obj.put("formId", (Object)formId);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(entityNumber = rs.getString("FNUMBER")))) {
                        obj.put("entityNumber", (Object)entityNumber);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(paramType = rs.getString("FPARAMTYPE")))) {
                        obj.put("paramType", (Object)paramType);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(parameters = rs.getString("FPARAMS")))) {
                        obj.put("params", (Object)parameters);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(openType = rs.getString("FOPENTYPE")))) {
                        obj.put("openType", (Object)openType);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(permission = rs.getString("FPERMISSION")))) {
                        obj.put("permission", (Object)permission);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(parentId = rs.getString("FPARENTID")))) {
                        obj.put("parentId", (Object)parentId);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(naviVector = rs.getString("FNAVIVECTOR")))) {
                        obj.put("naviVector", (Object)naviVector);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(shortcutIcon = rs.getString("FSHORTCUTICON")))) {
                        obj.put("shortcutIcon", (Object)shortcutIcon);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(data = rs.getString("FDATA")))) {
                        obj.put("data", (Object)data);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(menuType = rs.getString("FMenutype")))) {
                        obj.put("menuType", (Object)menuType);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(linkUrl = rs.getString("FLinkurl")))) {
                        obj.put("linkUrl", (Object)linkUrl);
                    }
                    if (objs == null) {
                        objs = new LinkedHashMap<String, JSONObject>();
                    }
                    objs.put(id, obj);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
            }
            return objs;
        };
        HashMap menus = (HashMap)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
        if (StringUtils.isNotBlank((Object)menus)) {
            StringBuilder ids = new StringBuilder();
            for (String id : menus.keySet()) {
                ids.append("'").append(id).append("',");
            }
            String langSql = String.format("SELECT FID,FLOCALEID,FNAME,FDESCRIPTION,FFORMNAME FROM %s WHERE FID in (%s)", AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_MENURUNTIME_L"), ids.substring(0, ids.length() - 1));
            ResultSetHandler callBackLangHanlder = rs -> {
                try {
                    while (rs.next()) {
                        String formName;
                        String description;
                        String localeId = rs.getString("FLOCALEID");
                        String id = rs.getString("FID");
                        if (!StringUtils.isNotBlank((CharSequence)localeId) || !StringUtils.isNotBlank((CharSequence)id)) continue;
                        JSONObject sRet = (JSONObject)menus.get(id);
                        String name = rs.getString("FNAME");
                        if (StringUtils.isNotBlank((CharSequence)name)) {
                            LocaleString langObj = (LocaleString)sRet.get((Object)"name");
                            if (langObj != null) {
                                langObj.setItem(localeId, (Object)name);
                            } else {
                                langObj = new LocaleString(localeId, name);
                                sRet.put("name", (Object)langObj);
                            }
                        }
                        if (StringUtils.isNotBlank((CharSequence)(description = rs.getString("FDESCRIPTION")))) {
                            LocaleString langObj = (LocaleString)sRet.get((Object)DESCRIPTION);
                            if (langObj != null) {
                                langObj.setItem(localeId, (Object)description);
                            } else {
                                langObj = new LocaleString(localeId, description);
                                sRet.put(DESCRIPTION, (Object)langObj);
                            }
                        }
                        if (!StringUtils.isNotBlank((CharSequence)(formName = rs.getString("FFORMNAME")))) continue;
                        LocaleString langObj = (LocaleString)sRet.get((Object)"formName");
                        if (langObj != null) {
                            langObj.setItem(localeId, (Object)formName);
                            continue;
                        }
                        langObj = new LocaleString(localeId, formName);
                        sRet.put("formName", (Object)langObj);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
                }
                return null;
            };
            DB.query((DBRoute)DBRoute.meta, (String)langSql, null, (ResultSetHandler)callBackLangHanlder);
        }
        String rt = null;
        if (menus == null) {
            String appInfo = this.queryAppMeta(appNumber, appNumber, RuntimeMetaType.App, appGroup);
            if (appInfo != null) {
                rt = "[]";
            }
        } else {
            rt = menus.values().toString();
        }
        return rt;
    }

    private boolean isGrayGroup() {
        return AppGroupUtils.isGrayGroup();
    }
}

