/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.metadata.ICtsyMetadataService;

public class CtsyMetadataServiceImpl
implements ICtsyMetadataService {
    private static Log log = LogFactory.getLog(CtsyMetadataServiceImpl.class);

    public List<String> getObjectTypeRefs(String entity) throws Exception {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        if (entityType == null) {
            throw new Exception("EntityMetadata not found, entity:" + entity);
        }
        Item item = new Item();
        this.buildObjectTypeRefs((IDataEntityType)entityType, item, 0);
        Map<Integer, Set<String>> map = item.getMap();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<Integer> keys = new ArrayList<Integer>(map.keySet());
        Collections.sort(keys);
        for (Integer key : keys) {
            Set<String> set = map.get(key);
            result.addAll(set);
            sb.append("index:").append(key).append(" ").append(Collections.singletonList(set)).append("\n");
        }
        log.debug(sb.toString());
        return result;
    }

    private void buildObjectTypeRefs(IDataEntityType entityType, Item item, int level) {
        if (entityType == null) {
            return;
        }
        for (IDataEntityProperty property : entityType.getProperties()) {
            if (property instanceof ICollectionProperty) {
                this.buildObjectTypeRefs(((ICollectionProperty)property).getItemType(), item, level);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)property.getAlias())) continue;
            if (property instanceof ItemClassProp) {
                ItemClassTypeProp typeProp = (ItemClassTypeProp)entityType.getProperties().get((Object)((ItemClassProp)property).getTypePropName());
                if (typeProp == null) continue;
                for (String refEntityNumber : typeProp.getBaseEntityIds()) {
                    if (!StringUtils.isNotEmpty((CharSequence)refEntityNumber)) continue;
                    this.handleRefEntity(item, refEntityNumber, level);
                }
                continue;
            }
            if (!(property instanceof BasedataProp) || !StringUtils.isNotBlank((CharSequence)((BasedataProp)property).getBaseEntityId())) continue;
            String refEntityId = ((BasedataProp)property).getBaseEntityId();
            this.handleRefEntity(item, refEntityId, level);
        }
    }

    private void handleRefEntity(Item item, String refEntityId, int level) {
        if (StringUtils.isNotEmpty((CharSequence)refEntityId) && item.put(level, refEntityId)) {
            MainEntityType refEntityType = EntityMetadataCache.getDataEntityType((String)refEntityId);
            int nextLevel = level + 1;
            this.buildObjectTypeRefs((IDataEntityType)refEntityType, item, nextLevel);
        }
    }

    class Item {
        private Map<Integer, Set<String>> map = new HashMap<Integer, Set<String>>();
        private Set<String> all = new LinkedHashSet<String>();

        Item() {
        }

        public Map<Integer, Set<String>> getMap() {
            return this.map;
        }

        public Set<String> getAll() {
            return this.all;
        }

        boolean put(int level, String entity) {
            if (this.all.add(entity)) {
                this.innerAdd(level, entity);
                return true;
            }
            log.debug("level:{},entity:{}", (Object)level, (Object)entity);
            for (Map.Entry<Integer, Set<String>> entry : this.map.entrySet()) {
                Set<String> set = entry.getValue();
                Integer oriLevel = entry.getKey();
                if (level >= oriLevel || !set.remove(entity)) continue;
                this.innerAdd(level, entity);
                break;
            }
            return false;
        }

        private void innerAdd(int level, String entity) {
            Set<String> set = this.map.get(level);
            if (set == null) {
                set = new HashSet<String>(6);
                this.map.put(level, set);
            }
            set.add(entity);
        }
    }
}

