/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;

class FormFunctionInfo
implements Serializable {
    private static Log log = LogFactory.getLog(FormFunctionInfo.class);
    private static final long serialVersionUID = 7224363358936610880L;
    private static final String KEY_ITEMS = "items";
    private static final String ITEMCLICK = "itemClick";
    private static final String OPERATIONKEY = "operationKey";
    private static final String TYPE_TOOLBAR = "toolbar";
    private static final String TYPE_BUTTON = "button";
    private String appName;
    private String formId;
    private String formName;
    @JsonProperty(value="functionLists")
    private List<Params> functionLists;
    @JsonProperty(value="functionForms")
    private List<Params> functionForms;

    FormFunctionInfo() {
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public List<Params> getFunctionLists() {
        return this.functionLists;
    }

    public void setFunctionLists(List<Params> functionLists) {
        this.functionLists = functionLists;
    }

    public List<Params> getFunctionForms() {
        return this.functionForms;
    }

    public void setFunctionForms(List<Params> functionForms) {
        this.functionForms = functionForms;
    }

    public void findFunctionLists(Map<String, Object> itemMeta, List<Params> resultList) {
        if (itemMeta == null) {
            return;
        }
        String key = null;
        String methodName = null;
        String name = null;
        ArrayList<String> args = null;
        if (itemMeta.containsKey("id") && itemMeta.containsKey("type")) {
            if (Objects.equals(TYPE_TOOLBAR, itemMeta.get("type"))) {
                List subitems = (List)itemMeta.get(KEY_ITEMS);
                for (Map subitem : subitems) {
                    key = (String)itemMeta.get("id");
                    if ("_toolbar_".equals(key)) {
                        key = "toolbarap";
                    }
                    methodName = ITEMCLICK;
                    name = this.findPropertyCaption(subitem, "text");
                    args = new ArrayList(2);
                    args.add(subitem.get("id") == null ? "" : subitem.get("id"));
                    args.add(subitem.get("opk") == null ? "" : subitem.get("opk"));
                    this.createParams(resultList, key, methodName, name, args);
                    List moreItems = (List)subitem.get(KEY_ITEMS);
                    if (CollectionUtils.isEmpty((Collection)moreItems)) continue;
                    for (Map moreItem : moreItems) {
                        key = (String)itemMeta.get("id");
                        if ("_toolbar_".equals(key)) {
                            key = "toolbarap";
                        }
                        methodName = ITEMCLICK;
                        name = this.findPropertyCaption(moreItem, "title");
                        args = new ArrayList(2);
                        args.add(moreItem.get("id") == null ? "" : moreItem.get("id"));
                        args.add(moreItem.get(OPERATIONKEY) == null ? "" : moreItem.get(OPERATIONKEY));
                        this.createParams(resultList, key, methodName, name, args);
                    }
                }
            } else if (Objects.equals(TYPE_BUTTON, itemMeta.get("type"))) {
                key = (String)itemMeta.get("id");
                methodName = "click";
                name = this.findPropertyCaption(itemMeta, "text");
                args = new ArrayList<String>(0);
                this.createParams(resultList, key, methodName, name, args);
            }
        }
        if (!itemMeta.containsKey(KEY_ITEMS) || !(itemMeta.get(KEY_ITEMS) instanceof List)) {
            return;
        }
        List items = (List)itemMeta.get(KEY_ITEMS);
        if (CollectionUtils.isEmpty((Collection)items)) {
            return;
        }
        for (Map item : items) {
            this.findFunctionLists(item, resultList);
        }
    }

    private String findPropertyCaption(Map<String, Object> item, String propertyName) {
        Map map;
        Map map2 = map = item.get(propertyName) == null ? null : (Map)item.get(propertyName);
        if (map != null && map.get(Lang.get().toString()) != null) {
            return (String)map.get(Lang.get().toString());
        }
        return "";
    }

    private void createParams(List<Params> resultList, String key, String methodName, String name, List args) {
        Params params = new Params();
        params.setKey(key);
        params.setMethodName(methodName);
        params.setArgs(args);
        params.setName(name);
        resultList.add(params);
    }

    static class Params
    implements Serializable {
        private static final long serialVersionUID = 7224363358936610881L;
        private String name;
        private String key;
        private String methodName;
        private List args;

        Params() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public List getArgs() {
            return this.args;
        }

        public void setArgs(List args) {
            this.args = args;
        }
    }
}

