/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.DesignEntityMetaL;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.DesignFormMetaL;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.lang.LangWriter;

public class MultiLangMetadataFileService
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(MultiLangMetadataFileService.class);
    private List<String> tlangs;
    private String slang = "zh_CN";
    private MetadataSerializer serializer;

    public ApiResult doCustomService(Map<String, Object> params) {
        String id = MetadataDao.getIdByNumber((String)params.get("number").toString(), (MetaCategory)MetaCategory.Form);
        this.tlangs = (List)params.get("langs");
        this.slang = params.get("sourceLang") == null ? "zh_CN" : params.get("sourceLang").toString();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("id", params.get("number"));
            map.put("ver", Long.valueOf(System.currentTimeMillis()).toString());
            List<DeployFile> list = this.getDeployFile(id);
            for (DeployFile file : list) {
                String[] name = file.getFileName().split("\\.");
                if (name.length == 2) continue;
                String localeId = name[1];
                if (this.tlangs.size() <= 0 || !this.tlangs.contains(localeId)) continue;
                map.put(localeId, file.getFileContent());
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u591a\u8bed\u8a00\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u591a\u8bed\u8a00\u6587\u4ef6\u5931\u8d25\uff1a%s\u3002", (String)"MultiLangMetadataFileService_0", (String)"bos-mservice-form", (Object[])new Object[0]), e.getMessage()));
        }
        return ApiResult.success((Object)SerializationUtils.toJsonString(map));
    }

    private void fillNullLangProperty(AbstractMetadata ... metas) {
        for (AbstractMetadata meta : metas) {
            if (meta == null) continue;
            String modelType = meta.getModelType();
            this.serializer = new MetadataSerializer(modelType);
            this.restoreLang(meta);
        }
    }

    private void restoreLang(AbstractMetadata metadata) {
        LangWriter writer = new LangWriter(this.serializer.getBinder(), (Object)metadata, new ArrayList());
        writer.setLoaceValue(this.tlangs);
        for (String tlang : this.tlangs) {
            writer.setNullLoaceValue(tlang, this.slang);
        }
    }

    private List<DeployFile> getDeployFile(String id) {
        AbstractMetadata abstractMetadata = MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetaData = null;
        if (abstractMetadata instanceof FormMetadata && StringUtils.isNotBlank((CharSequence)MetadataDao.getEntityNumberById((String)id))) {
            entityMetaData = (EntityMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Entity);
        }
        this.fillNullLangProperty(new AbstractMetadata[]{abstractMetadata, entityMetaData});
        return MultiLangMetadataFileService.getFormDeployFile(id, new AbstractMetadata[]{abstractMetadata, entityMetaData});
    }

    private static List<DeployFile> getFormDeployFile(String id, AbstractMetadata ... abstractMetadatas) {
        List files = null;
        ArrayList<DesignFormMetaL> designFormMetaLs = new ArrayList<DesignFormMetaL>();
        ArrayList<AbstractDesignMeta> designEntityMetaLs = new ArrayList<AbstractDesignMeta>();
        DesignFormMeta designFormMeta = null;
        DesignEntityMeta designEntityMeta = null;
        Map localeVersionMap = MetadataDao.getLocaleVersionMap((String)id);
        for (AbstractMetadata abstractMetadata : abstractMetadatas) {
            if (abstractMetadata == null) continue;
            MetadataWriter writer = new MetadataWriter(abstractMetadata.getModelType());
            List formDesigners = writer.convertToDesignMeta(new AbstractMetadata[]{abstractMetadata});
            for (AbstractDesignMeta abstractDesignMeta : formDesigners) {
                if (abstractDesignMeta instanceof DesignFormMetaL) {
                    DesignFormMetaL designFormMetaL = (DesignFormMetaL)abstractDesignMeta;
                    if (designFormMetaL.getLocaleId() != null && localeVersionMap.get(designFormMetaL.getLocaleId()) != null && (Long)localeVersionMap.get(designFormMetaL.getLocaleId()) != 0L) {
                        long version = (Long)localeVersionMap.get(designFormMetaL.getLocaleId());
                        designFormMetaL.setVersion(version);
                    }
                    designFormMetaLs.add(designFormMetaL);
                    continue;
                }
                if (abstractDesignMeta instanceof DesignFormMeta) {
                    designFormMeta = (DesignFormMeta)abstractDesignMeta;
                    continue;
                }
                if (abstractDesignMeta instanceof DesignEntityMetaL) {
                    designEntityMetaLs.add(abstractDesignMeta);
                    continue;
                }
                if (!(abstractDesignMeta instanceof DesignEntityMeta)) continue;
                designEntityMeta = (DesignEntityMeta)abstractDesignMeta;
            }
        }
        files = MetadataDao.getFormDeployFile(designFormMeta, designEntityMeta, designFormMetaLs, designEntityMetaLs);
        return files;
    }
}

