/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata.design;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtensibleDao;
import kd.bos.metadata.form.ContainerAp;

class DomainModelTypeExtHandler {
    private static final Log log = LogFactory.getLog(DomainModelTypeExtHandler.class);
    private static final String KEY_CATEGORIES = "Categories";
    private static final String KEY_ELEMENTS_TYPE = "ElementTypes";
    private static final String KEY_PROPERTIES = "Properties";
    private static final String KEY_PROPERTY_NAME = "PropertyName";
    private static final String KEY_ID = "Id";
    private static final String FIELD_PROPERTIES = "FieldProperties";
    private static final String HIDE_ELEMENTS = "HideElements";
    private static final String CATEGORY_ENTRY = "CategoryEntry";
    private static final String CATEGORY_HIDE_CONTAINER_CONTROL = "CategoryHideContainerControl";
    private static final String CONTAINER_CONTROL = "ContainerControl";
    private static final String CONTAINER_CONTROL_COMMON_PROPERTIES = "CommonProperties";
    private static final String ENTITY_CONTROL_PROPERTIES = "EntityControl";
    private static final String FIELD_AP_CONTROL = "FieldApControl";
    private static final String HIDE_ELEMENTS_EXTEND_EDIT = "ExtendCommonEdit";
    private static final Set<String> modelTypes = new HashSet<String>(Arrays.asList("BillFormModel", "BaseFormModel", "BillListCardViewModel", "MobileBillFormModel", "MobileListModel"));
    private static final Set<String> commonProperties = new HashSet<String>(Arrays.asList("Invisible", "Visible", "Lock"));
    private static final Set<String> formFieldAp = new HashSet<String>(Arrays.asList("FieldAp", "EntryFieldAp", "CardEntryFieldAp", "FlatFieldAp"));
    private static final Set<String> formApElements = new HashSet<String>(Arrays.asList("FormAp", "BillFormAp", "ListFormAp", "MobileBillFormAp", "MobileListFormAp", "MobileFormAp"));

    DomainModelTypeExtHandler() {
    }

    static void extHandler(Map<String, Object> modelMap, String modelType) {
        log.info("\u5f00\u59cb\u5c5e\u6027\u88c1\u526a\u8fc7\u6ee4\uff0cmodelType={}", (Object)modelType);
        if (!modelTypes.contains(modelType)) {
            return;
        }
        for (Map.Entry<String, Object> kv : modelMap.entrySet()) {
            if (!kv.getKey().equals(KEY_CATEGORIES)) continue;
            List categoryList = (List)kv.getValue();
            for (Object category : categoryList) {
                Map categoryMap = (Map)category;
                DomainModelTypeExtHandler.getExtLockTypeByJson(categoryMap, modelType);
            }
        }
    }

    private static void getExtLockTypeByJson(Map<String, Object> categoryMap, String modelType) {
        List elementTypeList = (List)categoryMap.get(KEY_ELEMENTS_TYPE);
        for (Object value : elementTypeList) {
            Map elementTypeMap = (Map)value;
            String elementName = (String)elementTypeMap.get(KEY_ID);
            String ownerTypeId = (String)elementTypeMap.get("OwnerTypeId");
            List propertyList = (List)elementTypeMap.get(KEY_PROPERTIES);
            if (propertyList == null) continue;
            for (Object o : propertyList) {
                ExtLockTypeEnum lockTypeEnum;
                Map property = (Map)o;
                String propertyName = (String)property.get(KEY_PROPERTY_NAME);
                if (("EntryEntity".equals(elementName) || "EntryEntity".equals(ownerTypeId)) && "TableName".equals(propertyName)) {
                    ((Map)o).remove("Action");
                }
                if ((lockTypeEnum = ExtensibleDao.getCommonExtLockType((String)"Field", (String)modelType, (String)elementName, (String)propertyName)) == null || lockTypeEnum == ExtLockTypeEnum.defaults) continue;
                property.put("LockType", lockTypeEnum.name());
            }
        }
    }

    static void lightExtHandler(Map<String, Object> modelMap, String modelType) {
        log.info("\u5f00\u59cb\u8f7b\u6269\u5c55\u5c5e\u6027\u63a7\u5236\uff0cmodelType={}", (Object)modelType);
        switch (modelType) {
            case "BillFormModel": 
            case "BaseFormModel": {
                DomainModelTypeExtHandler.filterFieldAttributes(modelMap, modelType);
                break;
            }
            case "BillListCardViewModel": 
            case "MobileListModel": 
            case "MobileBillFormModel": {
                DomainModelTypeExtHandler.controlPlugins(modelMap);
                break;
            }
        }
    }

    private static void filterFieldAttributes(Map<String, Object> modelMap, String modelType) {
        modelMap.put("disableFeatures", new String[]{"repeat", "copy", "cut", "paste"});
        modelMap.put("hidePropertyViews", new String[]{"style", "scheme"});
        Map fieldsMap = ExtensibleDao.getLightProperties((String)FIELD_PROPERTIES);
        Set fieldKeys = fieldsMap.keySet();
        Map entityMap = ExtensibleDao.getLightProperties((String)"Attribute");
        Set attributeWhitelist = (Set)entityMap.get("AttributeWhitelist");
        List allCategories = (List)modelMap.get(KEY_CATEGORIES);
        Map hideElementGrp = allCategories.stream().filter(o -> CATEGORY_HIDE_CONTAINER_CONTROL.equals(o.get(KEY_ID))).findFirst().get();
        Map hideElementGroup = allCategories.stream().filter(o -> HIDE_ELEMENTS.equals(o.get(KEY_ID))).findFirst().get();
        for (Map categoryMap : (List)modelMap.get(KEY_CATEGORIES)) {
            DomainModelTypeExtHandler.hideProperties(categoryMap, modelType, attributeWhitelist, fieldsMap);
            if (CATEGORY_HIDE_CONTAINER_CONTROL.equals(categoryMap.get(KEY_ID)) || HIDE_ELEMENTS.equals(categoryMap.get(KEY_ID))) continue;
            List elements = (List)categoryMap.get(KEY_ELEMENTS_TYPE);
            elements.removeIf(o -> {
                boolean e;
                boolean bl = e = !fieldKeys.contains(o.get(KEY_ID));
                if (e) {
                    try {
                        Class<?> clz = Class.forName(o.get("PackageName") + "." + o.get(KEY_ID));
                        List hideElements = ContainerAp.class.isAssignableFrom(clz) ? (List)hideElementGrp.get(KEY_ELEMENTS_TYPE) : (List)hideElementGroup.get(KEY_ELEMENTS_TYPE);
                        hideElements.add(o);
                    }
                    catch (Exception exception) {
                        log.info("qing ext attribute clipping" + exception);
                    }
                }
                return e;
            });
        }
    }

    private static void controlPlugins(Map<String, Object> modelMap) {
        modelMap.put("hidePropertyViews", new String[]{"style", "scheme"});
        for (Map.Entry<String, Object> kv : modelMap.entrySet()) {
            if (!kv.getKey().equals(KEY_CATEGORIES)) continue;
            List categoryList = (List)kv.getValue();
            for (Object category : categoryList) {
                Map categoryMap = (Map)category;
                List elementTypeList = (List)categoryMap.get(KEY_ELEMENTS_TYPE);
                Iterator elementItr = elementTypeList.iterator();
                JSONObject hide = new JSONObject();
                hide.put("hide", (Object)true);
                while (elementItr.hasNext()) {
                    List propertyList;
                    Map elementTypeMap = (Map)elementItr.next();
                    String elementName = (String)elementTypeMap.get(KEY_ID);
                    if (!formApElements.contains(elementName) || (propertyList = (List)elementTypeMap.get(KEY_PROPERTIES)) == null) continue;
                    for (Object o : propertyList) {
                        Map property = (Map)o;
                        String propertyName = (String)property.get(KEY_PROPERTY_NAME);
                        if (!"Plugins".equals(propertyName) && !"JSPlugins".equals(propertyName)) continue;
                        property.put("Hide", hide);
                    }
                }
            }
        }
    }

    private static void controlFrom(Map<String, Object> modelMap, String modelType) {
        modelMap.put("disableFeatures", new String[]{"repeat", "copy", "cut", "paste"});
        modelMap.put("hidePropertyViews", new String[]{"style", "scheme"});
        for (Map.Entry<String, Object> kv : modelMap.entrySet()) {
            if (!kv.getKey().equals(KEY_CATEGORIES)) continue;
            List categoryList = (List)kv.getValue();
            block18: for (Object category : categoryList) {
                String name;
                Map categoryMap = (Map)category;
                switch (name = (String)categoryMap.get(KEY_ID)) {
                    case "CommonField": 
                    case "BusinessField": {
                        DomainModelTypeExtHandler.controlFields(categoryMap, modelType);
                        continue block18;
                    }
                    case "EntityControl": {
                        DomainModelTypeExtHandler.controlProperties(categoryMap, modelType);
                        continue block18;
                    }
                    case "ContainerControl": {
                        DomainModelTypeExtHandler.controlEntity(categoryMap, modelType, name);
                    }
                    case "CategoryHideContainerControl": {
                        DomainModelTypeExtHandler.controlEntity(categoryMap, modelType, name);
                        categoryMap.put("Visible", false);
                    }
                    case "CategoryEntry": {
                        DomainModelTypeExtHandler.controlEntity(categoryMap, modelType, name);
                        categoryMap.put("Visible", false);
                        continue block18;
                    }
                    case "HideElements": {
                        DomainModelTypeExtHandler.hideElements(categoryMap, modelType);
                        continue block18;
                    }
                }
                categoryMap.put("Visible", false);
            }
        }
    }

    private static void hideProperties(Map<String, Object> categoryMap, String modelType, Set<String> attributeWhitelist, Map<String, Set<String>> fieldsMap) {
        List elementTypeList = (List)categoryMap.get(KEY_ELEMENTS_TYPE);
        for (Map elementTypeMap : elementTypeList) {
            String elementName = (String)elementTypeMap.get(KEY_ID);
            List propertyList = (List)elementTypeMap.get(KEY_PROPERTIES);
            if (propertyList == null) continue;
            if (fieldsMap.containsKey(elementName)) {
                propertyList.removeIf(p -> {
                    String propName = (String)p.get(KEY_PROPERTY_NAME);
                    Set props = (Set)fieldsMap.get(elementName);
                    return !props.contains(propName);
                });
            }
            for (Object o : propertyList) {
                Map property = (Map)o;
                String propertyName = (String)property.get(KEY_PROPERTY_NAME);
                if (attributeWhitelist.contains(propertyName)) {
                    ExtLockTypeEnum lockTypeEnum = ExtensibleDao.getCommonExtLockType((String)"Field", (String)modelType, (String)elementName, (String)propertyName);
                    if (lockTypeEnum == null || lockTypeEnum == ExtLockTypeEnum.defaults) continue;
                    property.put("LockType", lockTypeEnum.name());
                    continue;
                }
                DomainModelTypeExtHandler.updateActions(property, propertyName);
            }
        }
    }

    private static void controlEntity(Map<String, Object> categoryMap, String modelType, String categoryName) {
        Map fieldsMap = ExtensibleDao.getLightProperties((String)categoryName);
        List elementTypeList = (List)categoryMap.get(KEY_ELEMENTS_TYPE);
        Iterator elementItr = elementTypeList.iterator();
        JSONObject hide = new JSONObject();
        hide.put("hide", (Object)true);
        while (elementItr.hasNext()) {
            List propertyList;
            Map elementTypeMap = (Map)elementItr.next();
            String elementName = (String)elementTypeMap.get(KEY_ID);
            Set propertiesSet = (Set)fieldsMap.get(elementName);
            if (propertiesSet == null && (!categoryName.equalsIgnoreCase(CONTAINER_CONTROL) && !categoryName.equalsIgnoreCase(CATEGORY_HIDE_CONTAINER_CONTROL) || (propertiesSet = (Set)fieldsMap.get(CONTAINER_CONTROL_COMMON_PROPERTIES)) == null) || (propertyList = (List)elementTypeMap.get(KEY_PROPERTIES)) == null) continue;
            for (Object o : propertyList) {
                Map property = (Map)o;
                String propertyName = (String)property.get(KEY_PROPERTY_NAME);
                if (!propertiesSet.contains(propertyName)) {
                    property.put("Hide", hide);
                    continue;
                }
                ExtLockTypeEnum lockTypeEnum = ExtensibleDao.getCommonExtLockType((String)"Field", (String)modelType, (String)elementName, (String)propertyName);
                if (lockTypeEnum == null || lockTypeEnum == ExtLockTypeEnum.defaults) continue;
                property.put("LockType", lockTypeEnum.name());
            }
        }
    }

    private static void controlProperties(Map<String, Object> categoryMap, String modelType) {
        Map fieldsMap = ExtensibleDao.getLightProperties((String)ENTITY_CONTROL_PROPERTIES);
        Map entityMap = ExtensibleDao.getLightProperties((String)FIELD_AP_CONTROL);
        Set extendEditFields = (Set)entityMap.get(HIDE_ELEMENTS_EXTEND_EDIT);
        List elementTypeList = (List)categoryMap.get(KEY_ELEMENTS_TYPE);
        Iterator elementItr = elementTypeList.iterator();
        JSONObject hide = new JSONObject();
        hide.put("hide", (Object)true);
        while (elementItr.hasNext()) {
            List propertyList;
            Map elementTypeMap = (Map)elementItr.next();
            String elementName = (String)elementTypeMap.get(KEY_ID);
            Set propertiesSet = (Set)fieldsMap.get(elementName);
            if (propertiesSet == null || (propertyList = (List)elementTypeMap.get(KEY_PROPERTIES)) == null) continue;
            for (Object o : propertyList) {
                ExtLockTypeEnum lockTypeEnum;
                Map property = (Map)o;
                String propertyName = (String)property.get(KEY_PROPERTY_NAME);
                if (!propertiesSet.contains(propertyName)) {
                    property.put("Hide", hide);
                    continue;
                }
                if (formFieldAp.contains(elementName) && !extendEditFields.contains(propertyName)) {
                    DomainModelTypeExtHandler.updateActions(property, propertyName);
                }
                if ((lockTypeEnum = ExtensibleDao.getCommonExtLockType((String)"Field", (String)modelType, (String)elementName, (String)propertyName)) == null || lockTypeEnum == ExtLockTypeEnum.defaults) continue;
                property.put("LockType", lockTypeEnum.name());
            }
        }
    }

    private static void hideElements(Map<String, Object> categoryMap, String modelType) {
        List elementTypeList = (List)categoryMap.get(KEY_ELEMENTS_TYPE);
        Iterator elementItr = elementTypeList.iterator();
        JSONObject hide = new JSONObject();
        hide.put("hide", (Object)true);
        Map entityMap = ExtensibleDao.getLightProperties((String)HIDE_ELEMENTS);
        Set extendEditFields = (Set)entityMap.get(HIDE_ELEMENTS_EXTEND_EDIT);
        while (elementItr.hasNext()) {
            Map elementTypeMap = (Map)elementItr.next();
            String elementName = (String)elementTypeMap.get(KEY_ID);
            if (!entityMap.containsKey(elementName)) continue;
            Set layoutProperties = (Set)entityMap.get(elementName);
            List propertyList = (List)elementTypeMap.get(KEY_PROPERTIES);
            if (propertyList == null) continue;
            for (Object o : propertyList) {
                ExtLockTypeEnum lockTypeEnum;
                Map property = (Map)o;
                String propertyName = (String)property.get(KEY_PROPERTY_NAME);
                if (!layoutProperties.contains(propertyName)) {
                    property.put("Hide", hide);
                    continue;
                }
                if ("FlatFieldAp".equals(elementName) && !extendEditFields.contains(propertyName)) {
                    DomainModelTypeExtHandler.updateActions(property, propertyName);
                }
                if ((lockTypeEnum = ExtensibleDao.getCommonExtLockType((String)"Field", (String)modelType, (String)elementName, (String)propertyName)) == null || lockTypeEnum == ExtLockTypeEnum.defaults) continue;
                property.put("LockType", lockTypeEnum.name());
            }
        }
    }

    private static void controlFields(Map<String, Object> categoryMap, String modelType) {
        Map fieldsMap = ExtensibleDao.getLightProperties((String)FIELD_PROPERTIES);
        List elementTypeList = (List)categoryMap.get(KEY_ELEMENTS_TYPE);
        Iterator elementItr = elementTypeList.iterator();
        while (elementItr.hasNext()) {
            Map elementTypeMap = (Map)elementItr.next();
            String elementName = (String)elementTypeMap.get(KEY_ID);
            if (fieldsMap.containsKey(elementName)) {
                Set propertiesSet = (Set)fieldsMap.get(elementName);
                List propertyList = (List)elementTypeMap.get(KEY_PROPERTIES);
                if (propertyList == null) continue;
                Iterator properties = propertyList.iterator();
                while (properties.hasNext()) {
                    Map property = (Map)properties.next();
                    String propertyName = (String)property.get(KEY_PROPERTY_NAME);
                    if (!propertiesSet.contains(propertyName)) {
                        properties.remove();
                        continue;
                    }
                    DomainModelTypeExtHandler.updateActions(property, propertyName);
                    ExtLockTypeEnum lockTypeEnum = ExtensibleDao.getCommonExtLockType((String)"Field", (String)modelType, (String)elementName, (String)propertyName);
                    if (lockTypeEnum == null || lockTypeEnum == ExtLockTypeEnum.defaults) continue;
                    property.put("LockType", lockTypeEnum.name());
                }
                continue;
            }
            elementItr.remove();
        }
    }

    private static void updateActions(Map<String, Object> property, String propertyName) {
        HashMap actions = (HashMap)property.get("Action");
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        itemMap.put("condition", "is('Inherit', true) && true");
        HashMap<String, Object> actionMap = new HashMap<String, Object>();
        actionMap.put("name", "hideproperty");
        actionMap.put("args", Collections.singletonList(propertyName));
        itemMap.put("action", actionMap);
        if (actions == null) {
            actions = new HashMap();
            property.put("Action", actions);
            ArrayList<HashMap<String, Object>> itemList = new ArrayList<HashMap<String, Object>>();
            itemList.add(itemMap);
            actions.put("items", itemList);
        } else {
            List itemList = (List)actions.get("items");
            itemList.add(itemMap);
        }
    }
}

