/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata.log;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlObject;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.DBVersion;
import kd.bos.entity.ISVInfo;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.metadata.dao.MetaType;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.service.KDDateUtils;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.service.metadata.log.MetaLogData;
import kd.bos.service.metadata.log.MetaLogParam;
import kd.bos.service.metadata.log.MetaOperateLog;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.ExceptionUtils;

public class MetadataLogServiceImpl
implements MetadataLogService {
    private static Log log = LogFactory.getLog(MetadataLogServiceImpl.class);
    private static int META_LOG_SAVE_MONTH = Integer.parseInt(System.getProperty("meta_log_save_month", "-6"));
    private static final String ISV_KINGDEE = "kingdee";
    private static final String ISV_KDTEST = "kdtest";

    public void addMetaLog(String metaId, int type, long logId, int metaType) {
        this.addMetaLog(metaId, null, type, logId, metaType);
    }

    public void addMetaLog(String metaId, String metaNumber, int type, long logId, int metaType) {
        try {
            DeployMetadata deploy;
            if (StringUtils.isBlank((CharSequence)metaId) || !DB.exitsTable((DBRoute)DBRoute.log, (String)"T_LOG_METAOPERATE") || !DB.exitsTable((DBRoute)DBRoute.log, (String)"T_LOG_METAVERSION")) {
                log.info("\u8868\u5355ID\u4e3a\u7a7a\u6216\u5143\u6570\u636e\u65e5\u5fd7\u8868\u4e0d\u5b58\u5728\uff0c\u9000\u51fa\u3002");
                return;
            }
            if (StringUtils.isBlank((CharSequence)metaNumber) && MetaLogType.DataModel.getValue() != type) {
                metaNumber = MetadataDao.getNumberById((String)metaId);
            }
            String bizAppId = metaId;
            if (metaType == 1) {
                bizAppId = MetadataDao.getAppIdByFormId((String)metaId);
            }
            if (MetaLogType.BizObjExtSave.getValue() == type || MetaLogType.BizObjExtDeploy.getValue() == type) {
                deploy = MetadataDao.getBizObjExtMetadata((String)metaId);
            } else if (MetaLogType.DataModel.getValue() == type) {
                deploy = this.getDataModelMetadata(metaId);
                bizAppId = deploy == null ? "" : deploy.getBizappId();
            } else {
                deploy = this.getDeployMeta(metaId, bizAppId);
            }
            String data = this.getDeployMeta(deploy);
            long version = deploy == null ? 0L : deploy.getVersion();
            MetaLogParam param = new MetaLogParam(metaId, metaNumber, type, logId, metaType);
            param.setVersion(version);
            param.setData(data);
            param.setBizAppId(bizAppId);
            this.addMetaLog(param);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5143\u6570\u636e\u65e5\u5fd7\u5931\u8d25\uff0cerr\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public void addBotpMetaLog(String metaId, String metaNumber, String content, int type, long logId, String bizAppId, String remark) {
        if (StringUtils.isBlank((CharSequence)metaId) || !DB.exitsTable((DBRoute)DBRoute.log, (String)"T_LOG_METAOPERATE") || !DB.exitsTable((DBRoute)DBRoute.log, (String)"T_LOG_METAVERSION")) {
            log.info("\u8868\u5355ID\u4e3a\u7a7a\u6216\u5143\u6570\u636e\u65e5\u5fd7\u8868\u4e0d\u5b58\u5728\uff0c\u9000\u51fa\u3002");
            return;
        }
        MetaLogParam param = new MetaLogParam(metaId, metaNumber, type, logId, MetaType.Form.getValue());
        param.setData(content);
        param.setBizAppId(bizAppId);
        param.setContent(remark);
        this.addMetaLog(param);
    }

    public void addMetaLog(String metaId, String metaNumber, String data, int type, long logId, int metaType) {
        try {
            if (StringUtils.isBlank((CharSequence)metaId)) {
                return;
            }
            DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
            serializer.setColloctionIgnorePKValue(true);
            DeployMetadata deploy = (DeployMetadata)serializer.deserializeFromString(data, null);
            if (deploy.isMultilanguage()) {
                log.info("Multilanguage \u5143\u6570\u636e\u6682\u4e0d\u8bb0\u5f55");
                return;
            }
            if (StringUtils.isBlank((CharSequence)metaNumber)) {
                metaNumber = MetadataDao.getNumberById((String)metaId);
            }
            MetaLogParam param = new MetaLogParam(metaId, metaNumber, type, logId, metaType);
            param.setVersion(deploy.getVersion());
            param.setData(data);
            param.setBizAppId(deploy.getBizappId());
            this.addMetaLog(param);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5143\u6570\u636e\u65e5\u5fd7\u5931\u8d25\uff0cerr\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private boolean isForceAddLog() {
        AppParam param = new AppParam();
        param.setAppId("83bfebc800003dac");
        long rootOrgId = ((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId();
        param.setOrgId(Long.valueOf(rootOrgId));
        param.setViewType("15");
        Map map = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param);
        if (map.get("meta_log_force_add") == null) {
            return false;
        }
        return (Boolean)map.get("meta_log_force_add");
    }

    private void addMetaLog(MetaLogParam param) {
        if (param == null || StringUtils.isBlank((CharSequence)param.getMetaId())) {
            return;
        }
        ISVInfo isv = ISVServiceHelper.getISVInfo();
        if (!this.isForceAddLog() && (ISV_KINGDEE.equals(isv.getId()) || ISV_KDTEST.equals(isv.getId()))) {
            return;
        }
        String formId = param.getMetaId();
        String formNumber = param.getMetaNumber();
        String data = param.getData();
        String dbVer = DBVersion.getVer();
        String userId = RequestContext.get().getUserId();
        long user = 0L;
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            user = Long.parseLong(userId);
        }
        Date current = new Date();
        String bizAppId = param.getBizAppId();
        if (StringUtils.isBlank((CharSequence)bizAppId) && MetaLogType.DataModel.getValue() != param.getType()) {
            bizAppId = MetadataDao.getAppIdByFormId((String)formId);
        }
        long version = param.getVersion();
        long fid = param.getLogId();
        long entryId = DB.genGlobalLongId();
        IDataEntityType operateLogType = OrmUtils.getDataEntityType(MetaOperateLog.class);
        IDataEntityType logDataType = OrmUtils.getDataEntityType(MetaLogData.class);
        MetaOperateLog operateLog = new MetaOperateLog(fid, isv.getId(), param.getType(), dbVer, user, current);
        MetaLogData logData = new MetaLogData(entryId, fid, formId, formNumber, data, version, bizAppId, param.getMetaType());
        operateLog.setContent(param.getContent());
        Object[] logs = BusinessDataReader.load((Object[])new Object[]{fid}, (IDataEntityType)operateLogType);
        if (logs == null || logs.length <= 0) {
            try (TXHandle h = TX.requiresNew();){
                BusinessDataWriter.save((IDataEntityType)operateLogType, (Object[])new Object[]{operateLog});
                BusinessDataWriter.save((IDataEntityType)logDataType, (Object[])new Object[]{logData});
            }
        }
        try (TXHandle h = TX.requiresNew();){
            BusinessDataWriter.save((IDataEntityType)logDataType, (Object[])new Object[]{logData});
        }
    }

    public void addAppMetaLog(String appId, int type, long logId, int metaType) {
        try {
            if (StringUtils.isBlank((CharSequence)appId)) {
                log.info("\u8868\u5355ID\u4e3a\u7a7a\uff0c\u9000\u51fa\u3002");
                return;
            }
            String appNumber = MetadataDao.getAppNumberByAppId((String)appId);
            String data = "";
            List files = MetadataDao.getAppDeployFile((String)appId);
            if (files != null && files.size() > 0) {
                data = ((DeployFile)files.get(0)).getFileContent();
            }
            long version = 0L;
            MetaLogParam param = new MetaLogParam(appId, appNumber, type, logId, metaType);
            param.setVersion(version);
            param.setData(data);
            param.setBizAppId(appId);
            this.addMetaLog(param);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5143\u6570\u636e\u65e5\u5fd7\u5931\u8d25\uff0cerr\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private DeployMetadata getDeployMeta(String formId, String bizAppId) {
        DesignFormMeta designMeta = (DesignFormMeta)BusinessDataReader.read((Object)formId, (IDataEntityType)OrmUtils.getDataEntityType(DesignFormMeta.class), (Boolean)false);
        DeployMetadata deploy = new DeployMetadata();
        deploy.setBizappId(bizAppId);
        deploy.setBizunitId(MetadataDao.getUnitIdFromUnitrel((String)formId));
        deploy.setMultilanguage(false);
        deploy.getDesignMetas().add(designMeta);
        if (designMeta.getId().equals(designMeta.getEntityId())) {
            deploy.getDesignMetas().add((DesignEntityMeta)BusinessDataReader.read((Object)formId, (IDataEntityType)OrmUtils.getDataEntityType(DesignEntityMeta.class), (Boolean)false));
        }
        String masterId = "2".equals(designMeta.getDevType()) ? designMeta.getMasterId() : formId;
        deploy.setMasterId(masterId);
        deploy.setId(formId);
        deploy.setVersion(designMeta.getVersion());
        return deploy;
    }

    private DeployMetadata getDataModelMetadata(String modelId) {
        try {
            Class<?> dataModel = Class.forName("kd.bos.datamodel.metadata.pdm.DeployPDMMetadataDao");
            Object object = dataModel.newInstance();
            Method method = dataModel.getDeclaredMethod("getDataModelMetadata", String.class);
            return (DeployMetadata)method.invoke(object, modelId);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
    }

    private String getDeployMeta(DeployMetadata deploy) {
        if (deploy == null) {
            return "";
        }
        DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
        serializer.setIndent(true);
        serializer.setNewlines(true);
        String fileContent = serializer.serializeToString((Object)deploy, null);
        if (!fileContent.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>") && !(fileContent = serializer.serializeToString((Object)this, null)).startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) {
            throw new KDException(BosErrorCode.jSONParsing, new Object[]{ResManager.loadKDString((String)"\u5143\u6570\u636e\u5e8f\u5217\u5316\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff01", (String)"MetadataLogServiceImpl_0", (String)"bos-mservice-form", (Object[])new Object[0])});
        }
        return fileContent;
    }

    public void cleanLog() {
        this.cleanHalfYearMeta();
    }

    public List<String> queryMetaIds(List<String> metaIds) {
        if (CollectionUtils.isEmpty(metaIds)) {
            return new ArrayList<String>();
        }
        StringBuilder sqlBuilder = new StringBuilder("SELECT fmetaid  FROM T_LOG_METAVERSION where fmetaid in (?");
        ArrayList<Object> params = new ArrayList<Object>(10);
        params.add(new SqlParameter(":fmetaid0", 12, (Object)metaIds.get(0)));
        for (int i = 1; i < metaIds.size(); ++i) {
            sqlBuilder.append(",?");
            params.add(new kd.bos.dataentity.SqlParameter(":fmetaid" + String.valueOf(i), 12, (Object)metaIds.get(i)));
        }
        sqlBuilder.append(")");
        List metaIdList = (List)DB.query((DBRoute)DBRoute.log, (String)sqlBuilder.toString(), (Object[])params.toArray(new SqlParameter[params.size()]), (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> idList = new ArrayList<String>(10);
                while (rs.next()) {
                    String fmetaid = rs.getString(1);
                    idList.add(fmetaid);
                }
                return idList;
            }
        });
        return metaIdList;
    }

    public void addScheduleDeployMetaLog(String metaId, String metaNumber, String content, int type, long logId, String bizAppId, String remark) {
        if (StringUtils.isBlank((CharSequence)metaId) || !DB.exitsTable((DBRoute)DBRoute.log, (String)"T_LOG_METAOPERATE") || !DB.exitsTable((DBRoute)DBRoute.log, (String)"T_LOG_METAVERSION")) {
            log.info("\u8868\u5355ID\u4e3a\u7a7a\u6216\u5143\u6570\u636e\u65e5\u5fd7\u8868\u4e0d\u5b58\u5728\uff0c\u9000\u51fa\u3002");
            return;
        }
        MetaLogParam param = new MetaLogParam(metaId, metaNumber, type, logId, MetaType.Form.getValue());
        param.setData(content);
        param.setBizAppId(bizAppId);
        param.setRemark(remark);
        this.addMetaLog(param);
    }

    private void cleanHalfYearMeta() {
        try (TXHandle tx = TX.requiresNew();){
            Date now = KDDateUtils.now();
            Date threeMonthBefore = KDDateUtils.addMonths((Date)now, (int)META_LOG_SAVE_MONTH);
            String operatLogDelete = "delete from t_log_metaoperate where foperatetime <= ? ";
            DB.execute((DBRoute)DBRoute.log, (String)operatLogDelete, (Object[])new SqlParameter[]{new SqlParameter(":foperatetime", 91, (Object)threeMonthBefore)});
            String metaVersionDelete = "delete FROM t_log_metaversion a WHERE NOT EXISTS (SELECT 1 FROM t_log_metaoperate b WHERE b.FID = a.FID)";
            DB.execute((DBRoute)DBRoute.log, (String)metaVersionDelete);
        }
        catch (Exception e) {
            log.error("\u5143\u6570\u636e\u65e5\u5fd7\u6e05\u7406\u51fa\u9519\uff0cerr:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw e;
        }
    }

    @Deprecated
    private void cleanMeta() {
        try {
            Map<String, List<Long>> metaIds = this.getNeedClearMeta();
            if (metaIds.isEmpty()) {
                log.info("\u672a\u627e\u5230\u9700\u8981\u6e05\u7406\u7684\u5143\u6570\u636e\u65e5\u5fd7\uff0c\u9000\u51fa\u3002");
                return;
            }
            ArrayList<SqlObject> sqlList = new ArrayList<SqlObject>(10);
            for (Map.Entry<String, List<Long>> entry : metaIds.entrySet()) {
                String metaId = entry.getKey();
                List<Long> ids = entry.getValue();
                if (ids == null || ids.isEmpty() || ids.size() <= 3) continue;
                Long thirdId = ids.get(2);
                String sql = String.format("DELETE FROM %s WHERE fmetaid = '%s' and fentryid < %s", "T_LOG_METAVERSION", metaId, thirdId);
                sqlList.add(new SqlObject(sql, new SqlParameter[0]));
            }
            if (sqlList.isEmpty()) {
                log.info("\u672a\u627e\u5230\u5339\u914d\u7684\u5143\u6570\u636e\u65e5\u5fd7\uff0c\u9000\u51fa\u6e05\u7406\u3002");
                return;
            }
            for (SqlObject sql : sqlList) {
                TXHandle tx = TX.required();
                Throwable throwable = null;
                try {
                    DB.execute((DBRoute)DBRoute.log, (String)sql.getSql(), (Object[])sql.getParams());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
            log.info("\u5143\u6570\u636e\u65e5\u5fd7\u6e05\u7406\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u5143\u6570\u636e\u65e5\u5fd7\u6e05\u7406\u51fa\u9519\uff0cerr:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    @Deprecated
    private Map<String, List<Long>> getNeedClearMeta() {
        String sql = "SELECT fmetaid,fentryid from T_LOG_METAVERSION WHERE fmetaid in (SELECT fmetaid FROM T_LOG_METAVERSION GROUP BY fmetaid HAVING COUNT(fmetaid) > 3)  ORDER BY fentryid desc ";
        Map metaIds = (Map)DB.query((DBRoute)DBRoute.log, (String)sql, (ResultSetHandler)new ResultSetHandler<Map<String, List<Long>>>(){

            public Map<String, List<Long>> handle(ResultSet rs) throws Exception {
                HashMap<String, List<Long>> metaIds = new HashMap<String, List<Long>>(16);
                while (rs.next()) {
                    String metaId = rs.getString(1);
                    long fentryId = rs.getLong(2);
                    LinkedList<Long> ids = (LinkedList<Long>)metaIds.get(metaId);
                    if (metaIds.get(metaId) == null) {
                        ids = new LinkedList<Long>();
                    }
                    if (ids.size() > 4) continue;
                    ids.add(fentryId);
                    metaIds.put(metaId, ids);
                }
                return metaIds;
            }
        });
        return metaIds;
    }

    private void cleanOperateLog() {
        try {
            List<Long> logIds = this.getNeedClearLogIds();
            if (logIds == null || logIds.isEmpty()) {
                log.info("\u672a\u627e\u5230\u5197\u4f59\u7684\u64cd\u4f5c\u65e5\u5fd7\uff0c\u9000\u51fa\u6e05\u7406");
                return;
            }
            try (TXHandle h = TX.requiresNew((String)"delMetaOperateLog");){
                String deleteSql = "DELETE FROM T_LOG_METAOPERATE WHERE FID =?";
                ArrayList<Object[]> list = new ArrayList<Object[]>(10);
                for (int i = 0; i < logIds.size(); ++i) {
                    Object[] param = new Object[]{logIds.get(i)};
                    list.add(param);
                }
                DB.executeBatch((DBRoute)DBRoute.log, (String)deleteSql, list);
                log.info(String.format("\u627e\u5230%s\u6761\u9700\u6e05\u7406\u7684\u64cd\u4f5c\u65e5\u5fd7\uff0c\u6e05\u9664\u6210\u529f\uff01", logIds.size()));
            }
        }
        catch (Exception e) {
            log.error("\u6e05\u7406\u5197\u4f59\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25\uff0cerr\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private List<Long> getNeedClearLogIds() {
        String sql = "SELECT a.FID FROM T_LOG_METAOPERATE a WHERE NOT EXISTS (SELECT 1 FROM T_LOG_METAVERSION b WHERE b.FID = a.FID)";
        List logIds = (List)DB.query((DBRoute)DBRoute.log, (String)sql, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> logIds = new ArrayList<Long>(10);
                while (rs.next()) {
                    Long fid = rs.getLong(1);
                    logIds.add(fid);
                }
                return logIds;
            }
        });
        return logIds;
    }
}

