/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.multilang;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.metadata.form.DesignFormMetaL;
import kd.bos.service.multilang.ParameterUtil;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class MultiLangDataFileService
implements IBillWebApiPlugin {
    private static final String UNIQUE = "unique";
    private static final String FILENAME = "filename";
    private static final Log log = LogFactory.getLog(MultiLangDataFileService.class);
    private static final String[] types = new String[]{"BOS_BillFunctionTypes", "FilterMetadata"};

    public ApiResult doCustomService(Map<String, Object> params) {
        try {
            String id;
            Map checkResult;
            Object orgAuthorFilter;
            String urlFormat = "/app/mdl/MultiLangDataFileService";
            Object objResult = DispatchServiceHelper.invokeService((String)"kd.bos.openapi.servicehelper", (String)"bos", (String)"OpenApiEntityService", (String)"getUserConfig", (Object[])new Object[]{urlFormat});
            if (objResult instanceof Map && (orgAuthorFilter = (checkResult = (Map)objResult).get("org_author_filter")) instanceof Boolean && ((Boolean)orgAuthorFilter).booleanValue() && !this.isHasRight()) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u672a\u7ecf\u6388\u6743\u7684\u8bbf\u95ee\u3002", (String)"MultiLangDataFileService_2", (String)"bos-mservice-form", (Object[])new Object[0]));
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            ParameterUtil util = new ParameterUtil(params);
            String unique = util.getParam(UNIQUE);
            String tlangs = (String)params.get("tlangs");
            if (tlangs == null) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u66f4\u65b0\u591a\u8bed\u8a00\u8bcd\u6761\u5931\u8d25 tlangs  is null", (String)"MultiLangDataFileService_0", (String)"bos-mservice-form", (Object[])new Object[0]));
            }
            this.checkUnique(unique);
            switch (unique) {
                case "BOS_BillFunctionTypes": {
                    id = "269QKQ0MGDHP";
                    break;
                }
                case "FilterMetadata": {
                    id = "269QKQ0Q4X58";
                    break;
                }
                default: {
                    throw new InvalidParameterException("error unique");
                }
            }
            DesignFormMetaL meta = this.readMetaL(id, tlangs);
            if (meta != null) {
                DeployMetadata deploy = new DeployMetadata();
                deploy.setMasterId(id);
                deploy.setId(id);
                deploy.setVersion(1L);
                deploy.getDesignMetas().add(meta);
                DeployFile deployFile = deploy.toDeployFile(unique + "." + tlangs + ".dymx");
                result.put(FILENAME, deployFile.getFileName());
                result.put(UNIQUE, unique);
                result.put("domain", "bos");
                result.put("appId", "sys");
                result.put("version", "1");
                result.put("buildpath", "/MetaData");
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put(tlangs, deployFile.getFileContent());
                result.put("contents", map);
            }
            return ApiResult.success((Object)util.toEncrypt(SerializationUtils.toJsonString(result)));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u591a\u8bed\u8a00\u6587\u4ef6\u5931\u8d25: ", (Throwable)e);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u591a\u8bed\u8a00\u6587\u4ef6\u5931\u8d25: %s", (String)"MultiLangDataFileService_1", (String)"bos-mservice-form", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private DesignFormMetaL readMetaL(String id, String lcid) {
        String sql = "select fpkid,fdata,fnumber,fname from t_meta_formdesign_l where fid = ? and flocaleid = ? ";
        ArrayList list = new ArrayList(16);
        DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{new SqlParameter((Object)id), new SqlParameter((Object)lcid)}, rs -> {
            if (rs.next()) {
                DesignFormMetaL l = new DesignFormMetaL();
                l.setId(id);
                l.setPkId(rs.getString("fpkid"));
                l.setLocaleId(lcid);
                l.setNumber(rs.getString("fnumber"));
                l.setName(rs.getString("fname"));
                l.setDataXml(rs.getString("fdata"));
                list.add(l);
            }
            return list;
        });
        if (!list.isEmpty()) {
            return (DesignFormMetaL)list.get(0);
        }
        return null;
    }

    private void checkUnique(String type) {
        for (String s : types) {
            if (!s.equals(type)) continue;
            return;
        }
        throw new InvalidParameterException("error unique");
    }

    private boolean isHasRight() {
        long userId = RequestContext.get().getCurrUserId();
        int flag = PermissionServiceHelper.checkPermission((Long)userId, (Long)0L, null, (String)"pc_devportal_main", (String)"47150e89000000ac");
        return flag == 1;
    }
}

