/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.multilang;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.filter.CompareCategory;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.entity.function.FunctionGroup;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.id.Base39Coder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.DesignMetaL;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.form.DesignFormMetaL;
import kd.bos.service.multilang.LangDataConsumer;
import kd.bos.service.multilang.MultiLangDataLoad;
import kd.bos.service.multilang.ParameterUtil;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class MultiLangDataUpdate
implements IBillWebApiPlugin {
    private static final String FUNCTION_TYPES_ID = "269QKQ0MGDHP";
    private static final String FILTER_META_ID = "269QKQ0Q4X58";
    private static final String[] types = new String[]{"BOS_BillFunctionTypes", "FilterMetadata"};
    private static final List<IDataEntityType> dts_Function = new ArrayList<IDataEntityType>();
    private static final List<IDataEntityType> dts_FilterMeta = new ArrayList<IDataEntityType>();
    private static final Log log = LogFactory.getLog(MultiLangDataLoad.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        try {
            Map checkResult;
            Object orgAuthorFilter;
            String urlFormat = "/app/mdl/MultiLangDataUpdate";
            Object objResult = DispatchServiceHelper.invokeService((String)"kd.bos.openapi.servicehelper", (String)"bos", (String)"OpenApiEntityService", (String)"getUserConfig", (Object[])new Object[]{urlFormat});
            if (objResult instanceof Map && (orgAuthorFilter = (checkResult = (Map)objResult).get("org_author_filter")) instanceof Boolean && ((Boolean)orgAuthorFilter).booleanValue() && !this.isHasRight()) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u672a\u7ecf\u6388\u6743\u7684\u8bbf\u95ee\u3002", (String)"MultiLangDataUpdate_4", (String)"bos-mservice-form", (Object[])new Object[0]));
            }
            ParameterUtil util = new ParameterUtil(params);
            String unique = util.getParam("unique");
            this.checkUnique(unique);
            String tlangs = (String)params.get("tlangs");
            if (tlangs == null) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u66f4\u65b0\u591a\u8bed\u8a00\u8bcd\u6761\u5931\u8d25 tlangs  is null", (String)"MultiLangDataUpdate_2", (String)"bos-mservice-form", (Object[])new Object[0]));
            }
            List<Map<String, Map<String, String>>> localeData = util.getParamList("localeData");
            if (localeData != null) {
                Object baseObject;
                Object entityObject;
                String saveId;
                List<IDataEntityType> dts;
                switch (unique) {
                    case "BOS_BillFunctionTypes": {
                        dts = dts_Function;
                        saveId = FUNCTION_TYPES_ID;
                        FunctionTypes functionTypes = FunctionTypes.get();
                        entityObject = this.cloneObject(dts, functionTypes, tlangs);
                        baseObject = this.cloneObject(dts, functionTypes, tlangs);
                        this.clearLocaleValue(baseObject, OrmUtils.getDataEntityType(FunctionTypes.class), tlangs);
                        HashMap groupMap = new HashMap(16);
                        ((FunctionTypes)entityObject).getFunctionGroups().forEach(o -> groupMap.put(o.getId(), o));
                        HashMap functionTypeMap = new HashMap(16);
                        ((FunctionTypes)entityObject).getFunctionTypes().forEach(o -> functionTypeMap.put(o.getId(), o));
                        this.visitLocaleData(localeData, tlangs, (type, id, key, value) -> {
                            FunctionType functionType;
                            if (type.equals("FunctionGroup")) {
                                FunctionGroup functionGroup = (FunctionGroup)groupMap.get(id);
                                if (functionGroup != null && key.equals("name")) {
                                    functionGroup.getName().setItem(tlangs, (Object)value);
                                }
                            } else if (type.equals("FunctionType") && (functionType = (FunctionType)functionTypeMap.get(id)) != null) {
                                if (key.equals("name")) {
                                    functionType.getName().setItem(tlangs, (Object)value);
                                } else if (key.equals("desc")) {
                                    functionType.getDesc().setItem(tlangs, (Object)value);
                                }
                            }
                        });
                        break;
                    }
                    case "FilterMetadata": {
                        FilterMetadata filterMetadata = FilterMetadata.get();
                        saveId = FILTER_META_ID;
                        dts = dts_FilterMeta;
                        entityObject = this.cloneObject(dts, filterMetadata, tlangs);
                        baseObject = this.cloneObject(dts, filterMetadata, tlangs);
                        this.clearLocaleValue(baseObject, OrmUtils.getDataEntityType(FilterMetadata.class), tlangs);
                        HashMap compareCategoryMap = new HashMap(16);
                        HashMap compareTypeMap = new HashMap(16);
                        ((FilterMetadata)entityObject).getCompareCategories().forEach(compareCategory -> {
                            compareCategoryMap.put(compareCategory.getId(), compareCategory);
                            compareCategory.getCompareTypes().forEach(compareType -> compareTypeMap.put(compareCategory.getId() + "|" + compareType.getId(), compareType));
                        });
                        this.visitLocaleData(localeData, tlangs, (type, id, key, value) -> {
                            CompareType compareType;
                            if (type.equals("CompareCategory")) {
                                CompareCategory compareCategory = (CompareCategory)compareCategoryMap.get(id);
                                if (compareCategory != null && key.equals("name")) {
                                    compareCategory.getName().setItem(tlangs, (Object)value);
                                }
                            } else if (type.equals("CompareType") && (compareType = (CompareType)compareTypeMap.get(id)) != null && key.equals("name")) {
                                compareType.getName().setItem(tlangs, (Object)value);
                            }
                        });
                        break;
                    }
                    default: {
                        throw new InvalidParameterException("error unique");
                    }
                }
                String xml = this.toXml(dts, entityObject, baseObject, tlangs);
                this.saveXml(saveId, unique, tlangs, xml);
                switch (unique) {
                    case "BOS_BillFunctionTypes": {
                        FunctionTypes.clearCache();
                        break;
                    }
                    case "FilterMetadata": {
                        FilterMetadata.cleareCache();
                    }
                }
            } else {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u66f4\u65b0\u591a\u8bed\u8a00\u8bcd\u6761\u5931\u8d25 localeData  is null", (String)"MultiLangDataUpdate_3", (String)"bos-mservice-form", (Object[])new Object[0]));
            }
            return ApiResult.success((Object)ResManager.loadKDString((String)"\u66f4\u65b0\u591a\u8bed\u8a00\u8bcd\u6761\u6210\u529f", (String)"MultiLangDataUpdate_1", (String)"bos-mservice-form", (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u591a\u8bed\u8a00\u8bcd\u6761\u5931\u8d25: ", (Throwable)e);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u591a\u8bed\u8a00\u8bcd\u6761\u5931\u8d25", (String)"MultiLangDataUpdate_0", (String)"bos-mservice-form", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void clearLocaleValue(Object baseObject, IDataEntityType entityType, String localeId) {
        for (IDataEntityProperty property : entityType.getProperties()) {
            if (LocaleString.class.isAssignableFrom(property.getPropertyType())) {
                LocaleString value = (LocaleString)property.getValue(baseObject);
                value.setItem(localeId, (Object)"");
                continue;
            }
            if (property instanceof ICollectionProperty) {
                ICollectionProperty collectionProperty = (ICollectionProperty)property;
                List list = (List)collectionProperty.getValue(baseObject);
                for (Object row : list) {
                    this.clearLocaleValue(row, collectionProperty.getItemType(), localeId);
                }
                continue;
            }
            if (!(property instanceof IComplexProperty)) continue;
            IComplexProperty complexProperty = (IComplexProperty)property;
            this.clearLocaleValue(complexProperty.getValue(baseObject), complexProperty.getComplexType(), localeId);
        }
    }

    private void saveXml(String id, String type, String lcid, String xml) {
        DesignFormMetaL designMetaL = new DesignFormMetaL();
        designMetaL.setLocaleId(lcid);
        designMetaL.setNumber(type);
        designMetaL.setName(type);
        designMetaL.setId(id);
        designMetaL.setPkId(Base39Coder.toString((long)DB.genGlobalLongId()));
        designMetaL.setDataXml(xml);
        IDataEntityType dataEntityType = OrmUtils.getDataEntityType(DesignFormMetaL.class);
        MetadataWriter.delFormMetadataLang((DesignMetaL)designMetaL);
        BusinessDataWriter.save((IDataEntityType)dataEntityType, (Object[])new Object[]{designMetaL});
    }

    private void checkUnique(String type) {
        for (String s : types) {
            if (!s.equals(type)) continue;
            return;
        }
        throw new InvalidParameterException("error unique");
    }

    private void visitLocaleData(List<Map<String, Map<String, String>>> localeData, String langId, LangDataConsumer consumer) {
        for (Map<String, Map<String, String>> row : localeData) {
            for (Map.Entry<String, Map<String, String>> entry : row.entrySet()) {
                String[] s = entry.getKey().split("_");
                if (s.length > 2) {
                    int i;
                    StringBuilder id;
                    String key = s[s.length - 1];
                    if (key.equals("desc")) {
                        id = new StringBuilder();
                        for (i = 1; i <= s.length - 2; ++i) {
                            id.append(s[i]);
                            if (i >= s.length - 2) continue;
                            id.append("_");
                        }
                        consumer.accept(s[0], id.toString(), key, entry.getValue().get(langId));
                        continue;
                    }
                    id = new StringBuilder();
                    for (i = 1; i <= s.length - 1; ++i) {
                        id.append(s[i]);
                        if (i >= s.length - 1) continue;
                        id.append("_");
                    }
                    consumer.accept(s[0], id.toString(), "name", entry.getValue().get(langId));
                    continue;
                }
                consumer.accept(s[0], s[1], "name", entry.getValue().get(langId));
            }
        }
    }

    private Object cloneObject(List<IDataEntityType> dts, Object entity, String lcid) {
        String xml = this.toXml(dts, entity, null, lcid);
        return this.toObject(dts, xml, lcid, null);
    }

    private Object toObject(List<IDataEntityType> dts, String xml, String lcid, Object base) {
        ListDcxmlBinder binder = new ListDcxmlBinder(true, dts);
        binder.setLCId(lcid);
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)binder);
        return ser.deserializeFromString(xml, base);
    }

    private String toXml(List<IDataEntityType> dts, Object entity, Object base, String lcid) {
        ListDcxmlBinder binder = new ListDcxmlBinder(true, dts);
        binder.setLCId(lcid);
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)binder);
        ser.setIndent(true);
        ser.setNewlines(true);
        ser.setOnlyLocaleVale(true);
        ser.setIsLocaleValueFull(false);
        return ser.serializeToString(entity, base);
    }

    private boolean isHasRight() {
        long userId = RequestContext.get().getCurrUserId();
        int flag = PermissionServiceHelper.checkPermission((Long)userId, (Long)0L, null, (String)"pc_devportal_main", (String)"47150e89000000ac");
        return flag == 1;
    }

    static {
        dts_Function.add(OrmUtils.getDataEntityType(FunctionTypes.class));
        dts_Function.add(OrmUtils.getDataEntityType(FunctionGroup.class));
        dts_Function.add(OrmUtils.getDataEntityType(FunctionType.class));
        dts_FilterMeta.add(OrmUtils.getDataEntityType(FilterMetadata.class));
        dts_FilterMeta.add(OrmUtils.getDataEntityType(CompareCategory.class));
        dts_FilterMeta.add(OrmUtils.getDataEntityType(CompareType.class));
    }
}

