/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.nocode;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.ExprFuncCreator;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.function.UDFunctionVisitor;
import kd.bos.exception.KDException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.UDFunction;
import kd.bos.formula.excel.Visitor;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.NoCodeRuntimeService;
import kd.bos.nocode.express.NoCodeExpCtx;
import kd.bos.orm.query.QFilter;
import kd.bos.service.nocode.express.NoCodeExpressionContextAdapter;

public class NoCodeRuntimeServiceImpl
implements NoCodeRuntimeService {
    private static final Log logger = LogFactory.getLog(NoCodeRuntimeServiceImpl.class);
    private static final String SPAN_TYPE_FORMULA = "nocode_formula";
    private static final String SPAN_NAME_GETEXPRESSIONVALUE = "NoCodeRuntimeServiceImpl.getExpressionValue";
    private static final String SPAN_PARAM_EXPRESSION = "expression";
    private static final String SPAN_PARAM_CTX = "ctx";
    private static final String SPAN_PARAM_RESULT = "result";
    private FunctionManage funcLib;
    public static final String NOCODEBILL = "nocodebill";

    public boolean isNoCodeBill(String formId) {
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
        if (formConfig != null) {
            return NOCODEBILL.equalsIgnoreCase(formConfig.getModelType());
        }
        return false;
    }

    public boolean getConditionExpressionValue(NoCodeExpCtx ctx) throws KDException {
        Object expressionValue = this.getExpressionValue(ctx);
        if (expressionValue instanceof Boolean) {
            return (Boolean)expressionValue;
        }
        return false;
    }

    public Object getExpressionValue(NoCodeExpCtx ctx) throws KDException {
        String expression = this.prepareExpression(ctx);
        if (StringUtils.isBlank((CharSequence)expression)) {
            return null;
        }
        Expr expr = FormulaEngine.parseFormula((String)expression);
        Object[] vars = FormulaEngine.extractVariables((String)expression);
        Arrays.sort(vars);
        HashMap<Object, Object> engineCtx = new HashMap<Object, Object>(vars.length);
        for (int i = 0; i < vars.length; ++i) {
            Object var = vars[i];
            Object varValue = ctx.getVarValue((String)var);
            varValue = this.formatVarValue(varValue, ctx);
            engineCtx.put(var, varValue);
        }
        UDFunctionVisitor funVisitor = new UDFunctionVisitor();
        expr.accept((Visitor)funVisitor);
        HashSet funcs = new HashSet();
        funcs.addAll(funVisitor.getFuncNames());
        NoCodeExpressionContextAdapter expContext = new NoCodeExpressionContextAdapter(ctx);
        BOSUDFunction[] functions = ExprFuncCreator.createUDFunctions(funcs, (FunctionManage)this.getFuncLib(), (ExpressionContext)expContext);
        try {
            Object result = FormulaEngine.execExcelFormula((Expr)expr, engineCtx, (UDFunction[])functions);
            if (EntityTracer.isRealtime()) {
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_FORMULA, (String)SPAN_NAME_GETEXPRESSIONVALUE);){
                    span.addTag(SPAN_PARAM_EXPRESSION, expression);
                    span.addLocaleTag(SPAN_PARAM_CTX, (Object)ctx);
                    span.addLocaleTag(SPAN_PARAM_RESULT, result);
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            logger.error((Throwable)e);
            logger.error("expression:" + expression);
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_FORMULA, (String)SPAN_NAME_GETEXPRESSIONVALUE);){
                span.addLocaleTag(SPAN_PARAM_EXPRESSION, (Object)expression);
                span.addLocaleTag(SPAN_PARAM_CTX, (Object)ctx);
                span.throwException((Throwable)e);
            }
            throw e;
        }
    }

    public Object tryGetExpressionValue(NoCodeExpCtx ctx) {
        String expression = this.prepareExpression(ctx);
        if (StringUtils.isBlank((CharSequence)expression)) {
            return null;
        }
        try {
            Expr expr = FormulaEngine.parseFormula((String)expression);
            Object[] vars = FormulaEngine.extractVariables((String)expression);
            Arrays.sort(vars);
            HashMap<Object, Object> engineCtx = new HashMap<Object, Object>(vars.length);
            for (int i = 0; i < vars.length; ++i) {
                Object var = vars[i];
                Object varValue = ctx.getVarValue((String)var);
                varValue = this.formatVarValue(varValue, ctx);
                engineCtx.put(var, varValue);
            }
            UDFunctionVisitor funVisitor = new UDFunctionVisitor();
            expr.accept((Visitor)funVisitor);
            HashSet funcs = new HashSet();
            funcs.addAll(funVisitor.getFuncNames());
            NoCodeExpressionContextAdapter expContext = new NoCodeExpressionContextAdapter(ctx);
            BOSUDFunction[] functions = ExprFuncCreator.createUDFunctions(funcs, (FunctionManage)this.getFuncLib(), (ExpressionContext)expContext);
            Object result = FormulaEngine.execExcelFormula((Expr)expr, engineCtx, (UDFunction[])functions);
            if (EntityTracer.isRealtime()) {
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_FORMULA, (String)SPAN_NAME_GETEXPRESSIONVALUE);){
                    span.addTag(SPAN_PARAM_EXPRESSION, expression);
                    span.addLocaleTag(SPAN_PARAM_CTX, (Object)ctx);
                    span.addLocaleTag(SPAN_PARAM_RESULT, result);
                }
            }
            return result;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            logger.error("expression:" + expression);
            return expression;
        }
    }

    protected String prepareExpression(NoCodeExpCtx ctx) {
        return ctx.getExpression();
    }

    protected Object formatVarValue(Object varValue, NoCodeExpCtx ctx) {
        return varValue;
    }

    public String checkExpression(NoCodeExpCtx ctx) {
        try {
            this.getExpressionValue(ctx);
        }
        catch (KDException e) {
            return e.getMessage();
        }
        return null;
    }

    protected FunctionManage getFuncLib() {
        if (this.funcLib == null) {
            this.funcLib = FunctionManage.get();
        }
        return this.funcLib;
    }

    public String getNotifyExpression(NoCodeExpCtx ctx) {
        return ctx.getExpression();
    }

    public QFilter getQFilter(String entityNumber, String filterJson) {
        return null;
    }
}

