/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.dbversion.IndustryVersionService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.entity.DeployParam;

public abstract class AbsractVersion {
    private static Log log = LogFactory.getLog(AbsractVersion.class);
    protected DeployParam deployParam;
    private static final String T_BAS_INDUSTRY_VERSION = "T_BAS_INDUSTRY_VERSION";
    private static final String T_BAS_VERSIONCAPTION = "T_BAS_VERSIONCAPTION";
    private boolean isIgnoreVer = false;

    protected boolean isIgnoreVer() {
        return this.isIgnoreVer;
    }

    public AbsractVersion(DeployParam deployParam) {
        this.deployParam = deployParam;
        if (this.deployParam.isBigTablePack()) {
            this.isIgnoreVer = true;
        }
    }

    public abstract boolean checkVer();

    public abstract boolean checkRely();

    abstract void saveVer();

    abstract String getVer();

    abstract String getPackageType();

    public abstract boolean checkUndoVer();

    public abstract boolean checkUndoRely();

    protected boolean compareVer(String fullVer, String dbVer) {
        int result = this.comparePartVer(fullVer, dbVer, 3);
        return result >= 0;
    }

    protected int comparePartVer(String fullVer, String dbVer, int part) {
        if (kd.bos.util.StringUtils.isBlank((String)dbVer) && kd.bos.util.StringUtils.isBlank((String)fullVer)) {
            return 0;
        }
        if (kd.bos.util.StringUtils.isBlank((String)dbVer)) {
            return 1;
        }
        if (kd.bos.util.StringUtils.isBlank((String)fullVer)) {
            return -1;
        }
        String[] verStrs = fullVer.split("\\.");
        Integer[] intVers = new Integer[verStrs.length];
        for (int i = 0; i < verStrs.length; ++i) {
            intVers[i] = Integer.parseInt(verStrs[i]);
        }
        String[] dbVerStrs = dbVer.split("\\.");
        int length = dbVerStrs.length;
        if (verStrs.length > dbVerStrs.length) {
            length = verStrs.length;
        }
        Integer[] intDbVers = new Integer[length];
        for (int i = 0; i < verStrs.length; ++i) {
            intDbVers[i] = i >= dbVerStrs.length ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(dbVerStrs[i]));
        }
        int result = 0;
        for (int i = 0; i < length && (part == 0 || part != i); ++i) {
            if (intVers[i] > intDbVers[i]) {
                result = 1;
                break;
            }
            if (intVers[i] >= intDbVers[i]) continue;
            result = -1;
            break;
        }
        return result;
    }

    protected boolean compareRely(String relyVer, String dbVer) {
        if (kd.bos.util.StringUtils.isBlank((String)dbVer)) {
            return false;
        }
        if (kd.bos.util.StringUtils.isBlank((String)relyVer)) {
            return true;
        }
        String[] verStrs = relyVer.split("\\.");
        int[] intVers = new int[verStrs.length];
        for (int i = 0; i < verStrs.length; ++i) {
            intVers[i] = Integer.parseInt(verStrs[i]);
        }
        String[] dbVerStrs = dbVer.split("\\.");
        int length = dbVerStrs.length;
        if (verStrs.length > dbVerStrs.length) {
            length = verStrs.length;
        }
        int[] intDbVers = new int[length];
        for (int i = 0; i < verStrs.length; ++i) {
            intDbVers[i] = i >= dbVerStrs.length ? 0 : Integer.parseInt(dbVerStrs[i]);
        }
        if (intVers[0] < intDbVers[0]) {
            return true;
        }
        if (intVers[0] == intDbVers[0] && intVers[1] < intDbVers[1]) {
            return true;
        }
        return intVers[0] == intDbVers[0] && intVers[1] == intDbVers[1] && intVers[2] <= intDbVers[2];
    }

    protected void saveIndustryVer() {
        long id;
        DeployParam param = this.getDeployParam();
        String isv = StringUtils.isBlank((CharSequence)param.getIsv()) ? " " : param.getIsv();
        String productNumber = StringUtils.isBlank((CharSequence)param.getProductNumber()) ? " " : param.getProductNumber();
        Map<String, Object> verMap = this.getVerMap(isv, productNumber);
        String industryVer = verMap == null ? "" : (String)verMap.get("version");
        long l = id = verMap == null || verMap.get("id") == null ? 0L : (Long)verMap.get("id");
        if (StringUtils.isBlank((CharSequence)industryVer)) {
            String insIndustryVerSql = "insert into T_BAS_INDUSTRY_VERSION (FID, FISV, FPRODUCTNUMBER, FVERSION, FPRODUCTNAME, FUPGRADETIME, FPRODUCTTYPE) values(?, ?, ?, ?, ?, getdate(), ?);";
            Object[] insIndustryParams = new Object[6];
            id = DB.genGlobalLongId();
            insIndustryParams[0] = id;
            insIndustryParams[1] = isv;
            insIndustryParams[2] = productNumber;
            insIndustryParams[3] = param.getFullVer();
            insIndustryParams[4] = param.getProductName();
            insIndustryParams[5] = this.getPackageType();
            String delIndustryVerSql = "delete from T_BAS_INDUSTRY_VERSION where FISV = ? and FPRODUCTNUMBER = ? ;";
            Object[] delIndustryParams = new Object[]{param.getIsv(), param.getProductNumber()};
            DB.execute((DBRoute)DBRoute.meta, (String)delIndustryVerSql, (Object[])delIndustryParams);
            DB.execute((DBRoute)DBRoute.meta, (String)insIndustryVerSql, (Object[])insIndustryParams);
        } else {
            String UpdIndustryVerSql = "update T_BAS_INDUSTRY_VERSION set FVERSION = ?, FUPGRADETIME = getdate() where FPRODUCTNUMBER = ? and FISV = ?;";
            Object[] updIndustryParams = new Object[]{param.getFullVer(), productNumber, isv};
            DB.execute((DBRoute)DBRoute.meta, (String)UpdIndustryVerSql, (Object[])updIndustryParams);
        }
        this.saveVerCaption(id);
        IndustryVersionService.clearCache((String)productNumber, (String)isv);
        Map<String, String> verCaption = this.getDeployParam().getVerCaption();
        if (verCaption == null || verCaption.isEmpty()) {
            IndustryVersionService.clearCache((String)productNumber, (String)isv, (String)"");
        } else {
            for (Map.Entry<String, String> entry : verCaption.entrySet()) {
                String productName = entry.getKey();
                IndustryVersionService.clearCache((String)productNumber, (String)isv, (String)productName);
            }
        }
    }

    private void saveVerCaption(long id) {
        Map<String, String> verCaption;
        if (id == 0L) {
            id = DB.genGlobalLongId();
        }
        if ((verCaption = this.getDeployParam().getVerCaption()) == null || verCaption.isEmpty()) {
            log.info("verCaption is empty.");
            return;
        }
        for (Map.Entry<String, String> entry : verCaption.entrySet()) {
            String productName = entry.getKey();
            String caption = entry.getValue();
            Map<String, Object> verMap = this.getCaptionMap(id, productName);
            String name = verMap == null ? "" : (String)verMap.get("productName");
            log.info(String.format("verCaption productName:%s, caption:%s begin save.", name, caption));
            if (StringUtils.isNotBlank((CharSequence)name)) {
                if (StringUtils.isBlank((CharSequence)caption)) continue;
                String UpdVerCaptionSql = "update T_BAS_VERSIONCAPTION set FCAPTION = ? where FPRODUCTNAME = ? and FID = ?;";
                Object[] updCaptionParams = new Object[]{caption, productName, id};
                DB.execute((DBRoute)DBRoute.meta, (String)UpdVerCaptionSql, (Object[])updCaptionParams);
                continue;
            }
            String insVerCaptionSql = "insert into T_BAS_VERSIONCAPTION (FID, FPRODUCTNAME, FCAPTION) values(?, ?, ?);";
            Object[] insCaptionParams = new Object[]{id, productName, caption};
            String delVerCaptionSql = "delete from T_BAS_VERSIONCAPTION where FID = ? and FPRODUCTNAME = ? ;";
            Object[] delCaptionParams = new Object[]{id, productName};
            DB.execute((DBRoute)DBRoute.meta, (String)delVerCaptionSql, (Object[])delCaptionParams);
            DB.execute((DBRoute)DBRoute.meta, (String)insVerCaptionSql, (Object[])insCaptionParams);
        }
        log.info("verCaption end save.");
    }

    private Map<String, Object> getCaptionMap(long id, String productName) {
        String sql = String.format("select FID,FPRODUCTNAME,FCAPTION from %s where FPRODUCTNAME = ? and FID = ?", T_BAS_VERSIONCAPTION);
        Object[] params = new SqlParameter[]{new SqlParameter("FPRODUCTNAME", -9, (Object)productName), new SqlParameter("FID", -5, (Object)id)};
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

            public Map<String, Object> handle(ResultSet rs) throws Exception {
                HashMap<String, Object> verMap = new HashMap<String, Object>(3);
                if (rs.next()) {
                    long id = rs.getLong(1);
                    String productName = rs.getString(2);
                    String caption = rs.getString(3);
                    verMap.put("id", id);
                    verMap.put("productName", productName);
                    verMap.put("caption", caption);
                    return verMap;
                }
                return verMap;
            }
        });
    }

    private Map<String, Object> getVerMap(String isv, String productNumber) {
        String sql = String.format("select FID,FVERSION from %s where FPRODUCTNUMBER = ? and FISV = ?", T_BAS_INDUSTRY_VERSION);
        Object[] params = new SqlParameter[]{new SqlParameter("FPRODUCTNUMBER", 12, (Object)productNumber), new SqlParameter("FISV", 12, (Object)isv)};
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

            public Map<String, Object> handle(ResultSet rs) throws Exception {
                HashMap<String, Object> verMap = new HashMap<String, Object>(2);
                if (rs.next()) {
                    long id = rs.getLong(1);
                    String version = rs.getString(2);
                    verMap.put("id", id);
                    verMap.put("version", version);
                    return verMap;
                }
                return verMap;
            }
        });
    }

    public DeployParam getDeployParam() {
        return this.deployParam;
    }

    public void setDeployParam(DeployParam deployParam) {
        this.deployParam = deployParam;
    }

    static enum PackageType {
        Standard("1"),
        Industry("2"),
        Secondry("3");

        private String val;

        private PackageType(String val) {
            this.val = val;
        }

        public String getValue() {
            return this.val;
        }
    }
}

