/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade;

import java.sql.ResultSet;
import java.util.Date;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.service.upgrade.entity.DeployCategory;
import kd.bos.service.upgrade.entity.DeployInfo;
import kd.bos.service.upgrade.entity.DeployLog;

@DataEntityTypeAttribute(tableName="T_BAS_DEPLOYPACKAGE", dbRouteKey="sys.meta")
public class DeployPackageInfo {
    private long id;
    private String pkName;
    private int type;
    private Date createTime;
    private String version;
    private int result;
    private String content;
    private String isv;

    public DeployPackageInfo() {
    }

    public DeployPackageInfo(long id, String pkName, int type, String version, int result) {
        this.id = id;
        this.pkName = pkName;
        this.type = type;
        this.version = version;
        this.result = result;
        this.createTime = new Date();
    }

    public DeployPackageInfo(long id, String pkName, int type, String version, int result, String content) {
        this(id, pkName, type, version, result);
        this.content = content;
    }

    @SimplePropertyAttribute(alias="FId", isPrimaryKey=true, dbType=-5)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @SimplePropertyAttribute(alias="fpkname", dbType=12)
    public String getPkName() {
        return this.pkName;
    }

    public void setPkName(String pkName) {
        this.pkName = pkName;
    }

    @SimplePropertyAttribute(alias="ftype", dbType=1)
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @SimplePropertyAttribute(alias="fcreatetime", dbType=91)
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @SimplePropertyAttribute(alias="fversion", dbType=12)
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @SimplePropertyAttribute(alias="fresult", dbType=1)
    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    @SimplePropertyAttribute(alias="fcontent", dbType=2011)
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @SimplePropertyAttribute(alias="fisv", dbType=12)
    public String getIsv() {
        return this.isv;
    }

    public void setIsv(String isv) {
        this.isv = isv;
    }

    public static void saveDeployPackageInfo(DeployInfo info, Class<?> type) {
        IDataEntityType dataType = OrmUtils.getDataEntityType(type);
        String sql = String.format("select fid from %s where fid = ?", dataType.getAlias());
        Object[] params = new Object[]{info.getId()};
        Long id = (Long)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getLong(1);
                }
                return 0L;
            }
        });
        if (id == 0L) {
            DeployPackageInfo.saveDeployInfo(info, type);
        } else {
            String updSql = String.format("update %s set fresult = ?,  FEXECTIME = ?  where fid = ?", dataType.getAlias());
            Object[] updParams = new Object[]{Character.valueOf(info.getResult()), info.getExecTime(), info.getId()};
            DB.execute((DBRoute)DBRoute.meta, (String)updSql, (Object[])updParams);
        }
    }

    public static void saveErrorDeployInfo(long taskId, String fullVer, DeployInfo packageInfo) {
        if (packageInfo == null) {
            packageInfo = new DeployInfo();
            packageInfo.setId(taskId);
            packageInfo.setExecTime(new Date());
            packageInfo.setFileName(" ");
            packageInfo.setIsv(" ");
            packageInfo.setName(" ");
            fullVer = StringUtils.isBlank((CharSequence)fullVer) ? "0" : fullVer;
            packageInfo.setVer(fullVer);
        }
        packageInfo.setResult('0');
        DeployPackageInfo.saveDeployPackageInfo(packageInfo, packageInfo.getClass());
        DeployLog.info(taskId, fullVer, DeployCategory.Package, String.format("save deployinfo %s finish, Deployment errors!", taskId));
    }

    public static void saveDeployInfo(Object info, Class<?> type) {
        IDataEntityType scriptInfoType = OrmUtils.getDataEntityType(type);
        BusinessDataWriter.save((IDataEntityType)scriptInfoType, (Object[])new Object[]{info});
    }

    public static boolean checkCreateTable() {
        Throwable throwable;
        TXHandle h;
        boolean isNewCreated = false;
        if (!DB.exitsTable((DBRoute)DBRoute.meta, (String)"T_BAS_DEPLOYPACKAGE")) {
            DeployPackageInfo.createTable();
            isNewCreated = true;
        }
        if (!DB.exitsTable((DBRoute)DBRoute.meta, (String)"T_BAS_GRAYINFO")) {
            DeployPackageInfo.createGrayInfoTable();
            isNewCreated = true;
        }
        if (!DB.exitsTable((DBRoute)DBRoute.meta, (String)"T_BAS_GRAYAPP")) {
            DeployPackageInfo.createGrayAppTable();
            isNewCreated = true;
        }
        if (!DB.exitsTable((DBRoute)DBRoute.meta, (String)"T_META_GRAYMETA")) {
            DeployPackageInfo.createGrayMetaTable();
            isNewCreated = true;
        } else {
            h = TX.notSupported();
            throwable = null;
            try {
                String alterTablepkname = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_META_GRAYMETA' AND KSQL_COL_NAME ='FNAME')  ALTER TABLE T_META_GRAYMETA ADD (FNAME NVARCHAR(200) DEFAULT ' ' NOT NULL );";
                DB.execute((DBRoute)DBRoute.meta, (String)alterTablepkname, null);
            }
            catch (Throwable alterTablepkname) {
                throwable = alterTablepkname;
                throw alterTablepkname;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable alterTablepkname) {
                            throwable.addSuppressed(alterTablepkname);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        if (!DB.exitsTable((DBRoute)DBRoute.meta, (String)"t_bas_versioncaption")) {
            DeployPackageInfo.createVersionCaptionTable();
            isNewCreated = true;
        }
        h = TX.notSupported();
        throwable = null;
        try {
            String addFormDesignLVersion = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_META_FORMDESIGN_L' AND KSQL_COL_NAME ='FVERSION') ALTER TABLE T_META_FORMDESIGN_L ADD (FVERSION BIGINT DEFAULT 0 NOT NULL);";
            DB.execute((DBRoute)DBRoute.meta, (String)addFormDesignLVersion, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (h != null) {
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    h.close();
                }
            }
        }
        return isNewCreated;
    }

    private static void createTable() {
        try (TXHandle h = TX.notSupported();){
            String sqlCreateTable = "create table T_BAS_DEPLOYPACKAGE (FID bigint not null primary key, FPKNAME              NVARCHAR(50)          not null DEFAULT ' ', FVERSION             varchar(20)           not null DEFAULT ' ', FCONTENT           \tNCLOB          \t\t  not null, FCREATETIME          datetime              not null DEFAULT GETDATE(),FTYPE                char(1)               not null DEFAULT '3', FRESULT              char(1)               not null DEFAULT '0', FISV                 varchar(50)           not null DEFAULT ' ') ";
            DB.execute((DBRoute)DBRoute.meta, (String)sqlCreateTable, null);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{DeployPackageInfo.getErrMsg("T_BAS_DEPLOYPACKAGE")});
        }
    }

    private static void createGrayInfoTable() {
        try (TXHandle h = TX.notSupported();){
            String sqlCreateTable = "create table T_BAS_GRAYINFO (FAPPGROUP            varchar(10)          not null primary key,FVER                 varchar(20)          not null default ' ',FCREATETIME          DATETIME             not null  ,FRELEASESTATUS       varchar(2)         not null default '0',FRELEASETIME         datetime             null)";
            DB.execute((DBRoute)DBRoute.meta, (String)sqlCreateTable, null);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{DeployPackageInfo.getErrMsg("T_BAS_GRAYINFO")});
        }
    }

    private static void createGrayAppTable() {
        try (TXHandle h = TX.notSupported();){
            String sqlGrayAppTable = "create table T_BAS_GRAYAPP (FID bigint not null primary key, FAPPGROUP            varchar(10)          not null default ' ',FAPPID               varchar(36)          not null default ' ',FDBVERSION           varchar(18)          not null default ' ',FITERATION           varchar(10)          not null default ' ')";
            DB.execute((DBRoute)DBRoute.meta, (String)sqlGrayAppTable, null);
            String indexSql = "CREATE INDEX IDX_BAS_GRAYAPP_APPGROUP ON T_BAS_GRAYAPP(FAPPGROUP)";
            DB.execute((DBRoute)DBRoute.meta, (String)indexSql, null);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{DeployPackageInfo.getErrMsg("T_BAS_GRAYAPP")});
        }
    }

    private static void createGrayMetaTable() {
        try (TXHandle h = TX.notSupported();){
            String sqlGrayAppTable = "create table T_META_GRAYMETA (FID varchar(36) not null primary key, FNUMBER           varchar(36)          not null default ' ',FNAME           nvarchar(200)          not null default ' ',FMODELTYPE            varchar(50)          not null default ' ',FAPPID               varchar(36)          not null default ' ',FAPPGROUP           varchar(10)          not null default ' ')";
            DB.execute((DBRoute)DBRoute.meta, (String)sqlGrayAppTable, null);
            String indexSql = "CREATE INDEX IDX_META_GRAYMETA_APPGROUP ON T_META_GRAYMETA(FAPPGROUP)";
            DB.execute((DBRoute)DBRoute.meta, (String)indexSql, null);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{DeployPackageInfo.getErrMsg("T_META_GRAYMETA")});
        }
    }

    private static void createVersionCaptionTable() {
        try (TXHandle h = TX.notSupported();){
            String sqlCaptionTable = "create table t_bas_versioncaption (FID                  bigint               not null default 0,FPRODUCTNAME         nvarchar(100)        not null default ' ',FCAPTION             nvarchar(50)         not null default ' ',constraint PK_T_BAS_VERSIONCAPTION primary key (FID, FPRODUCTNAME))";
            DB.execute((DBRoute)DBRoute.meta, (String)sqlCaptionTable, null);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{DeployPackageInfo.getErrMsg("t_bas_versioncaption")});
        }
    }

    private static String getErrMsg(String tableName) {
        return String.format(ResManager.loadKDString((String)"\u5efa\u8868 %s \u5931\u8d25", (String)"DeployPackageInfo_0", (String)"bos-mservice-form", (Object[])new Object[0]), tableName);
    }
}

