/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade;

import com.alibaba.fastjson.JSON;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBException;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.DBVersion;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormConfig;
import kd.bos.form.upgrade.IUpgradePlugin;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mservice.form.ExceptionHandler;
import kd.bos.schedule.deploy.IScheduleDeployService;
import kd.bos.script.ScriptExecutor;
import kd.bos.script.ScriptInfo;
import kd.bos.script.util.SimpleScriptInfo;
import kd.bos.service.CloudAppMappingDictionary;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.service.upgrade.DeployService;
import kd.bos.service.upgrade.StandUpgradePlugin;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.service.upgrade.XmlFileHandler;
import kd.bos.service.upgrade.entity.DeployAppInfo;
import kd.bos.service.upgrade.entity.DeployCategory;
import kd.bos.service.upgrade.entity.DeployInfo;
import kd.bos.service.upgrade.entity.DeployLog;
import kd.bos.service.upgrade.entity.DeployResult;
import kd.bos.service.upgrade.entity.DeployScriptInfo;
import kd.bos.service.upgrade.entity.SqlScript;
import kd.bos.sqlscript.PreInsDataScriptWriter;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.FileUtils;

public class DeployServiceImpl
implements DeployService {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Log log = LogFactory.getLog(DeployServiceImpl.class);
    private static final String T_BAS_SQLVERSION = "T_BAS_SQLVERSION";
    private static final String DEPLOY_PROGRESS = "deploy_progress";
    private static final String METADATA_REBUILD = "metadata_rebuild";
    private static final String METADATA_REBUILD_STATE = "metadata_rebuild_state";
    private static final int CACHE_TIMEOUT = 3600;
    private static final String STATUS = "status";
    private static final String BOS_DEPLOY_CACHE = "bos_deploy_cache_";
    private static final String LOGID = "logid";
    private static final String TWO_PLACEHOLDER = "%s.%s";
    private static final String FAILED = "failed";
    private static final String ERROR = "error";
    private static final String SUCCESS = "success";
    private static final String ERROR_INFO = "errorInfo";
    private static final String TASKID = "taskid";
    public static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    public static final String MESSAGE = "message";
    protected static ExecutorService es = ThreadPools.newCachedExecutorService((String)"DeployServiceImpl-Thread", (int)3, (int)100);

    private DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
    }

    public Map<String, Object> excuteStatus(long taskId) {
        this.deprecatedMethodCheck();
        Object[] params = new Object[]{taskId};
        String sql = "select FRESULT from t_bas_deployinfo where FID = ?";
        String result = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                String result = "";
                if (rs.next()) {
                    result = rs.getString(1);
                }
                return result;
            }
        });
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)result)) {
            map.put(STATUS, 2);
            DistributeSessionlessCache progCache = this.getCache();
            String progress = (String)progCache.get(BOS_DEPLOY_CACHE + taskId + "_" + DEPLOY_PROGRESS);
            map.put("progress", progress);
        } else {
            int res = Integer.parseInt(result);
            if (res == 1) {
                map.put(STATUS, 1);
            } else {
                map.put(STATUS, 0);
            }
        }
        return map;
    }

    public Map<String, Object> getLogs(long taskId, final long logId) {
        this.deprecatedMethodCheck();
        Object[] params = new Object[]{taskId, logId};
        log.info(String.format("getLogs taskid %s logid %s", taskId, logId));
        String sql = "select FID, FCONTENT, FDATETIME from T_LOG_DEPLOY where FPACKAGEID = ? and FID > ?";
        Map result = (Map)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

            public Map<String, Object> handle(ResultSet rs) throws Exception {
                HashMap<String, Object> result = new HashMap<String, Object>();
                long maxid = 0L;
                StringBuilder sb = new StringBuilder();
                while (rs.next()) {
                    maxid = rs.getLong(1);
                    sb.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(rs.getTimestamp(3))).append(" ");
                    sb.append(rs.getString(2)).append(System.lineSeparator());
                }
                if (maxid == 0L) {
                    maxid = logId;
                }
                result.put(DeployServiceImpl.LOGID, maxid);
                result.put("logs", sb.toString());
                return result;
            }
        });
        log.info(String.format("getLogs taskid %s maxid %s", taskId, result.get(LOGID)));
        return result;
    }

    public String deployDM(long taskId, String ver, String dmUrl) {
        return this.deployDM(taskId, ver, dmUrl, "");
    }

    public String deployDM(long taskId, String ver, String dmUrl, String appIds) {
        return this.deployDM(taskId, ver, dmUrl, appIds, 0);
    }

    /*
     * Exception decompiling
     */
    public String deployDM(long taskId, String fullVer, String dmUrl, String appIds, int category) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkVer(String fullVersion, String dbVersion) {
        if (kd.bos.util.StringUtils.isBlank((String)dbVersion)) {
            return true;
        }
        if (kd.bos.util.StringUtils.isBlank((String)fullVersion)) {
            return false;
        }
        String[] verStrs = fullVersion.split("\\.");
        int[] intVers = new int[verStrs.length];
        for (int i = 0; i < verStrs.length; ++i) {
            intVers[i] = Integer.parseInt(verStrs[i]);
        }
        String[] dbVerStrs = dbVersion.split("\\.");
        int length = dbVerStrs.length;
        if (verStrs.length > dbVerStrs.length) {
            length = verStrs.length;
        }
        int[] intDbVers = new int[length];
        for (int i = 0; i < verStrs.length; ++i) {
            intDbVers[i] = i >= dbVerStrs.length ? 0 : Integer.parseInt(dbVerStrs[i]);
        }
        if (intVers[0] > intDbVers[0]) {
            return true;
        }
        if (intVers[0] == intDbVers[0] && intVers[1] > intDbVers[1]) {
            return true;
        }
        return intVers[0] == intDbVers[0] && intVers[1] == intDbVers[1] && intVers[2] >= intDbVers[2];
    }

    private void saveErrorDeployInfo(long taskId, String fullVer, DeployInfo packageInfo) {
        if (packageInfo == null) {
            packageInfo = new DeployInfo();
            packageInfo.setId(taskId);
            packageInfo.setExecTime(new Date());
            packageInfo.setFileName(" ");
            packageInfo.setIsv(" ");
            packageInfo.setName(" ");
            String[] verStrs = fullVer.split("\\.");
            if (verStrs.length > 3) {
                packageInfo.setPatch(verStrs[3]);
            } else {
                packageInfo.setPatch("0");
            }
            if (verStrs.length > 2) {
                packageInfo.setIteration(verStrs[2]);
            } else {
                packageInfo.setIteration("0");
            }
            String ver = String.format(TWO_PLACEHOLDER, verStrs[0], verStrs[1]);
            packageInfo.setVer(ver);
        }
        packageInfo.setResult('0');
        this.saveDeployInfo(packageInfo, packageInfo.getClass());
        DeployLog.info(taskId, fullVer, DeployCategory.Package, String.format("save deployinfo %s finish, Deployment errors!", taskId));
    }

    private void saveVerInfo(DeployInfo packageInfo) {
        String fullVer = packageInfo.getFullVer();
        String insVerSql = "insert into T_BAS_VERSION (FID, FDBVERSION, FUPGRADETIME) values(1, ?, getdate());";
        String insAppVerSql = "insert into T_BAS_APPVERSION (FID, FAPPID, FITERATION, FUPGRADETIME, FDBVERSION) values(?, ?, ?, getdate(), ?);";
        String updAppVerSql = "update T_META_BIZAPP set FVERSION = ? where FNUMBER = ?;";
        Object[] params = new Object[]{fullVer};
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)DBRoute.meta, (String)"delete from T_BAS_VERSION;", null);
            DB.execute((DBRoute)DBRoute.meta, (String)insVerSql, (Object[])params);
            for (String appId : packageInfo.getApp().keySet()) {
                Object[] appIds = new Object[]{appId};
                DB.execute((DBRoute)DBRoute.meta, (String)"delete from T_BAS_APPVERSION where FAPPID = ? ;", (Object[])appIds);
                Object[] insAppParams = new Object[]{DB.genGlobalLongId(), appId, packageInfo.getIteration(), fullVer};
                DB.execute((DBRoute)DBRoute.meta, (String)insAppVerSql, (Object[])insAppParams);
                Object[] updBizAppParams = new Object[]{appId, fullVer};
                DB.execute((DBRoute)DBRoute.meta, (String)updAppVerSql, (Object[])updBizAppParams);
            }
        }
        catch (Exception e) {
            String msg = String.format("update ver error ! error stack: %s ", ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            DeployLog.error(packageInfo.getId(), fullVer, DeployCategory.Package, msg, e);
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{"update ver error ! error message:" + e.getMessage()});
        }
    }

    private void cacheProgress(long taskId, BigDecimal progress) {
        this.getCache().put(BOS_DEPLOY_CACHE + taskId + "_" + DEPLOY_PROGRESS, (Object)String.valueOf(progress.multiply(new BigDecimal(100)).intValue()), 3600);
    }

    private void deployByAppId(DeployAppInfo appInfo, DeployResult result, int category) throws IOException {
        String fullVer = String.format(TWO_PLACEHOLDER, appInfo.getVer(), appInfo.getDeployInfo().getIteration());
        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Package, String.format("begin deploy app %s  ...", appInfo.getName()));
        if (category == 0 || category == 2) {
            this.deployScript(appInfo, result);
        }
        if ((category | 4) == 4) {
            this.doDeployXml(appInfo, result);
        }
        if (category == 0 || category == 1) {
            this.deployDym(appInfo, result);
        }
        appInfo.setProgVal(new BigDecimal(1));
        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Package, String.format("end deploy app %s.", appInfo.getName()));
        this.saveDeployInfo(appInfo, appInfo.getClass());
        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Package, "save deploy app info finish!");
    }

    private void checkTable(long taskId, String fullVer) {
        DeployLog.info(taskId, fullVer, DeployCategory.Package, "check table");
        if (this.checkCreateTables()) {
            DeployLog.info(taskId, fullVer, DeployCategory.Package, "create table finish");
            DeployInfo.upgradeData10();
            DeployLog.info(taskId, fullVer, DeployCategory.Package, "upgrade history table finish");
        } else if (DeployScriptInfo.checkTableCount()) {
            DeployLog.info(taskId, fullVer, DeployCategory.Package, "T_BAS_DEPLOYINFODETAIL has no history");
            DeployInfo.upgradeData10();
            DeployLog.info(taskId, fullVer, DeployCategory.Package, "upgrade history table finish");
        }
    }

    private boolean checkCreateTables() {
        boolean isDeploy = DeployInfo.checkCreateTable();
        boolean isDeployApp = DeployAppInfo.checkCreateTable();
        boolean isDeployScript = DeployScriptInfo.checkCreateTable();
        return isDeploy || isDeployApp || isDeployScript;
    }

    private void deployScript(DeployAppInfo appInfo, DeployResult result) throws IOException {
        String fullVer = String.format(TWO_PLACEHOLDER, appInfo.getVer(), appInfo.getDeployInfo().getIteration());
        List<DeployScriptInfo> scriptInfoList = appInfo.getScriptInfoList();
        String scriptmsg = String.format(ResManager.loadKDString((String)"\u5373\u5c06\u6267\u884c\u811a\u672c%1$s\u811a\u672c\uff0c\u5171%2$s\u4e2a\u6587\u4ef6 ... ", (String)"DeployServiceImpl_5", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), appInfo.getName(), scriptInfoList.size());
        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, scriptmsg);
        List<String> existSqlFile = DeployScriptInfo.existScript(appInfo);
        for (DeployScriptInfo scriptInfo : scriptInfoList) {
            DBRoute dbRoute;
            DBType dbType;
            SqlScript sqlScript = scriptInfo.getSqlScript();
            if (existSqlFile.contains(sqlScript.getName())) {
                String msg = String.format(ResManager.loadKDString((String)"\u811a\u672c%s\u5df2\u6267\u884c\uff0c\u4e0d\u518d\u91cd\u590d\u6267\u884c\uff01", (String)"DeployServiceImpl_6", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), sqlScript.getName());
                result.addInfo(msg);
                DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, msg);
                continue;
            }
            boolean success = true;
            IUpgradePlugin plugin = sqlScript.getPlugin();
            if (plugin != null) {
                DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format("deploy puglin: %s beforeExecuteSql begin...", plugin.getClassQualifiedName()));
                UpgradeResult upGradeResult = plugin.beforeExecuteSql(appInfo.getVer(), appInfo.getDeployInfo().getIteration(), sqlScript.getDbKey(), sqlScript.getName());
                DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, upGradeResult.getLog());
                if (!upGradeResult.isSuccess()) {
                    success = false;
                    appInfo.getDeployInfo().setResult('0');
                    String msg = String.format(ResManager.loadKDString((String)"%1$s\u63d2\u4ef6\u6267\u884c\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"DeployServiceImpl_7", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), "beforeExecuteSql", upGradeResult.getErrorInfo());
                    result.addError(msg);
                    DeployLog.error(appInfo.getPkgId(), fullVer, DeployCategory.Script, msg, new KDException(BosErrorCode.bOS, new Object[]{msg}));
                    if (ERROR.equals(upGradeResult.getEl())) {
                        throw new KDException(BosErrorCode.bOS, new Object[]{msg});
                    }
                }
                DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"deploy puglin: %s beforeExecuteSql \u5b8c\u6210.", (String)"DeployServiceImpl_8", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), plugin.getClassQualifiedName()));
            }
            if (!"KSQL".equalsIgnoreCase(sqlScript.getSqlType()) && !"all".equalsIgnoreCase(sqlScript.getDbKey()) && !(dbType = DB.getDBType((DBRoute)(dbRoute = new DBRoute(sqlScript.getDbKey())))).toString().equalsIgnoreCase(sqlScript.getSqlType())) continue;
            List<String> sqlList = this.readSqlFile(appInfo.getPkgId(), fullVer, sqlScript, result);
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format("begin deploy script: %s -- DBKey:%s  -- sqlcount:%s  .", sqlScript.getName(), sqlScript.getDbKey(), sqlList.size()));
            scriptInfo.setExecTime(new Date());
            boolean isAll = false;
            Map<Object, Object> dbRoutes = new HashMap<String, DBRoute>();
            if ("all".equalsIgnoreCase(sqlScript.getDbKey())) {
                dbRoutes = appInfo.getDeployInfo().getAllDBRoutes();
                isAll = true;
            } else {
                dbRoutes.put(sqlScript.getDbKey(), new DBRoute(sqlScript.getDbKey()));
            }
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"deploy script: %1$s  \u5373\u5c06\u5728%2$s\u4e2a\u5e93\u6267\u884c .", (String)"DeployServiceImpl_9", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), sqlScript.getName(), dbRoutes.size()));
            for (String sql : sqlList) {
                Object declare;
                if (!"KSQL".equals(sqlScript.getSqlType())) {
                    sql = sql.trim();
                    if ("oracle".equalsIgnoreCase(sqlScript.getSqlType()) && sql.endsWith(";") && !((String)(declare = sql.substring(0, 8))).equalsIgnoreCase("DECLARE ") && sqlScript.getSeparator().equals(";")) {
                        sql = sql.substring(0, sql.length() - 1);
                    }
                    sql = "/*dialect*/" + sql;
                }
                try {
                    declare = dbRoutes.values().iterator();
                    while (declare.hasNext()) {
                        long end;
                        long cost;
                        DBRoute dbRoute2 = (DBRoute)declare.next();
                        DBType dbType2 = null;
                        try {
                            dbType2 = DB.getDBType((DBRoute)dbRoute2);
                        }
                        catch (Exception e) {
                            String stackMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                            DeployLog.error(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u83b7\u53d6DBType\u51fa\u9519\uff0cDBRouteKey: %1$s , script: %2$s, \u9519\u8bef\u4fe1\u606f\uff1a%3$s ----\uff0c%4$s\u5806\u6808\uff1a%5$s", (String)"DeployServiceImpl_10", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), dbRoute2.getRouteKey(), sqlScript.getName(), e.getMessage(), System.lineSeparator(), stackMsg), e);
                        }
                        if (dbType2 == null || !"KSQL".equalsIgnoreCase(sqlScript.getSqlType()) && !dbType2.toString().equalsIgnoreCase(sqlScript.getSqlType())) continue;
                        long start = new Date().getTime();
                        try (TXHandle h = TX.required();){
                            DB.execute((DBRoute)dbRoute2, (String)sql, null);
                        }
                        if (isAll) {
                            if (sql.length() > 30) {
                                DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format("execute finish! -- dbKey:%s,dbType:%s,sql:%s ... ", dbRoute2.getRouteKey(), dbType2.toString(), sql.substring(0, 29)));
                            } else {
                                DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format("execute finish! -- dbKey:%s,dbType:%s,sql:%s ... ", dbRoute2.getRouteKey(), dbType2.toString(), sql));
                            }
                        }
                        if ((cost = (end = new Date().getTime()) - start) <= 1000L) continue;
                        DeployLog.warn(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u8d85\u957f\u6267\u884csql\uff0c\u8017\u65f6%1$s \u811a\u672c%2$s sql %3$s", (String)"DeployServiceImpl_11", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), cost, sqlScript.getName(), sql));
                    }
                }
                catch (Exception e) {
                    success = false;
                    appInfo.getDeployInfo().setResult('0');
                    String stackMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                    result.addError(String.format(ResManager.loadKDString((String)"sql\u6267\u884c\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%1$s ---- \u9519\u8befsql:%2$s\uff0c%s\u5806\u6808\uff1a%3$s", (String)"DeployServiceImpl_12", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), e.getMessage(), sql, System.lineSeparator(), stackMsg));
                    DeployLog.error(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"sql\u6267\u884c\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%1$s ---- \u9519\u8befsql:%2$s\uff0c%s\u5806\u6808\uff1a%3$s", (String)"DeployServiceImpl_12", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), e.getMessage(), sql, System.lineSeparator(), stackMsg), e);
                    if (!ERROR.equals(sqlScript.getErrorLevel())) continue;
                    throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"sql\u6267\u884c\u9519\u8bef\uff0c\u90e8\u7f72\u7ec8\u6b62\uff01", (String)"DeployServiceImpl_13", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])});
                }
            }
            if (plugin != null) {
                DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format("deploy puglin: %s afterExecuteSql begin...", plugin.getClassQualifiedName()));
                UpgradeResult upGradeResult = plugin.afterExecuteSql(appInfo.getVer(), appInfo.getDeployInfo().getIteration(), sqlScript.getDbKey(), sqlScript.getName());
                DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, upGradeResult.getLog());
                if (!upGradeResult.isSuccess()) {
                    success = false;
                    appInfo.getDeployInfo().setResult('0');
                    String msg = String.format(ResManager.loadKDString((String)"%1$s\u63d2\u4ef6\u6267\u884c\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"DeployServiceImpl_7", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), "afterExecuteSql", upGradeResult.getErrorInfo());
                    result.addError(msg);
                    DeployLog.error(appInfo.getPkgId(), fullVer, DeployCategory.Script, msg, new KDException(BosErrorCode.bOS, new Object[]{msg}));
                    if (ERROR.equals(upGradeResult.getEl())) {
                        throw new KDException(BosErrorCode.bOS, new Object[]{msg});
                    }
                }
                DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"deploy puglin: %s afterExecuteSql \u63d2\u4ef6\u6267\u884c\u5b8c\u6210.", (String)"DeployServiceImpl_14", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), plugin.getClassQualifiedName()));
            }
            scriptInfo.finish();
            this.cacheProgress(appInfo.getPkgId(), appInfo.getDeployInfo().getProgVal());
            if (!success) continue;
            this.saveDeployInfo(scriptInfo, scriptInfo.getClass());
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, "save deploy script info finish!");
        }
    }

    private void deployDym(DeployAppInfo appInfo, DeployResult result) {
        List<String> metaFileList = appInfo.getMetaFileList();
        String fullVer = appInfo.getDeployInfo().getFullVer();
        int i = 0;
        for (String dymPath : metaFileList) {
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Dym, String.format("dym path : %s begin ... ", dymPath));
            File path = new File(dymPath);
            if (path.isDirectory()) {
                String[] files;
                for (String fileName : files = path.list()) {
                    String msg;
                    String fullPath = dymPath + File.separatorChar + fileName;
                    try {
                        String content = this.readerDym(fullPath);
                        if (fileName.endsWith(".ks")) {
                            MetadataDao.deployScript((String)content);
                        } else if (fileName.endsWith(".card")) {
                            MetadataDao.deployCard((String)content);
                        } else if (fileName.endsWith(".sch")) {
                            MetadataDao.deploySchema((String)content);
                        } else if (fileName.endsWith(".cld") || fileName.endsWith(".cldx")) {
                            MetadataDao.deployCloud((String)content);
                        } else if (fileName.endsWith(".app") || fileName.endsWith(".appx")) {
                            MetadataDao.deployAppMetadata((String)content);
                        } else if (fileName.endsWith(".schdata")) {
                            IScheduleDeployService service = (IScheduleDeployService)ServiceFactory.getService((String)"IScheduleDeployService");
                            HashMap<String, String> params = new HashMap<String, String>(4);
                            params.put("path", appInfo.getName());
                            params.put("filename", fileName);
                            params.put("deployMode", "upgrade");
                            service.deployXml(params, content);
                        } else {
                            MetadataDao.deployMetadata((String)content);
                        }
                        msg = String.format("dym file : %s finish! ", fileName);
                        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Dym, msg);
                        result.addInfo(msg);
                    }
                    catch (Throwable e) {
                        appInfo.getDeployInfo().setResult('0');
                        msg = DeployLog.getExceptionStackTraceMessage(e);
                        DeployLog.error(appInfo.getPkgId(), fullVer, DeployCategory.Dym, msg, e);
                        result.addError(msg);
                    }
                }
            }
            appInfo.setMetaProgVal(new BigDecimal(++i).divide(new BigDecimal(metaFileList.size()), 10, RoundingMode.HALF_EVEN));
            this.cacheProgress(appInfo.getPkgId(), appInfo.getDeployInfo().getProgVal());
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Dym, String.format("dym path : %s finish! ", dymPath));
        }
    }

    private void doDeployXml(DeployAppInfo appInfo, DeployResult result) {
        List<String> xmlFileList = appInfo.getXmlFileList();
        String fullVer = appInfo.getDeployInfo().getFullVer();
        int i = 0;
        List<String> existSqlFile = DeployScriptInfo.existScript(appInfo);
        boolean success = true;
        ArrayList<String> xmlFileNames = new ArrayList<String>();
        for (String xmlDataPath : xmlFileList) {
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Xml, String.format("xml path : %s begin ... ", xmlDataPath));
            File path = new File(xmlDataPath);
            if (path.isDirectory()) {
                String[] files;
                for (String fileName : files = path.list()) {
                    if (existSqlFile.contains(fileName)) {
                        String msg = String.format(ResManager.loadKDString((String)"xml\uff1a%s\u5df2\u6267\u884c\uff0c\u4e0d\u518d\u91cd\u590d\u6267\u884c\uff01", (String)"DeployServiceImpl_36", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), fileName);
                        result.addInfo(msg);
                        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, msg);
                        continue;
                    }
                    String fullPath = xmlDataPath + File.separatorChar + fileName;
                    try (FileInputStream inputStream = new FileInputStream(fullPath);){
                        PreInsDataScriptWriter wr = new PreInsDataScriptWriter();
                        wr.insertPreInsData((InputStream)inputStream);
                        String msg = String.format("xml file : %s finish! ", fileName);
                        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Xml, msg);
                        result.addInfo(msg);
                        xmlFileNames.add(fileName);
                    }
                    catch (Exception e) {
                        success = false;
                        appInfo.getDeployInfo().setResult('0');
                        String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                        DeployLog.error(appInfo.getPkgId(), fullVer, DeployCategory.Xml, msg, e);
                        result.addError(msg);
                    }
                }
            }
            appInfo.setXmlProgVal(new BigDecimal(++i).divide(new BigDecimal(xmlFileList.size()), 10, RoundingMode.HALF_EVEN));
            this.cacheProgress(appInfo.getPkgId(), appInfo.getDeployInfo().getProgVal());
            if (success) {
                for (String filename : xmlFileNames) {
                    DeployScriptInfo scriptInfo = new DeployScriptInfo();
                    scriptInfo.setId(DB.genGlobalLongId());
                    scriptInfo.setAppId(appInfo.getName());
                    scriptInfo.setEntryId(appInfo.getId());
                    scriptInfo.setVer(appInfo.getVer());
                    scriptInfo.setFileName(filename);
                    scriptInfo.setExecTime(new Date());
                    this.saveDeployInfo(scriptInfo, scriptInfo.getClass());
                }
                DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Xml, String.format("xml path : %s finish,run-time error!!! ", xmlDataPath));
                continue;
            }
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Xml, String.format("xml path : %s finish! ", xmlDataPath));
        }
    }

    private DeployInfo readDeployInfo(long taskId, String fullVer, String isv, File tempFile) throws Exception {
        Path unZipFilePath = Paths.get(tempFile.getPath(), "datamodel");
        XmlFileHandler xmlDMHandler = new XmlFileHandler(taskId, fullVer);
        xmlDMHandler.setIsv(isv);
        DeployLog.info(taskId, fullVer, DeployCategory.Package, String.format("begin - read xml : %s", unZipFilePath.toString()));
        xmlDMHandler.readXml(unZipFilePath.toString());
        return xmlDMHandler.getDeployInfo();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean downloadStreamFile(long taskId, String fullVer, String dmUrl, DeployResult result, File tempFile) {
        boolean success = true;
        InputStream ins = null;
        try {
            DeployLog.info(taskId, fullVer, DeployCategory.Package, String.format("begin - download zip package, url : %s", dmUrl));
            ins = new URL(dmUrl).openStream();
            Path target = tempFile.toPath();
            this.unZipFile(taskId, fullVer, ins, target.toString());
            DeployLog.info(taskId, fullVer, DeployCategory.Package, "end - download zip package");
            if (ins == null) return success;
        }
        catch (Exception e) {
            try {
                String msg = String.format("deploy downloadStreamFile faild  -- error:%s -- Stack:%s ", e.getMessage(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{msg, e});
            }
            catch (Throwable throwable) {
                if (ins == null) throw throwable;
                try {
                    ins.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    success = false;
                    String msg = String.format("deploy downloadStreamFile close faild  -- error:%s -- Stack:%s ", e2.getMessage(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e2));
                    log.error(msg, (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            ins.close();
            return success;
        }
        catch (IOException e) {
            success = false;
            String msg = String.format("deploy downloadStreamFile close faild  -- error:%s -- Stack:%s ", e.getMessage(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            log.error(msg, (Throwable)e);
            return success;
        }
    }

    private void saveDeployInfo(Object info, Class<?> type) {
        IDataEntityType scriptInfoType = OrmUtils.getDataEntityType(type);
        BusinessDataWriter.save((IDataEntityType)scriptInfoType, (Object[])new Object[]{info});
    }

    private void unZipFile(long taskId, String fullVer, InputStream ins, String zipPath) throws IOException {
        DeployLog.info(taskId, fullVer, DeployCategory.Package, String.format("begin unZipFile to Path : %s", zipPath));
        try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(ins));){
            ZipEntry entry = null;
            while ((entry = in.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    String name = entry.getName();
                    name = name.substring(0, name.length() - 1);
                    File entryFile = new File(zipPath + File.separatorChar + name);
                    entryFile.mkdirs();
                    continue;
                }
                String filePath = FileUtils.cleanString((String)(zipPath + File.separatorChar + entry.getName()));
                File child = new File(filePath);
                if (!child.getParentFile().exists()) {
                    child.getParentFile().mkdirs();
                }
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(child));
                Throwable throwable = null;
                try {
                    int n = 0;
                    byte[] buf = new byte[1024];
                    while ((n = in.read(buf)) != -1) {
                        out.write(buf, 0, n);
                    }
                    in.closeEntry();
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
            in.close();
        }
        DeployLog.info(taskId, fullVer, DeployCategory.Package, "unZipFile end");
    }

    private static File createTempDir() {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    private void deleteFile(File tempFile) {
        if (tempFile.exists()) {
            if (tempFile.isFile()) {
                tempFile.delete();
            } else if (tempFile.isDirectory()) {
                File[] files = tempFile.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.deleteFile(files[i]);
                }
                tempFile.delete();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private List<String> readSqlFile(long pkgId, String fullVer, SqlScript sqlScript, DeployResult result) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> readerSqlStatement(BufferedReader bufferReader, String separator) throws IOException {
        ArrayList<String> sqlList = new ArrayList<String>();
        String line = null;
        boolean isFirstLine = true;
        StringBuilder stringbuffer = new StringBuilder();
        boolean hasCommentLine = false;
        while ((line = bufferReader.readLine()) != null) {
            if (line.length() <= 0) continue;
            if (isFirstLine && line.charAt(0) == '\ufeff') {
                line = line.substring(1);
                isFirstLine = false;
            }
            String tempStr = line.trim();
            if (hasCommentLine) {
                if (!tempStr.endsWith("*/")) continue;
                hasCommentLine = false;
                continue;
            }
            if (tempStr.startsWith("/*")) {
                if (tempStr.endsWith("*/")) continue;
                hasCommentLine = true;
                continue;
            }
            if (tempStr.startsWith("--")) continue;
            if (!(tempStr.endsWith(separator) && separator.equals("GO") || StringUtils.isEmpty((CharSequence)tempStr))) {
                stringbuffer.append(" ").append(line).append(" ");
            }
            if (!tempStr.endsWith(separator)) continue;
            sqlList.add(stringbuffer.toString());
            stringbuffer = new StringBuilder();
        }
        return sqlList;
    }

    /*
     * Exception decompiling
     */
    private String readerDym(String name) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void rebuildApps(long taskid, String ver, String apps) {
        HashMap<String, Serializable> appsMap = new HashMap<String, Serializable>();
        boolean success = true;
        DistributeSessionlessCache cache = this.getCache();
        try {
            cache.put(BOS_DEPLOY_CACHE + taskid + "_" + METADATA_REBUILD_STATE, (Object)"2", 3600);
            DeployLog.info(taskid, ver, DeployCategory.Package, String.format("begin rebuild taskId %s apps %s", taskid, apps));
            List<String> rebuidAppParams = Arrays.asList(apps.split(","));
            MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
            Map result = metadataService.rebuildByApps(true, rebuidAppParams);
            ArrayList appInfoList = new ArrayList(10);
            for (Map.Entry entry : result.entrySet()) {
                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                Map appResult = (Map)entry.getValue();
                if (appResult.get(FAILED) != null && ((List)appResult.get(FAILED)).size() > 0) {
                    success = false;
                    map.put(SUCCESS, false);
                    map.put("successInfo", (Boolean)appResult.get(SUCCESS));
                    map.put(ERROR_INFO, (Boolean)appResult.get(FAILED));
                } else {
                    map.put(SUCCESS, true);
                    map.put("successInfo", (Boolean)appResult.get(SUCCESS));
                }
                map.put("appId", (Boolean)entry.getKey());
                map.put("count", (Boolean)appResult.get("count"));
                appInfoList.add(map);
            }
            if (result.isEmpty()) {
                success = false;
            }
            appsMap.put(SUCCESS, Boolean.valueOf(success));
            appsMap.put("rebuildInfo", appInfoList);
            String resString = JSON.toJSONString(appsMap, (boolean)true);
            cache.put(BOS_DEPLOY_CACHE + taskid + "_" + METADATA_REBUILD, (Object)resString, 3600);
            cache.put(BOS_DEPLOY_CACHE + taskid + "_" + METADATA_REBUILD_STATE, (Object)"1", 3600);
            DeployLog.info(taskid, ver, DeployCategory.Package, String.format("end rebuild taskId %s apps %s", taskid, apps));
            DeployLog.info(taskid, ver, DeployCategory.Package, resString);
        }
        catch (Exception e) {
            cache.put(BOS_DEPLOY_CACHE + taskid + "_" + METADATA_REBUILD_STATE, (Object)"0", 3600);
            DeployLog.error(taskid, ver, DeployCategory.Package, String.format(ResManager.loadKDString((String)"\u91cd\u5efa\u5143\u6570\u636e\u5931\u8d25\uff01taskId %1$s ERR:%2$s", (String)"DeployServiceImpl_16", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), taskid, e.getMessage()), e);
        }
    }

    public Map<String, Object> getRebuildResult(long taskid) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int state = 2;
        String rebuildRet = "";
        try {
            if (StringUtils.isBlank((Object)taskid)) {
                state = 0;
                log.warn(String.format("\u83b7\u53d6\u91cd\u5efa\u5143\u6570\u636e\u7ed3\u679c\u7684taskId\u4e3a\u7a7a taskId %s ", taskid));
            } else {
                DistributeSessionlessCache cache = this.getCache();
                String stateStr = (String)cache.get(BOS_DEPLOY_CACHE + taskid + "_" + METADATA_REBUILD_STATE);
                state = StringUtils.isBlank((CharSequence)stateStr) ? state : Integer.parseInt(stateStr);
                rebuildRet = (String)cache.get(BOS_DEPLOY_CACHE + taskid + "_" + METADATA_REBUILD);
            }
        }
        catch (Exception e) {
            state = 0;
            rebuildRet = String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u91cd\u5efa\u5143\u6570\u636e\u7ed3\u679c\u5931\u8d25!taskId %1$s ERR:%2$s", (String)"DeployServiceImpl_17", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), taskid, e.getMessage());
            log.error(rebuildRet, (Throwable)e);
        }
        result.put("state", state);
        result.put("result", rebuildRet);
        return result;
    }

    public Map<String, Object> deployMC(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<Object, Object> mapRetInfo = new HashMap<String, Number>();
        boolean success = true;
        Object type = params.get("type");
        log.info("\u63a5\u6536\u5230\u8bf7\u6c42\uff0cparams:" + SerializationUtils.toJsonString(params));
        if (type != null) {
            Map param = (Map)params.get("params");
            if (param == null) {
                result.put(SUCCESS, false);
                result.put(MESSAGE, ResManager.loadKDString((String)"\u8bf7\u6c42\u683c\u5f0f\u975e\u6cd5\uff0c\u672a\u627e\u5230params", (String)"DeployServiceImpl_18", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
                return result;
            }
            String action = (String)type;
            if (action.equalsIgnoreCase("u")) {
                String dmUrl = (String)param.get("dmurl");
                String ver = (String)param.get("ver");
                long id = DB.genGlobalLongId();
                mapRetInfo.put(TASKID, id);
                mapRetInfo.put("progress", 0);
                DeployLog.info(id, ver, DeployCategory.Package, String.format("taskId:%s begin deployRunnable! dmUrl:%s", id, dmUrl));
                log.debug(String.format("taskId:%s begin deployRunnable! dmUrl:%s", id, dmUrl));
                es.execute(new DeployRunnable(RequestContext.get(), id, ver, dmUrl));
                log.debug(String.format("taskId:%s end deployRunnable! dmUrl:%s", id, dmUrl));
            } else if (action.equalsIgnoreCase("l")) {
                Object taskid = param.get(TASKID);
                Object logid = param.get(LOGID);
                if (taskid != null && logid != null) {
                    mapRetInfo = this.getLogs(Long.parseLong((String)taskid), Long.parseLong((String)logid));
                }
            } else if (action.equalsIgnoreCase("p")) {
                Object taskid = param.get(TASKID);
                Object logid = param.get(LOGID);
                if (taskid != null && logid != null) {
                    long task = Long.parseLong((String)taskid);
                    long l = Long.parseLong((String)logid);
                    mapRetInfo = this.excuteStatus(task);
                }
            } else if (action.equalsIgnoreCase("s")) {
                Object taskid = param.get(TASKID);
                Object logid = param.get(LOGID);
                if (taskid != null && logid != null) {
                    long task = Long.parseLong((String)taskid);
                    long l = Long.parseLong((String)logid);
                    mapRetInfo = this.getLogs(task, l);
                    mapRetInfo.putAll(this.excuteStatus(task));
                }
            } else if ("upgrade".equals(action)) {
                DistributeSessionlessCache cache = this.getCache();
                String upgradeState = (String)cache.get("bos_deploy_cache_upgradedeployinfo");
                if (upgradeState == null || "0".equals(upgradeState)) {
                    cache.put("bos_deploy_cache_upgradedeployinfo", (Object)"1", 3600);
                    log.info("begin upgradeData");
                    DeployInfo.upgradeData10();
                    log.info("end upgradeData");
                    mapRetInfo.put("msg", ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u5df2\u5b8c\u6210,\u8bf7\u52ff\u91cd\u590d\u5237\u65b0\u9875\u9762\u3002", (String)"DeployServiceImpl_19", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
                } else {
                    log.info("data center upgradeData already.");
                    mapRetInfo.put("msg", ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u5237\u65b0\u9875\u9762\u3002", (String)"DeployServiceImpl_20", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
                }
            } else {
                success = false;
                result.put(MESSAGE, String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u63d0\u4f9b\u6307\u4ee4\uff1a%s", (String)"DeployServiceImpl_21", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), action));
                log.warn("\u6682\u4e0d\u63d0\u4f9b\u6307\u4ee4\uff1a" + action);
            }
            if (success) {
                result.put("data", mapRetInfo);
            }
        } else {
            success = false;
            result.put(MESSAGE, ResManager.loadKDString((String)"\u8bf7\u6c42\u683c\u5f0f\u975e\u6cd5\uff0c\u672a\u627e\u5230type", (String)"DeployServiceImpl_22", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
        }
        result.put(SUCCESS, success);
        return result;
    }

    public Map<String, Object> rebuildDym(Map<String, Object> paramsMap) {
        HashMap<String, Object> dymResult = new HashMap<String, Object>();
        Map<Object, Object> mapRetInfo = new HashMap<String, Object>();
        boolean success = true;
        Object type = paramsMap.get("type");
        log.info("\u63a5\u53d7\u5230\u8bf7\u6c42\uff0cparams:" + SerializationUtils.toJsonString(paramsMap));
        if (type != null) {
            Map param = (Map)paramsMap.get("params");
            if (param == null) {
                dymResult.put(SUCCESS, false);
                dymResult.put(MESSAGE, ResManager.loadKDString((String)"\u8bf7\u6c42\u683c\u5f0f\u975e\u6cd5\uff0c\u672a\u627e\u5230params", (String)"DeployServiceImpl_18", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
                return dymResult;
            }
            String action = (String)type;
            if ("rebuildApp".equalsIgnoreCase(action)) {
                if (StringUtils.isBlank(param.get("apps"))) {
                    success = false;
                    dymResult.put(MESSAGE, ResManager.loadKDString((String)"apps\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"DeployServiceImpl_23", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
                } else {
                    mapRetInfo.putAll(this.rebuildAction(param));
                }
            } else if ("getRebuildResult".equalsIgnoreCase(action)) {
                Object taskid = param.get(TASKID);
                Object logid = param.get(LOGID);
                if (taskid != null && logid != null) {
                    long task = Long.parseLong((String)taskid);
                    long l = Long.parseLong((String)logid);
                    mapRetInfo = this.getLogs(task, l);
                    mapRetInfo.putAll(this.getRebuildResult(task));
                } else {
                    success = false;
                    dymResult.put(MESSAGE, ResManager.loadKDString((String)"taskid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"DeployServiceImpl_24", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
                }
            } else {
                success = false;
                dymResult.put(MESSAGE, String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u63d0\u4f9b\u6307\u4ee4\uff1a%s", (String)"DeployServiceImpl_21", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), action));
                log.warn("\u6682\u4e0d\u63d0\u4f9b\u6307\u4ee4\uff1a" + action);
            }
            if (success) {
                dymResult.put("data", mapRetInfo);
            }
        } else {
            success = false;
            dymResult.put(MESSAGE, ResManager.loadKDString((String)"\u8bf7\u6c42\u683c\u5f0f\u975e\u6cd5\uff0c\u672a\u627e\u5230type", (String)"DeployServiceImpl_22", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
        }
        dymResult.put(SUCCESS, success);
        return dymResult;
    }

    public Map<String, Object> rebuildAction(Map<String, Object> param) {
        HashMap<String, Object> mapRetInfo = new HashMap<String, Object>();
        String ver = (String)param.get("ver");
        String apps = (String)param.get("apps");
        long id = DB.genGlobalLongId();
        mapRetInfo.put(TASKID, id);
        DeployLog.info(id, ver, DeployCategory.Package, String.format("taskId:%s begin rebuildRunnable!", id));
        es.execute(new RebuildRunnable(RequestContext.get(), id, ver, apps));
        log.debug(String.format("taskId:%s end rebuildRunnable!", id));
        return mapRetInfo;
    }

    @Deprecated
    public Map<String, Object> deploySql(Map<String, Object> params, List<String> sqlList) {
        Serializable sqlResult;
        DBRoute dbRoute;
        DBType dbType;
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean success = true;
        String type = (String)params.get("type");
        String dbKey = (String)params.get("dbkey");
        String ksqlName = (String)params.get("ksqlname");
        String version = (String)params.get("version");
        String appName = (String)params.get("appname");
        String pkname = (String)params.get("pkname");
        String pluginElement = (String)params.get("plugin");
        Object el = params.get("el");
        OperationContext oc = OperationContext.get();
        if (oc == null) {
            oc = new OperationContext();
        }
        oc.setAppId("bos");
        oc.setFormId("deploy");
        oc.setOpMethod("deploySql");
        if (!("KSQL".equals(type) || "all".equalsIgnoreCase(dbKey) || (dbType = DB.getDBType((DBRoute)(dbRoute = new DBRoute(dbKey)))).toString().equalsIgnoreCase(type))) {
            map.put(SUCCESS, success);
            return map;
        }
        boolean syncSQLVerTable = this.checkSqlVersionTable();
        Boolean isexistBOSTable = DB.exitsTable((DBRoute)DBRoute.basedata, (String)"T_BOS_SQLVERSION");
        if (syncSQLVerTable && isexistBOSTable.booleanValue()) {
            String insSQL = "insert into T_BAS_SQLVERSION  select FID, FVER, FFILENAME, EXECTIME, FAPPID, PKNAME from t_bos_sqlversion;";
            try (TXHandle h = TX.required();){
                DB.execute((DBRoute)DBRoute.meta, (String)insSQL, null);
            }
            catch (Exception e) {
                String msg = ResManager.loadKDString((String)"T_BAS_SQLVERSION \u6570\u636e\u540c\u6b65\u5931\u8d25", (String)"DeployServiceImpl_26", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]);
                log.error(msg, (Throwable)e);
            }
        }
        String ksqlisexist = "select 1 from T_BAS_SQLVERSION where fver=? and ffilename = ? and fappid = ?";
        Object[] dbParams = new Object[]{version, ksqlName, appName};
        try (DataSet dataset = DB.queryDataSet((String)"deployServiceImpl", (DBRoute)DBRoute.meta, (String)ksqlisexist, (Object[])dbParams);){
            Iterator its = dataset.iterator();
            if (its.hasNext()) {
                map.put(SUCCESS, success);
                StringBuilder checkinfoSB = new StringBuilder(ResManager.loadKDString((String)"\u811a\u672c:", (String)"DeployServiceImpl_27", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])).append(ksqlName).append(ResManager.loadKDString((String)"\u5df2\u88ab\u6267\u884c\u8fc7\uff0c\u4e0d\u518d\u91cd\u590d\u6267\u884c\uff01", (String)"DeployServiceImpl_28", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
                map.put("checkinfo", checkinfoSB.toString());
                HashMap<String, Object> hashMap = map;
                return hashMap;
            }
        }
        ArrayList errorInfo = new ArrayList();
        StringBuilder checkinfoSB = new StringBuilder("type:").append(type).append(" sql ");
        IUpgradePlugin plugin = null;
        String iteration = "";
        if (StringUtils.isNotBlank((CharSequence)pluginElement)) {
            String[] appNameArr = StringUtil.split((String)appName, (String)"-");
            String appNumber = appNameArr != null && appNameArr.length > 1 ? appNameArr[1] : appName;
            plugin = this.createPlugin(appNumber, pluginElement);
        }
        if (plugin != null) {
            checkinfoSB.append(String.format("deploy plugin: %s beforeExecuteSql begin...", plugin.getClassQualifiedName()));
            log.info(String.format("deploy plugin: %s beforeExecuteSql begin...", plugin.getClassQualifiedName()));
            UpgradeResult result = plugin.beforeExecuteSql(version, iteration, dbKey, ksqlName);
            checkinfoSB.append(result.getLog()).append(System.lineSeparator());
            if (!result.isSuccess()) {
                HashMap<String, String> sqlResult2 = new HashMap<String, String>();
                sqlResult2.put("err", "dbroute: " + dbKey + ", " + result.getErrorInfo());
                errorInfo.add(sqlResult2);
                log.error(result.getErrorInfo());
                if (ERROR.equals(result.getEl())) {
                    map.put("el", ERROR);
                }
            }
            success = success && result.isSuccess();
            checkinfoSB.append(String.format(ResManager.loadKDString((String)"deploy puglin: %s beforeExecuteSql \u5b8c\u6210.", (String)"DeployServiceImpl_8", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), plugin.getClassQualifiedName()));
            log.info(String.format("deploy puglin: %s beforeExecuteSql finish...", plugin.getClassQualifiedName()));
        }
        boolean isAll = false;
        HashMap<String, DBRoute> dbRoutes = new HashMap<String, DBRoute>();
        if ("all".equalsIgnoreCase(dbKey)) {
            Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
            List dbs = account.getDBInstanceList();
            for (DBInstance dbInstance : dbs) {
                String insid = String.format("%s.%s.%s.%s.%s", dbInstance.getDbtype(), dbInstance.getDbip(), dbInstance.getDbport(), dbInstance.getDBInsatnce(), dbInstance.getDbuser());
                if (dbRoutes.containsKey(insid)) continue;
                dbRoutes.put(insid, new DBRoute(dbInstance.getRouteKey()));
            }
            checkinfoSB.append("to be exec in all DB : -- ");
            isAll = true;
        } else {
            dbRoutes.put(dbKey, new DBRoute(dbKey));
            checkinfoSB.append("to be exec single DB : -- ");
        }
        for (String sql : sqlList) {
            try {
                if (!"KSQL".equals(type)) {
                    sql = sql.trim();
                    sql = "/*dialect*/" + sql;
                }
                for (DBRoute dbRoute2 : dbRoutes.values()) {
                    DBType dbType2 = DB.getDBType((DBRoute)dbRoute2);
                    if (!"KSQL".equalsIgnoreCase(type) && !dbType2.toString().equalsIgnoreCase(type)) continue;
                    if (isAll) {
                        checkinfoSB.append("execute -- dbKey:").append(dbRoute2.getRouteKey()).append(", dbType:").append(dbType2.toString());
                        if (sql.length() > 30) {
                            checkinfoSB.append(", sql:").append(sql.substring(0, 29)).append(" ... ").append(System.lineSeparator());
                        } else {
                            checkinfoSB.append(", sql:").append(sql).append(" ... ").append(System.lineSeparator());
                        }
                    }
                    TXHandle h = TX.required();
                    Throwable throwable = null;
                    try {
                        DB.execute((DBRoute)dbRoute2, (String)sql, null);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (h == null) continue;
                        if (throwable != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        h.close();
                    }
                }
            }
            catch (Exception e) {
                success = false;
                sqlResult = new HashMap<String, String>();
                String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                sqlResult.put("sql", sql);
                sqlResult.put("err", "dbroute: " + dbKey + ", " + msg);
                errorInfo.add(sqlResult);
                log.error(msg, (Throwable)e);
                if (!ERROR.equals(el)) continue;
                map.put("el", ERROR);
                break;
            }
        }
        if (plugin != null) {
            log.info(String.format("deploy plugin: %s afterExecuteSql begin...", plugin.getClassQualifiedName()));
            checkinfoSB.append(String.format("deploy plugin: %s afterExecuteSql begin...", plugin.getClassQualifiedName())).append(System.lineSeparator());
            UpgradeResult result = plugin.afterExecuteSql(version, iteration, dbKey, ksqlName);
            checkinfoSB.append(result.getLog()).append(System.lineSeparator());
            if (!result.isSuccess()) {
                HashMap<String, String> sqlResult3 = new HashMap<String, String>();
                sqlResult3.put("err", "dbroute: " + dbKey + ", " + result.getErrorInfo());
                errorInfo.add(sqlResult3);
                log.error(result.getErrorInfo());
                if (ERROR.equals(result.getEl())) {
                    map.put("el", ERROR);
                }
            }
            success = success && result.isSuccess();
            checkinfoSB.append(String.format(ResManager.loadKDString((String)"deploy plugin: %s afterExecuteSql \u5b8c\u6210.", (String)"DeployServiceImpl_29", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), plugin.getClassQualifiedName())).append(System.lineSeparator());
            log.info(String.format("deploy plugin: %s afterExecuteSql finish...", plugin.getClassQualifiedName()));
        }
        if (success) {
            Object[] insertParams = new Object[]{version, ksqlName, appName, DB.genGlobalLongId(), pkname};
            String insertKSQL = "insert into T_BAS_SQLVERSION(fver,ffilename,fappid,exectime,FID,PKNAME) values(?,?,?,NOW(),?,?);";
            try {
                TXHandle h = TX.required();
                sqlResult = null;
                try {
                    DB.execute((DBRoute)DBRoute.meta, (String)insertKSQL, (Object[])insertParams);
                }
                catch (Throwable throwable) {
                    sqlResult = throwable;
                    throw throwable;
                }
                finally {
                    if (h != null) {
                        if (sqlResult != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)sqlResult).addSuppressed(throwable);
                            }
                        } else {
                            h.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                String msg = new StringBuffer(ksqlName).append(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff0c\u4f46\u662f\u63d2\u5165\u6267\u884c\u8bb0\u5f55\u5931\u8d25", (String)"DeployServiceImpl_30", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])).toString();
                log.error(msg, (Throwable)e);
            }
        }
        map.put(SUCCESS, success);
        map.put(ERROR_INFO, errorInfo);
        map.put("checkinfo", checkinfoSB.toString());
        return map;
    }

    private boolean checkSqlVersionTable() {
        String dbVer = this.getVer();
        if (this.compareDbVer(dbVer)) {
            return false;
        }
        boolean syncSQLVerTable = false;
        Boolean isexisttable = DB.exitsTable((DBRoute)DBRoute.meta, (String)T_BAS_SQLVERSION);
        if (!isexisttable.booleanValue()) {
            try (TXHandle h = TX.notSupported();){
                String sqlCreateTable = "create table T_BAS_SQLVERSION (FID bigint primary key, FVER varchar(10),FFILENAME varchar(500),EXECTIME DATETIME NOT NULL,FAPPID varchar(50),PKNAME varchar(50));";
                DB.execute((DBRoute)DBRoute.meta, (String)sqlCreateTable, null);
                String idxSQL = "CREATE INDEX IDX_BAS_SQLVERSION_FNUMBER ON T_BAS_SQLVERSION ( fver,ffilename,fappid);";
                DB.execute((DBRoute)DBRoute.meta, (String)idxSQL, null);
                syncSQLVerTable = true;
            }
            catch (Exception e) {
                String msg = ResManager.loadKDString((String)"\u5efa\u8868 T_BAS_SQLVERSION \u5931\u8d25", (String)"DeployServiceImpl_25", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]);
                log.error(msg, (Throwable)e);
            }
        } else {
            try (TXHandle h = TX.notSupported();){
                String alterTablepkname = "EXEC p_AlterColumn 'T_BAS_SQLVERSION', 'FFILENAME', 'varchar(500)', 'NULL', '0100', '';";
                DB.execute((DBRoute)DBRoute.meta, (String)alterTablepkname, null);
            }
            catch (Exception e) {
                String msg = ResManager.loadKDString((String)"\u4fee\u6539 T_BAS_SQLVERSION \u5931\u8d25", (String)"DeployServiceImpl_35", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]);
                log.error(msg, (Throwable)e);
            }
        }
        return syncSQLVerTable;
    }

    private boolean compareDbVer(String dbVer) {
        if (kd.bos.util.StringUtils.isBlank((String)dbVer)) {
            return false;
        }
        String sqlVer = this.getSqlVersionTableVer();
        if (kd.bos.util.StringUtils.isBlank((String)sqlVer)) {
            return true;
        }
        String[] verStrs = sqlVer.split("\\.");
        int[] intVers = new int[verStrs.length];
        for (int i = 0; i < verStrs.length; ++i) {
            intVers[i] = Integer.parseInt(verStrs[i]);
        }
        String[] dbVerStrs = dbVer.split("\\.");
        int length = verStrs.length;
        int[] intDbVers = new int[length];
        for (int i = 0; i < length; ++i) {
            intDbVers[i] = i >= dbVerStrs.length ? 0 : Integer.parseInt(dbVerStrs[i]);
        }
        if (intDbVers[0] > intVers[0]) {
            return true;
        }
        if (intDbVers[0] == intVers[0] && intDbVers[1] > intVers[1]) {
            return true;
        }
        return intDbVers[0] == intVers[0] && intDbVers[1] == intVers[1] && intDbVers[2] > intVers[2];
    }

    private String getSqlVersionTableVer() {
        return "1.5.0";
    }

    private IUpgradePlugin createPlugin(String appNumber, String pluginNameElement) {
        Object splugin;
        if (StringUtils.isBlank((CharSequence)pluginNameElement)) {
            return null;
        }
        String[] pluginParams = pluginNameElement.split(",");
        if (pluginParams == null || pluginParams.length == 0) {
            return null;
        }
        String type = "js";
        String pluginName = "";
        String cloudNumber = "";
        String app = appNumber;
        String scriptPlugin = "";
        for (String param : pluginParams) {
            String[] sp = param.split(":");
            if (sp.length == 2) {
                if ("cloud".equalsIgnoreCase(sp[0])) {
                    cloudNumber = sp[1];
                    continue;
                }
                if ("app".equalsIgnoreCase(sp[0])) {
                    app = sp[1];
                    continue;
                }
                if ("scriptPlugin".equalsIgnoreCase(sp[0])) {
                    scriptPlugin = sp[1];
                    continue;
                }
                type = sp[0];
                pluginName = sp[1];
                continue;
            }
            if (sp.length != 1) continue;
            pluginName = sp[0];
        }
        if (StringUtils.isBlank((CharSequence)pluginName)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)app)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u63d2\u4ef6app\u540d\u79f0\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", (String)"DeployServiceImpl_31", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])});
        }
        if ("class".equalsIgnoreCase(type)) {
            if (StringUtils.isBlank((CharSequence)cloudNumber)) {
                cloudNumber = CloudAppMappingDictionary.getCloudIdBy((String)app);
            }
            if (StringUtils.isBlank((CharSequence)cloudNumber)) {
                String getCloudSql = "select a.fnumber from t_meta_bizcloud a inner join t_meta_bizapp b on a.fid = b.fbizcloudid where b.fnumber = ?";
                Object[] getCloudParams = new Object[]{app};
                cloudNumber = (String)DB.query((DBRoute)DBRoute.meta, (String)getCloudSql, (Object[])getCloudParams, (ResultSetHandler)new ResultSetHandler<String>(){

                    public String handle(ResultSet rs) throws Exception {
                        if (rs.next()) {
                            String tmp = rs.getString("fnumber");
                            return StringUtils.isNotBlank((CharSequence)tmp) ? tmp.toLowerCase() : tmp;
                        }
                        return "";
                    }
                });
            }
            if (StringUtils.isBlank((CharSequence)cloudNumber)) {
                throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u672a\u80fd\u627e\u5230\u63d2\u4ef6\u6240\u5c5ecloud\uff0c\u8bf7\u68c0\u67e5", (String)"DeployServiceImpl_32", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])});
            }
            splugin = new StandUpgradePlugin();
            ((StandUpgradePlugin)((Object)splugin)).setDispatchParams(cloudNumber, app, pluginName);
            if (StringUtils.isNotBlank((CharSequence)scriptPlugin)) {
                ((StandUpgradePlugin)((Object)splugin)).setScriptPluginName(scriptPlugin);
            }
            return splugin;
        }
        try {
            splugin = this.createDynamicScriptPlugin(pluginName);
            return splugin;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public List<String> deployDym(Map<String, Object> params, String content) {
        List<String> formIds = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)content)) {
            return formIds;
        }
        String type = (String)params.get("type");
        DB.__setIgnoreCheckThreadGetMaxConnectionCount((boolean)true);
        if ("js".equals(type)) {
            MetadataDao.deployScript((String)content);
        } else if ("card".equals(type)) {
            MetadataDao.deployCard((String)content);
        } else if ("sch".equals(type)) {
            MetadataDao.deploySchema((String)content);
        } else if ("cld".equals(type)) {
            MetadataDao.deployCloud((String)content);
        } else if ("app".equals(type)) {
            MetadataDao.deployAppMetadata((String)content);
        } else if ("schdata".equals(type)) {
            IScheduleDeployService service = (IScheduleDeployService)ServiceFactory.getService((String)"IScheduleDeployService");
            service.deployXml(Collections.emptyMap(), content);
        } else {
            formIds = MetadataDao.deployMetadata((String)content);
        }
        return formIds;
    }

    @Deprecated
    public Map<String, Object> deployXML(Map<String, Object> params, String content) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String type = (String)params.get("type");
        try {
            PreInsDataScriptWriter wr = new PreInsDataScriptWriter();
            wr.insertPreInsData(content);
            map.put(SUCCESS, true);
        }
        catch (JAXBException e) {
            map.put(SUCCESS, false);
            map.put(ERROR_INFO, ExceptionUtils.getExceptionStackTraceMessage((Exception)((Object)e)));
        }
        return map;
    }

    public String getVer() {
        return DBVersion.getVer();
    }

    public String getAppIteration(String appId) {
        return DBVersion.getAppIteration((String)appId);
    }

    private IUpgradePlugin createDynamicScriptPlugin(String scriptNumber) throws IOException {
        String scriptContent = this.getScript(scriptNumber);
        if (StringUtils.isBlank((CharSequence)scriptContent)) {
            return null;
        }
        try (InputStream in = FormConfig.class.getResourceAsStream("/FormPlugin.js");){
            String envScript = FormConfig.getContent((InputStream)in);
            ScriptExecutor scriptExecutor = ScriptExecutor.getOrCreate();
            scriptExecutor.init(ctx -> ctx.require(new String[]{"/ScriptModule.conf"}));
            scriptExecutor.begin();
            scriptExecutor.exec(new ScriptInfo[]{new SimpleScriptInfo("/FormPlugin.js", envScript, false), new SimpleScriptInfo(scriptNumber, scriptContent, true)});
            IUpgradePlugin iUpgradePlugin = (IUpgradePlugin)scriptExecutor.getContext().get("plugin");
            return iUpgradePlugin;
        }
    }

    private String getScript(String number) {
        HashMap<String, String> returnMap;
        block15: {
            returnMap = new HashMap<String, String>();
            String sql = "select fscriptnumber,fscriptcontext_tag,fscripttype from t_meta_pluginscript where fclassname = ?";
            Object[] params = new Object[]{number};
            try (DataSet ds = DB.queryDataSet((String)"FormConfig.t_meta_pluginscript.getScriptInfo", (DBRoute)DBRoute.meta, (String)sql, (Object[])params);){
                Iterator iter = ds.iterator();
                if (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    returnMap.put("scriptnumber", row.getString("fscriptnumber"));
                    returnMap.put("scripttype", row.getString("fscripttype"));
                    returnMap.put("scriptcontext", row.getString("fscriptcontext_tag"));
                    break block15;
                }
                String string = null;
                return string;
            }
        }
        return (String)returnMap.get("scripttype");
    }

    private void deprecatedMethodCheck() {
        boolean execDeprecated = Boolean.parseBoolean(System.getProperty("kd.deployservice.execdeprecatedmethod", "false"));
        if (!execDeprecated) {
            throw new KDException(BosErrorCode.methodInvocation, new Object[]{"deprecated method access."});
        }
    }

    public class RebuildRunnable
    implements Runnable {
        private final Log loger = LogFactory.getLog(RebuildRunnable.class);
        private long id;
        private RequestContext ctx;
        private String ver;
        private String apps;

        public RebuildRunnable(RequestContext ctx, long id, String ver, String apps) {
            this.id = id;
            this.ctx = ctx;
            this.ver = ver;
            this.apps = apps;
        }

        @Override
        public void run() {
            String result = "";
            RequestContext.copyAndSet((RequestContext)this.ctx);
            try {
                DeployServiceImpl deployService = new DeployServiceImpl();
                deployService.rebuildApps(this.id, this.ver, this.apps);
            }
            catch (Exception e) {
                result = ExceptionHandler.HandlerErr(e, ResManager.loadKDString((String)"rebuild apps error, \u672a\u77e5\u7684\u5f02\u5e38\u4e2d\u65ad\uff0c\u91cd\u5efa\u5143\u6570\u636e\u5931\u8d25\u3002", (String)"DeployServiceImpl_34", (String)DeployServiceImpl.BOS_MSERVICE_FORM, (Object[])new Object[0])).toString();
                DeployLog.error(this.id, this.ver, DeployCategory.Package, result, e);
            }
        }
    }

    public class DeployRunnable
    implements Runnable {
        private final Log loger = LogFactory.getLog(DeployRunnable.class);
        private long id;
        private String ver;
        private String dmUrl;
        private RequestContext ctx;

        public DeployRunnable(RequestContext ctx, long id, String ver, String dmUrl) {
            this.id = id;
            this.ver = ver;
            this.dmUrl = dmUrl;
            this.ctx = ctx;
        }

        @Override
        public void run() {
            String result = "";
            RequestContext.copyAndSet((RequestContext)this.ctx);
            DeployServiceImpl deployService = null;
            try {
                deployService = new DeployServiceImpl();
                deployService.deployDM(this.id, this.ver, this.dmUrl);
            }
            catch (Exception e) {
                result = ExceptionHandler.HandlerErr(e, ResManager.loadKDString((String)"Deploy dm error,\u672a\u77e5\u7684\u5f02\u5e38\u4e2d\u65ad\uff0czip\u5305\u90e8\u7f72\u5347\u7ea7\u5931\u8d25\u3002", (String)"DeployServiceImpl_33", (String)DeployServiceImpl.BOS_MSERVICE_FORM, (Object[])new Object[0])).toString();
                try {
                    DeployLog.error(this.id, this.ver, DeployCategory.Package, result, e);
                    deployService.saveErrorDeployInfo(this.id, this.ver, null);
                }
                catch (Exception e2) {
                    this.loger.error("Deploy dm error and save error DeployInfo error.", (Throwable)e2);
                }
            }
        }
    }
}

