/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade;

import com.google.common.base.Splitter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.broadcast.BroadcastService;
import kd.bos.param.ParameterReader;
import kd.bos.service.upgrade.JarDeployService;
import kd.bos.upgrade.ExtJarApi;

public class JarDeployServiceImpl
implements JarDeployService {
    private static final Log log = LogFactory.getLog(JarDeployServiceImpl.class);
    private static final String TENANT = "tenant";
    private static final String ACCOUNTID = "accountid";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyDeployJar(String tenandId, String accountId) {
        MessagePublisher mpb = MQFactory.get().createSimplePublisher("bos", "deploy_jar");
        HashMap<String, String> deployInfo = new HashMap<String, String>();
        deployInfo.put(TENANT, tenandId);
        deployInfo.put("account", accountId);
        try {
            mpb.publish(deployInfo);
        }
        finally {
            mpb.close();
        }
    }

    public static void resetDeployJar(String tenantId, String accountId) {
        try {
            RequestContext oldctx = RequestContext.get();
            RequestContext ctx = RequestContext.create();
            ctx.setAccountId(accountId);
            ctx.setTenantId(tenantId);
            RequestContext.set((RequestContext)ctx);
            ExtJarApi.reset((String)accountId);
            if (oldctx != null) {
                RequestContext.set((RequestContext)oldctx);
            } else {
                RequestContext.set(null);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String deployJar(String deployInfo) {
        String rt;
        JarDeployResult result = new JarDeployResult();
        String opType = "";
        try {
            Map params = (Map)SerializationUtils.fromJsonString((String)deployInfo, Map.class);
            opType = (String)params.get("opType");
            String tenantId = (String)params.get(TENANT);
            String accountId = (String)params.get(ACCOUNTID);
            if (StringUtils.isBlank((CharSequence)tenantId) || StringUtils.isBlank((CharSequence)accountId)) {
                result.setError(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u5408\u6cd5\u7684\u79df\u6237\uff08tenant\uff09|| \u8d26\u5957\uff08accountid\uff09", (String)"JarDeployServiceImpl_0", (String)"bos-mservice-form", (Object[])new Object[0]));
                result.setSuccess(false);
                String string = SerializationUtils.toJsonString((Object)result);
                return string;
            }
            if (StringUtils.isBlank((CharSequence)opType)) {
                result.setError(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u64cd\u4f5c\u7c7b\u578b\uff08opType\uff09", (String)"JarDeployServiceImpl_1", (String)"bos-mservice-form", (Object[])new Object[0]));
                result.setSuccess(false);
                return rt;
            }
            switch (opType) {
                case "deploy": {
                    this.doDeployJar(params);
                    return rt;
                }
                case "init": {
                    this.doInitDeployJar(params);
                    return rt;
                }
                case "disable": {
                    this.doDisableDeployJar(params);
                    return rt;
                }
                case "enable": {
                    this.doEnableDeployJar(params);
                    return rt;
                }
                case "clear": {
                    this.doClearDeployJar(params);
                    return rt;
                }
                default: {
                    result.setError(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u64cd\u4f5c\u7c7b\u578b\uff1a%s", (String)"JarDeployServiceImpl_2", (String)"bos-mservice-form", (Object[])new Object[0]), opType));
                    result.setSuccess(false);
                    return rt;
                }
            }
        }
        catch (Exception e) {
            result.setError(JarDeployServiceImpl.isShowStackTrace() ? this.getExceptionStackTraceMessage(e) : this.getNormalError(opType));
            result.setSuccess(false);
            return rt;
        }
        finally {
            rt = SerializationUtils.toJsonString((Object)result);
        }
    }

    private String getNormalError(String opType) {
        RequestContext requestContext = RequestContext.get();
        String msg = "";
        if (requestContext != null) {
            msg = "TraceId:" + requestContext.getTraceId() + "\r\n";
        }
        msg = msg + " deployJar " + opType + " error ";
        return msg;
    }

    private static boolean isShowStackTrace() {
        String showStackTrace = System.getProperty("exception_showstacktrace");
        if ("true".equals(showStackTrace)) {
            return true;
        }
        try {
            Object isShowStackTrace;
            Map cache = ParameterReader.loadPublicParameterFromCache();
            if (cache.size() > 0 && (isShowStackTrace = cache.get("showstacktrace")) != null) {
                return (Boolean)isShowStackTrace;
            }
        }
        catch (Throwable ex) {
            log.error("\u83b7\u53d6\u516c\u5171\u53c2\u6570\u5931\u8d25.", ex);
            return false;
        }
        return false;
    }

    private void doDeployJar(Map<String, Object> deployInfo) throws Exception {
        List jarZips = (List)deployInfo.get("args");
        String isv = (String)deployInfo.get("isv");
        String app = (String)deployInfo.get("app");
        ArrayList<Map<String, Object>> lstJarInfo = new ArrayList<Map<String, Object>>();
        for (Map jarZip : jarZips) {
            String url = (String)jarZip.get("url");
            List<Map<String, Object>> lstJarInfoFromZip = this.readJarFromZip(url, isv, app);
            lstJarInfo.addAll(lstJarInfoFromZip);
        }
        if (lstJarInfo.isEmpty()) {
            return;
        }
        String accountId = (String)deployInfo.get(ACCOUNTID);
        String tenantId = (String)deployInfo.get(TENANT);
        if (accountId.equals(RequestContext.get().getAccountId()) && tenantId.equals(RequestContext.get().getTenantId())) {
            ExtJarApi.save(lstJarInfo);
        } else {
            RequestContext ctxOld = RequestContext.get();
            RequestContext ctxNew = RequestContext.create();
            ctxNew.setAccountId(accountId);
            ctxNew.setTenantId(tenantId);
            RequestContext.set((RequestContext)ctxNew);
            ExtJarApi.save(lstJarInfo);
            RequestContext.set((RequestContext)ctxOld);
        }
    }

    private void doInitDeployJar(Map<String, Object> deployInfo) throws Exception {
        String accountId = (String)deployInfo.get(ACCOUNTID);
        String tenantId = (String)deployInfo.get(TENANT);
        BroadcastService.broadcastMessage((String)"kd.bos.service.upgrade.JarDeployServiceImpl", (String)"resetDeployJar", (Object[])new Object[]{tenantId, accountId});
        JarDeployServiceImpl.resetDeployJar(tenantId, accountId);
    }

    private void doEnableDeployJar(Map<String, Object> deployInfo) {
        String accountId = (String)deployInfo.get(ACCOUNTID);
        String tenantId = (String)deployInfo.get(TENANT);
        if (accountId.equals(RequestContext.get().getAccountId()) && tenantId.equals(RequestContext.get().getTenantId())) {
            ExtJarApi.enableDeployJar();
        } else {
            RequestContext ctxOld = RequestContext.get();
            RequestContext ctxNew = RequestContext.create();
            ctxNew.setAccountId(accountId);
            ctxNew.setTenantId(tenantId);
            RequestContext.set((RequestContext)ctxNew);
            ExtJarApi.enableDeployJar();
            RequestContext.set((RequestContext)ctxOld);
        }
    }

    private void doDisableDeployJar(Map<String, Object> deployInfo) {
        String accountId = (String)deployInfo.get(ACCOUNTID);
        String tenantId = (String)deployInfo.get(TENANT);
        if (accountId.equals(RequestContext.get().getAccountId()) && tenantId.equals(RequestContext.get().getTenantId())) {
            ExtJarApi.disableDeployJar();
        } else {
            RequestContext ctxOld = RequestContext.get();
            RequestContext ctxNew = RequestContext.create();
            ctxNew.setAccountId(accountId);
            ctxNew.setTenantId(tenantId);
            RequestContext.set((RequestContext)ctxNew);
            ExtJarApi.disableDeployJar();
            RequestContext.set((RequestContext)ctxOld);
        }
    }

    private void doClearDeployJar(Map<String, Object> deployInfo) {
        String accountId = (String)deployInfo.get(ACCOUNTID);
        String tenantId = (String)deployInfo.get(TENANT);
        if (accountId.equals(RequestContext.get().getAccountId()) && tenantId.equals(RequestContext.get().getTenantId())) {
            ExtJarApi.clear();
        } else {
            RequestContext ctxOld = RequestContext.get();
            RequestContext ctxNew = RequestContext.create();
            ctxNew.setAccountId(accountId);
            ctxNew.setTenantId(tenantId);
            RequestContext.set((RequestContext)ctxNew);
            ExtJarApi.clear();
            RequestContext.set((RequestContext)ctxOld);
        }
    }

    private String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> readJarFromZip(String url, String isv, String app) throws IOException {
        ArrayList<Map<String, Object>> lstJarInfo;
        HttpURLConnection httpUrl;
        block16: {
            String path = this.getParam(url, "path");
            URL urlfile = null;
            httpUrl = null;
            lstJarInfo = new ArrayList<Map<String, Object>>();
            InputStream is = null;
            try {
                if (StringUtils.isNotBlank((CharSequence)path)) {
                    is = FileServiceFactory.getAttachmentFileService().getInputStream(path);
                } else {
                    urlfile = new URL(url);
                    httpUrl = (HttpURLConnection)urlfile.openConnection();
                    httpUrl.connect();
                    is = httpUrl.getInputStream();
                }
                byte[] ft = new byte[4];
                is.read(ft, 0, 4);
                String sft = this.bytesToHexString(ft);
                if (sft != null && !sft.equalsIgnoreCase("52617221") && !sft.equalsIgnoreCase("504B0304")) {
                    if (httpUrl != null) {
                        httpUrl.disconnect();
                    }
                    throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u70ed\u90e8\u7f72\u6587\u4ef6\u975e\u6cd5\u5f02\u5e38\uff0cUrl=%s", (String)"JarDeployServiceImpl_3", (String)"bos-mservice-form", (Object[])new Object[0]), url));
                }
                if (httpUrl != null) {
                    httpUrl.disconnect();
                }
                if (StringUtils.isNotBlank((CharSequence)path)) {
                    is = FileServiceFactory.getAttachmentFileService().getInputStream(path);
                } else {
                    urlfile = new URL(url);
                    httpUrl = (HttpURLConnection)urlfile.openConnection();
                    httpUrl.connect();
                    is = httpUrl.getInputStream();
                    path = url;
                }
                ZipInputStream zipIn = new ZipInputStream(is);
                ZipEntry zEntry = zipIn.getNextEntry();
                if (zEntry != null) {
                    while (null != zEntry) {
                        if (!zEntry.isDirectory()) {
                            String fileName = zEntry.getName();
                            if ((fileName = fileName.replace(File.separator, "/")).endsWith("jar")) {
                                byte[] jarByte = this.readJarContent(zipIn);
                                HashMap<String, Object> jarInfo = new HashMap<String, Object>();
                                jarInfo.put("name", fileName);
                                jarInfo.put("desc", fileName);
                                jarInfo.put("jar", jarByte);
                                jarInfo.put("app", app);
                                jarInfo.put("isv", isv);
                                lstJarInfo.add(jarInfo);
                            }
                        }
                        zEntry = zipIn.getNextEntry();
                    }
                }
                if (is == null) break block16;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    JarDeployServiceImpl.safeClose(is);
                }
                if (httpUrl != null) {
                    httpUrl.disconnect();
                }
                throw throwable;
            }
            JarDeployServiceImpl.safeClose(is);
        }
        if (httpUrl != null) {
            httpUrl.disconnect();
        }
        return lstJarInfo;
    }

    private static void safeClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }

    private byte[] readJarContent(InputStream zipIn) throws IOException {
        byte[] bytes;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            int c = zipIn.read();
            while (c >= 0) {
                os.write(c);
                c = zipIn.read();
            }
            bytes = os.toByteArray();
        }
        return bytes;
    }

    private String getParam(String url, String name) {
        String params = url.substring(url.indexOf("?") + 1, url.length());
        if (url.equals(params)) {
            return null;
        }
        Map split = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)params);
        return (String)split.get(name);
    }

    private static boolean downloadStreamFileInner(File localFile, HttpURLConnection httpUrl) throws IOException {
        boolean success = true;
        try (BufferedInputStream bis = new BufferedInputStream(httpUrl.getInputStream());
             BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(localFile));){
            int len = 2048;
            byte[] b = new byte[len];
            while ((len = bis.read(b)) != -1) {
                bos.write(b, 0, len);
            }
            bos.flush();
        }
        catch (IOException e) {
            success = false;
            throw e;
        }
        return success;
    }

    /*
     * Exception decompiling
     */
    private String getExceptionStackTraceMessage(Throwable ex) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class JarDeployResult
    implements Serializable {
        private static final long serialVersionUID = 627039829396810062L;
        boolean success = true;
        String error;
        HashMap<String, Object> data;

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public void setError(String error) {
            this.error = error;
        }

        public void setData(HashMap<String, Object> data) {
            if (this.data == null) {
                this.data = new HashMap();
            }
            this.data.putAll(data);
        }

        public boolean getSuccess() {
            return this.success;
        }

        public String getError() {
            return this.error;
        }

        public HashMap<String, Object> getData() {
            return this.data;
        }
    }
}

