/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade.deploy;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.upgrade.IUpgradePlugin;
import kd.bos.service.upgrade.AbsractVersion;
import kd.bos.service.upgrade.DeployPackageInfo;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.service.upgrade.deploy.DeployBatchSql;
import kd.bos.service.upgrade.entity.DeployAppInfo;
import kd.bos.service.upgrade.entity.DeployCategory;
import kd.bos.service.upgrade.entity.DeployLog;
import kd.bos.service.upgrade.entity.DeployResult;
import kd.bos.service.upgrade.entity.DeployScriptInfo;
import kd.bos.service.upgrade.entity.DeployState;
import kd.bos.service.upgrade.entity.SqlScript;
import kd.bos.sqlscript.PreInsDataScriptWriter;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.ExceptionUtils;
import kd.bos.xdb.QueryTimeout;

public class DeplayDataModelBase {
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private static final String ERROR = "error";
    private static final String FAILED = "failed";
    private DeployState deployState;
    private boolean isBigTablePack;
    private String appGroup;
    private String localeId;
    private static String deploy_no_dbroute_error = "deploy.error.nodbroute";
    private static boolean dbrouteErrorLevel = false;
    private static String deploy_query_timeout = "deploy.query.timeout";
    private static int queryTimeout = 0;
    private static String DEPLOY_ERROR_REBUILD_FAILE = "deploy.error.rebuildfail";
    protected static boolean rebuildFailErrorLevel = false;

    public void setDeployState(DeployState ds) {
        this.deployState = ds;
    }

    public DeployState getDeployState() {
        return this.deployState;
    }

    public boolean isBigTablePack() {
        return this.isBigTablePack;
    }

    public void setBigTablePack(boolean isBigTablePack) {
        this.isBigTablePack = isBigTablePack;
    }

    public String getAppGroup() {
        return this.appGroup;
    }

    public void setAppGroup(String appGroup) {
        this.appGroup = appGroup;
    }

    public String getLocaleId() {
        return this.localeId;
    }

    public void setLocaleId(String localeId) {
        this.localeId = localeId;
    }

    public boolean checkVer(AbsractVersion deployingVer) {
        throw new KDException("not implement");
    }

    public void deployByAppId(DeployAppInfo appInfo, DeployResult result, int category) throws IOException {
        throw new KDException("not implement");
    }

    protected void deployScript(DeployAppInfo appInfo, int category, DeployResult result, List<String> existSqlFile) throws IOException {
        String fullVer = String.format("%s.%s", appInfo.getVer(), appInfo.getDeployInfo().getIteration());
        List<DeployScriptInfo> scriptInfoList = appInfo.getScriptInfoList();
        String scriptmsg = String.format(ResManager.loadKDString((String)"\u5373\u5c06\u6267\u884c\u811a\u672c%1$s\u811a\u672c\uff0c\u5171%2$s\u4e2a\u6587\u4ef6 ... ", (String)"DeplayDataModelBase_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), appInfo.getName(), scriptInfoList.size());
        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, scriptmsg);
        this.deployScript(appInfo, scriptInfoList, category, result, existSqlFile);
    }

    private void deployScript(DeployAppInfo appInfo, List<DeployScriptInfo> scriptInfoList, int category, DeployResult result, List<String> existSqlFile) throws IOException {
        String fullVer = String.format("%s.%s", appInfo.getVer(), appInfo.getDeployInfo().getIteration());
        int execIndex = 1;
        int total = scriptInfoList.size();
        for (DeployScriptInfo scriptInfo : scriptInfoList) {
            boolean success;
            block24: {
                SqlScript sqlScript = scriptInfo.getSqlScript();
                DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u811a\u672c(%1$s/%2$s)\uff1a%3$s", (String)"DeplayDataModelBase_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), execIndex, total, sqlScript.getName()));
                ++execIndex;
                if (this.isBigTablePack() && !scriptInfo.isBigTable()) {
                    DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u811a\u672c\uff1a%s\uff0c\u975e\u5927\u8868\u811a\u672c,\u8df3\u8fc7", (String)"DeplayDataModelBase_2", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), sqlScript.getName()));
                    continue;
                }
                String scriptPath = sqlScript.getFilePath();
                scriptPath = scriptPath.replace("\\", "/");
                if ("sql".equals(sqlScript.getFileType())) {
                    if ((category & 8) != 8 || (category & 0x10) != 16) {
                        if ((category & 8) == 8 && !scriptPath.contains("/dbschema/")) {
                            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"category\uff1a%1$s\u811a\u672c\uff1a%2$s\uff0c\u4e0d\u5305\u542bdbschema,\u8df3\u8fc7", (String)"DeplayDataModelBase_3", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), category, scriptPath));
                            continue;
                        }
                        if ((category & 0x10) == 16 && !scriptPath.contains("/preinsdata/")) {
                            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"category\uff1a%1$s\u811a\u672c\uff1a%2$s\uff0c\u4e0d\u5305\u542bpreinsdata,\u8df3\u8fc7", (String)"DeplayDataModelBase_4", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), category, scriptPath));
                            continue;
                        }
                    } else {
                        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"category\uff1a%1$s\u811a\u672c\uff1a%2$s\uff0c\u6267\u884c\u7c7b\u578bsql", (String)"DeplayDataModelBase_5", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), category, scriptPath));
                    }
                } else {
                    DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"category\uff1a%1$s\u811a\u672c\uff1a%2$s\uff0c\u6267\u884c\u7c7b\u578bxml", (String)"DeplayDataModelBase_6", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), category, scriptPath));
                }
                if (existSqlFile.contains(sqlScript.getName())) {
                    String msg = String.format(ResManager.loadKDString((String)"\u811a\u672c%s\u5df2\u6267\u884c\uff0c\u4e0d\u518d\u91cd\u590d\u6267\u884c\uff01", (String)"DeplayDataModelBase_7", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), sqlScript.getName());
                    result.addInfo(msg);
                    DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, msg);
                    continue;
                }
                success = true;
                try {
                    DBRoute dbRoute;
                    DBType dbType;
                    IUpgradePlugin plugin = sqlScript.getPlugin();
                    if (plugin != null) {
                        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u811a\u672c:%1$s  deploy puglin: %2$s beforeExecuteSql begin...", (String)"DeplayDataModelBase_8", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), scriptPath, plugin.getClassQualifiedName()));
                        UpgradeResult upGradeResult = plugin.beforeExecuteSql(appInfo.getVer(), appInfo.getDeployInfo().getIteration(), sqlScript.getDbKey(), sqlScript.getName());
                        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, upGradeResult.getLog());
                        if (!upGradeResult.isSuccess()) {
                            success = false;
                            appInfo.getDeployInfo().setResult('0');
                            String msg = String.format(ResManager.loadKDString((String)"%1$s\u63d2\u4ef6\u6267\u884c\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"DeplayDataModelBase_9", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), "beforeExecuteSql", upGradeResult.getErrorInfo());
                            result.addError(msg);
                            DeployLog.error(appInfo.getPkgId(), fullVer, DeployCategory.Script, msg, (Throwable)new KDException(BosErrorCode.bOS, new Object[]{msg}));
                            if (ERROR.equals(upGradeResult.getEl())) {
                                throw new KDException(BosErrorCode.bOS, new Object[]{msg});
                            }
                        }
                        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"deploy puglin: %s beforeExecuteSql \u5b8c\u6210.", (String)"DeplayDataModelBase_10", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), plugin.getClassQualifiedName()));
                    }
                    if (!"KSQL".equalsIgnoreCase(sqlScript.getSqlType()) && !"all".equalsIgnoreCase(sqlScript.getDbKey()) && !(dbType = DB.getDBType((DBRoute)(dbRoute = new DBRoute(sqlScript.getDbKey())))).toString().equalsIgnoreCase(sqlScript.getSqlType())) continue;
                    scriptInfo.setExecTime(new Date());
                    boolean sqlSucssecss = true;
                    if ("sql".equals(sqlScript.getFileType())) {
                        if (scriptInfo.isBatchSql()) {
                            DeployBatchSql deployBatchSql = new DeployBatchSql(dbrouteErrorLevel);
                            sqlSucssecss = deployBatchSql.execute(appInfo, sqlScript, fullVer, result);
                        } else {
                            sqlSucssecss = this.deploySingleSql(appInfo, sqlScript, fullVer, result);
                        }
                    } else {
                        sqlSucssecss = this.deploySingleXml(appInfo, sqlScript, fullVer, result);
                    }
                    if (success) {
                        success = sqlSucssecss;
                    }
                    if (plugin != null) {
                        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format("deploy puglin: %s afterExecuteSql begin...", plugin.getClassQualifiedName()));
                        UpgradeResult upGradeResult = plugin.afterExecuteSql(appInfo.getVer(), appInfo.getDeployInfo().getIteration(), sqlScript.getDbKey(), sqlScript.getName());
                        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, upGradeResult.getLog());
                        if (!upGradeResult.isSuccess()) {
                            success = false;
                            appInfo.getDeployInfo().setResult('0');
                            String msg = String.format(ResManager.loadKDString((String)"%1$s\u63d2\u4ef6\u6267\u884c\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"DeplayDataModelBase_9", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), "afterExecuteSql", upGradeResult.getErrorInfo());
                            result.addError(msg);
                            DeployLog.error(appInfo.getPkgId(), fullVer, DeployCategory.Script, msg, (Throwable)new KDException(BosErrorCode.bOS, new Object[]{msg}));
                            if (ERROR.equals(upGradeResult.getEl())) {
                                throw new KDException(BosErrorCode.bOS, new Object[]{msg});
                            }
                        }
                        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"deploy puglin: %s afterExecuteSql \u63d2\u4ef6\u6267\u884c\u5b8c\u6210.", (String)"DeplayDataModelBase_11", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), plugin.getClassQualifiedName()));
                    }
                }
                catch (Exception e) {
                    success = false;
                    appInfo.getDeployInfo().setResult('0');
                    String stackMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                    result.addError(String.format(ResManager.loadKDString((String)"sql\u6267\u884c\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%1$s ---- %2$s\u5806\u6808\uff1a%3$s", (String)"DeplayDataModelBase_12", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), e.getMessage(), System.lineSeparator(), stackMsg));
                    DeployLog.error(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"sql\u6267\u884c\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%1$s ---- %2$s\u5806\u6808\uff1a%3$s", (String)"DeplayDataModelBase_12", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), e.getMessage(), System.lineSeparator(), stackMsg), e);
                    if (!ERROR.equals(sqlScript.getErrorLevel())) break block24;
                    throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"sql\u6267\u884c\u9519\u8bef\uff0c\u90e8\u7f72\u7ec8\u6b62\uff01", (String)"DeplayDataModelBase_13", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])});
                }
            }
            scriptInfo.finish();
            this.setProgress(appInfo.getDeployInfo().getProgVal());
            if (success) {
                if (appInfo.getResult() == 2) {
                    appInfo.setResult(1);
                }
                DeployPackageInfo.saveDeployInfo(scriptInfo, scriptInfo.getClass());
                DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, "save deploy script info finish!");
                continue;
            }
            appInfo.setResult(0);
        }
    }

    private boolean deploySingleSql(DeployAppInfo appInfo, SqlScript sqlScript, String fullVer, DeployResult result) throws IOException {
        boolean success = true;
        List<String> sqlList = this.readSqlFile(appInfo.getPkgId(), fullVer, sqlScript, result);
        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"begin deploy script: %1$s -- DBKey:%2$s  -- sqlcount:%3$s  .", (String)"DeplayDataModelBase_23", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), sqlScript.getName(), sqlScript.getDbKey(), sqlList.size()));
        Map<Object, Object> dbRoutes = new HashMap<String, DBRoute>();
        boolean isAll = false;
        if ("all".equalsIgnoreCase(sqlScript.getDbKey())) {
            dbRoutes = appInfo.getDeployInfo().getAllDBRoutes();
            isAll = true;
        } else {
            dbRoutes.put(sqlScript.getDbKey(), new DBRoute(sqlScript.getDbKey()));
        }
        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"deploy script: %1$s  \u5373\u5c06\u5728%2$s\u4e2a\u5e93\u6267\u884c .", (String)"DeplayDataModelBase_14", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), sqlScript.getName(), dbRoutes.size()));
        int sqlCount = sqlList.size();
        int i = 1;
        for (String sql : sqlList) {
            if (!"KSQL".equals(sqlScript.getSqlType())) {
                String declare;
                sql = sql.trim();
                if ("oracle".equalsIgnoreCase(sqlScript.getSqlType()) && sql.endsWith(";") && !(declare = sql.substring(0, 8)).equalsIgnoreCase("DECLARE ") && sqlScript.getSeparator().equals(";")) {
                    sql = sql.substring(0, sql.length() - 1);
                }
                sql = "/*dialect*/" + sql;
            }
            for (DBRoute dBRoute : dbRoutes.values()) {
                long end;
                long cost;
                DBType dbType = null;
                try {
                    dbType = DB.getDBType((DBRoute)dBRoute);
                }
                catch (Exception e) {
                    String stackMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                    String msg = String.format(ResManager.loadKDString((String)"\u83b7\u53d6DBType\u51fa\u9519\uff0cDBRouteKey: %1$s , script: %2$s, \u9519\u8bef\u4fe1\u606f\uff1a%3$s ----\uff0c%4$s\u5806\u6808\uff1a%5$s", (String)"DeplayDataModelBase_15", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), dBRoute.getRouteKey(), sqlScript.getName(), e.getMessage(), System.lineSeparator(), stackMsg);
                    if (dbrouteErrorLevel) {
                        result.addError(msg);
                        DeployLog.error(appInfo.getPkgId(), fullVer, DeployCategory.Script, msg, e);
                    }
                    result.addWarn(msg);
                    DeployLog.warn(appInfo.getPkgId(), fullVer, DeployCategory.Script, msg);
                }
                if (dbType == null) {
                    String sqlStr = sql.length() > 30 ? sql.substring(0, 29) : sql;
                    DeployLog.warn(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u83b7\u53d6DBType\u4e3a\u7a7a\uff0cDBRouteKey: %1$s , script: %2$s , sql: %3$s", (String)"DeplayDataModelBase_16", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), dBRoute.getRouteKey(), sqlScript.getName(), sqlStr));
                    success = false;
                    continue;
                }
                if (!"KSQL".equalsIgnoreCase(sqlScript.getSqlType()) && !dbType.toString().equalsIgnoreCase(sqlScript.getSqlType())) continue;
                long start = new Date().getTime();
                try (TXHandle h = TX.requiresNew();){
                    if (queryTimeout > 0) {
                        try (QueryTimeout ao = DB.timeout((int)queryTimeout);){
                            DB.execute((DBRoute)dBRoute, (String)sql, null);
                        }
                    } else {
                        DB.execute((DBRoute)dBRoute, (String)sql, null);
                    }
                    ++i;
                }
                catch (Exception e) {
                    String msg;
                    String message = e.getMessage();
                    String traceId = RequestContext.get().getTraceId();
                    String stack = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                    if (dbType == DBType.TiDB && (message.contains("[DO_NOT_DROP_PRIMARY_KEY]") || message.contains("[DO_NOT_ALTER_PRIMARY_KEY]"))) {
                        msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7248\u672cTiDB\u4e0d\u652f\u6301\u4fee\u6539\u6216\u5220\u9664\u4e3b\u952e\uff0c\u5efa\u8bae\u4eba\u5de5\u8fc1\u79fb\u5904\u7406 source sql is : %1$s, stack:%2$s", (String)"DeplayDataModelBase_24", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), sql, stack);
                        result.addWarn(msg);
                        DeployLog.warn(appInfo.getPkgId(), fullVer, DeployCategory.Script, msg);
                    }
                    msg = String.format(ResManager.loadKDString((String)"deploy script error--traceId:%1$s --isAll:%2$s--DBRouteKey:%3$s -- error:%4$s, \u9519\u8befsql:%5$s\uff0c-- Stack:%6$s ", (String)"DeplayDataModelBase_18", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), traceId, isAll, dBRoute.getRouteKey(), e.getMessage(), sql, stack);
                    DeployLog.error(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u811a\u672c\u6587\u4ef6\uff1a%1$s\u4e2d\uff0c\u7b2c%2$s\u6761SQL\u6267\u884c\u51fa\u9519\uff0c\u811a\u672c\u6587\u4ef6\u5185\u8fd8\u6709%3$s\u6761sql\u672a\u6267\u884c", (String)"DeplayDataModelBase_19", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), sqlScript.getFilePath(), i, sqlCount - i), e);
                    throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{msg, e});
                }
                if (isAll) {
                    if (sql.length() > 30) {
                        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format("execute finish! -- dbKey:%s,dbType:%s,sql:%s ... ", dBRoute.getRouteKey(), dbType.toString(), sql.substring(0, 29)));
                    } else {
                        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format("execute finish! -- dbKey:%s,dbType:%s,sql:%s ... ", dBRoute.getRouteKey(), dbType.toString(), sql));
                    }
                }
                if ((cost = (end = new Date().getTime()) - start) <= 1000L) continue;
                DeployLog.warn(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u8d85\u957f\u6267\u884csql\uff0c\u8017\u65f6%1$s \u811a\u672c%2$s sql %3$s", (String)"DeplayDataModelBase_20", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), cost, sqlScript.getName(), sql));
            }
        }
        return success;
    }

    protected boolean deploySingleXml(DeployAppInfo appInfo, SqlScript sqlScript, String fullVer, DeployResult result) {
        String fullPath = sqlScript.getFilePath();
        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Xml, String.format("begin deploy xml file : %s", fullPath));
        try (FileInputStream inputStream = new FileInputStream(fullPath);){
            PreInsDataScriptWriter wr = new PreInsDataScriptWriter();
            wr.insertPreInsData((InputStream)inputStream);
            String msg = String.format("xml file : %s finish! ", fullPath);
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Xml, msg);
            result.addInfo(msg);
        }
        catch (Exception e) {
            appInfo.getDeployInfo().setResult('0');
            String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            DeployLog.error(appInfo.getPkgId(), fullVer, DeployCategory.Xml, msg, e);
            result.addError(msg);
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{msg, e});
        }
        return true;
    }

    protected void setProgress(BigDecimal progress) {
        this.getDeployState().setProgress(progress);
    }

    /*
     * Exception decompiling
     */
    private List<String> readSqlFile(long pkgId, String fullVer, SqlScript sqlScript, DeployResult result) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> readerSqlStatement(BufferedReader br, String separator) throws IOException {
        ArrayList<String> sqlList = new ArrayList<String>();
        String line = null;
        boolean isFirstLine = true;
        StringBuilder sb = new StringBuilder();
        boolean commentLine = false;
        while ((line = br.readLine()) != null) {
            if (line.length() <= 0) continue;
            if (isFirstLine && line.charAt(0) == '\ufeff') {
                line = line.substring(1);
                isFirstLine = false;
            }
            String temp = line.trim();
            if (commentLine) {
                if (!temp.endsWith("*/")) continue;
                commentLine = false;
                continue;
            }
            if (temp.startsWith("/*") && !temp.startsWith("/*dialect*/")) {
                if (temp.endsWith("*/")) continue;
                commentLine = true;
                continue;
            }
            if (temp.startsWith("--")) continue;
            if (!(temp.endsWith(separator) && separator.equals("GO") || StringUtils.isEmpty((CharSequence)temp))) {
                sb.append(" ").append(line).append(" ");
            }
            if (temp.endsWith(separator)) {
                sqlList.add(sb.toString());
                sb = new StringBuilder();
            }
            if (!temp.toLowerCase(Locale.ENGLISH).startsWith("use ")) continue;
            throw new KDException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301use database\u8bed\u53e5\uff0c\u8bf7\u68c0\u67e5\u811a\u672c", (String)"DeplayDataModelBase_22", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
        }
        return sqlList;
    }

    static {
        dbrouteErrorLevel = Boolean.parseBoolean(System.getProperty(deploy_no_dbroute_error));
        rebuildFailErrorLevel = Boolean.parseBoolean(System.getProperty(DEPLOY_ERROR_REBUILD_FAILE));
        ConfigurationUtil.observeChange((String)deploy_no_dbroute_error, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                dbrouteErrorLevel = Boolean.parseBoolean(System.getProperty(deploy_no_dbroute_error));
            }
        });
        queryTimeout = Integer.parseInt(System.getProperty(deploy_query_timeout, "0"));
        ConfigurationUtil.observeChange((String)deploy_query_timeout, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                queryTimeout = Integer.parseInt(System.getProperty(deploy_query_timeout, "0"));
            }
        });
    }
}

