/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade.deploy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.service.upgrade.deploy.BatchExcutorOne;
import kd.bos.service.upgrade.entity.DeployAppInfo;
import kd.bos.service.upgrade.entity.DeployCategory;
import kd.bos.service.upgrade.entity.DeployLog;
import kd.bos.service.upgrade.entity.DeployResult;
import kd.bos.service.upgrade.entity.SqlScript;
import kd.bos.util.ExceptionUtils;

class DeployBatchSql {
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private static int BATCH_SIZE = 1000;
    private boolean dbrouteErrorLevel;

    public DeployBatchSql() {
    }

    public DeployBatchSql(boolean dbrouteErrorLevel) {
        this.dbrouteErrorLevel = dbrouteErrorLevel;
    }

    protected boolean execute(DeployAppInfo appInfo, SqlScript sqlScript, String fullVer, DeployResult result) throws IOException {
        List<Map<String, Object>> sqlList = this.readSqlFile(appInfo.getPkgId(), fullVer, sqlScript, result);
        if (sqlList == null || sqlList.isEmpty()) {
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u811a\u672c\uff1a%s sql\u6570\u91cf\u4e3a0\uff0c\u9000\u51fa\u90e8\u7f72\u3002", (String)"DeployBatchSql_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), sqlScript.getName()));
            return true;
        }
        Map<Object, Object> dbRoutes = new HashMap<String, DBRoute>();
        if ("all".equalsIgnoreCase(sqlScript.getDbKey())) {
            dbRoutes = appInfo.getDeployInfo().getAllDBRoutes();
        } else {
            dbRoutes.put(sqlScript.getDbKey(), new DBRoute(sqlScript.getDbKey()));
        }
        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"deploy script: %1$s  \u5373\u5c06\u5728%2$s\u4e2a\u5e93\u6267\u884c .", (String)"DeplayDataModelBase_14", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), sqlScript.getName(), dbRoutes.size()));
        boolean success = true;
        for (DBRoute dBRoute : dbRoutes.values()) {
            DBType dbType = null;
            try {
                dbType = DB.getDBType((DBRoute)dBRoute);
            }
            catch (Exception e) {
                String stackMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                String msg = String.format(ResManager.loadKDString((String)"\u83b7\u53d6DBType\u51fa\u9519\uff0cDBRouteKey: %1$s , script: %2$s, \u9519\u8bef\u4fe1\u606f\uff1a%3$s ----\uff0c%4$s\u5806\u6808\uff1a%5$s", (String)"DeplayDataModelBase_15", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), dBRoute.getRouteKey(), sqlScript.getName(), e.getMessage(), System.lineSeparator(), stackMsg);
                if (this.dbrouteErrorLevel) {
                    result.addError(msg);
                    DeployLog.error(appInfo.getPkgId(), fullVer, DeployCategory.Script, msg, e);
                }
                result.addWarn(msg);
                DeployLog.warn(appInfo.getPkgId(), fullVer, DeployCategory.Script, msg);
            }
            if (dbType == null) {
                String sqlStr = sqlScript.getFilePath();
                DeployLog.warn(appInfo.getPkgId(), fullVer, DeployCategory.Script, String.format(ResManager.loadKDString((String)"\u83b7\u53d6DBType\u4e3a\u7a7a\uff0cDBRouteKey: %1$s , script: %2$s , sql: %3$s", (String)"DeplayDataModelBase_16", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), dBRoute.getRouteKey(), sqlScript.getName(), sqlStr));
                success = false;
                continue;
            }
            BatchExcutorOne batchExcutor = new BatchExcutorOne();
            batchExcutor.batchInsert(appInfo.getPkgId(), fullVer, sqlList, dBRoute);
        }
        return success;
    }

    private List<Map<String, Object>> readSqlFile(long pkgId, String fullVer, SqlScript sqlScript, DeployResult result) throws IOException {
        StringBuilder sb;
        block39: {
            sb = new StringBuilder();
            File file = new File(sqlScript.getFilePath());
            if (file.isFile() && file.exists()) {
                try (FileInputStream inputStream = new FileInputStream(file);
                     InputStreamReader read = new InputStreamReader((InputStream)inputStream, "UTF-8");
                     BufferedReader br = new BufferedReader(read);){
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        sb.append(line.trim());
                    }
                    break block39;
                }
            }
            String msg = String.format(ResManager.loadKDString((String)"\u6587\u4ef6%s\u4e0d\u5b58\u5728\uff01", (String)"DeplayDataModelBase_21", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), sqlScript.getFilePath());
            result.addError(msg);
            DeployLog.error(pkgId, fullVer, DeployCategory.Script, msg, null);
        }
        if (sb.length() <= 0) {
            return new ArrayList<Map<String, Object>>(0);
        }
        return (List)SerializationUtils.fromJsonString((String)sb.toString(), List.class);
    }

    public boolean isDbrouteErrorLevel() {
        return this.dbrouteErrorLevel;
    }

    public void setDbrouteErrorLevel(boolean dbrouteErrorLevel) {
        this.dbrouteErrorLevel = dbrouteErrorLevel;
    }

    static class Column {
        private String name;
        private int type;
        private int index;

        public Column() {
        }

        public Column(String name, int type, int index) {
            this.name = name;
            this.type = type;
            this.index = index;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }
}

