/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade.deploy;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.gray.GrayAppInfo;
import kd.bos.entity.gray.GrayInfo;
import kd.bos.entity.gray.MetaGrayInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.BuildFormDesignMeta;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.DesignMetaL;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetaRebuilder;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.metadata.deploy.DeployParameter;
import kd.bos.metadata.deploy.MetaDeploy;
import kd.bos.metadata.deploy.gray.GrayDeployMetadataWriter;
import kd.bos.metadata.devportal.AppDesignMetaReader;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.DesignEntityMetaL;
import kd.bos.metagray.MetaGrayService;
import kd.bos.mservice.print.BosPrintBusinessService;
import kd.bos.mservice.print.param.PrintDeployFile;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.model.perm.req.upgrade.PermUpgradePreProcessFile;
import kd.bos.schedule.deploy.IScheduleDeployService;
import kd.bos.service.DeployServiceFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.IMetadataDeployService;
import kd.bos.service.metadata.MetadataDeployFile;
import kd.bos.service.metadata.MetadataDeployResult;
import kd.bos.service.metadata.MetadataServiceImpl;
import kd.bos.service.upgrade.AbsractVersion;
import kd.bos.service.upgrade.DeployPackageInfo;
import kd.bos.service.upgrade.after.DeployPackageApp;
import kd.bos.service.upgrade.deploy.DeplayDataModelBase;
import kd.bos.service.upgrade.deploy.extplugin.DefDeployMetaSubPlugin;
import kd.bos.service.upgrade.deploy.extplugin.DeployBeforeArgs;
import kd.bos.service.upgrade.deploy.extplugin.IDeployMetaSubPlugin;
import kd.bos.service.upgrade.deploy.extplugin.IPluginProxyUtil;
import kd.bos.service.upgrade.deploy.extplugin.PluginProxyImpl;
import kd.bos.service.upgrade.entity.DeployAppInfo;
import kd.bos.service.upgrade.entity.DeployCategory;
import kd.bos.service.upgrade.entity.DeployInfo;
import kd.bos.service.upgrade.entity.DeployLog;
import kd.bos.service.upgrade.entity.DeployParam;
import kd.bos.service.upgrade.entity.DeployResult;
import kd.bos.service.upgrade.entity.DeployScriptInfo;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.sqlscript.PreInsDataScriptWriter;
import kd.bos.upgrade.ExtJarApi;
import kd.bos.util.ExceptionUtils;

public class DeployDataModel
extends DeplayDataModelBase {
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private static final String ERROR = "error";
    private static final String FAILED = "failed";
    private static final String RESULT = "result";
    private static final String ERROR_INFO = "errorInfo";
    private static final String MESSAGE = "message";
    private static final String ZH_CN = "zh_CN";
    private IPluginProxyUtil pluginProxyUtil = new PluginProxyImpl();

    @Override
    public boolean checkVer(AbsractVersion deployingVer) {
        return deployingVer.checkVer() && deployingVer.checkRely();
    }

    @Override
    public void deployByAppId(DeployAppInfo appInfo, DeployResult result, int category) throws IOException {
        String fullVer = String.format("%s.%s", appInfo.getVer(), appInfo.getDeployInfo().getIteration());
        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Package, String.format("begin deploy app %s  ...", appInfo.getName()));
        ArrayList<String> existSqlFile = new ArrayList<String>(10);
        if (!appInfo.getScriptInfoList().isEmpty() || !appInfo.getXmlFileList().isEmpty()) {
            long start = new Date().getTime();
            existSqlFile.addAll(DeployScriptInfo.existScript(appInfo));
            long end = new Date().getTime();
            long cost = end - start;
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5e94\u7528%1$s\u4e0b\u811a\u672c\u6267\u884c\u8bb0\u5f55\u8017\u65f6:%2$s.", (String)"DeployDataModel_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), appInfo.getName(), cost));
        }
        if (this.isBigTablePack()) {
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u6267\u884c\u5e94\u7528%s\u5927\u8868\u8865\u4e01.", (String)"DeployDataModel_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), appInfo.getName()));
            this.deployScript(appInfo, category, result, existSqlFile);
        } else {
            if (category == 0 || (category & 2) == 2 || (category & 8) == 8 || (category & 0x10) == 16) {
                this.deployScript(appInfo, category, result, existSqlFile);
            }
            if (category == 0 || (category & 4) == 4) {
                this.deployXml(appInfo, result, existSqlFile);
            }
            if (category == 0 || (category & 1) == 1) {
                this.deployDym(appInfo, result);
            }
            if (category == 0 || (category & 0x20) == 32) {
                this.deployJar(appInfo, result);
            }
        }
        appInfo.setProgVal(new BigDecimal(1));
        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Package, String.format("end deploy app %s.", appInfo.getName()));
    }

    public Map<String, Object> releaseGray(DeployParam deployParam) {
        String appGroup = deployParam.getAppGroup();
        this.setAppGroup(appGroup);
        DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, String.format("Release Gray %s begin...", appGroup));
        Map<String, Object> retMap = this.executeReleaseGray(deployParam);
        DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, String.format("Release Gray %s end.", appGroup));
        DeployInfo deployInfo = this.createDeployInfo(deployParam);
        deployInfo.setDescription("release gray");
        String result = (String)retMap.get(RESULT);
        boolean clearSchGrayConfig = false;
        if ("1".equals(result)) {
            deployInfo.setResult('1');
            clearSchGrayConfig = true;
        } else if ("0".equals(result)) {
            deployInfo.setResult('0');
        } else {
            deployInfo.setResult('5');
        }
        if (clearSchGrayConfig) {
            HashMap<String, String> params = new HashMap<String, String>(3);
            params.put("group", appGroup);
            ScheduleServiceHelper.stopGray(params);
        }
        DeployPackageInfo.saveDeployInfo(deployInfo, DeployInfo.class);
        return retMap;
    }

    private Map<String, Object> executeReleaseGray(DeployParam deployParam) {
        String err;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(RESULT, "1");
        String appGroup = this.getAppGroup();
        MetaGrayService mgs = new MetaGrayService();
        GrayInfo currentGrayInfo = mgs.getGrayInfo(appGroup);
        String grayInfoStatus = "0";
        if (currentGrayInfo != null) {
            grayInfoStatus = currentGrayInfo.getReleaseStatus();
        }
        DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, "status:" + grayInfoStatus);
        if ("1".equals(grayInfoStatus)) {
            map.put(RESULT, "5");
            map.put(MESSAGE, ResManager.loadKDString((String)"\u7070\u5ea6\u5df2\u7ed3\u675f\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed3\u675f\u3002", (String)"DeployDataModel_2", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
            DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, ResManager.loadKDString((String)"\u7070\u5ea6\u5df2\u7ed3\u675f\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed3\u675f.", (String)"DeployDataModel_3", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
            return map;
        }
        GrayDeployMetadataWriter writer = new GrayDeployMetadataWriter(appGroup);
        if ("0".equals(grayInfoStatus)) {
            try {
                DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, "releaseGray begin ...");
                writer.releaseGray();
                grayInfoStatus = "2";
                mgs.updateGrayInfoStatus(appGroup, "2");
                map.put(MESSAGE, "releaseGray finish");
                DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, "releaseGray finish, status:STATUS_METAUPDATED.");
            }
            catch (Exception e) {
                map.put(RESULT, "0");
                String err2 = String.format("releaseGray failed, error: %s", this.getErrorMsg(e));
                map.put(MESSAGE, err2);
                DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, err2);
                return map;
            }
        }
        if ("2".equals(grayInfoStatus)) {
            try {
                MetaRebuilder mr = new MetaRebuilder(appGroup);
                List metas = null;
                List appInfos = null;
                metas = mr.getAllRebuildFormDesignMeta();
                MetaRebuilder nativeMr = new MetaRebuilder("defaultGroup");
                AppDesignMetaReader amr = new AppDesignMetaReader();
                ArrayList<String> rebuildMetaIds = new ArrayList<String>(mgs.getMasterMetaGrayInfoByGroup(appGroup).size());
                for (MetaGrayInfo meta : mgs.getMasterMetaGrayInfoByGroup(appGroup)) {
                    rebuildMetaIds.add(meta.getId());
                }
                List nativeMetas = nativeMr.getRebuildFormDesignMeta(rebuildMetaIds);
                ArrayList<String> graySubMetaIds = new ArrayList<String>(nativeMetas.size());
                for (BuildFormDesignMeta meta : nativeMetas) {
                    if (rebuildMetaIds.contains(meta.getId())) continue;
                    graySubMetaIds.add(meta.getId());
                }
                try {
                    MetadataServiceImpl metaImpl = new MetadataServiceImpl();
                    Map<String, Object> rebuildResult = metaImpl.rebuildRunTimeFormMetas(graySubMetaIds);
                    DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, "rebuild child meta success, result:" + JSON.toJSONString(rebuildResult, (boolean)true));
                }
                catch (Exception e) {
                    DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, "rebuild child meta failed,:" + this.getErrorMsg(e));
                }
                appInfos = mgs.getGrayAppInfo(this.getAppGroup());
                if (metas != null) {
                    this.clearMetaCache("defaultGroup", metas);
                    DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, "clear metaCache:" + metas.size());
                }
                if (appInfos != null) {
                    this.clearAppCache("defaultGroup", appInfos);
                    DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, "clear appCache:" + appInfos.size());
                }
                this.clearPermCache();
                grayInfoStatus = "3";
                mgs.updateGrayInfoStatus(appGroup, "3");
                map.put(MESSAGE, "clearCache finish");
                DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, "clearCache finish");
            }
            catch (Exception e) {
                map.put(RESULT, "0");
                String err3 = String.format("releaseGray finish,clearcache failed, error: %s", this.getErrorMsg(e));
                map.put(MESSAGE, err3);
                DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, err3);
                return map;
            }
        }
        if ("3".equals(grayInfoStatus)) {
            try {
                writer.dropGrayTable();
                grayInfoStatus = "4";
                mgs.updateGrayInfoStatus(appGroup, "4");
                mgs.removeGrayMeta(appGroup);
                map.put(MESSAGE, "dropTable finish");
                DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, "dropTable finish");
            }
            catch (Exception e) {
                map.put(RESULT, "0");
                err = String.format("dropTable failed, error: %s", this.getErrorMsg(e));
                map.put(MESSAGE, err);
                DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, err);
                return map;
            }
        }
        try {
            if ("4".equals(grayInfoStatus)) {
                DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, "release grayinfo. status:" + grayInfoStatus);
                mgs.releaseGrayInfo(appGroup);
                grayInfoStatus = "1";
            }
            map.put(MESSAGE, "release grayinfo finish");
            DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, "release grayinfo finish");
        }
        catch (Exception e) {
            map.put(RESULT, "5");
            err = String.format("releaseGray and dropTable finish, releaseGrayInfo failed, error: %s", this.getErrorMsg(e));
            map.put(MESSAGE, err);
            DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, err);
        }
        return map;
    }

    public Map<String, Object> stopGray(DeployParam deployParam) {
        String appGroup = deployParam.getAppGroup();
        this.setAppGroup(appGroup);
        DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, String.format("stop Gray %s begin...", appGroup));
        Map<String, Object> retMap = this.executeStopGray(deployParam);
        DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, String.format("stop Gray %s end.", appGroup));
        DeployInfo deployInfo = this.createDeployInfo(deployParam);
        deployInfo.setDescription("stop gray");
        String result = (String)retMap.get(RESULT);
        boolean clearSchGrayConfig = false;
        if ("1".equals(result)) {
            deployInfo.setResult('1');
            clearSchGrayConfig = true;
        } else if ("0".equals(result)) {
            deployInfo.setResult('0');
        } else {
            deployInfo.setResult('5');
        }
        if (clearSchGrayConfig) {
            HashMap<String, String> params = new HashMap<String, String>(3);
            params.put("group", appGroup);
            ScheduleServiceHelper.stopGray(params);
        }
        DeployPackageInfo.saveDeployInfo(deployInfo, DeployInfo.class);
        return retMap;
    }

    public void dropGrayBackTable(Map<String, Object> param) {
        GrayDeployMetadataWriter writer = new GrayDeployMetadataWriter(this.getAppGroup());
        writer.dropGrayBackTable();
    }

    private Map<String, Object> executeStopGray(DeployParam deployParam) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String appGroup = this.getAppGroup();
        MetaGrayService mgs = new MetaGrayService();
        GrayInfo currentGrayInfo = mgs.getGrayInfo(appGroup);
        String grayInfoStatus = "0";
        if (currentGrayInfo != null) {
            grayInfoStatus = currentGrayInfo.getReleaseStatus();
        }
        if ("1".equals(grayInfoStatus)) {
            map.put(RESULT, "5");
            map.put(MESSAGE, ResManager.loadKDString((String)"\u7070\u5ea6\u5df2\u7ed3\u675f\uff0c\u4e0d\u80fd\u7ec8\u6b62\u3002", (String)"DeployDataModel_4", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
            DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, ResManager.loadKDString((String)"\u7070\u5ea6\u5df2\u7ed3\u675f\uff0c\u4e0d\u80fd\u7ec8\u6b62\u3002", (String)"DeployDataModel_4", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
            return map;
        }
        if (!"0".equals(grayInfoStatus) && !"9".equals(grayInfoStatus)) {
            map.put(RESULT, "5");
            map.put(MESSAGE, ResManager.loadKDString((String)"\u7070\u5ea6\u6570\u636e\u5df2\u66f4\u65b0\uff0c\u4e0d\u80fd\u7ec8\u6b62\u7070\u5ea6\u3002", (String)"DeployDataModel_5", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
            DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, ResManager.loadKDString((String)"\u7070\u5ea6\u6570\u636e\u5df2\u66f4\u65b0\uff0c\u4e0d\u80fd\u7ec8\u6b62\u7070\u5ea6\u3002", (String)"DeployDataModel_5", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
            return map;
        }
        DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, "status:" + grayInfoStatus);
        GrayDeployMetadataWriter writer = new GrayDeployMetadataWriter(appGroup);
        try {
            block10: {
                MetaRebuilder mr = new MetaRebuilder(appGroup);
                List metas = null;
                List appInfos = null;
                if (DB.exitsTable((DBRoute)DBRoute.meta, (String)("T_META_FORM_" + appGroup))) {
                    metas = mr.getAllRebuildFormDesignMeta();
                }
                appInfos = mgs.getGrayAppInfo(this.getAppGroup());
                if (metas != null) {
                    this.clearMetaCache("defaultGroup", metas);
                    DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, "clear metaCache:" + metas.size());
                }
                if (appInfos != null) {
                    this.clearAppCache("defaultGroup", appInfos);
                    DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, "clear appCache:" + appInfos.size());
                }
                mgs.removeGrayMeta(appGroup);
                try {
                    DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, "removeGrayMeta finish");
                    writer.dropGrayTable();
                    DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, "dropGrayTable finish");
                }
                catch (Exception e) {
                    String tenantId = RequestContext.get().getTenantId();
                    String ignoreError = SystemPropertyUtils.getProptyByTenant((String)"deploy.stopgray.ignoreerror", (String)tenantId);
                    if (!StringUtils.isBlank((CharSequence)ignoreError) && Boolean.parseBoolean(ignoreError)) break block10;
                    throw e;
                }
            }
            mgs.updateGrayInfoStatus(appGroup, "9");
            DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, "update grayinfo status finish");
        }
        catch (Exception e) {
            map.put(RESULT, "0");
            String err = String.format("stop gray failed, error: %s", this.getErrorMsg(e));
            map.put(MESSAGE, err);
            DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, err);
            return map;
        }
        map.put(RESULT, "1");
        map.put(MESSAGE, "stop gray finish");
        DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, "stop gray finish");
        return map;
    }

    private void deployJar(DeployAppInfo appInfo, DeployResult result) {
        block17: {
            try {
                String dmFilePath = appInfo.getDeployInfo().getFileName();
                File file = new File(dmFilePath);
                File rootPath = file.getParentFile();
                if (rootPath == null) {
                    String msg = String.format(ResManager.loadKDString((String)"\u90e8\u7f72\u6587\u4ef6%s\u6ca1\u6709\u6839\u76ee\u5f55\uff0c\u65e0\u6cd5\u6267\u884cJar\u5305\u66f4\u65b0\u3002", (String)"DeployDataModel_6", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), dmFilePath);
                    DeployLog.warn(appInfo.getPkgId(), appInfo.getDeployInfo().getFullVer(), DeployCategory.Jar, msg);
                    result.addError(msg);
                    return;
                }
                Path jarPath = Paths.get(rootPath.getPath(), "hotswap");
                DeployLog.info(appInfo.getPkgId(), appInfo.getDeployInfo().getFullVer(), DeployCategory.Jar, String.format("jar path : %s begin ... ", jarPath));
                File path = jarPath.toFile();
                if (path.isDirectory()) {
                    String[] files = path.list();
                    if (files == null) break block17;
                    ArrayList list = new ArrayList(files.length);
                    for (String fileName : files) {
                        byte[] jarByte;
                        HashMap<String, Object> map = new HashMap<String, Object>(4);
                        try (InputStream inputStream = Files.newInputStream(new File(path + File.separator + fileName).toPath(), new OpenOption[0]);){
                            jarByte = this.getJarData(inputStream);
                        }
                        map.put("name", fileName);
                        map.put("desc", String.format(ResManager.loadKDString((String)"\u90e8\u7f72%s", (String)"DeployDataModel_8", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), fileName));
                        map.put("jar", jarByte);
                        map.put("app", "mdl");
                        map.put("isv", appInfo.getDeployInfo().getIsv());
                        list.add(map);
                        DeployLog.info(appInfo.getPkgId(), appInfo.getDeployInfo().getFullVer(), DeployCategory.Jar, String.format("read jar path : %s ,size: %s", fileName, jarByte.length));
                    }
                    ExtJarApi.save(list);
                    ExtJarApi.reset((String)RequestContext.get().getAccountId());
                    break block17;
                }
                String msg = String.format("no jar path : %s ", jarPath);
                DeployLog.info(appInfo.getPkgId(), appInfo.getDeployInfo().getFullVer(), DeployCategory.Jar, msg);
                result.addInfo(msg);
            }
            catch (Throwable e) {
                appInfo.getDeployInfo().setResult('0');
                String msg = DeployLog.getExceptionStackTraceMessage(e);
                DeployLog.error(appInfo.getPkgId(), appInfo.getDeployInfo().getFullVer(), DeployCategory.Jar, msg, e);
                result.addError(msg);
            }
        }
    }

    private byte[] getJarData(InputStream zipIn) throws IOException {
        int readLength;
        byte[] buf = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((readLength = zipIn.read(buf, 0, 1024)) != -1) {
            bos.write(buf, 0, readLength);
        }
        bos.flush();
        bos.close();
        return bos.toByteArray();
    }

    private void deployDym(DeployAppInfo appInfo, DeployResult result) {
        String fullVer = appInfo.getDeployInfo().getFullVer();
        List<String> metaFileList = appInfo.getMetaFileList();
        if (metaFileList.isEmpty()) {
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u5e94\u7528 %s\u4e0b\u65e0\u5143\u6570\u636e\u6587\u4ef6\uff0c\u9000\u51fa\u90e8\u7f72\u5143\u6570\u636e.", (String)"DeployDataModel_9", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), appInfo.getName()));
            return;
        }
        ArrayList<String> rebuildMetaIds = new ArrayList<String>();
        HashSet<String> rebuildAppMetaIds = new HashSet<String>();
        ArrayList<DeployMetadata> deployMetaList = new ArrayList<DeployMetadata>();
        int i = 0;
        long start = new Date().getTime();
        Map map = new HashMap(1);
        map = StringUtils.isBlank((CharSequence)this.getLocaleId()) || ZH_CN.equalsIgnoreCase(this.getLocaleId()) ? MetadataDao.getMetaVersion((String)appInfo.getName()) : MetadataDao.getMetaLVersion((String)appInfo.getName(), (String)this.getLocaleId());
        long end = new Date().getTime();
        long cost = end - start;
        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5e94\u7528%1$s\u4e0b\u5143\u6570\u636e\u7248\u672c\u8017\u65f6:%2$s.", (String)"DeployDataModel_10", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), appInfo.getName(), cost));
        DeployParameter param = new DeployParameter();
        param.setAppGroup(this.getAppGroup());
        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u90e8\u7f72dym, appgroup\uff1a%s.", (String)"DeployDataModel_11", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), this.getAppGroup()));
        MetaDeploy metaDeploy = new MetaDeploy(param);
        ArrayList<String> numChangedList = new ArrayList<String>(10);
        for (String dymPath : metaFileList) {
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Dym, String.format("dym path : %s begin ... ", dymPath));
            File path = new File(dymPath);
            if (path.isDirectory()) {
                String[] files;
                for (String fileName : files = path.list()) {
                    if (appInfo.getResult() == 2) {
                        appInfo.setResult(1);
                    }
                    String fullPath = dymPath + File.separatorChar + fileName;
                    try {
                        byte[] contentBytes = this.readerDym(fullPath);
                        String content = new String(contentBytes, "UTF-8");
                        String msg = String.format("dym file : %s finish! ", fileName);
                        if (DeployServiceFactory.isExistService((String)fileName)) {
                            this.deployMetadataFile(appInfo, fullVer, fileName, contentBytes);
                        } else if (fileName.endsWith(".ks") || fileName.endsWith(".ts")) {
                            metaDeploy.deployScript(content);
                        } else if (fileName.endsWith(".card")) {
                            if (!this.isGray()) {
                                metaDeploy.deployCard(content);
                            }
                        } else if (fileName.endsWith(".sch")) {
                            if (!this.isGray()) {
                                metaDeploy.deploySchema(content);
                            }
                        } else if (fileName.endsWith(".schdata")) {
                            IScheduleDeployService service = (IScheduleDeployService)ServiceFactory.getService((String)"IScheduleDeployService");
                            HashMap<String, String> params = new HashMap<String, String>(4);
                            params.put("path", appInfo.getName());
                            params.put("filename", fileName);
                            params.put("deployMode", "upgrade");
                            service.deployXml(params, content);
                        } else if (fileName.endsWith(".prt") || fileName.endsWith(".prtx")) {
                            BosPrintBusinessService printBusinessService = (BosPrintBusinessService)ServiceFactory.getService(BosPrintBusinessService.class);
                            PrintDeployFile printDeployFile = new PrintDeployFile();
                            printDeployFile.setFileName(fileName);
                            printDeployFile.setContent(content);
                            ArrayList<PrintDeployFile> prtList = new ArrayList<PrintDeployFile>(1);
                            prtList.add(printDeployFile);
                            printBusinessService.deployPrintFile(prtList);
                        } else if (fileName.endsWith(".perm")) {
                            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
                            PermUpgradePreProcessFile permUpgradePreProcessFile = new PermUpgradePreProcessFile();
                            permUpgradePreProcessFile.setFileName(fileName);
                            permUpgradePreProcessFile.setContent(content);
                            ArrayList<PermUpgradePreProcessFile> fileList = new ArrayList<PermUpgradePreProcessFile>(1);
                            fileList.add(permUpgradePreProcessFile);
                            permissionService.upgradePreProcess(fileList);
                        } else if (fileName.endsWith(".cld") || fileName.endsWith(".cldx")) {
                            metaDeploy.deployCloud(content);
                        } else if (fileName.endsWith(".app") || fileName.endsWith(".appx")) {
                            rebuildAppMetaIds.addAll(metaDeploy.deployAppMetadata(content));
                        } else if (fileName.endsWith(".dynplug") || fileName.endsWith(".dynplugbind")) {
                            metaDeploy.deployDynPlugin(fileName, content);
                        } else {
                            DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
                            serializer.setColloctionIgnorePKValue(true);
                            DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(content, null);
                            Long oldVer = (Long)map.get(deployNew.getId());
                            if (oldVer == null || deployNew.getVersion() != oldVer.longValue()) {
                                DeployBeforeArgs beforeArgs = new DeployBeforeArgs(deployNew);
                                DefDeployMetaSubPlugin defDeployMetaSubPlugin = new DefDeployMetaSubPlugin();
                                PluginProxy<IDeployMetaSubPlugin> pluginProxy = this.pluginProxyUtil.create(defDeployMetaSubPlugin, IDeployMetaSubPlugin.class);
                                pluginProxy.callBefore(p -> {
                                    p.beforeDeploy(beforeArgs);
                                    return null;
                                });
                                if (beforeArgs.isCancel()) {
                                    DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e:%1$s\u68c0\u67e5\u4e0d\u901a\u8fc7\u53d6\u6d88\u6267\u884c\uff0c\u539f\u56e0\uff1a%2$s", (String)"DeployDataModel_20", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), fileName, beforeArgs.getMessage()));
                                    continue;
                                }
                                if (StringUtils.isNotBlank((CharSequence)beforeArgs.getMessage())) {
                                    DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Dym, String.format(ResManager.loadKDString((String)"%1$s\u5143\u6570\u636e\u68c0\u67e5:%2$s", (String)"DeployDataModel_21", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), fileName, beforeArgs.getMessage()));
                                }
                                this.addNumberChangeList(deployNew, numChangedList);
                                rebuildMetaIds.add(metaDeploy.deployMetadata(deployNew));
                                deployMetaList.add(deployNew);
                            } else {
                                msg = String.format(ResManager.loadKDString((String)"dym file : %s \u5143\u6570\u636e\u7248\u672c\u4e0e\u6570\u636e\u4e2d\u5fc3\u4e00\u81f4\uff0c\u4e0d\u91cd\u590d\u6267\u884c ", (String)"DeployDataModel_12", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), fileName);
                            }
                        }
                        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Dym, msg);
                        result.addInfo(msg);
                    }
                    catch (Throwable e) {
                        appInfo.setResult(0);
                        appInfo.getDeployInfo().setResult('0');
                        String msg = "deploy error dym file :" + fileName + DeployLog.getExceptionStackTraceMessage(e);
                        DeployLog.error(appInfo.getPkgId(), fullVer, DeployCategory.Dym, msg, e);
                        result.addError(msg);
                    }
                }
            }
            appInfo.setMetaProgVal(new BigDecimal(++i).divide(new BigDecimal(metaFileList.size()), 10, RoundingMode.HALF_EVEN));
            this.setProgress(appInfo.getDeployInfo().getProgVal());
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Dym, String.format("dym path : %s finish! ", dymPath));
        }
        if (this.isGray()) {
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Dym, "gray deploy dym super meta...");
            this.deploySuperAppMetas(rebuildAppMetaIds);
            this.deploySuperMetas(deployMetaList);
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Dym, String.format("appgroup:%s gray deploy dym super meta finish!", this.getAppGroup()));
            this.saveGrayMetaInfo(appInfo, deployMetaList, result);
        }
        this.rebuildMetas(appInfo, result, fullVer, rebuildMetaIds, rebuildAppMetaIds);
        if (!numChangedList.isEmpty()) {
            this.recordAfterRebuildApp(numChangedList);
        }
    }

    private void saveGrayMetaInfo(DeployAppInfo appInfo, List<DeployMetadata> deployMetaList, DeployResult result) {
        MetaGrayService mgs = new MetaGrayService();
        ArrayList<MetaGrayInfo> grayInfoList = new ArrayList<MetaGrayInfo>();
        HashSet<String> ids = new HashSet<String>(deployMetaList.size());
        HashSet<String> numbers = new HashSet<String>(deployMetaList.size());
        HashMap<String, String> metaNames = new HashMap<String, String>();
        for (DeployMetadata deployNew : deployMetaList) {
            for (AbstractDesignMeta designMeta : deployNew.getDesignMetas()) {
                if (!(designMeta instanceof DesignMetaL) || designMeta instanceof DesignEntityMetaL) continue;
                metaNames.put(designMeta.getId(), ((DesignMetaL)designMeta).getName());
            }
        }
        for (DeployMetadata deployNew : deployMetaList) {
            for (AbstractDesignMeta designMeta : deployNew.getDesignMetas()) {
                if (!(designMeta instanceof DesignMeta) || designMeta instanceof DesignEntityMeta) continue;
                if (ids.contains(designMeta.getId())) {
                    result.addWarn(String.format(" Duplicate metadata Id:%s", designMeta.getId()));
                    continue;
                }
                ids.add(designMeta.getId());
                if (numbers.contains(designMeta.getNumber())) {
                    result.addWarn(String.format(" Duplicate metadata number:%s", designMeta.getNumber()));
                    continue;
                }
                numbers.add(designMeta.getNumber());
                MetaGrayInfo grayInfo = new MetaGrayInfo();
                grayInfo.setId(designMeta.getId());
                String number = designMeta.getNumber();
                String modelType = ((DesignMeta)designMeta).getModelType();
                if (modelType.equals("ConvertRuleModel")) {
                    number = designMeta.getId();
                }
                grayInfo.setNumber(number);
                String metaName = (String)metaNames.get(designMeta.getId());
                if (StringUtils.isBlank((CharSequence)metaName)) {
                    metaName = " ";
                }
                grayInfo.setName(metaName);
                grayInfo.setModelType(((DesignMeta)designMeta).getModelType());
                grayInfo.setAppId(appInfo.getName());
                grayInfo.setAppGroup(this.getAppGroup());
                grayInfoList.add(grayInfo);
            }
        }
        mgs.saveMetaGrayInfo(grayInfoList);
        GrayInfo grayInfo = new GrayInfo();
        grayInfo.setAppGroup(this.getAppGroup());
        grayInfo.setVer(appInfo.getDeployInfo().getFullVer());
        grayInfo.setCreateTime(appInfo.getDeployInfo().getExecTime());
        grayInfo.setReleaseStatus("0");
        mgs.saveGrayInfo(grayInfo);
    }

    private void deployXml(DeployAppInfo appInfo, DeployResult result, List<String> existSqlFile) {
        List<String> xmlFileList = appInfo.getXmlFileList();
        String fullVer = appInfo.getDeployInfo().getFullVer();
        int i = 0;
        boolean success = true;
        ArrayList<String> xmlFileNames = new ArrayList<String>();
        for (String xmlDataPath : xmlFileList) {
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Xml, String.format("xml path : %s begin ... ", xmlDataPath));
            File path = new File(xmlDataPath);
            if (path.isDirectory()) {
                String[] files;
                for (String fileName : files = path.list()) {
                    if (existSqlFile.contains(fileName)) {
                        String msg = String.format(ResManager.loadKDString((String)"xml:%s\u5df2\u6267\u884c\uff0c\u4e0d\u518d\u91cd\u590d\u6267\u884c\uff01", (String)"DeployDataModel_13", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), fileName);
                        result.addInfo(msg);
                        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Xml, msg);
                        continue;
                    }
                    if (appInfo.getResult() == 2) {
                        appInfo.setResult(1);
                    }
                    DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Xml, String.format("begin deploy xml file : %s", fileName));
                    String fullPath = xmlDataPath + File.separatorChar + fileName;
                    try (FileInputStream inputStream = new FileInputStream(fullPath);){
                        PreInsDataScriptWriter wr = new PreInsDataScriptWriter();
                        wr.insertPreInsData((InputStream)inputStream);
                        String msg = String.format("xml file : %s finish! ", fileName);
                        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Xml, msg);
                        result.addInfo(msg);
                        xmlFileNames.add(fileName);
                    }
                    catch (Exception e) {
                        success = false;
                        appInfo.getDeployInfo().setResult('0');
                        String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                        DeployLog.error(appInfo.getPkgId(), fullVer, DeployCategory.Xml, msg, e);
                        result.addError(msg);
                    }
                }
            }
            appInfo.setXmlProgVal(new BigDecimal(++i).divide(new BigDecimal(xmlFileList.size()), 10, RoundingMode.HALF_EVEN));
            this.setProgress(appInfo.getDeployInfo().getProgVal());
            if (success) {
                for (String filename : xmlFileNames) {
                    DeployScriptInfo scriptInfo = new DeployScriptInfo();
                    scriptInfo.setId(DB.genGlobalLongId());
                    scriptInfo.setAppId(appInfo.getName());
                    scriptInfo.setEntryId(appInfo.getId());
                    scriptInfo.setVer(appInfo.getVer());
                    scriptInfo.setFileName(filename);
                    scriptInfo.setExecTime(new Date());
                    DeployPackageInfo.saveDeployInfo(scriptInfo, scriptInfo.getClass());
                }
                DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Xml, String.format("xml path : %s finish! ", xmlDataPath));
                continue;
            }
            appInfo.setResult(0);
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Xml, String.format("xml path : %s finish! ", xmlDataPath));
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] readerDym(String fileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void rebuildMetas(DeployAppInfo appInfo, DeployResult result, String fullVer, List<String> rebuildMetaIds, Set<String> rebuildAppMetaIds) {
        MetadataServiceImpl metaImpl = new MetadataServiceImpl();
        metaImpl.setAppGroup(this.getAppGroup());
        Map<Object, Object> rebuildResult = new ConcurrentHashMap();
        if (this.isGray()) {
            ArrayList<String> failedResult;
            Map<String, Object> map;
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Dym, "gray deploy rebuild meta...");
            HashMap<String, Object> appResult = (HashMap<String, Object>)rebuildResult.get(appInfo.getName());
            if (appResult == null) {
                appResult = new HashMap<String, Object>();
                rebuildResult.put(appInfo.getName(), appResult);
            }
            if (!rebuildMetaIds.isEmpty()) {
                try {
                    map = metaImpl.rebuildRunTimeFormMetas(rebuildMetaIds);
                    this.mergeRebuildResult(appResult, map);
                }
                catch (Exception e) {
                    failedResult = new ArrayList<String>();
                    failedResult.add(String.format(ResManager.loadKDString((String)"\u91cd\u5efa\u5143\u6570\u636e\u5931\u8d25\uff01taskId %1$s bos-mservice-form %2$s ERR:%3$s", (String)"DeployDataModel_14", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), appInfo.getPkgId(), appInfo.getName(), this.getErrorMsg(e)));
                    appResult.put(FAILED, failedResult);
                }
            }
            if (!rebuildAppMetaIds.isEmpty()) {
                try {
                    map = metaImpl.rebuildRunTimeAppMetas(rebuildAppMetaIds);
                    this.mergeRebuildResult(appResult, map);
                }
                catch (Exception e) {
                    failedResult = new ArrayList();
                    failedResult.add(String.format(ResManager.loadKDString((String)"\u6784\u5efa\u5e94\u7528\u5305\u3010%1$s\u3011\u8868\u5355\u5143\u6570\u636e\u5931\u8d25\uff1a%2$s", (String)"DeployDataModel_15", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), appInfo.getName(), this.getErrorMsg(e)));
                    appResult.put(FAILED, failedResult);
                }
            }
        } else if (rebuildMetaIds.size() > 0 || rebuildAppMetaIds.size() > 0) {
            rebuildResult = metaImpl.rebuildRunTimeMetas(appInfo.getName(), rebuildAppMetaIds, rebuildMetaIds);
        }
        if (!rebuildMetaIds.isEmpty() || !rebuildAppMetaIds.isEmpty()) {
            PermissionServiceHelper.clearAllUserAppCache();
        }
        boolean rebuildSuccess = true;
        for (Map.Entry<Object, Object> entry : rebuildResult.entrySet()) {
            Map appResult = (Map)entry.getValue();
            if (appResult.get(FAILED) == null || ((List)appResult.get(FAILED)).size() <= 0) continue;
            rebuildSuccess = false;
        }
        String rebuildMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u91cd\u5efa\u5143\u6570\u636e%1$s, \u5e94\u7528\uff1a%2$s, appgroup:%3$s, \u91cd\u5efa\u7ed3\u679c\uff1a%4$s", (String)"DeployDataModel_17", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), rebuildSuccess ? ResManager.loadKDString((String)"\u6210\u529f", (String)"DeployDataModel_18", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5931\u8d25", (String)"DeployDataModel_19", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), appInfo.getName(), this.getAppGroup(), JSON.toJSONString(rebuildResult, (boolean)true));
        if (!rebuildSuccess) {
            if (rebuildFailErrorLevel) {
                result.addError(rebuildMsg);
                DeployLog.error(appInfo.getPkgId(), fullVer, DeployCategory.Dym, rebuildMsg, (Throwable)new KDException("rebuild fail"));
            } else {
                result.addWarn(rebuildMsg);
                DeployLog.warn(appInfo.getPkgId(), fullVer, DeployCategory.Dym, rebuildMsg);
            }
        } else {
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Dym, rebuildMsg);
        }
    }

    private void mergeRebuildResult(Map<String, Object> appResult, Map<String, Object> map) {
        for (Map.Entry<String, Object> ret : map.entrySet()) {
            Object srcMsgList;
            ArrayList<Object> msgList = (ArrayList<Object>)appResult.get(ret.getKey());
            if (msgList == null) {
                msgList = new ArrayList<Object>();
                appResult.put(ret.getKey(), msgList);
            }
            if ((srcMsgList = map.get(ret.getKey())) instanceof List) {
                msgList.addAll((List)srcMsgList);
                continue;
            }
            msgList.add(srcMsgList);
        }
    }

    private void deploySuperAppMetas(Set<String> rebuildAppMetaIds) {
        AppDesignMetaReader admr = new AppDesignMetaReader();
        admr.setAppGroup(this.getAppGroup());
        Set ids = admr.getExistAppMetas(rebuildAppMetaIds);
        HashSet<String> superAppMetas = new HashSet<String>(16);
        superAppMetas.addAll(rebuildAppMetaIds);
        superAppMetas.removeAll(ids);
        DeployParameter param = new DeployParameter();
        param.setAppGroup(this.getAppGroup());
        MetaDeploy metaDeploy = new MetaDeploy(param);
        metaDeploy.deploySuperMetas("T_META_BIZAPP", superAppMetas.toArray());
        metaDeploy.deploySuperMetas("T_META_BIZAPP_L", superAppMetas.toArray());
    }

    private void deploySuperMetas(List<DeployMetadata> deployMetaList) {
        HashMap classIds = new HashMap();
        for (DeployMetadata deployNew : deployMetaList) {
            for (AbstractDesignMeta abstractDesignMeta : deployNew.getDesignMetas()) {
                String[] superMetas;
                String inheritPath;
                if (!(abstractDesignMeta instanceof DesignMeta)) continue;
                HashSet<String> ids = (HashSet<String>)classIds.get(abstractDesignMeta.getClass());
                if (ids == null) {
                    ids = new HashSet<String>();
                    classIds.put(abstractDesignMeta.getClass(), ids);
                }
                if (!StringUtils.isNotBlank((CharSequence)(inheritPath = ((DesignMeta)abstractDesignMeta).getInheritPath()))) continue;
                for (String meta : superMetas = inheritPath.split(",")) {
                    ids.add(meta.trim());
                }
            }
        }
        DeployParameter param = new DeployParameter();
        param.setAppGroup(this.getAppGroup());
        MetaDeploy metaDeploy = new MetaDeploy(param);
        for (Map.Entry entry : classIds.entrySet()) {
            String tableName = OrmUtils.getDataEntityType((Class)((Class)entry.getKey())).getAlias();
            metaDeploy.deploySuperMetas(tableName, ((Set)entry.getValue()).toArray());
        }
    }

    private void clearMetaCache(String appGroup, List<BuildFormDesignMeta> metas) {
        MetaRebuilder mr = new MetaRebuilder(appGroup);
        mr.clearCache(metas);
    }

    private void clearAppCache(String appGroup, List<GrayAppInfo> appInfos) {
        AppDesignMetaReader appMetaReader = new AppDesignMetaReader();
        appMetaReader.setAppGroup(appGroup);
        for (GrayAppInfo grayAppInfo : appInfos) {
            String appNumber = grayAppInfo.getAppId();
            String appId = appMetaReader.getAppIdByNumber(appNumber);
            if (!StringUtils.isNotBlank((CharSequence)appId)) continue;
            appMetaReader.removeAppNumberAndIdCache(appId, appNumber);
            MetaCacheUtils.removeAppmetaDistributeCache((String)appNumber);
            MetaCacheUtils.removeAppmetaDistributeCache((String)appGroup, (String)appNumber);
        }
        DataEntityCacheManager appCacheManager = new DataEntityCacheManager("t_meta_bizapp");
        appCacheManager.removeByDt();
        MetaRebuilder mr = new MetaRebuilder(appGroup);
        mr.cleanAllAppMetadataCache();
        mr = new MetaRebuilder("defaultGroup");
        mr.cleanAllAppMetadataCache();
        MetadataDao.cleanAllPortalAppCache();
    }

    private void clearPermCache() {
        PermissionServiceHelper.clearAllCache();
    }

    private DeployInfo createDeployInfo(DeployParam deployParam) {
        DeployInfo deployInfo = new DeployInfo();
        deployInfo.setId(deployParam.getTaskId());
        deployInfo.setName(deployParam.getAppGroup());
        deployInfo.setExecTime(new Date());
        String fullVer = deployParam.getFullVer();
        if (StringUtils.isNotBlank((CharSequence)fullVer)) {
            String[] verStrs = deployParam.getFullVer().split("\\.");
            if (verStrs.length > 2) {
                deployInfo.setIteration(verStrs[2]);
            } else {
                deployInfo.setIteration("0");
            }
            String ver = String.format("%s.%s", verStrs[0], verStrs[1]);
            deployInfo.setVer(ver);
        }
        deployInfo.setIsv(deployParam.getIsv());
        return deployInfo;
    }

    private boolean isGray() {
        return StringUtils.isNotBlank((CharSequence)this.getAppGroup());
    }

    /*
     * Exception decompiling
     */
    private String getErrorMsg(Exception e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addNumberChangeList(DeployMetadata deployNew, List<String> numChangedList) {
        String oldNumber = MetadataDao.getNumberById((String)deployNew.getId());
        for (AbstractDesignMeta designMeta : deployNew.getDesignMetas()) {
            if (!(designMeta instanceof DesignMeta) || designMeta instanceof DesignEntityMeta) continue;
            String newNumber = designMeta.getNumber();
            if (!StringUtils.isNotBlank((CharSequence)oldNumber) || !StringUtils.isNotBlank((CharSequence)newNumber) || newNumber.equalsIgnoreCase(oldNumber)) continue;
            numChangedList.add(oldNumber);
            numChangedList.add(newNumber);
        }
    }

    private void recordAfterRebuildApp(List<String> numChangedList) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select FId, FAppId, FFormId from T_META_MENURUNTIME where", new Object[0]).appendIn("FFormId", numChangedList.toArray());
        ResultSetHandler<Set<String>> action = new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> appIds = new HashSet<String>(10);
                while (rs.next()) {
                    String appId = rs.getString("FAppId");
                    appIds.add(appId);
                }
                return appIds;
            }
        };
        Set appIds = (Set)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, (ResultSetHandler)action);
        if (!appIds.isEmpty()) {
            DeployPackageApp.addAfterRebuildApps(appIds);
        }
    }

    private void deployMetadataFile(DeployAppInfo appInfo, String fullVer, String fileName, byte[] contentByte) {
        IMetadataDeployService metadataDeployService = DeployServiceFactory.getService((String)fileName);
        if (metadataDeployService == null) {
            return;
        }
        MetadataDeployFile deployFile = new MetadataDeployFile();
        deployFile.setContentBytes(contentByte);
        deployFile.setFileName(fileName);
        deployFile.setAppGroup(this.getAppGroup());
        ArrayList<MetadataDeployFile> deployFileList = new ArrayList<MetadataDeployFile>(1);
        deployFileList.add(deployFile);
        MetadataDeployResult metaDeployResult = metadataDeployService.deploy(deployFileList);
        if (metaDeployResult != null && !metaDeployResult.isSuccess()) {
            String comDeployMsg = String.format(ResManager.loadKDString((String)"\u6587\u4ef6:%1$s\u90e8\u7f72\u5931\u8d25\uff0c\u539f\u56e0\uff1a%2$s, \u65e5\u5fd7\uff1a%3$s", (String)"DeployDataModel_22", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), fileName, metaDeployResult.getErrorInfo(), metaDeployResult.getLog());
            DeployLog.error(appInfo.getPkgId(), fullVer, DeployCategory.Dym, comDeployMsg, (Throwable)new KDException(BosErrorCode.bOS, new Object[]{comDeployMsg}));
            appInfo.getDeployInfo().setResult('0');
            appInfo.setResult(0);
            if (ERROR.equals(metaDeployResult.getEl())) {
                throw new KDException(BosErrorCode.bOS, new Object[]{comDeployMsg});
            }
        }
    }

    protected MetaRebuilder getMetaRebuilder(String appGroup) {
        return new MetaRebuilder(appGroup);
    }

    protected GrayDeployMetadataWriter getGrayDeployMetadataWriter(String appGroup) {
        return new GrayDeployMetadataWriter(appGroup);
    }

    protected MetaGrayService getMetaGrayService() {
        return new MetaGrayService();
    }
}

