/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade.entity;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.service.upgrade.entity.DeployAppInfo;
import kd.bos.service.upgrade.entity.DeployScriptInfo;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

@DataEntityTypeAttribute(tableName="T_BAS_DEPLOYINFO", dbRouteKey="sys.meta")
public class DeployInfo {
    private static boolean upgradeAll = false;
    private static String deploy_sqlvsersion_upgrade_all = "deploy.sqlvsersion.upgrade.all";
    protected static String T_BAS_DEPLOYINFO;
    private long id;
    private String name;
    private String ver;
    private String iteration;
    private String patch;
    private Date execTime;
    private String fileName;
    private String isv;
    private char result;
    private String description;
    private String productNumber;
    private long deployPackageId;
    private boolean isUndo;
    Map<String, DBRoute> dbRoutes = new HashMap<String, DBRoute>();
    BigDecimal progVal = new BigDecimal(0);
    private Map<String, DeployAppInfo> appMap = new LinkedHashMap<String, DeployAppInfo>();

    public BigDecimal getProgVal() {
        if (this.progVal.compareTo(new BigDecimal(1)) == 0) {
            return this.progVal;
        }
        if (this.appMap.size() == 0) {
            return new BigDecimal(1);
        }
        BigDecimal i = new BigDecimal(0);
        for (DeployAppInfo appInfo : this.appMap.values()) {
            if (appInfo.getProgVal().compareTo(new BigDecimal(1)) == 0) {
                i = i.add(new BigDecimal(1));
                continue;
            }
            i = i.add(appInfo.getProgVal().divide(new BigDecimal(this.appMap.size()), 10, RoundingMode.HALF_EVEN));
        }
        this.progVal = i.divide(new BigDecimal(this.appMap.size()), 10, RoundingMode.HALF_EVEN);
        return this.progVal;
    }

    public void setProgVal(BigDecimal progVal) {
        this.progVal = progVal;
    }

    @SimplePropertyAttribute(isPrimaryKey=true, alias="FID", dbType=-5)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @SimplePropertyAttribute(alias="FNAME", dbType=12)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @SimplePropertyAttribute(alias="FVER", dbType=12)
    public String getVer() {
        return this.ver;
    }

    public void setVer(String ver) {
        this.ver = ver;
    }

    @SimplePropertyAttribute(alias="FITERATION", dbType=12)
    public String getIteration() {
        return this.iteration;
    }

    public void setIteration(String iteration) {
        this.iteration = iteration;
    }

    public String getPatch() {
        return this.patch;
    }

    public void setPatch(String patch) {
        this.patch = patch;
    }

    public String getFullVer() {
        return String.format("%s.%s.%s", this.ver, this.iteration, this.patch);
    }

    @SimplePropertyAttribute(alias="FEXECTIME", dbType=91)
    public Date getExecTime() {
        return this.execTime;
    }

    public void setExecTime(Date execTime) {
        this.execTime = execTime;
    }

    @SimplePropertyAttribute(alias="FFILENAME", dbType=12)
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @SimplePropertyAttribute(alias="FISV", dbType=12)
    public String getIsv() {
        return this.isv;
    }

    public void setIsv(String isv) {
        this.isv = isv;
    }

    @SimplePropertyAttribute(name="Result", alias="FRESULT", dbType=1)
    public char getResult() {
        return this.result;
    }

    public void setResult(char result) {
        this.result = result;
    }

    public String getDescription() {
        return this.description;
    }

    @SimplePropertyAttribute(alias="FDPKGID", dbType=-5)
    public long getDeployPackageId() {
        return this.deployPackageId;
    }

    public void setDeployPackageId(long deployPackageId) {
        this.deployPackageId = deployPackageId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getProductNumber() {
        return this.productNumber;
    }

    public void setProductNumber(String productNumber) {
        this.productNumber = productNumber;
    }

    public boolean isUndo() {
        return this.isUndo;
    }

    public void setUndo(boolean isUndo) {
        this.isUndo = isUndo;
    }

    public Map<String, DeployAppInfo> getApp() {
        return this.appMap;
    }

    public void addApp(DeployAppInfo app) {
        this.appMap.put(app.getName(), app);
    }

    public Map<String, DBRoute> getAllDBRoutes() {
        if (this.dbRoutes.size() > 0) {
            return this.dbRoutes;
        }
        Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        List dbs = account.getDBInstanceList(false);
        for (DBInstance dbInstance : dbs) {
            String insid = String.format("%s.%s.%s.%s.%s", dbInstance.getDbtype(), dbInstance.getDbip(), dbInstance.getDbport(), dbInstance.getDBInsatnce(), dbInstance.getDbuser());
            if (this.dbRoutes.containsKey(insid) || !StringUtils.isNotBlank((CharSequence)dbInstance.getRouteKey())) continue;
            this.dbRoutes.put(insid, new DBRoute(dbInstance.getRouteKey()));
        }
        return this.dbRoutes;
    }

    public static boolean checkCreateTable() {
        if (!DB.exitsTable((DBRoute)DBRoute.meta, (String)T_BAS_DEPLOYINFO)) {
            DeployInfo.createTable();
            return true;
        }
        return false;
    }

    private static void createTable() {
        try (TXHandle h = TX.notSupported();){
            String sqlCreateTable = "create table " + T_BAS_DEPLOYINFO + " (FID bigint not null primary key, FNAME                varchar(50)          not null, FVER                 varchar(10)          not null, FITERATION           varchar(10)          not null default ' ', FEXECTIME            datetime             not null, FFILENAME            varchar(500)         not null, FRESULT              char(1)              not null, FISV                 varchar(50)          not null ) ";
            DB.execute((DBRoute)DBRoute.meta, (String)sqlCreateTable, null);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u5efa\u8868 T_BAS_DEPLOYINFO \u5931\u8d25", (String)"DeployInfo_0", (String)"bos-mservice-form", (Object[])new Object[0])});
        }
    }

    public static void upgradeData10() {
        String sql = "select FID, FVER, FFILENAME, EXECTIME, FAPPID, PKNAME from T_BAS_SQLVERSION where FVER = '1.0' ";
        if (upgradeAll) {
            sql = "select FID, FVER, FFILENAME, EXECTIME, FAPPID, PKNAME from T_BAS_SQLVERSION";
        }
        Map res = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)new ResultSetHandler<Map<Long, Map<String, Object>>>(){

            public Map<Long, Map<String, Object>> handle(ResultSet rs) throws Exception {
                HashMap<Long, Map<String, Object>> res = new HashMap<Long, Map<String, Object>>(16);
                while (rs.next()) {
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    long id = rs.getLong(1);
                    dataMap.put("FID", id);
                    dataMap.put("FVER", rs.getString(2));
                    dataMap.put("FFILENAME", rs.getString(3));
                    dataMap.put("EXECTIME", rs.getDate(4));
                    dataMap.put("FAPPID", rs.getString(5));
                    dataMap.put("PKNAME", rs.getString(6));
                    res.put(id, dataMap);
                }
                return res;
            }
        });
        HashMap<String, DeployInfo> deployInfoMap = new HashMap<String, DeployInfo>();
        HashMap<String, DeployAppInfo> deployAppInfoMap = new HashMap<String, DeployAppInfo>();
        HashMap<String, DeployScriptInfo> deployScriptInfoMap = new HashMap<String, DeployScriptInfo>();
        for (Map.Entry entry : res.entrySet()) {
            String fileName;
            DeployScriptInfo scriptInfo;
            DeployAppInfo appInfo;
            String app;
            String[] appTmpStr;
            String pkName = (String)((Map)entry.getValue()).get("PKNAME");
            String ver = (String)((Map)entry.getValue()).get("FVER");
            Date execTime = (Date)((Map)entry.getValue()).get("EXECTIME");
            DeployInfo dpi = (DeployInfo)deployInfoMap.get(pkName);
            if (dpi == null) {
                dpi = new DeployInfo();
                dpi.setId(DB.genGlobalLongId());
                dpi.setName(pkName);
                dpi.setVer(ver);
                dpi.setIteration(" ");
                dpi.setExecTime(execTime);
                dpi.setFileName(pkName);
                dpi.setResult('1');
                deployInfoMap.put(pkName, dpi);
            }
            if ((appTmpStr = (app = (String)((Map)entry.getValue()).get("FAPPID")).split("-")).length > 1) {
                app = appTmpStr[1];
            }
            if ((appInfo = (DeployAppInfo)deployAppInfoMap.get(app)) == null) {
                appInfo = new DeployAppInfo(app, "");
                appInfo.setId(DB.genGlobalLongId());
                appInfo.setPkgId(dpi.getId());
                appInfo.setPkgName(pkName);
                appInfo.setVer(ver);
                deployAppInfoMap.put(app, appInfo);
            }
            if ((scriptInfo = (DeployScriptInfo)deployScriptInfoMap.get(fileName = (String)((Map)entry.getValue()).get("FFILENAME"))) != null) continue;
            scriptInfo = new DeployScriptInfo();
            scriptInfo.setId(DB.genGlobalLongId());
            scriptInfo.setEntryId(appInfo.getId());
            scriptInfo.setAppId(app);
            scriptInfo.setFileName(fileName);
            scriptInfo.setExecTime(execTime);
            scriptInfo.setVer(ver);
            deployScriptInfoMap.put(fileName, scriptInfo);
        }
        IDataEntityType deployInfoType = OrmUtils.getDataEntityType(DeployInfo.class);
        IDataEntityType appInfoType = OrmUtils.getDataEntityType(DeployAppInfo.class);
        IDataEntityType scriptInfoType = OrmUtils.getDataEntityType(DeployScriptInfo.class);
        try (TXHandle h = TX.requiresNew();){
            BusinessDataWriter.save((IDataEntityType)deployInfoType, (Object[])deployInfoMap.values().toArray());
            BusinessDataWriter.save((IDataEntityType)appInfoType, (Object[])deployAppInfoMap.values().toArray());
            BusinessDataWriter.save((IDataEntityType)scriptInfoType, (Object[])deployScriptInfoMap.values().toArray());
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u4fdd\u5b58\u5347\u7ea7\u6570\u636e\u5931\u8d25\uff01", (String)"DeployInfo_1", (String)"bos-mservice-form", (Object[])new Object[0])});
        }
    }

    static {
        upgradeAll = Boolean.parseBoolean(System.getProperty(deploy_sqlvsersion_upgrade_all));
        ConfigurationUtil.observeChange((String)deploy_sqlvsersion_upgrade_all, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                upgradeAll = Boolean.parseBoolean(System.getProperty(deploy_sqlvsersion_upgrade_all));
            }
        });
        T_BAS_DEPLOYINFO = "T_BAS_DEPLOYINFO";
    }
}

