/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade.entity;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.entity.DeployCategory;

public class DeployLog {
    private static final String YYYY_MM_DD_HH_MM_SS_SSS = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String DEPLOY_ERROR = "deploy log writing DB error";
    private static String T_LOG_DEPLOY = "T_LOG_DEPLOY";
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private static Map<Long, Boolean> packageMap = new HashMap<Long, Boolean>();
    private static final Log log = LogFactory.getLog(DeployLog.class);

    public static void info(long packageId, String ver, DeployCategory category, String content) {
        OperationContext oc = OperationContext.get();
        if (oc == null) {
            oc = new OperationContext();
        }
        oc.setAppId("bos");
        oc.setFormId("deploy");
        oc.setFormName(ResManager.loadKDString((String)"\u90e8\u7f72\u5347\u7ea7", (String)"DeployLog_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
        oc.setOpMethod("DeployCategory_" + (Object)((Object)category));
        SimpleDateFormat dateFormat = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS_SSS);
        String msg = String.format("%s INFO - %s : %s", dateFormat.format(new Date()), packageId, content);
        log.info(msg);
        if (packageId != 0L) {
            try {
                DeployLog.writeLog(packageId, ver, category, msg, "1");
            }
            catch (Exception e) {
                log.error(DEPLOY_ERROR, (Throwable)e);
            }
        }
    }

    public static void warn(long packageId, String ver, DeployCategory category, String content) {
        OperationContext oc = OperationContext.get();
        if (oc == null) {
            oc = new OperationContext();
        }
        oc.setAppId("bos");
        oc.setFormId("deploy");
        oc.setFormName(ResManager.loadKDString((String)"\u90e8\u7f72\u5347\u7ea7", (String)"DeployLog_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
        oc.setOpMethod("DeployCategory_" + (Object)((Object)category));
        SimpleDateFormat dateFormat = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS_SSS);
        String msg = String.format("%s WARN - %s : %s", dateFormat.format(new Date()), packageId, content);
        log.warn(msg);
        if (packageId != 0L) {
            try {
                DeployLog.writeLog(packageId, ver, category, msg, "2");
            }
            catch (Exception e) {
                log.error(DEPLOY_ERROR, (Throwable)e);
            }
        }
    }

    public static void error(long packageId, String ver, DeployCategory category, String content, Throwable ex) {
        OperationContext oc = OperationContext.get();
        if (oc == null) {
            oc = new OperationContext();
        }
        oc.setAppId("bos");
        oc.setFormId("deploy");
        oc.setFormName(ResManager.loadKDString((String)"\u90e8\u7f72\u5347\u7ea7", (String)"DeployLog_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
        oc.setOpMethod("DeployCategory_" + (Object)((Object)category));
        SimpleDateFormat dateFormat = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS_SSS);
        String traceId = RequestContext.get().getTraceId();
        String msg = String.format("%s ERRORINFO - %s : traceId:%s, %s", dateFormat.format(new Date()), packageId, traceId, content);
        log.error(msg, ex);
        if (packageId != 0L) {
            try {
                DeployLog.writeLog(packageId, ver, category, msg, "2");
            }
            catch (Exception e) {
                log.error(DEPLOY_ERROR, (Throwable)e);
            }
        }
    }

    private static void writeLog(long packageId, String ver, DeployCategory category, String content, String type) {
        DeployLog.createTable(packageId);
        if (packageId != 0L) {
            if (category != DeployCategory.Dym && StringUtils.isNotBlank((CharSequence)content) && content.length() > 2000) {
                content = content.substring(0, 2000);
            }
            String sql = "insert into T_LOG_DEPLOY(FID, FPACKAGEID, FTYPE, FCATEGORY, FVER, FCONTENT) values (?, ?, ?, ?, ?, ?)";
            Object[] params = new Object[]{DB.genGlobalLongId(), packageId, type, category.getValue(), ver, content};
            try (TXHandle h = TX.requiresNew();){
                DB.execute((DBRoute)DBRoute.log, (String)sql, (Object[])params);
            }
            catch (Exception e) {
                log.error(DEPLOY_ERROR, (Throwable)e);
            }
        }
    }

    private static void createTable(long packageId) {
        Boolean isExist;
        Boolean bl = isExist = packageMap.get(packageId) == null ? Boolean.valueOf(false) : packageMap.get(packageId);
        if (isExist.booleanValue()) {
            return;
        }
        if (!DB.exitsTable((DBRoute)DBRoute.log, (String)T_LOG_DEPLOY)) {
            try (TXHandle h = TX.notSupported();){
                String sqlCreateTable = "create table " + T_LOG_DEPLOY + " (FID BIGINT NOT NULL primary key, FPACKAGEID BIGINT NOT NULL, FTYPE CHAR(1) NOT NULL, FCATEGORY CHAR(1) NOT NULL, FVER VARCHAR(10) NOT NULL, FCONTENT NCLOB, FDATETIME DATETIME DEFAULT GETDATE() NOT NULL ) ";
                DB.execute((DBRoute)DBRoute.log, (String)sqlCreateTable, null);
                log.info(packageId + "\u521b\u5efalog\u8868 T_LOG_DEPLOY \u5b8c\u6210");
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u5efa\u8868 T_LOG_DEPLOY \u5931\u8d25", (String)"DeployLog_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])});
            }
        }
        packageMap.put(packageId, true);
    }

    /*
     * Exception decompiling
     */
    public static String getExceptionStackTraceMessage(Throwable ex) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

