/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.cache;

import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.cache.AppCacheLimiterService;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.cache.IAppCache;

final class AppCacheImpl
implements IAppCache {
    private final DistributeSessionlessCache cache;
    private final String appKey;
    private static final String SPAN_TYPE_APPCACHE = "appcache";
    private static final String SPAN_PARAM_KEY = "key";
    private static final String SPAN_PARAM_VAL = "val";
    private static final Map<String, AppCacheImpl> caches = new ConcurrentHashMap<String, AppCacheImpl>();

    private AppCacheImpl(String appKey) {
        this.appKey = appKey;
        this.cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
    }

    public static AppCacheImpl get(String appKey) {
        AppCacheImpl cache = caches.get(appKey);
        if (cache == null) {
            cache = caches.computeIfAbsent(appKey, k -> new AppCacheImpl((String)k));
        }
        return cache;
    }

    private String getFullKey(String key) {
        return CacheKeyUtil.getAcctId() + '.' + this.appKey + "_appcache_" + key;
    }

    private String getContainerKey() {
        return CacheKeyUtil.getAcctId() + '.' + this.appKey + "_appcacheallkeys";
    }

    private void putKeyToContainer(String key) {
        if (key == null) {
            return;
        }
        String containerKey = this.getContainerKey();
        this.cache.hset(containerKey, key.getBytes(StandardCharsets.UTF_8), LocalDateTime.now().toString().getBytes(StandardCharsets.UTF_8));
    }

    private void removeKeyFromContainer(String key) {
        if (key == null) {
            return;
        }
        String containerKey = this.getContainerKey();
        this.cache.remove(containerKey, key);
    }

    private List<String> getContainerAllKeys() {
        String containerKey = this.getContainerKey();
        Map map = this.cache.hgetAll(containerKey);
        ArrayList<String> list = new ArrayList<String>(map.size());
        for (byte[] bytes : map.keySet()) {
            list.add(new String(bytes, StandardCharsets.UTF_8));
        }
        return list;
    }

    @Override
    public void put(String key, Object value) {
        String fullKey = this.getFullKey(key);
        String jsonValue = SerializationUtils.toJsonString((Object)value);
        if (jsonValue != null) {
            AppCacheLimiterService.limitSize(jsonValue.length());
        }
        this.cache.put(fullKey, (Object)jsonValue);
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_APPCACHE, (String)"put");){
                span.addTag(SPAN_PARAM_KEY, fullKey);
                span.addLocaleTag(SPAN_PARAM_VAL, (Object)jsonValue);
            }
        }
        this.putKeyToContainer(key);
    }

    @Override
    public void put(String key, Object value, int timeout) {
        String fullKey = this.getFullKey(key);
        String jsonValue = SerializationUtils.toJsonString((Object)value);
        if (jsonValue != null) {
            AppCacheLimiterService.limitSize(jsonValue.length());
        }
        this.cache.put(fullKey, (Object)jsonValue, timeout);
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_APPCACHE, (String)"put");){
                span.addTag(SPAN_PARAM_KEY, fullKey);
                span.addLocaleTag(SPAN_PARAM_VAL, (Object)jsonValue);
                span.addLocaleTag("timeout", (Object)timeout);
            }
        }
        this.putKeyToContainer(key);
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        String fullKey = this.getFullKey(key);
        String jsonValue = (String)this.cache.get(fullKey);
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_APPCACHE, (String)"get");){
                span.addTag(SPAN_PARAM_KEY, fullKey);
                span.addLocaleTag(SPAN_PARAM_VAL, (Object)jsonValue);
            }
        }
        if (jsonValue == null || jsonValue.isEmpty()) {
            return null;
        }
        return (T)SerializationUtils.fromJsonString((String)jsonValue, clazz);
    }

    @Override
    public void remove(String key) {
        String fullKey = this.getFullKey(key);
        this.cache.remove(fullKey);
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_APPCACHE, (String)"remove");){
                span.addTag(SPAN_PARAM_KEY, fullKey);
            }
        }
        this.removeKeyFromContainer(key);
    }

    @Override
    @Deprecated
    public void clear() {
        List<String> keys = this.getContainerAllKeys();
        for (String key : keys) {
            String cacheKey = this.getFullKey(key);
            this.cache.remove(cacheKey);
        }
        String containerKey = this.getContainerKey();
        this.cache.remove(containerKey);
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_APPCACHE, (String)"clear");){
                span.addTag(SPAN_PARAM_KEY, containerKey);
            }
        }
    }
}

