/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.cache.IBusinessAppCache;

final class BusinessAppCacheImpl
implements IBusinessAppCache {
    private final DistributeSessionlessCache cache;
    private final String appKey;
    private static final String SPAN_TYPE_APPCACHE = "appcache";
    private static final String SPAN_PARAM_KEY = "key";
    private static final String SPAN_PARAM_VAL = "val";
    private static final Map<String, BusinessAppCacheImpl> caches = new ConcurrentHashMap<String, BusinessAppCacheImpl>();

    private BusinessAppCacheImpl(String appKey) {
        this.appKey = appKey;
        this.cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
    }

    public static BusinessAppCacheImpl get(String appKey) {
        BusinessAppCacheImpl cache = caches.get(appKey);
        if (cache == null) {
            cache = caches.computeIfAbsent(appKey, k -> new BusinessAppCacheImpl((String)k));
        }
        return cache;
    }

    private String getKey(String key) {
        return CacheKeyUtil.getAcctId() + ".businessappcache." + this.appKey + "." + key;
    }

    @Override
    public void put(String key, Object value) {
        String cacheKey = this.getKey(key);
        String valJson = SerializationUtils.toJsonString((Object)value);
        this.cache.put(cacheKey, (Object)valJson);
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_APPCACHE, (String)"put");){
                span.addTag(SPAN_PARAM_KEY, cacheKey);
                span.addLocaleTag(SPAN_PARAM_VAL, (Object)valJson);
            }
        }
    }

    @Override
    public void put(String key, Object value, int timeout) {
        String cacheKey = this.getKey(key);
        String valJson = SerializationUtils.toJsonString((Object)value);
        this.cache.put(cacheKey, (Object)valJson, timeout);
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_APPCACHE, (String)"put");){
                span.addTag(SPAN_PARAM_KEY, cacheKey);
                span.addLocaleTag(SPAN_PARAM_VAL, (Object)valJson);
                span.addLocaleTag("timeout", (Object)timeout);
            }
        }
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        String cacheKey = this.getKey(key);
        String json = (String)this.cache.get(cacheKey);
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_APPCACHE, (String)"get");){
                span.addTag(SPAN_PARAM_KEY, cacheKey);
                span.addLocaleTag(SPAN_PARAM_VAL, (Object)json);
            }
        }
        if (json == null || json.isEmpty()) {
            return null;
        }
        return (T)SerializationUtils.fromJsonString((String)json, clazz);
    }

    @Override
    public void remove(String key) {
        String cacheKey = this.getKey(key);
        this.cache.remove(cacheKey);
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_APPCACHE, (String)"remove");){
                span.addTag(SPAN_PARAM_KEY, cacheKey);
            }
        }
    }

    @Override
    public void clear() {
    }
}

