/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.EntryInfo;
import kd.bos.dataentity.entity.PkSnapshot;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntityDeserializerOption;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.IDataEntityBinder;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.cache.IModelCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.EntryFilterHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.entryfilter.EntryQueryParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class RedisModelCache
implements IModelCache {
    private static final String TYPE_NAME = "ModelCache";
    private static final String EVENT_ADD = "add";
    private static final String EVENT_INSERT = "insert";
    private static final String EVENT_REMOVE = "remove";
    private static final String EVENT_REMOVEALL = "removeall";
    private static final String PARAM_ROWINDEX = "rowIndex";
    private static final String PARAM_BATCHSTART = "batchStart";
    private static final String PARAM_CACHEINDEX = "cacheIndex";
    private static final String PARAM_ROWS_SIZE = "rows.size";
    private static final String PARAM_PROP = "prop";
    private static final String PARAM_ROWS = "rows";
    private static final String SPAN_TAG_DT = "dt.name";
    private static final String SPAN_LTAG_ROOTDATAENTITY = "rootDataEntity";
    private static final String SPAN_LTAG_DT = "dt";
    private static final String SPAN_LTAG_ENTRY_ROWS = "entry.rows";
    private static final String LOCK = "_lock";
    private static final String REDISMODELCACHE_ENABLELUA = "redismodelcache.enablelua";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("formmodel", new DistributeCacheHAPolicy(true, true));
    private static DistributeSessionlessCache cacheBO = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("formmodel-bigobject", new DistributeCacheHAPolicy(true, true));
    private DistributeSessionlessCache useCache;
    private static final int SWITCH_TO_BIGCACHE_ENTRY_AMOUNT = 20000;
    private static final int SWITCH_TO_BIGCACHE_BYTES = 10240000;
    private String pageId;
    private MainEntityType dt;
    private DynamicObject rootDataEntity;
    private Map<String, Map<Integer, DynamicObject>> localEntryRowCahe = new HashMap<String, Map<Integer, DynamicObject>>();
    private Map<String, Integer> entryRowCountCahe = new HashMap<String, Integer>();
    private IRefrencedataProvider refProvide;
    private static Log log = LogFactory.getLog(RedisModelCache.class);
    private EntryFilterHandler entryFilterHandler;
    private boolean isLockCache = false;
    private static boolean checkEntryDataState;

    private static void readCheckEntryDataStateConfig() {
        String checkState = System.getProperty("redismodelcache.checkentrydatastate");
        checkEntryDataState = StringUtils.isNotBlank((CharSequence)checkState) ? Boolean.parseBoolean(checkState) : true;
    }

    public RedisModelCache(IRefrencedataProvider refProvide, MainEntityType dt, String pageId) {
        this.pageId = pageId;
        this.dt = dt;
        this.refProvide = refProvide;
        if (this.refProvide instanceof AbstractFormDataModel) {
            this.entryFilterHandler = new EntryFilterHandler((AbstractFormDataModel)this.refProvide);
        }
    }

    public DynamicObject getRootDataEntity() {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getRootDataEntity");){
            DynamicObject rootDataEntity = this.getRootDataEntity(true, true);
            this.addCommonTag(span, "");
            DynamicObject dynamicObject = rootDataEntity;
            return dynamicObject;
        }
    }

    private DynamicObject getRootDataEntity(boolean loadRefdata, boolean throwError) {
        if (this.rootDataEntity == null) {
            DistributeSessionlessCache cacheClient = this.getCacheClient(throwError);
            if (cacheClient == null) {
                return null;
            }
            String strMain = (String)cacheClient.get(this.getRootCacheKey());
            if (!StringUtils.isEmpty((CharSequence)strMain)) {
                DataEntityDeserializerOption option = new DataEntityDeserializerOption();
                option.setIncludeDataEntityState(true);
                this.rootDataEntity = (DynamicObject)DataEntitySerializer.deSerializerFromString((String)strMain, (IDataEntityType)this.dt, (DataEntityDeserializerOption)option);
                if (loadRefdata) {
                    this.refProvide.fillReferenceData(new Object[]{this.rootDataEntity}, (IDataEntityType)this.dt);
                }
                for (ICollectionProperty prop : this.dt.getProperties().getCollectionProperties(false)) {
                    if (prop instanceof DynamicLocaleProperty || prop instanceof MulBasedataProp) continue;
                    this.setDataLoaded(prop.getItemType().getAlias(), false);
                }
            } else {
                if (!throwError) {
                    return null;
                }
                KDException e = new KDException(new ErrorCode("bos.pageCacheInvalid", ResManager.loadKDString((String)"\u9875\u9762\u672a\u521d\u59cb\u5316\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00---\u4ece\u7f13\u5b58\u8bfb\u53d6\u6a21\u578b\u6570\u636e\u5931\u8d25,\u952e\u503c:%s", (String)"RedisModelCache_0", (String)"bos-entity-core", (Object[])new Object[0])), new Object[]{this.getRootCacheKey()});
                EntityTracer.addLocaleTag((String)"pageId", (String)this.pageId);
                EntityTracer.addLocaleTag((String)SPAN_LTAG_DT, (Object)this.dt);
                EntityTracer.throwException((Throwable)e);
                throw e;
            }
        }
        return this.rootDataEntity;
    }

    private void setDataLoaded(String tableName, boolean isLoaded) {
        List snapshots;
        if (this.rootDataEntity.getDataEntityState().getPkSnapshotSet() != null && (snapshots = this.rootDataEntity.getDataEntityState().getPkSnapshotSet().Snapshots) != null) {
            for (PkSnapshot snapshot : snapshots) {
                if (!snapshot.TableName.equalsIgnoreCase(tableName)) continue;
                snapshot.setLoaded(isLoaded);
                break;
            }
        }
    }

    private String getRootCacheKey() {
        return String.format("%s.pagecache.model.%s.%s", CacheKeyUtil.getAcctId(), this.dt.getName(), this.pageId);
    }

    public Boolean getRemovedItemFlag() {
        return this.getRootDataEntity().getDataEntityState().getRemovedItems();
    }

    public void setRemovedItemFlag(Boolean b) {
        if (b != null && b.booleanValue()) {
            this.getRootDataEntity().getDataEntityState().setRemovedItems(b);
            this.getRootDataEntity().getLastDirty().set(0, true);
        }
    }

    public void saveRemovedItemFlag() {
    }

    private String getEntryCacheKey(String entryKey) {
        return String.format("%s.pagecache.model.%s.%s.%s", CacheKeyUtil.getAcctId(), this.dt.getName(), entryKey, this.pageId);
    }

    public DynamicObject getEntryRowDataEntity(String entryName, int rowIndex) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getEntryRowDataEntity");){
            String strRow;
            span.addTag(SPAN_TAG_DT, this.dt.getName() + "." + entryName);
            span.addTag(PARAM_ROWINDEX, String.valueOf(rowIndex));
            ICollectionProperty prop = (ICollectionProperty)this.dt.getProperties().get((Object)entryName);
            DynamicObject ret = null;
            DynamicObject rootDataEntity2 = this.getRootDataEntity(true, false);
            if (rootDataEntity2 == null) {
                DynamicObject dynamicObject = null;
                return dynamicObject;
            }
            int start = rootDataEntity2.getDataEntityState().getEntryStartRowIndex(entryName);
            int index = rowIndex - start;
            if (index < 0) {
                DynamicObject dynamicObject = null;
                return dynamicObject;
            }
            Map<Integer, DynamicObject> mapRows = this.localEntryRowCahe.get(prop.getName());
            if (mapRows == null) {
                mapRows = new HashMap<Integer, DynamicObject>();
                this.localEntryRowCahe.put(prop.getName(), mapRows);
            } else if (mapRows.size() > 0) {
                ret = mapRows.get(index);
            }
            if (ret == null && StringUtils.isNotBlank((CharSequence)(strRow = this.getCacheClient().getListObject(this.getEntryCacheKey(prop.getName()), index)))) {
                DataEntityDeserializerOption option = new DataEntityDeserializerOption();
                option.setIncludeDataEntityState(true);
                ret = DataEntitySerializer.deserializerFromListString((IDataEntityType)prop.getItemType(), (String)strRow, (DataEntityDeserializerOption)option);
                ret.set("seq", (Object)(rowIndex + 1));
                ret.setParent((Object)this.getRootDataEntity());
                this.refProvide.fillReferenceData(new Object[]{ret}, prop.getItemType());
                mapRows.put(index, ret);
            }
            this.addCommonTag(span, entryName);
            DynamicObject dynamicObject = ret;
            return dynamicObject;
        }
    }

    public List<DynamicObject> getEntryRowDataEntities(String entryName, int startRowIndex, int endRowIndex) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getEntryRowDataEntities");){
            span.addTag(SPAN_TAG_DT, this.dt.getName() + "." + entryName);
            span.addTag("startRowIndex", String.valueOf(startRowIndex));
            span.addTag("endRowIndex", String.valueOf(endRowIndex));
            int start = this.getRootDataEntity().getDataEntityState().getEntryStartRowIndex(entryName);
            this.storeChanged();
            ICollectionProperty prop = (ICollectionProperty)this.dt.getProperties().get((Object)entryName);
            String[] strRows = this.getCacheClient().getList(this.getEntryCacheKey(prop.getName()), startRowIndex - start, endRowIndex - startRowIndex);
            ArrayList<DynamicObject> cols = new ArrayList<DynamicObject>();
            DataEntityDeserializerOption option = new DataEntityDeserializerOption();
            option.setIncludeDataEntityState(true);
            DataEntitySerializer.deserializerFromListString(cols, (IDataEntityType)prop.getItemType(), (String[])strRows, (DataEntityDeserializerOption)option);
            IDataEntityType itemType = prop.getItemType();
            DynamicObject parentObj = this.getRootDataEntity();
            for (DynamicObject dataEntity : cols) {
                dataEntity.setParent((Object)parentObj);
            }
            this.refProvide.fillReferenceData(cols.toArray(new Object[cols.size()]), itemType);
            this.addCommonTag(span, entryName);
            List<DynamicObject> list = this.setSeq(start, cols, itemType);
            return list;
        }
    }

    private List<DynamicObject> getEntryRowDataEntitiesByRowkeys(String entryName, int[] rowkeys) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getEntryRowDataEntitiesByRowkeys");){
            span.addTag(SPAN_TAG_DT, this.dt.getName() + "." + entryName);
            span.addLocaleTag("rowkeys", (Object)rowkeys);
            if (rowkeys == null || rowkeys.length == 0) {
                ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(0);
                return arrayList;
            }
            int start = this.getRootDataEntity().getDataEntityState().getEntryStartRowIndex(entryName);
            this.storeChanged();
            ICollectionProperty prop = (ICollectionProperty)this.dt.getProperties().get((Object)entryName);
            String[] strRows = new String[rowkeys.length];
            if (rowkeys.length > 5) {
                String[] strAllRows = this.getCacheClient().getList(this.getEntryCacheKey(prop.getName()));
                for (int i = 0; i < rowkeys.length; ++i) {
                    strRows[i] = strAllRows[rowkeys[i] - start];
                }
            } else {
                for (int i = 0; i < rowkeys.length; ++i) {
                    strRows[i] = this.getCacheClient().getListObject(this.getEntryCacheKey(prop.getName()), rowkeys[i] - start);
                }
            }
            ArrayList<DynamicObject> cols = new ArrayList<DynamicObject>();
            DataEntityDeserializerOption option = new DataEntityDeserializerOption();
            option.setIncludeDataEntityState(true);
            DataEntitySerializer.deserializerFromListString(cols, (IDataEntityType)prop.getItemType(), (String[])strRows, (DataEntityDeserializerOption)option);
            IDataEntityType itemType = prop.getItemType();
            DynamicObject parentObj = this.getRootDataEntity();
            for (DynamicObject dataEntity : cols) {
                dataEntity.setParent((Object)parentObj);
            }
            this.refProvide.fillReferenceData(cols.toArray(new Object[cols.size()]), itemType);
            this.addCommonTag(span, entryName);
            IDataEntityProperty propSeq = (IDataEntityProperty)itemType.getProperties().get((Object)"seq");
            if (propSeq != null) {
                for (int i = 0; i < cols.size(); ++i) {
                    propSeq.setValueFast(cols.get(i), (Object)(rowkeys[i] + 1));
                }
            }
            ArrayList<DynamicObject> arrayList = cols;
            return arrayList;
        }
    }

    private List<DynamicObject> setSeq(int start, List<DynamicObject> cols, IDataEntityType itemType) {
        IDataEntityProperty propSeq = (IDataEntityProperty)itemType.getProperties().get((Object)"seq");
        if (propSeq != null) {
            for (int i = 0; i < cols.size(); ++i) {
                propSeq.setValueFast((Object)cols.get(i), (Object)(start + i + 1));
            }
        }
        return cols;
    }

    public void appendEntryRows(String entryName, DynamicObject[] cols) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"appendEntryRows");){
            this.addCommonTag(span, entryName);
            span.addTag(PARAM_ROWS_SIZE, String.valueOf(cols.length));
            ICollectionProperty prop = (ICollectionProperty)this.dt.getProperties().get((Object)entryName);
            Map<Integer, DynamicObject> mapRows = this.localEntryRowCahe.get(prop.getName());
            if (mapRows == null) {
                mapRows = new HashMap<Integer, DynamicObject>(16);
                this.localEntryRowCahe.put(prop.getName(), mapRows);
            }
            int start = this.getRootDataEntity().getDataEntityState().getEntryStartRowIndex(entryName);
            int startIndex = cols[0].getInt("seq") - 1 - start;
            span.addLocaleTag(SPAN_LTAG_ENTRY_ROWS, (Object)this.entryRowCountCahe.get(entryName));
            span.addTag(PARAM_BATCHSTART, String.valueOf(start));
            span.addTag(PARAM_CACHEINDEX, String.valueOf(startIndex));
            DynamicObject parentObj = this.getRootDataEntity();
            DynamicObjectCollection entryRows = parentObj.getDynamicObjectCollection((IDataEntityProperty)prop);
            for (DynamicObject row : cols) {
                mapRows.put(startIndex, row);
                row.setParent((Object)parentObj);
                if (!entryRows.isEmpty()) {
                    entryRows.add((Object)row);
                }
                ++startIndex;
            }
            String[] strRows = this.serializerEntryRows(prop, Arrays.asList(cols));
            this.updateEntryCacheState(parentObj, prop.getName(), true, true);
            this.getCacheClient().addList(this.getEntryCacheKey(prop.getName()), strRows, CacheKeyUtil.getPageCacheKeyTimeout());
            this.entryRowCountCahe.remove(prop.getName());
            for (DynamicObject entryRow : cols) {
                this.entryFilterHandler.appendRK(entryName, entryRow.getInt("seq") - 1);
            }
            span.addLocaleTag(PARAM_PROP, (Object)prop);
            span.addLocaleTag(PARAM_ROWS, (Object)strRows);
            span.fireEvent(EVENT_ADD);
        }
    }

    public void insertEntryRows(String entryName, int rowIndex, DynamicObject[] cols) {
        this.insertEntryRowsRedisCacheHandle(entryName, rowIndex, cols);
        for (DynamicObject row : cols) {
            this.entryFilterHandler.insertRkBefore(entryName, row.getInt("seq") - 1);
        }
    }

    public void appendEntryRows(String entryName, int rowIndex, DynamicObject[] cols) {
        this.insertEntryRowsRedisCacheHandle(entryName, rowIndex, cols);
        int[] rows = new int[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            rows[i] = cols[i].getInt("seq") - 1;
        }
        this.entryFilterHandler.insertRkAfter(entryName, rows);
    }

    private void updateEntryCacheState(DynamicObject rootDataEntity, String entryName, boolean hasEntry, boolean sync) {
        if (!checkEntryDataState) {
            return;
        }
        if (rootDataEntity == null) {
            return;
        }
        if (hasEntry == rootDataEntity.getDataEntityState().getCacheState(entryName)) {
            return;
        }
        rootDataEntity.getDataEntityState().setCacheState(entryName, Boolean.valueOf(hasEntry));
        if (sync) {
            this.storeRootDataEntity(rootDataEntity);
        }
    }

    private void insertEntryRowsRedisCacheHandle(String entryName, int rowIndex, DynamicObject[] cols) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"insertEntryRows");){
            this.addCommonTag(span, entryName);
            span.addTag(PARAM_ROWINDEX, String.valueOf(rowIndex));
            span.addTag(PARAM_ROWS_SIZE, String.valueOf(cols.length));
            ICollectionProperty prop = (ICollectionProperty)this.dt.getProperties().get((Object)entryName);
            this.storeEntryChaned(prop);
            int start = this.getRootDataEntity().getDataEntityState().getEntryStartRowIndex(entryName);
            int startIndex = rowIndex - start;
            span.addTag(PARAM_BATCHSTART, String.valueOf(start));
            span.addTag(PARAM_CACHEINDEX, String.valueOf(startIndex));
            span.addLocaleTag(SPAN_LTAG_ENTRY_ROWS, (Object)this.entryRowCountCahe.get(entryName));
            HashMap<Integer, DynamicObject> mapRows = new HashMap<Integer, DynamicObject>(16);
            this.localEntryRowCahe.put(prop.getName(), mapRows);
            DynamicObject parentObj = this.getRootDataEntity();
            DynamicObjectCollection entryRows = parentObj.getDynamicObjectCollection((IDataEntityProperty)prop);
            for (DynamicObject row : cols) {
                mapRows.put(startIndex, row);
                row.setParent((Object)parentObj);
                if (!entryRows.isEmpty()) {
                    entryRows.add(startIndex, row);
                }
                ++startIndex;
            }
            if (!entryRows.isEmpty()) {
                this.setSeq(start, (List<DynamicObject>)entryRows, prop.getItemType());
            }
            this.updateEntryCacheState(parentObj, entryName, true, true);
            String[] strRows = this.serializerEntryRows(prop, Arrays.asList(cols));
            if (this.getCacheClient().getListLength(this.getEntryCacheKey(prop.getName())) == rowIndex - start) {
                this.getCacheClient().addList(this.getEntryCacheKey(prop.getName()), strRows);
            } else {
                this.getCacheClient().insertList(this.getEntryCacheKey(prop.getName()), rowIndex - start, strRows);
            }
            this.getCacheClient().expireAfter(this.getEntryCacheKey(prop.getName()), CacheKeyUtil.getPageCacheKeyTimeout());
            this.entryRowCountCahe.remove(prop.getName());
            span.addLocaleTag(PARAM_PROP, (Object)prop);
            span.addLocaleTag(PARAM_ROWS, (Object)strRows);
            span.fireEvent(EVENT_INSERT);
        }
    }

    public void delEntryRow(String entryName, int rowIndex) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"delEntryRow");){
            span.addTag(PARAM_ROWINDEX, String.valueOf(rowIndex));
            ICollectionProperty prop = (ICollectionProperty)this.dt.getProperties().get((Object)entryName);
            if (rowIndex >= 0) {
                this.setRemovedItemFlag(true);
            }
            this.storeEntryChaned(prop);
            DynamicObjectCollection cols = this.getRootDataEntity().getDynamicObjectCollection((IDataEntityProperty)prop);
            if (rowIndex >= 0) {
                int start = this.getRootDataEntity().getDataEntityState().getEntryStartRowIndex(entryName);
                span.addTag(PARAM_BATCHSTART, String.valueOf(start));
                span.addTag(PARAM_CACHEINDEX, String.valueOf(rowIndex - start));
                int entryRows = this.getCacheClient().getListLength(this.getEntryCacheKey(prop.getName()));
                span.addLocaleTag(SPAN_LTAG_ENTRY_ROWS, (Object)entryRows);
                this.updateEntryCacheState(this.getRootDataEntity(), entryName, entryRows > 1, true);
                if (!cols.isEmpty()) {
                    cols.remove(rowIndex - start);
                    this.setSeq(start, (List<DynamicObject>)cols, prop.getItemType());
                }
                this.getCacheClient().removeListObject(this.getEntryCacheKey(prop.getName()), rowIndex - start);
                this.entryRowCountCahe.remove(prop.getName());
                this.entryFilterHandler.removeRK(entryName, new int[]{rowIndex});
            }
            this.addCommonTag(span, entryName);
            span.addLocaleTag(PARAM_PROP, (Object)prop);
            span.fireEvent(EVENT_REMOVE);
        }
    }

    public void delEntryRows(String entryName, int[] rowIndices) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"delEntryRows");){
            if (rowIndices.length > 0) {
                span.addTag(PARAM_ROWINDEX, Arrays.toString(rowIndices));
                this.setRemovedItemFlag(true);
                ICollectionProperty prop = (ICollectionProperty)this.dt.getProperties().get((Object)entryName);
                this.storeEntryChaned(prop);
                ArrayList<int[]> removeItems = this.getRemoveItems(rowIndices);
                int start = this.getRootDataEntity().getDataEntityState().getEntryStartRowIndex(entryName);
                DynamicObjectCollection cols = this.getRootDataEntity().getDynamicObjectCollection((IDataEntityProperty)prop);
                int entryRows = this.getCacheClient().getListLength(this.getEntryCacheKey(entryName));
                span.addLocaleTag(SPAN_LTAG_ENTRY_ROWS, (Object)entryRows);
                this.updateEntryCacheState(this.getRootDataEntity(), entryName, entryRows > rowIndices.length, true);
                for (int i = removeItems.size() - 1; i >= 0; --i) {
                    int startIndex = removeItems.get(i)[0] - start;
                    int len = removeItems.get(i)[1];
                    if (!cols.isEmpty()) {
                        for (int j = len; j > 0; --j) {
                            cols.remove(startIndex + j - 1);
                        }
                    }
                    this.getCacheClient().removeListObjects(this.getEntryCacheKey(prop.getName()), startIndex, len);
                }
                if (!cols.isEmpty()) {
                    this.setSeq(start, (List<DynamicObject>)cols, prop.getItemType());
                }
                this.entryRowCountCahe.remove(prop.getName());
                this.entryFilterHandler.removeRK(entryName, rowIndices);
                this.addCommonTag(span, entryName);
                span.addTag(PARAM_BATCHSTART, String.valueOf(start));
                span.addLocaleTag(PARAM_PROP, (Object)prop);
                span.fireEvent(EVENT_REMOVE);
            }
        }
    }

    private ArrayList<int[]> getRemoveItems(int[] rowIndices) {
        int[] sortedrows = Arrays.copyOf(rowIndices, rowIndices.length);
        ArrayList<int[]> ret = new ArrayList<int[]>();
        Arrays.sort(sortedrows);
        int index = 0;
        do {
            int first;
            int[] removeitem = new int[2];
            removeitem[0] = sortedrows[index];
            int count = 0;
            do {
                ++count;
                first = sortedrows[index];
            } while (++index < sortedrows.length && sortedrows[index] <= first + 1);
            removeitem[1] = count;
            ret.add(removeitem);
        } while (index < sortedrows.length);
        return ret;
    }

    public void moveEntryBlockRows(String entryName, int startIndex, int len, int toIndex) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"moveEntryBlockRows");){
            span.addTag("startIndex", String.valueOf(startIndex));
            span.addTag("len", String.valueOf(len));
            span.addTag("toIndex", String.valueOf(toIndex));
            this.addCommonTag(span, entryName);
            if (toIndex > startIndex && toIndex < startIndex + len) {
                throw new KDException(new ErrorCode("bos.", String.format(ResManager.loadKDString((String)"\u4ece\u884c%1$s\u79fb\u52a8%2$s\u6761\u6570\u636e\u5230\u884c%3$s\u9519\u8bef\uff0c\u76ee\u6807\u884c\u53f7\u5e94\u5927\u4e8e\u8d77\u59cb\u884c+\u79fb\u52a8\u8bb0\u5f55\u6570\u3002", (String)"RedisModelCache_2", (String)"bos-entity-core", (Object[])new Object[0]), startIndex, len, toIndex)), new Object[0]);
            }
            ICollectionProperty prop = (ICollectionProperty)this.dt.getProperties().get((Object)entryName);
            this.storeEntryChaned(prop);
            String key = this.getEntryCacheKey(prop.getName());
            int start = this.getRootDataEntity().getDataEntityState().getEntryStartRowIndex(entryName);
            String[] strRows = this.getCacheClient().getList(key, startIndex - start, len);
            String[] rows = new String[strRows.length];
            for (int i = strRows.length - 1; i >= 0; --i) {
                rows[strRows.length - i - 1] = strRows[i];
            }
            int targetIndex = toIndex - start;
            if (toIndex > startIndex) {
                targetIndex = targetIndex - len + 1;
            }
            this.getCacheClient().removeListObjects(key, startIndex - start, len);
            this.getCacheClient().insertList(key, targetIndex, rows);
            this.getCacheClient().expireAfter(key, CacheKeyUtil.getPageCacheKeyTimeout());
        }
    }

    public void moveEntryBlockRows(String entryName, int[] formIndexs, int toIndex) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"moveEntryBlockRows");){
            int i;
            span.addLocaleTag("startIndex", (Object)String.valueOf(formIndexs));
            span.addTag("toIndex", String.valueOf(toIndex));
            this.addCommonTag(span, entryName);
            ICollectionProperty prop = (ICollectionProperty)this.dt.getProperties().get((Object)entryName);
            this.storeEntryChaned(prop);
            String key = this.getEntryCacheKey(prop.getName());
            int start = this.getRootDataEntity().getDataEntityState().getEntryStartRowIndex(entryName);
            String[] strRows = this.getCacheClient().getList(key, formIndexs[0] - start, formIndexs[formIndexs.length - 1] - formIndexs[0] + 1);
            String[] rows = new String[formIndexs.length];
            for (i = 0; i < formIndexs.length; ++i) {
                rows[i] = strRows[formIndexs[formIndexs.length - i - 1] - formIndexs[0]];
            }
            for (i = formIndexs.length - 1; i >= 0; --i) {
                this.getCacheClient().removeListObject(key, formIndexs[i] - start);
                if (formIndexs[i] > toIndex) continue;
                --toIndex;
            }
            if (this.getCacheClient().getListLength(this.getEntryCacheKey(prop.getName())) == toIndex - start + 1) {
                String[] rowsTemp = new String[rows.length];
                for (int i2 = 0; i2 < rows.length; ++i2) {
                    rowsTemp[i2] = rows[rows.length - i2 - 1];
                }
                this.getCacheClient().addList(this.getEntryCacheKey(prop.getName()), rowsTemp);
            } else {
                this.getCacheClient().insertList(key, toIndex - start + 1, rows);
            }
            this.getCacheClient().expireAfter(key, CacheKeyUtil.getPageCacheKeyTimeout());
        }
    }

    public void swapEntryRow(String entryName, int rowIndex1, int rowIndex2) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"swapEntryRow");){
            span.addTag("rowIndex1", String.valueOf(rowIndex1));
            span.addTag("rowIndex2", String.valueOf(rowIndex2));
            this.addCommonTag(span, entryName);
            ICollectionProperty prop = (ICollectionProperty)this.dt.getProperties().get((Object)entryName);
            this.storeEntryChaned(prop);
            int start = this.getRootDataEntity().getDataEntityState().getEntryStartRowIndex(entryName);
            String key = this.getEntryCacheKey(prop.getName());
            String strRow1 = this.getCacheClient().getListObject(key, rowIndex1 - start);
            String strRow2 = this.getCacheClient().getListObject(key, rowIndex2 - start);
            span.addLocaleTag(SPAN_LTAG_ENTRY_ROWS, (Object)this.entryRowCountCahe.get(entryName));
            this.getCacheClient().setListObject(key, rowIndex1 - start, strRow2);
            this.getCacheClient().setListObject(key, rowIndex2 - start, strRow1);
            this.getCacheClient().expireAfter(key, CacheKeyUtil.getPageCacheKeyTimeout());
        }
    }

    public void storeAll(DynamicObject dataEntity) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"storeAll");){
            DataEntitySerializerOption option = new DataEntitySerializerOption();
            option.setIncludeComplexProperty(false);
            option.setIncludeCollectionProperty(true);
            option.setIncludeDataEntityState(true);
            List properties = this.dt.getProperties().getCollectionProperties(false);
            HashMap<String, String[]> entryMap = new HashMap<String, String[]>(properties.size());
            for (ICollectionProperty prop : properties) {
                String key = this.getEntryCacheKey(prop.getName());
                DynamicObjectCollection cols = (DynamicObjectCollection)prop.getValueFast((Object)dataEntity);
                String[] strRows = DataEntitySerializer.serializerToListString((IDataEntityType)prop.getItemType(), (List)cols, (DataEntitySerializerOption)option);
                entryMap.put(key, strRows);
                this.updateEntryCacheState(dataEntity, prop.getName(), strRows.length > 0, false);
                if (!(prop instanceof EntryProp)) continue;
                span.addTag("dt.name." + prop.getName(), this.dt.getName() + "." + prop.getName());
                span.addTag("rows.size." + prop.getName(), String.valueOf(strRows.length));
                span.addLocaleTag("prop." + prop.getName(), (Object)prop);
                span.addLocaleTag("rows." + prop.getName(), (Object)strRows);
            }
            this.addCommonTag(span, "");
            span.addLocaleTag(PARAM_ROWS, entryMap);
            this.storeEntryByLua(entryMap);
            this.storeRootDataEntity(dataEntity);
            this.rootDataEntity = null;
            this.localEntryRowCahe = new HashMap<String, Map<Integer, DynamicObject>>();
            this.entryRowCountCahe = new HashMap<String, Integer>();
        }
    }

    private void storeEntryByLua(String key, String[] strRows) {
        HashMap<String, String[]> entryMap = new HashMap<String, String[]>();
        entryMap.put(key, strRows);
        this.storeEntryByLua(entryMap);
    }

    protected boolean enableLua() {
        String lightWeight = System.getProperty("lightweightdeploy");
        if (StringUtils.isNotBlank((CharSequence)lightWeight) && Boolean.parseBoolean(lightWeight)) {
            return false;
        }
        String ha = System.getProperty("ha.component.enable");
        if (StringUtils.isNotBlank((CharSequence)ha) && Boolean.parseBoolean(ha)) {
            log.warn("ha.component.enable\u542f\u7528\uff0clua\u6a21\u5f0f\u5173\u95ed\u3002");
            return false;
        }
        String enableLua = System.getProperty(REDISMODELCACHE_ENABLELUA);
        if (StringUtils.isBlank((CharSequence)enableLua)) {
            String code = RequestContext.get().getTenantCode();
            enableLua = System.getProperty(code + "_" + REDISMODELCACHE_ENABLELUA);
        }
        return StringUtils.isBlank((CharSequence)enableLua) || Boolean.parseBoolean(enableLua);
    }

    private void storeEntryByLua(Map<String, String[]> entryMap) {
        this.setCacheClientIsBigObjectFlag(entryMap);
        if (this.enableLua()) {
            for (Map.Entry<String, String[]> keyValue : entryMap.entrySet()) {
                String key = keyValue.getKey();
                String[] strRows = keyValue.getValue();
                this.getCacheClient().resetList(key, strRows, CacheKeyUtil.getPageCacheKeyTimeout());
            }
        } else {
            this.getCacheClient().remove(entryMap.keySet().toArray(new String[0]));
            for (Map.Entry<String, String[]> keyValue : entryMap.entrySet()) {
                String[] strRows = keyValue.getValue();
                if (strRows.length <= 0) continue;
                this.getCacheClient().addList(keyValue.getKey(), strRows, CacheKeyUtil.getPageCacheKeyTimeout());
            }
        }
    }

    public void storeEntry(DynamicObjectCollection cols) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"storeEntry");){
            DataEntitySerializerOption option = new DataEntitySerializerOption();
            option.setIncludeComplexProperty(false);
            option.setIncludeCollectionProperty(true);
            option.setIncludeDataEntityState(true);
            String[] strRows = DataEntitySerializer.serializerToListString((IDataEntityType)cols.getDynamicObjectType(), (List)cols, (DataEntitySerializerOption)option);
            this.storeEntryByLua(this.getEntryCacheKey(cols.getDynamicObjectType().getName()), strRows);
            this.updateEntryCacheState(cols.getRootEntity(), cols.getDynamicObjectType().getName(), cols.size() > 0, true);
            this.addCommonTag(span, cols.getDynamicObjectType().getName());
            span.addTag(PARAM_ROWS_SIZE, String.valueOf(strRows.length));
            span.addLocaleTag(PARAM_ROWS, (Object)strRows);
            span.addLocaleTag(SPAN_LTAG_ENTRY_ROWS, (Object)this.getCacheClient().getListLength(this.getEntryCacheKey(cols.getDynamicObjectType().getName())));
            this.localEntryRowCahe = new HashMap<String, Map<Integer, DynamicObject>>();
            this.entryRowCountCahe.clear();
        }
    }

    private void storeRootDataEntity(DynamicObject dataEntity) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"storeRootDataEntity");){
            DataEntitySerializerOption option = new DataEntitySerializerOption();
            option.setIncludeComplexProperty(false);
            option.setIncludeCollectionProperty(false);
            option.setIncludeDataEntityState(true);
            option.setDataEntityBinder(new IDataEntityBinder(){

                public boolean isSerializProperty(IDataEntityProperty prop, DataEntitySerializerOption option) {
                    if (prop instanceof DynamicLocaleProperty) {
                        return true;
                    }
                    if (prop instanceof MulBasedataProp) {
                        return true;
                    }
                    return super.isSerializProperty(prop, option);
                }
            });
            String main = DataEntitySerializer.serializerToString((Object)dataEntity, (DataEntitySerializerOption)option);
            this.getCacheClient().put(this.getRootCacheKey(), (Object)main, CacheKeyUtil.getPageCacheKeyTimeout());
            this.writeParallelRequestLog(dataEntity, dataEntity.getLastDirty());
            log.debug("rootCacheKey:{},cacheStrSize:{},timeout:{}", new Object[]{this.getRootCacheKey(), main == null ? -1 : main.length(), CacheKeyUtil.getPageCacheKeyTimeout()});
            if (span.isRealtime()) {
                span.addLocaleTag("rootCacheKey", (Object)this.getRootCacheKey());
                span.addLocaleTag("cacheStrSize", (Object)(main == null ? -1 : main.length()));
                span.addLocaleTag("timeout", (Object)CacheKeyUtil.getPageCacheKeyTimeout());
            }
        }
    }

    public int getEntryRowCount(String entryName) {
        ICollectionProperty prop = (ICollectionProperty)this.dt.getProperty(entryName);
        Integer count = this.entryRowCountCahe.get(prop.getName());
        if (count == null) {
            count = this.getCacheClient().getListLength(this.getEntryCacheKey(prop.getName()));
            EntryInfo entryInfo = this.getRootDataEntity().getDataEntityState().getEntryInfo(entryName);
            if (entryInfo != null && entryInfo.getRowCount() != null) {
                count = entryInfo.getStartRowIndex() + entryInfo.getPageSize() >= entryInfo.getRowCount() ? Integer.valueOf(entryInfo.getStartRowIndex() + count) : Integer.valueOf(entryInfo.getRowCount() + count - entryInfo.getPageSize());
            }
            this.entryRowCountCahe.put(prop.getName(), count);
        }
        return count;
    }

    public void storeChanged() {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"storeChanged");){
            if (this.rootDataEntity != null && this.rootDataEntity.getLastDirty().length() > 0) {
                this.storeRootDataEntity(this.rootDataEntity);
            }
            this.addCommonTag(span, "");
            ArrayList<ICollectionProperty> entryProps = new ArrayList<ICollectionProperty>(this.localEntryRowCahe.size());
            for (Map.Entry<String, Map<Integer, DynamicObject>> entry : this.localEntryRowCahe.entrySet()) {
                ICollectionProperty prop = (ICollectionProperty)this.dt.getProperty(entry.getKey());
                entryProps.add(prop);
                if (!(prop instanceof EntryProp)) continue;
                span.addTag("dt.name." + prop.getName(), this.dt.getName() + "." + prop.getName());
                span.addTag("rows.size." + prop.getName(), String.valueOf(entry.getValue().size()));
            }
            for (ICollectionProperty prop : entryProps) {
                this.storeEntryChaned(prop);
            }
            this.saveRemovedItemFlag();
            this.rootDataEntity = null;
            this.localEntryRowCahe = new HashMap<String, Map<Integer, DynamicObject>>();
        }
    }

    private void storeEntryChaned(ICollectionProperty prop) {
        Map<Integer, DynamicObject> entry = this.localEntryRowCahe.get(prop.getName());
        if (entry != null) {
            boolean resetExpirationTime = false;
            HashMap<Integer, DynamicObject> data = new HashMap<Integer, DynamicObject>();
            for (Map.Entry<Integer, DynamicObject> entry2 : entry.entrySet()) {
                DynamicObject dynamicObject = entry2.getValue();
                if (!this.isEntryRowChanged(dynamicObject)) continue;
                data.put(entry2.getKey(), dynamicObject);
                resetExpirationTime = true;
            }
            if (data.size() <= 5) {
                for (Map.Entry<Integer, Object> entry3 : data.entrySet()) {
                    this.getCacheClient().setListObject(this.getEntryCacheKey(prop.getName()), entry3.getKey().intValue(), this.serializerEntryRow(prop, (DynamicObject)entry3.getValue()));
                }
            } else {
                String[] strRows = this.getCacheClient().getList(this.getEntryCacheKey(prop.getName()));
                for (Map.Entry entry4 : data.entrySet()) {
                    strRows[((Integer)entry4.getKey()).intValue()] = this.serializerEntryRow(prop, (DynamicObject)entry4.getValue());
                }
                String string = this.getEntryCacheKey(prop.getName());
                this.storeEntryByLua(string, strRows);
            }
            if (resetExpirationTime) {
                this.getCacheClient().expireAfter(this.getEntryCacheKey(prop.getName()), CacheKeyUtil.getPageCacheKeyTimeout());
            }
        }
        this.localEntryRowCahe.remove(prop.getName());
    }

    private boolean isEntryRowChanged(DynamicObject rowDataEntity) {
        if (rowDataEntity.getLastDirty().length() > 0) {
            this.writeParallelRequestLog(rowDataEntity, rowDataEntity.getLastDirty());
            return true;
        }
        IDataEntityType entryType = rowDataEntity.getDataEntityType();
        for (ICollectionProperty prop : entryType.getProperties().getCollectionProperties(false)) {
            DynamicObjectCollection cols = (DynamicObjectCollection)prop.getValueFast((Object)rowDataEntity);
            for (DynamicObject row : cols) {
                if (row.getLastDirty().length() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public DynamicObject getAll() {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getAll");){
            this.storeChanged();
            DynamicObject dataEntity = this.getRootDataEntity(false, true);
            DataEntityDeserializerOption option = new DataEntityDeserializerOption();
            option.setIncludeDataEntityState(true);
            for (ICollectionProperty prop : this.dt.getProperties().getCollectionProperties(false)) {
                boolean entryCacheState;
                if (prop instanceof DynamicLocaleProperty || prop instanceof MulBasedataProp) continue;
                DynamicObjectCollection cols = (DynamicObjectCollection)prop.getValueFast((Object)dataEntity);
                String[] strRows = this.getCacheClient().getList(this.getEntryCacheKey(prop.getName()));
                if (checkEntryDataState && (entryCacheState = dataEntity.getDataEntityState().getCacheState(prop.getName()).booleanValue()) && strRows.length == 0) {
                    throw new KDException(new ErrorCode("bos.pageCacheInvalid", ResManager.loadKDString((String)"\u9875\u9762\u672a\u521d\u59cb\u5316\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00---\u4ece\u7f13\u5b58\u8bfb\u53d6\u6a21\u578b\u6570\u636e\u5931\u8d25,\u952e\u503c:%s", (String)"RedisModelCache_0", (String)"bos-entity-core", (Object[])new Object[0])), new Object[]{this.getEntryCacheKey(prop.getName())});
                }
                IDataEntityType itemType = prop.getItemType();
                DataEntitySerializer.deserializerFromListString((List)cols, (IDataEntityType)itemType, (String[])strRows, (DataEntityDeserializerOption)option);
                this.setDataLoaded(itemType.getAlias(), true);
                this.setSeq(cols.getStartRowIndex(), (List<DynamicObject>)cols, itemType);
                if (!(prop instanceof EntryProp)) continue;
                span.addTag("dt.name." + prop.getName(), this.dt.getName() + "." + prop.getName());
                span.addTag("rows.size." + prop.getName(), String.valueOf(strRows.length));
                span.addLocaleTag("prop." + prop.getName(), (Object)prop);
                span.addLocaleTag("rows." + prop.getName(), (Object)strRows);
            }
            this.addCommonTag(span, "");
            this.refProvide.fillReferenceData(new Object[]{dataEntity}, (IDataEntityType)this.dt);
            DynamicObject dynamicObject = dataEntity;
            return dynamicObject;
        }
    }

    public void deleteEntryData(String entryName) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"deleteEntryData");){
            Map<Integer, DynamicObject> entryRows;
            ICollectionProperty prop = (ICollectionProperty)this.dt.getProperty(entryName);
            span.addLocaleTag(SPAN_LTAG_ENTRY_ROWS, (Object)this.getCacheClient().getListLength(this.getEntryCacheKey(prop.getName())));
            this.getCacheClient().remove(this.getEntryCacheKey(prop.getName()));
            this.updateEntryCacheState(this.getRootDataEntity(), prop.getName(), false, true);
            DynamicObjectCollection cols = this.getRootDataEntity().getDynamicObjectCollection((IDataEntityProperty)prop);
            if (!cols.isEmpty()) {
                cols.clear();
            }
            if ((entryRows = this.localEntryRowCahe.get(prop.getName())) != null) {
                entryRows.clear();
                this.setRemovedItemFlag(true);
            }
            this.entryRowCountCahe.put(prop.getName(), 0);
            this.entryFilterHandler.clearFilterRKList(entryName);
            this.addCommonTag(span, entryName);
            span.addLocaleTag(PARAM_PROP, (Object)prop);
            span.fireEvent(EVENT_REMOVEALL);
        }
    }

    public DynamicObjectCollection getEntryRowDataEntities(EntryProp prop) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getEntryRowDataEntities");){
            span.addTag(SPAN_TAG_DT, this.dt.getName() + "." + prop.getName());
            DynamicObject dataEntity = this.getRootDataEntity();
            DynamicObjectCollection cols = (DynamicObjectCollection)prop.getValueFast((Object)dataEntity);
            if (cols == null || cols.isEmpty()) {
                this.storeEntryChaned((ICollectionProperty)prop);
                String[] strRows = this.getCacheClient().getList(this.getEntryCacheKey(prop.getName()));
                IDataEntityType itemType = prop.getItemType();
                DataEntityDeserializerOption option = new DataEntityDeserializerOption();
                option.setIncludeDataEntityState(true);
                DataEntitySerializer.deserializerFromListString((List)cols, (IDataEntityType)itemType, (String[])strRows, (DataEntityDeserializerOption)option);
                this.setDataLoaded(itemType.getAlias(), true);
                if (cols != null) {
                    this.refProvide.fillReferenceData(cols.toArray(), (IDataEntityType)cols.getDynamicObjectType());
                    this.setSeq(cols.getStartRowIndex(), (List<DynamicObject>)cols, itemType);
                    HashMap<Integer, Object> entry = new HashMap<Integer, Object>(32);
                    for (int i = 0; i < cols.size(); ++i) {
                        entry.put(i, cols.get(i));
                    }
                    this.localEntryRowCahe.put(prop.getName(), entry);
                }
            }
            this.addCommonTag(span, prop.getName());
            DynamicObjectCollection dynamicObjectCollection = cols;
            return dynamicObjectCollection;
        }
    }

    public void release() {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"release");){
            ArrayList<String> keys = new ArrayList<String>(10);
            keys.add(this.getRootCacheKey());
            for (ICollectionProperty prop : this.dt.getProperties().getCollectionProperties(false)) {
                keys.add(this.getEntryCacheKey(prop.getName()));
                if (!(prop instanceof EntryProp)) continue;
                span.addTag("dt.name." + prop.getName(), this.dt.getName() + "." + prop.getName());
            }
            this.addCommonTag(span, "");
            log.debug("rootCacheKey:{}", (Object)this.getRootCacheKey());
            if (span.isRealtime()) {
                span.addLocaleTag("rootCacheKey", (Object)this.getRootCacheKey());
            }
            cache.remove(keys.toArray(new String[keys.size()]));
            cacheBO.remove(keys.toArray(new String[keys.size()]));
            cache.remove(this.getRedisModelCacheIsBigObjectKey());
            this.rootDataEntity = null;
            this.localEntryRowCahe = null;
        }
    }

    private String[] serializerEntryRows(ICollectionProperty prop, List<DynamicObject> cols) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(false);
        option.setIncludeCollectionProperty(true);
        option.setIncludeDataEntityState(true);
        return DataEntitySerializer.serializerToListString((IDataEntityType)prop.getItemType(), cols, (DataEntitySerializerOption)option);
    }

    private String serializerEntryRow(ICollectionProperty prop, DynamicObject o) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(false);
        option.setIncludeCollectionProperty(true);
        option.setIncludeDataEntityState(true);
        ArrayList<DynamicObject> cols = new ArrayList<DynamicObject>(1);
        cols.add(o);
        return DataEntitySerializer.serializerToListString((IDataEntityType)prop.getItemType(), cols, (DataEntitySerializerOption)option)[0];
    }

    public boolean isChanged() {
        if (this.rootDataEntity != null && this.rootDataEntity.getLastDirty().length() > 0) {
            return true;
        }
        for (Map.Entry<String, Map<Integer, DynamicObject>> entry : this.localEntryRowCahe.entrySet()) {
            for (Map.Entry<Integer, DynamicObject> entryRow : entry.getValue().entrySet()) {
                DynamicObject rowDataEntity = entryRow.getValue();
                if (!this.isEntryRowChanged(rowDataEntity)) continue;
                return true;
            }
        }
        return false;
    }

    public void expireAfter(int timeout) {
        if (this.getCacheClient(false) == null) {
            return;
        }
        this.getCacheClient().expireAfter(this.getRootCacheKey(), timeout);
        cache.expireAfter(this.getRedisModelCacheIsBigObjectKey(), timeout);
        for (ICollectionProperty prop : this.dt.getProperties().getCollectionProperties(false)) {
            if (prop instanceof DynamicLocaleProperty || prop instanceof MulBasedataProp) continue;
            this.getCacheClient().expireAfter(this.getEntryCacheKey(prop.getName()), timeout);
        }
    }

    public boolean isExistDataEntity() {
        if (this.rootDataEntity != null) {
            return true;
        }
        if (this.getCacheClient(false) == null) {
            return false;
        }
        String strMain = (String)this.getCacheClient().get(this.getRootCacheKey());
        return StringUtils.isNotBlank((CharSequence)strMain);
    }

    private void addCommonTag(EntityTraceSpan span, String entryName) {
        if (StringUtils.isNotEmpty((CharSequence)entryName)) {
            span.addTag(SPAN_TAG_DT, this.dt.getName() + "." + entryName);
        } else {
            span.addTag(SPAN_TAG_DT, this.dt.getName());
        }
        span.addLocaleTag(SPAN_LTAG_ROOTDATAENTITY, (Object)this.rootDataEntity);
        span.addLocaleTag(SPAN_LTAG_DT, (Object)this.dt);
    }

    public void filterEntry(String entryKey, EntryQueryParam queryParam) {
        IDataEntityProperty prop = ((AbstractFormDataModel)this.refProvide).getProperty(entryKey);
        DynamicObjectCollection entryDataEntities = this.getEntryRowDataEntities((EntryProp)prop);
        this.entryFilterHandler.filterEntry(entryKey, queryParam, entryDataEntities);
    }

    public int getFilterEntryRowCount(String entryKey) {
        if (((AbstractFormDataModel)this.refProvide).isFilterAndSortModel(entryKey)) {
            ArrayList<Integer> filterRkList = this.entryFilterHandler.getFilterRkList(entryKey);
            return filterRkList.size();
        }
        return this.getEntryRowCount(entryKey);
    }

    public DynamicObject[] getFilterEntryRows(String entryKey, int startRowIndex, int endRowIndex) {
        boolean isFilterAndSortModel = ((AbstractFormDataModel)this.refProvide).isFilterAndSortModel(entryKey);
        if (isFilterAndSortModel) {
            ArrayList<Integer> filterRkList = this.entryFilterHandler.getFilterRkList(entryKey);
            endRowIndex = Math.min(filterRkList.size(), endRowIndex);
            int[] rowIndexs = new int[endRowIndex - startRowIndex];
            for (int i = startRowIndex; i < endRowIndex; ++i) {
                rowIndexs[i - startRowIndex] = filterRkList.get(i);
            }
            List<DynamicObject> dynamicObjects = this.getEntryRowDataEntitiesByRowkeys(entryKey, rowIndexs);
            return dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]);
        }
        List<DynamicObject> dynamicObjects = this.getEntryRowDataEntities(entryKey, startRowIndex, endRowIndex);
        if (dynamicObjects == null) {
            return new DynamicObject[0];
        }
        return dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]);
    }

    public List<Integer> getFilterEntryRowKeys(String entryKey, int startRowIndex, int endRowIndex) {
        return this.entryFilterHandler.getFilterEntryRowKeys(entryKey, startRowIndex, endRowIndex);
    }

    public List<Integer> getFilterIndexByRowKeys(String entryKey, List<Integer> rowkeyList) {
        boolean isFilterAndSortModel = ((AbstractFormDataModel)this.refProvide).isFilterAndSortModel(entryKey);
        if (isFilterAndSortModel) {
            return this.entryFilterHandler.getFilterIndexByRowKeys(entryKey, rowkeyList);
        }
        return rowkeyList;
    }

    public List<Integer> filterSortByRowKeys(String entryKey, List<Integer> rowkeyList) {
        boolean isFilterAndSortModel = ((AbstractFormDataModel)this.refProvide).isFilterAndSortModel(entryKey);
        if (isFilterAndSortModel) {
            return this.entryFilterHandler.filterSortByRowKeys(entryKey, rowkeyList);
        }
        return rowkeyList;
    }

    public boolean isFilterAndSortModel(String entryKey) {
        return this.entryFilterHandler.isFilterAndSortModel(entryKey);
    }

    public EntryQueryParam getEntryQueryParam(String entryKey) {
        return this.entryFilterHandler.getEntryQueryParam(entryKey);
    }

    private DistributeSessionlessCache getCacheClient() {
        return this.getCacheClient(true);
    }

    private DistributeSessionlessCache getCacheClient(boolean throwError) {
        if (this.useCache != null) {
            return this.useCache;
        }
        String str = (String)cache.get(this.getRedisModelCacheIsBigObjectKey());
        if (StringUtils.isNotBlank((CharSequence)str)) {
            boolean isBig = Boolean.parseBoolean(str);
            this.useCache = isBig ? cacheBO : cache;
            return this.useCache;
        }
        if (!throwError) {
            return null;
        }
        KDException e = new KDException(new ErrorCode("bos.pageCacheInvalid", ResManager.loadKDString((String)"\u9875\u9762\u672a\u521d\u59cb\u5316\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00---\u83b7\u53d6\u7f13\u5b58\u8fde\u63a5\u5ba2\u6237\u7aef\u5931\u8d25\uff0c\u952e\u503c:%s\u3002", (String)"RedisModelCache_3", (String)"bos-entity-core", (Object[])new Object[0])), new Object[]{this.getRootCacheKey()});
        EntityTracer.addLocaleTag((String)"pageId", (String)this.pageId);
        EntityTracer.addLocaleTag((String)SPAN_LTAG_DT, (Object)this.dt);
        EntityTracer.throwException((Throwable)e);
        throw e;
    }

    private void setCacheClientIsBigObjectFlag(Map<String, String[]> entryMap) {
        if (this.useCache != null) {
            return;
        }
        String key = this.getRedisModelCacheIsBigObjectKey();
        String str = (String)cache.get(key);
        boolean isBig = false;
        if (StringUtils.isBlank((CharSequence)str)) {
            int rowsizeMax = -1;
            int bytesMax = 0;
            for (Map.Entry<String, String[]> keyValue : entryMap.entrySet()) {
                String[] strRows = keyValue.getValue();
                int bytes = 0;
                for (int i = 0; i < strRows.length; ++i) {
                    bytes = strRows[i].getBytes().length + bytes;
                }
                rowsizeMax = Math.max(rowsizeMax, strRows.length);
                bytesMax = Math.max(bytesMax, bytes);
            }
            if (rowsizeMax > 20000 || bytesMax > 10240000) {
                isBig = true;
            }
            cache.put(key, (Object)String.valueOf(isBig), CacheKeyUtil.getPageCacheKeyTimeout());
        } else {
            isBig = Boolean.parseBoolean(str);
        }
        this.useCache = isBig ? cacheBO : cache;
    }

    private String getRedisModelCacheIsBigObjectKey() {
        return String.format("%s.redismodelcache.isbigobject.%s.%s", CacheKeyUtil.getAcctId(), this.dt.getName(), this.pageId);
    }

    private void writeParallelRequestLog(DynamicObject obj, BitSet dirtyArray) {
        if (!(this.refProvide instanceof IDataModel) || obj == null || dirtyArray.length() <= 0) {
            return;
        }
        IDataModel dataModel = (IDataModel)this.refProvide;
        try {
            Object parallel = dataModel.getContextVariable("formaction_parallelwebrequest");
            if (parallel instanceof Boolean && ((Boolean)parallel).booleanValue() && obj.getDataEntityType() != null) {
                DataEntityPropertyCollection props = obj.getDataEntityType().getProperties();
                StringBuilder builder = new StringBuilder();
                builder.append("parallelwebrequest warnning:").append("\r\n").append("dt:").append(obj.getDataEntityType().getExtendName()).append("\r\n").append("dirtyprops:").append("[");
                int proplength = props.size();
                int dirtyLength = dirtyArray.length();
                for (int i = 0; i < dirtyArray.length(); ++i) {
                    if (!dirtyArray.get(i)) continue;
                    boolean indexOutOfBounds = i >= proplength;
                    builder.append(String.format("%s(%s)", indexOutOfBounds ? "???" : ((IDataEntityProperty)props.get(i)).getName(), i));
                    if (i >= dirtyLength - 1) continue;
                    builder.append(",");
                }
                builder.append("]");
                log.info(builder.toString());
            }
        }
        catch (Exception e) {
            log.info("parallelwebrequest warnning:  exists dirtyArray , match prop error");
        }
    }

    static {
        RedisModelCache.readCheckEntryDataStateConfig();
        ConfigurationUtil.observeChange((String)"redismodelcache.checkentrydatastate", (key, newValue) -> RedisModelCache.readCheckEntryDataStateConfig());
    }
}

