/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.cache;

import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.TCacheSortField;
import kd.bos.entity.formula.OutValue;
import kd.bos.entity.formula.RowDataModel;

class TCacheSortString
implements TCacheSortField {
    private String fieldKey;
    private String fullFieldKey;
    private int seq = 1;
    private String alias;
    private String order = "ASC";
    private int length = 50;
    private RowDataModel rowDataModel;

    public TCacheSortString(String fieldKey, String fullFieldKey) {
        this.fieldKey = fieldKey;
        this.fullFieldKey = fullFieldKey;
    }

    @Override
    public String getFieldKey() {
        return this.fieldKey;
    }

    @Override
    public String getFullFieldKey() {
        return this.fullFieldKey;
    }

    @Override
    public int getSeq() {
        return this.seq;
    }

    @Override
    public void setSeq(int seq) {
        this.seq = seq;
    }

    @Override
    public String getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(String order) {
        this.order = order;
    }

    @Override
    public String getAlias() {
        if (this.alias == null) {
            this.alias = "forder" + this.seq;
        }
        return this.alias;
    }

    @Override
    public String getFieldName() {
        return "forder" + this.seq;
    }

    @Override
    public int getDBType() {
        return -9;
    }

    @Override
    public Object formatValue(Row row) {
        Object val = row.get(this.getFullFieldKey());
        return this.formatValue(val);
    }

    @Override
    public Object formatValue(DynamicObject entryRow) {
        Object val = this.getValue(entryRow);
        return this.formatValue(val);
    }

    private Object formatValue(Object val) {
        if (val == null) {
            return val;
        }
        String str = val.toString();
        if (str.length() <= this.length) {
            return str;
        }
        return str.substring(0, this.length);
    }

    protected Object getValue(DynamicObject entryRow) {
        RowDataModel rowDataModel = this.getRowDataModel(entryRow);
        rowDataModel.setRowContext(entryRow);
        OutValue ref = new OutValue();
        if (rowDataModel.tryGetValue(this.fieldKey, ref).booleanValue()) {
            return ref.get();
        }
        return null;
    }

    public RowDataModel getRowDataModel(DynamicObject entryRow) {
        if (this.rowDataModel == null) {
            IDataEntityType entryType = entryRow.getDataEntityType();
            IDataEntityType dt = entryType.getParent();
            this.rowDataModel = new RowDataModel(entryType.getName(), (MainEntityType)dt);
        }
        return this.rowDataModel;
    }
}

