/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.EntryInfo;
import kd.bos.dataentity.entity.PkSnapshot;
import kd.bos.dataentity.entity.PkSnapshotSet;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IEntryType;
import kd.bos.dataentity.metadata.database.DataEntityTypeMap;
import kd.bos.dataentity.metadata.database.DbMetadataDatabase;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntityDeserializerOption;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.cache.IModelCache;
import kd.bos.entity.cache.ModelDataTable;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.entryfilter.EntryQueryParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.grid.DragEntryRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;

public class TableModelCache
implements IModelCache {
    private static final String TYPE_NAME = "TableCache";
    private static final String EVENT_ADD = "add";
    private static final String EVENT_INSERT = "insert";
    private static final String EVENT_REMOVE = "remove";
    private static final String EVENT_REMOVEALL = "removeall";
    private static final String SPAN_PAGEID = "pageid";
    private static final String SPAN_DT = "dt";
    private static final String SPAN_DT_NAME = "dt.name";
    private static final String SPAN_PROP = "prop";
    private static final String SPAN_ROOTDATAENTITY = "rootDataEntity";
    private static final String SPAN_ENTRY_ROWS = "entry.rows";
    private static final String SPAN_ROWS_SIZE = "rows.size";
    private static final String SPAN_ROWINDEX = "rowIndex";
    private static final String SPAN_CACHEINDEX = "cacheIndex";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("formmodel", new DistributeCacheHAPolicy(true, true));
    private static Log log = LogFactory.getLog(TableModelCache.class);
    private static final String CACHE_KEY_ISTABLECACHE = "istablecache";
    private static final String CACHE_KEY_FILTER = "filter";
    private static final String CACHE_KEY_ORDER_FIELDS = "orderfields";
    private static final String CACHE_KEY_QUERYPARAM = "queryParam";
    private String pageId;
    private MainEntityType dt;
    private DbMetadataDatabase dbMetadataDatabase;
    private IRefrencedataProvider refProvide;
    private ModelDataTable table;
    private DynamicObject rootDataEntity;
    private Map<String, Map<Integer, DynamicObject>> localEntryRowCahe = new HashMap<String, Map<Integer, DynamicObject>>();
    private Map<String, Integer> entryRowCountCahe = new HashMap<String, Integer>();
    private Map<String, Integer> entryBatch1MaxSeqCahe = new HashMap<String, Integer>(1);

    public TableModelCache(IRefrencedataProvider refProvide, MainEntityType dt, String pageId) {
        this.pageId = pageId;
        this.dt = dt;
        this.refProvide = refProvide;
    }

    private ModelDataTable getTable() {
        if (this.table == null) {
            this.table = new ModelDataTable(this.refProvide, this.dt, this.pageId);
        }
        return this.table;
    }

    public static boolean isTableCache(String pageId) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"isTableCache");){
            String type = TableModelCache.getCacheType(pageId);
            String val = (String)cache.get(type, CACHE_KEY_ISTABLECACHE);
            if (span.isRealtime()) {
                span.addLocaleTag(SPAN_PAGEID, (Object)pageId);
                span.addLocaleTag("isTableCache", (Object)val);
            }
            boolean bl = StringUtils.equals((CharSequence)"true", (CharSequence)val);
            return bl;
        }
    }

    public DynamicObject getRootDataEntity() {
        return this.getRootDataEntity(true, true);
    }

    private DynamicObject getRootDataEntity(boolean loadRefdata, boolean throwError) {
        block20: {
            if (this.rootDataEntity != null) {
                return this.rootDataEntity;
            }
            try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getRootDataEntity");){
                span.addTag(SPAN_DT_NAME, this.dt.getName());
                this.rootDataEntity = this.getTable().readRoot();
                if (this.rootDataEntity != null) {
                    if (loadRefdata) {
                        this.refProvide.fillReferenceData(new Object[]{this.rootDataEntity}, (IDataEntityType)this.dt);
                    }
                    for (ICollectionProperty prop : this.dt.getProperties().getCollectionProperties(false)) {
                        if (prop instanceof DynamicLocaleProperty || prop instanceof MulBasedataProp) continue;
                        this.setDataLoaded(prop.getItemType().getAlias(), false);
                    }
                    break block20;
                }
                if (!throwError) {
                    span.addLocaleTag(SPAN_ROOTDATAENTITY, null);
                    DynamicObject dynamicObject = null;
                    return dynamicObject;
                }
                KDException e = new KDException(new ErrorCode("bos.pageCacheInvalid", ResManager.loadKDString((String)"\u9875\u9762\u672a\u521d\u59cb\u5316\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00---\u4ece\u7f13\u5b58\u8bfb\u53d6\u6a21\u578b\u6570\u636e\u5931\u8d25,\u952e\u503c:%s", (String)"RedisModelCache_0", (String)"bos-entity-core", (Object[])new Object[0])), new Object[]{this.pageId + "." + this.dt.getName()});
                EntityTracer.addLocaleTag((String)SPAN_PAGEID, (String)this.pageId);
                EntityTracer.addLocaleTag((String)SPAN_DT, (Object)this.dt);
                EntityTracer.throwException((Throwable)e);
                throw e;
            }
        }
        return this.rootDataEntity;
    }

    private void setDataLoaded(String tableName, boolean isLoaded) {
        List snapshots;
        if (this.rootDataEntity.getDataEntityState().getPkSnapshotSet() != null && (snapshots = this.rootDataEntity.getDataEntityState().getPkSnapshotSet().Snapshots) != null) {
            for (PkSnapshot snapshot : snapshots) {
                if (!snapshot.TableName.equalsIgnoreCase(tableName)) continue;
                snapshot.setLoaded(isLoaded);
                break;
            }
        }
    }

    public DynamicObject getAll() {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getAll");){
            span.addTag(SPAN_DT_NAME, this.dt.getName());
            DynamicObject dataEntity = this.getRootDataEntity(true, true);
            for (ICollectionProperty prop : this.dt.getProperties().getCollectionProperties(false)) {
                if (prop instanceof DynamicLocaleProperty || prop instanceof MulBasedataProp) continue;
                DynamicObjectCollection dynamicObjectCollection = this.getEntryRowDataEntities((EntryProp)prop);
            }
            DynamicObject dynamicObject = dataEntity;
            return dynamicObject;
        }
    }

    public DynamicObject getEntryRowDataEntity(String entryKey, int rowIndex) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getEntryRowDataEntity");){
            span.addTag(SPAN_DT_NAME, this.dt.getName() + "." + entryKey);
            span.addTag(SPAN_ROWINDEX, String.valueOf(rowIndex));
            ICollectionProperty prop = (ICollectionProperty)this.dt.getProperties().get((Object)entryKey);
            DynamicObject ret = null;
            DynamicObject rootDataEntity2 = this.getRootDataEntity(true, false);
            if (rootDataEntity2 == null) {
                DynamicObject dynamicObject = null;
                return dynamicObject;
            }
            if (rowIndex < 0) {
                DynamicObject dynamicObject = null;
                return dynamicObject;
            }
            Map<Integer, DynamicObject> mapRows = this.localEntryRowCahe.get(prop.getName());
            if (mapRows == null) {
                mapRows = new HashMap<Integer, DynamicObject>();
                this.localEntryRowCahe.put(prop.getName(), mapRows);
            } else if (mapRows.size() > 0) {
                ret = mapRows.get(rowIndex);
            }
            if (ret == null) {
                ModelDataTable.TableData tableData = this.getTable().readEntryRow(prop, rowIndex);
                if (tableData == null) {
                    DynamicObject dynamicObject = null;
                    return dynamicObject;
                }
                if (StringUtils.isBlank((CharSequence)tableData.getData())) {
                    Object[] objs = this.getTable().readObject(new Object[]{tableData.getEntryId()}, (IDataEntityType)((DynamicObjectType)prop.getItemType()), 0, 0);
                    this.refProvide.fillReferenceData(objs, prop.getItemType());
                    if (objs != null && objs.length > 0) {
                        ret = (DynamicObject)objs[0];
                        ret.set("seq", (Object)(rowIndex + 1));
                        this.getTable().updateRowsFromDb(prop, new DynamicObject[]{ret});
                    }
                } else {
                    DataEntityDeserializerOption option = new DataEntityDeserializerOption();
                    option.setIncludeDataEntityState(true);
                    ret = DataEntitySerializer.deserializerFromListString((IDataEntityType)prop.getItemType(), (String)tableData.getData(), (DataEntityDeserializerOption)option);
                    this.refProvide.fillReferenceData(new Object[]{ret}, prop.getItemType());
                }
                if (ret != null) {
                    ret.set("seq", (Object)(rowIndex + 1));
                    ret.setParent((Object)this.getRootDataEntity());
                    mapRows.put(rowIndex, ret);
                }
            }
            if (span.isRealtime()) {
                span.addLocaleTag(SPAN_ENTRY_ROWS, (Object)ret);
            }
            DynamicObject dynamicObject = ret;
            return dynamicObject;
        }
    }

    public List<DynamicObject> getEntryRowDataEntities(String entryKey, int startRowIndex, int endRowIndex) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getEntryRowDataEntities");){
            span.addTag(SPAN_DT_NAME, this.dt.getName() + "." + entryKey);
            span.addTag("startRowIndex", String.valueOf(startRowIndex));
            span.addTag("endRowIndex", String.valueOf(endRowIndex));
            EntryProp prop = (EntryProp)this.dt.getProperties().get((Object)entryKey);
            List<ModelDataTable.TableData> tableDatas = this.getTable().readEntryRows((ICollectionProperty)prop, startRowIndex, endRowIndex);
            List<DynamicObject> entryRows = this.tableDataToEntryRows(prop, tableDatas);
            span.addLocaleTag(SPAN_ROWS_SIZE, (Object)entryRows.size());
            List<DynamicObject> list = entryRows;
            return list;
        }
    }

    public DynamicObjectCollection getEntryRowDataEntities(EntryProp prop) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getEntryRowDataEntities");){
            span.addTag(SPAN_DT_NAME, this.dt.getName() + "." + prop.getName());
            DynamicObject dataEntity = this.getRootDataEntity();
            DynamicObjectCollection entryRows = (DynamicObjectCollection)prop.getValueFast((Object)dataEntity);
            IDataEntityType itemType = prop.getItemType();
            if (entryRows == null || entryRows.isEmpty()) {
                this.getTable().checkAndFixEntrySeq((ICollectionProperty)prop);
                List<ModelDataTable.TableData> tableDatas = this.getTable().readEntryRows((ICollectionProperty)prop);
                ArrayList rowsFromTable = new ArrayList(tableDatas.size());
                String[] strRows = new String[tableDatas.size()];
                for (int i = 0; i < tableDatas.size(); ++i) {
                    strRows[i] = tableDatas.get(i).getData();
                }
                if (!tableDatas.isEmpty()) {
                    DataEntityDeserializerOption option = new DataEntityDeserializerOption();
                    option.setIncludeDataEntityState(true);
                    DataEntitySerializer.deserializerFromListString(rowsFromTable, (IDataEntityType)itemType, (String[])strRows, (DataEntityDeserializerOption)option);
                }
                if (!rowsFromTable.isEmpty()) {
                    this.refProvide.fillReferenceData(rowsFromTable.toArray(), prop.getItemType());
                    Map<Integer, DynamicObject> rowsFromLocal = this.localEntryRowCahe.get(prop.getName());
                    if (rowsFromLocal == null) {
                        rowsFromLocal = new HashMap<Integer, DynamicObject>();
                        this.localEntryRowCahe.put(prop.getName(), rowsFromLocal);
                    }
                    ArrayList<DynamicObject> batch2 = new ArrayList<DynamicObject>(rowsFromTable.size());
                    for (int i = 0; i < tableDatas.size(); ++i) {
                        ModelDataTable.TableData tableData = tableDatas.get(i);
                        int seq = tableDatas.get(i).getSeq();
                        if (!tableData.isBatch1() && !tableData.isAdded()) {
                            batch2.add((DynamicObject)rowsFromTable.get(i));
                        }
                        if (!tableData.isDeleted()) {
                            DynamicObject entryRow = rowsFromLocal.get(seq - 1);
                            if (entryRow == null) {
                                entryRow = (DynamicObject)rowsFromTable.get(i);
                                rowsFromLocal.put(seq - 1, entryRow);
                            }
                            entryRow.set("seq", (Object)seq);
                            if (entryRows != null) {
                                entryRows.add((Object)entryRow);
                            }
                        }
                        if (batch2.isEmpty()) continue;
                        this.addPkSnapshot(dataEntity, batch2);
                    }
                }
                this.checkDelEntryRows(dataEntity, prop, entryRows);
                this.setDataLoaded(itemType.getAlias(), true);
            }
            span.addLocaleTag(SPAN_ENTRY_ROWS, entryRows == null ? null : Integer.valueOf(entryRows.size()));
            this.addCommonTag(span, prop.getName());
            DynamicObjectCollection dynamicObjectCollection = entryRows;
            return dynamicObjectCollection;
        }
    }

    public void filterEntry(String entryKey, EntryQueryParam queryParam) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"filterEntry");){
            DynamicObject root = this.getRootDataEntity();
            EntryProp prop = (EntryProp)this.dt.getProperties().get((Object)entryKey);
            this.filterSplitEntry(prop, root, queryParam);
        }
    }

    public int getFilterEntryRowCount(String entryKey) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getFilterEntryRowCount");){
            if (!this.isFilter(entryKey)) {
                int n = this.getEntryRowCount(entryKey);
                return n;
            }
            int rowCount = this.getTable().readFilterEntryRowCount(entryKey);
            if (span.isRealtime()) {
                span.addLocaleTag(SPAN_DT_NAME, (Object)(this.dt.getName() + "." + entryKey));
                span.addLocaleTag(SPAN_ROWS_SIZE, (Object)rowCount);
            }
            int n = rowCount;
            return n;
        }
    }

    public DynamicObject[] getFilterEntryRows(String entryKey, int startRowIndex, int endRowIndex) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getFilterEntryRows");){
            span.addTag(SPAN_DT_NAME, this.dt.getName() + "." + entryKey);
            span.addTag("startRowIndex", String.valueOf(startRowIndex));
            span.addTag("endRowIndex", String.valueOf(endRowIndex));
            if (!this.isFilter(entryKey)) {
                DynamicObject[] dynamicObjectArray = this.getEntryRowDataEntities(entryKey, startRowIndex, endRowIndex).toArray(new DynamicObject[0]);
                return dynamicObjectArray;
            }
            EntryProp prop = (EntryProp)this.dt.getProperties().get((Object)entryKey);
            int length = endRowIndex - startRowIndex;
            List<ModelDataTable.TableData> tableDataList = this.getTable().readFilterEntryRows((ICollectionProperty)prop, startRowIndex, endRowIndex);
            List<DynamicObject> entryRows = this.tableDataToEntryRows(prop, tableDataList);
            span.addLocaleTag(SPAN_ROWS_SIZE, (Object)entryRows.size());
            DynamicObject[] dynamicObjectArray = entryRows.toArray(new DynamicObject[0]);
            return dynamicObjectArray;
        }
    }

    public List<Integer> getFilterEntryRowKeys(String entryKey, int startRowIndex, int endRowIndex) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getFilterEntryRows");){
            span.addTag(SPAN_DT_NAME, this.dt.getName() + "." + entryKey);
            span.addTag("startRowIndex", String.valueOf(startRowIndex));
            span.addTag("endRowIndex", String.valueOf(endRowIndex));
            if (!this.isFilter(entryKey)) {
                int rowCount = this.getFilterEntryRowCount(entryKey);
                endRowIndex = Math.min(rowCount, endRowIndex);
                ArrayList<Integer> rowKeys = new ArrayList<Integer>(endRowIndex - startRowIndex);
                for (int row = startRowIndex; row < endRowIndex; ++row) {
                    rowKeys.add(row);
                }
                ArrayList<Integer> arrayList = rowKeys;
                return arrayList;
            }
            List<Integer> tableDataList = this.getTable().readFilterEntryRowKeys(entryKey, startRowIndex, endRowIndex);
            span.addLocaleTag(SPAN_ROWS_SIZE, (Object)tableDataList.size());
            List<Integer> list = tableDataList;
            return list;
        }
    }

    public List<Integer> getFilterIndexByRowKeys(String entryKey, List<Integer> rowkeyList) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getFilterIndexByRowKeys");){
            if (CollectionUtils.isEmpty(rowkeyList) || !this.isFilter(entryKey)) {
                List<Integer> list = rowkeyList;
                return list;
            }
            int[] rowIndexs = new int[rowkeyList.size()];
            for (int i = 0; i < rowIndexs.length; ++i) {
                rowIndexs[i] = rowkeyList.get(i);
            }
            List<Integer> filterSeqs = this.getTable().readFilterSeqByRowKeys(entryKey, rowIndexs);
            ArrayList<Integer> filterIndexs = new ArrayList<Integer>(filterSeqs.size());
            Object object = filterSeqs.iterator();
            while (object.hasNext()) {
                int seq = object.next();
                filterIndexs.add(seq - 1);
            }
            if (span.isRealtime()) {
                span.addLocaleTag(SPAN_DT_NAME, (Object)(this.dt.getName() + "." + entryKey));
                span.addLocaleTag("rowkeyList", rowkeyList);
                span.addLocaleTag("filterIndexs", filterIndexs);
            }
            object = filterIndexs;
            return object;
        }
    }

    public List<Integer> filterSortByRowKeys(String entryKey, List<Integer> rowkeyList) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getFilterSortByRowKeys");){
            int[] rowIndexs = new int[rowkeyList.size()];
            for (int i = 0; i < rowIndexs.length; ++i) {
                rowIndexs[i] = rowkeyList.get(i);
            }
            List<Integer> seqs = this.getTable().readFilterSortByRowKeys(entryKey, rowIndexs);
            ArrayList<Integer> indexs = new ArrayList<Integer>(seqs.size());
            Object object = seqs.iterator();
            while (object.hasNext()) {
                int seq = object.next();
                indexs.add(seq - 1);
            }
            if (span.isRealtime()) {
                span.addLocaleTag(SPAN_DT_NAME, (Object)(this.dt.getName() + "." + entryKey));
                span.addLocaleTag("rowkeyList", rowkeyList);
                span.addLocaleTag("indexs", indexs);
            }
            object = indexs;
            return object;
        }
    }

    public boolean isFilterAndSortModel(String entryKey) {
        return this.isFilter(entryKey);
    }

    public EntryQueryParam getEntryQueryParam(String entryKey) {
        String key_queryparam;
        Map cacheVals = cache.getAll(TableModelCache.getCacheType(this.pageId));
        String cacheVal_queryparam = (String)cacheVals.get(key_queryparam = entryKey + "." + CACHE_KEY_QUERYPARAM);
        if (StringUtils.isBlank((CharSequence)cacheVal_queryparam)) {
            return new EntryQueryParam();
        }
        return (EntryQueryParam)SerializationUtils.fromJsonString((String)cacheVal_queryparam, EntryQueryParam.class);
    }

    public void insertEntryRows(String entryKey, int rowIndex, DynamicObject[] entryRows) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"insertEntryRows");){
            this.addCommonTag(span, entryKey);
            span.addTag(SPAN_ROWINDEX, String.valueOf(rowIndex));
            span.addTag(SPAN_ROWS_SIZE, String.valueOf(entryRows.length));
            ICollectionProperty prop = (ICollectionProperty)this.dt.getProperties().get((Object)entryKey);
            Map<Integer, DynamicObject> mapRows = this.upLocaleBeforeInsert(entryKey, rowIndex, entryRows.length);
            DynamicObject parentObj = this.getRootDataEntity();
            DynamicObjectCollection cols = parentObj.getDynamicObjectCollection((IDataEntityProperty)prop);
            int startIndex = rowIndex;
            for (DynamicObject row : entryRows) {
                mapRows.put(startIndex, row);
                row.set("seq", (Object)(startIndex + 1));
                row.setParent((Object)parentObj);
                if (!cols.isEmpty()) {
                    this.insertRowToDynamicCollection(cols, startIndex, row);
                }
                ++startIndex;
            }
            this.getTable().insertRows(prop, rowIndex, entryRows);
            this.entryRowCountCahe.remove(prop.getName());
            this.entryBatch1MaxSeqCahe.remove(prop.getName());
            span.addLocaleTag(SPAN_PROP, (Object)prop);
            span.fireEvent(EVENT_INSERT);
        }
    }

    public void appendEntryRows(String entryKey, DynamicObject[] entryRows) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"appendEntryRows");){
            int rowCount;
            this.addCommonTag(span, entryKey);
            span.addTag(SPAN_ROWS_SIZE, String.valueOf(entryRows.length));
            ICollectionProperty prop = (ICollectionProperty)this.dt.getProperties().get((Object)entryKey);
            Map<Integer, DynamicObject> mapRows = this.localEntryRowCahe.get(prop.getName());
            if (mapRows == null) {
                mapRows = new HashMap<Integer, DynamicObject>(16);
                this.localEntryRowCahe.put(prop.getName(), mapRows);
            }
            int startIndex = rowCount = this.getTable().readMaxSeq(entryKey);
            span.addLocaleTag(SPAN_ENTRY_ROWS, (Object)this.entryRowCountCahe.get(entryKey));
            span.addTag(SPAN_CACHEINDEX, String.valueOf(startIndex));
            DynamicObject parentObj = this.getRootDataEntity();
            DynamicObjectCollection cols = parentObj.getDynamicObjectCollection((IDataEntityProperty)prop);
            for (DynamicObject row : entryRows) {
                row.set("seq", (Object)(startIndex + 1));
                mapRows.put(startIndex, row);
                row.setParent((Object)parentObj);
                if (!cols.isEmpty()) {
                    this.insertRowToDynamicCollection(cols, startIndex, row);
                }
                ++startIndex;
            }
            this.getTable().appendRows(prop, entryRows);
            this.entryRowCountCahe.remove(prop.getName());
            this.entryBatch1MaxSeqCahe.remove(prop.getName());
            span.addLocaleTag(SPAN_PROP, (Object)prop);
            span.fireEvent(EVENT_ADD);
        }
    }

    public void delEntryRow(String entryKey, int rowIndex) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"delEntryRow");){
            span.addTag(SPAN_ROWINDEX, String.valueOf(rowIndex));
            ICollectionProperty prop = (ICollectionProperty)this.dt.getProperties().get((Object)entryKey);
            if (rowIndex >= 0) {
                int[] passRowIndices = this.getTable().checkDelEntryRows(entryKey, new int[]{rowIndex});
                if (passRowIndices.length == 0) {
                    span.addLocaleTag("checkDelEntryRows", (Object)false);
                    return;
                }
                this.setRemovedItemFlag(true);
                this.getTable().deleteRows(entryKey, rowIndex, 1);
                DynamicObject root = this.getRootDataEntity();
                DynamicObjectCollection cols = root.getDynamicObjectCollection((IDataEntityProperty)prop);
                if (!cols.isEmpty()) {
                    this.delRowFromDynamicCollection(cols, new int[]{rowIndex});
                }
                this.upLocaleAfterDelete(entryKey, rowIndex, 1);
                this.entryRowCountCahe.remove(prop.getName());
                this.entryBatch1MaxSeqCahe.remove(prop.getName());
            }
            this.addCommonTag(span, entryKey);
            span.addLocaleTag(SPAN_PROP, (Object)prop);
            span.fireEvent(EVENT_REMOVE);
        }
    }

    public void delEntryRows(String entryKey, int[] rowIndices) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"delEntryRows");){
            if (rowIndices.length > 0) {
                span.addLocaleTag(SPAN_ROWINDEX, (Object)rowIndices);
                ICollectionProperty prop = (ICollectionProperty)this.dt.getProperties().get((Object)entryKey);
                int[] passRowIndices = this.getTable().checkDelEntryRows(entryKey, rowIndices);
                this.getTable().deleteRows(entryKey, passRowIndices);
                DynamicObject root = this.getRootDataEntity();
                DynamicObjectCollection cols = root.getDynamicObjectCollection((IDataEntityProperty)prop);
                if (!cols.isEmpty()) {
                    this.delRowFromDynamicCollection(cols, rowIndices);
                }
                ArrayList<int[]> removeItems = ModelDataTable.getRemoveItems(passRowIndices);
                for (int i = removeItems.size() - 1; i >= 0; --i) {
                    int startIndex = removeItems.get(i)[0];
                    int len = removeItems.get(i)[1];
                    this.upLocaleAfterDelete(entryKey, startIndex, len);
                }
                this.setRemovedItemFlag(true);
                this.entryRowCountCahe.remove(prop.getName());
                this.entryBatch1MaxSeqCahe.remove(prop.getName());
                this.addCommonTag(span, entryKey);
                span.addLocaleTag(SPAN_PROP, (Object)prop);
                span.fireEvent(EVENT_REMOVE);
            }
        }
    }

    public void deleteEntryData(String entryKey) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"deleteEntryData");){
            Map<Integer, DynamicObject> entryRows;
            ICollectionProperty prop = (ICollectionProperty)this.dt.getProperty(entryKey);
            span.addLocaleTag(SPAN_ENTRY_ROWS, (Object)this.getTable().readEntryRowCount(entryKey));
            DynamicObject root = this.getRootDataEntity();
            if (ModelDataTable.isSplitPage(root, prop.getName())) {
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u3010%s\u3011\u884c\u6570\u6bd4\u8f83\u591a\uff0c\u662f\u5206\u6279\u52a0\u8f7d\u7684\uff0c\u65e0\u6cd5\u4e00\u6b21\u6e05\u7406\u5168\u90e8\u5206\u5f55\u884c\uff0c\u8bf7\u9009\u62e9\u5206\u5f55\u884c\u5206\u6279\u5220\u9664\u3002", (String)"TableModelCache_0", (String)"bos-entity-core", (Object[])new Object[0]), prop.getDisplayName().toString());
                throw new KDException(new ErrorCode("TableModelCache.deleteEntryData.01", msg), new Object[0]);
            }
            this.getTable().deleteEntry(entryKey);
            DynamicObjectCollection cols = root.getDynamicObjectCollection((IDataEntityProperty)prop);
            if (!cols.isEmpty()) {
                cols.clear();
            }
            if ((entryRows = this.localEntryRowCahe.get(prop.getName())) != null) {
                entryRows.clear();
            }
            this.setRemovedItemFlag(true);
            this.entryRowCountCahe.put(prop.getName(), 0);
            this.entryBatch1MaxSeqCahe.put(prop.getName(), 0);
            this.addCommonTag(span, entryKey);
            span.addLocaleTag(SPAN_PROP, (Object)prop);
            span.fireEvent(EVENT_REMOVEALL);
        }
    }

    public void swapEntryRow(String entryKey, int rowIndex1, int rowIndex2) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"swapEntryRow");){
            span.addTag("rowIndex1", String.valueOf(rowIndex1));
            span.addTag("rowIndex2", String.valueOf(rowIndex2));
            this.addCommonTag(span, entryKey);
            ICollectionProperty prop = (ICollectionProperty)this.dt.getProperty(entryKey);
            this.getTable().swapEntryRow(prop, rowIndex1, rowIndex2);
            Map<Integer, DynamicObject> entryRows = this.localEntryRowCahe.get(entryKey);
            if (entryRows != null) {
                DynamicObject entryRow1 = entryRows.get(rowIndex1);
                DynamicObject entryRow2 = entryRows.get(rowIndex2);
                entryRows.remove(rowIndex1);
                entryRows.remove(rowIndex2);
                if (entryRow1 != null) {
                    entryRow1.set("seq", (Object)(rowIndex2 + 1));
                    entryRows.put(rowIndex2, entryRow1);
                }
                if (entryRow2 != null) {
                    entryRow2.set("seq", (Object)(rowIndex1 + 1));
                    entryRows.put(rowIndex1, entryRow2);
                }
            }
        }
    }

    public void moveEntryBlockRows(String entryKey, int startIndex, int len, int toIndex) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"moveEntryBlockRows");){
            if (span.isRealtime()) {
                span.addTag(SPAN_DT_NAME, this.dt.getName() + "." + entryKey);
                span.addTag("startIndex", String.valueOf(startIndex));
                span.addTag("len", String.valueOf(len));
                span.addTag("toIndex", String.valueOf(toIndex));
            }
            if (toIndex > startIndex && toIndex < startIndex + len) {
                throw new KDException(new ErrorCode("bos.", String.format(ResManager.loadKDString((String)"\u4ece\u884c%1$s\u79fb\u52a8%2$s\u6761\u6570\u636e\u5230\u884c%3$s\u9519\u8bef\uff0c\u76ee\u6807\u884c\u53f7\u5e94\u5927\u4e8e\u8d77\u59cb\u884c+\u79fb\u52a8\u8bb0\u5f55\u6570\u3002", (String)"RedisModelCache_2", (String)"bos-entity-core", (Object[])new Object[0]), startIndex, len, toIndex)), new Object[0]);
            }
            this.getTable().moveEntryBlockRows(entryKey, startIndex, len, toIndex);
            Map<Integer, DynamicObject> entryRows = this.localEntryRowCahe.get(entryKey);
            if (entryRows != null) {
                HashMap<Integer, DynamicObject> tempRows = new HashMap<Integer, DynamicObject>(entryRows);
                entryRows.clear();
                if (toIndex > startIndex) {
                    int moveLen = toIndex - startIndex - len + 1;
                    for (Map.Entry entry : tempRows.entrySet()) {
                        int index = (Integer)entry.getKey();
                        if (startIndex <= index && index < startIndex + len) {
                            entryRows.put(index + moveLen, (DynamicObject)entry.getValue());
                            continue;
                        }
                        if (startIndex + len <= index && index <= toIndex) {
                            entryRows.put(index - len, (DynamicObject)entry.getValue());
                            continue;
                        }
                        entryRows.put((Integer)entry.getKey(), (DynamicObject)entry.getValue());
                    }
                } else {
                    int moveLen = startIndex - toIndex;
                    for (Map.Entry entry : tempRows.entrySet()) {
                        int index = (Integer)entry.getKey();
                        if (startIndex <= index && index < startIndex + len) {
                            entryRows.put(index - moveLen, (DynamicObject)entry.getValue());
                            continue;
                        }
                        if (toIndex <= index && index < startIndex) {
                            entryRows.put(index + len, (DynamicObject)entry.getValue());
                            continue;
                        }
                        entryRows.put((Integer)entry.getKey(), (DynamicObject)entry.getValue());
                    }
                }
            }
        }
    }

    public void moveEntryBlockRows(String entryKey, int[] formIndexs, int toIndex) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"moveEntryBlockRows");){
            if (span.isRealtime()) {
                span.addTag(SPAN_DT_NAME, this.dt.getName() + "." + entryKey);
                span.addTag("toIndex", String.valueOf(toIndex));
                span.addLocaleTag("formIndexs", (Object)formIndexs);
            }
            int minIndex = toIndex;
            int maxIndex = toIndex;
            for (int i = 0; i < formIndexs.length; ++i) {
                minIndex = Math.min(minIndex, formIndexs[i]);
                maxIndex = Math.max(maxIndex, formIndexs[i]);
            }
            if (minIndex < 0) {
                minIndex = 0;
            }
            if (maxIndex < 0) {
                maxIndex = 0;
            }
            List moveAfterRowKeysList = new DragEntryRow().getMoveAfterRowKeysList(formIndexs, toIndex, minIndex, maxIndex);
            ICollectionProperty prop = (ICollectionProperty)this.dt.getProperty(entryKey);
            this.getTable().moveEntryBlockRows(prop, moveAfterRowKeysList, minIndex, maxIndex + 1);
            Map<Integer, DynamicObject> entryRows = this.localEntryRowCahe.get(entryKey);
            if (entryRows != null) {
                int index;
                int i;
                ArrayList<DynamicObject> moveAfterRowList = new ArrayList<DynamicObject>(moveAfterRowKeysList.size());
                for (i = 0; i < moveAfterRowKeysList.size(); ++i) {
                    index = (Integer)moveAfterRowKeysList.get(i);
                    moveAfterRowList.add(entryRows.get(index));
                }
                for (i = 0; i < moveAfterRowList.size(); ++i) {
                    index = minIndex + i;
                    DynamicObject entryRow = (DynamicObject)moveAfterRowList.get(i);
                    entryRow.set("seq", (Object)(index + 1));
                    entryRows.put(index, entryRow);
                }
            }
        }
    }

    public void initTable(DynamicObject dataEntity) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"initTable");){
            cache.remove(TableModelCache.getCacheType(this.pageId));
            cache.put(TableModelCache.getCacheType(this.pageId), CACHE_KEY_ISTABLECACHE, (Object)"true");
            this.getTable().initTable(dataEntity);
        }
    }

    public void storeAll(DynamicObject dataEntity) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"storeAll");){
            this.checkEntryInfoStartIndex(dataEntity);
            this.getTable().updateAll(dataEntity);
            for (Map.Entry<String, Map<Integer, DynamicObject>> localEntryItem : this.localEntryRowCahe.entrySet()) {
                Map<Integer, DynamicObject> localEntryRows = localEntryItem.getValue();
                ICollectionProperty prop = (ICollectionProperty)this.dt.getProperties().get((Object)localEntryItem.getKey());
                IDataEntityType entryType = prop.getItemType();
                IDataEntityProperty seqProp = (IDataEntityProperty)entryType.getProperties().get((Object)"seq");
                DynamicObjectCollection cols = dataEntity.getDynamicObjectCollection((IDataEntityProperty)prop);
                for (DynamicObject entryRow : cols) {
                    int rowIndex;
                    DynamicObject localRow;
                    if (entryRow != (localRow = localEntryRows.get(rowIndex = entryRow.getInt(seqProp) - 1))) continue;
                    localEntryRows.remove(rowIndex);
                }
            }
            this.getTable().updateChanged(dataEntity, this.localEntryRowCahe);
            this.rootDataEntity = null;
            this.localEntryRowCahe = new HashMap<String, Map<Integer, DynamicObject>>();
            this.entryRowCountCahe = new HashMap<String, Integer>();
            this.entryBatch1MaxSeqCahe = new HashMap<String, Integer>(1);
        }
    }

    public void storeChanged() {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"storeChanged");){
            this.getTable().updateChanged(this.rootDataEntity, this.localEntryRowCahe);
            this.rootDataEntity = null;
            this.localEntryRowCahe = new HashMap<String, Map<Integer, DynamicObject>>();
        }
    }

    public void storeEntry(DynamicObjectCollection cols) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"storeEntry");){
            this.checkEntryInfoStartIndex((DynamicObject)cols.getParent());
            this.getTable().updateRows(cols);
            this.localEntryRowCahe.remove(cols.getDynamicObjectType().getName());
            this.entryRowCountCahe.clear();
            this.entryBatch1MaxSeqCahe.clear();
        }
    }

    public void release() {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"release");){
            this.getTable().clear();
            cache.remove(TableModelCache.getCacheType(this.pageId));
            this.rootDataEntity = null;
            this.localEntryRowCahe = null;
        }
    }

    public Boolean getRemovedItemFlag() {
        return this.getRootDataEntity().getDataEntityState().getRemovedItems();
    }

    public void setRemovedItemFlag(Boolean b) {
        if (b != null && b.booleanValue()) {
            this.getRootDataEntity().getDataEntityState().setRemovedItems(b);
            this.getRootDataEntity().getLastDirty().set(0, true);
        }
    }

    public int getEntryRowCount(String entryKey) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getEntryRowCount");){
            Integer count = this.entryRowCountCahe.get(entryKey);
            if (count == null) {
                count = this.getTable().readEntryRowCount(entryKey);
                this.entryRowCountCahe.put(entryKey, count);
            }
            if (span.isRealtime()) {
                span.addTag(SPAN_DT_NAME, this.dt.getName() + "." + entryKey);
                span.addLocaleTag(SPAN_ENTRY_ROWS, (Object)count);
            }
            int n = count;
            return n;
        }
    }

    public int getMaxSeqInBatch1(String entryKey) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getMaxSeqInBatch1");){
            Integer maxSeq = this.entryBatch1MaxSeqCahe.get(entryKey);
            if (maxSeq == null) {
                maxSeq = this.getTable().readBatch1MaxSeq(entryKey);
                this.entryBatch1MaxSeqCahe.put(entryKey, maxSeq);
            }
            if (span.isRealtime()) {
                span.addTag(SPAN_DT_NAME, this.dt.getName() + "." + entryKey);
                span.addLocaleTag("batch1.maxSeq", (Object)maxSeq);
            }
            int n = maxSeq;
            return n;
        }
    }

    public boolean isChanged() {
        if (this.rootDataEntity != null && this.rootDataEntity.getLastDirty().length() > 0) {
            return true;
        }
        for (Map.Entry<String, Map<Integer, DynamicObject>> entry : this.localEntryRowCahe.entrySet()) {
            for (Map.Entry<Integer, DynamicObject> entryRow : entry.getValue().entrySet()) {
                DynamicObject rowDataEntity = entryRow.getValue();
                if (!ModelDataTable.isEntryRowChanged(rowDataEntity, null)) continue;
                return true;
            }
        }
        return false;
    }

    public void expireAfter(int timeout) {
    }

    public void setSaveOption(OperateOption option) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"setSaveOption");){
            if (!TableModelCache.isTableCache(this.pageId)) {
                return;
            }
            DynamicObject root = this.getRootDataEntity();
            for (ICollectionProperty prop : this.dt.getProperties().getCollectionProperties(false)) {
                if (!StringUtils.isNotBlank((CharSequence)prop.getItemType().getAlias()) || !ModelDataTable.isSplitPage(root, prop.getName())) continue;
                HashMap<String, String> entryParams = new HashMap<String, String>(4);
                entryParams.put(SPAN_PAGEID, this.pageId);
                entryParams.put("temptable", this.getTableName());
                entryParams.put("entrykey", prop.getName());
                entryParams.put("epkfield", this.getEntryPkField());
                String paramKey = "orm_formmodeltable_" + prop.getItemType().getAlias();
                option.setVariableValue(paramKey, SerializationUtils.toJsonString(entryParams));
                span.addLocaleTag(paramKey, entryParams);
            }
        }
    }

    private List<DynamicObject> tableDataToEntryRows(EntryProp prop, List<ModelDataTable.TableData> tableDataList) {
        Object[] objs;
        ArrayList<Object> entryIds = new ArrayList<Object>(tableDataList.size());
        for (ModelDataTable.TableData tableData : tableDataList) {
            if (!StringUtils.isBlank((CharSequence)tableData.getData())) continue;
            entryIds.add(tableData.getEntryId());
        }
        HashMap<Object, DynamicObject> formDbRows = new HashMap<Object, DynamicObject>(entryIds.size());
        if (!entryIds.isEmpty() && (objs = this.getTable().readObject(entryIds.toArray(), (IDataEntityType)((DynamicObjectType)prop.getItemType()), 0, 0)) != null) {
            for (Object object : objs) {
                formDbRows.put(((DynamicObject)object).getPkValue(), (DynamicObject)object);
            }
        }
        DataEntityDeserializerOption option = new DataEntityDeserializerOption();
        option.setIncludeDataEntityState(true);
        ArrayList<Object> rowsFromTable = new ArrayList<Object>(tableDataList.size());
        for (ModelDataTable.TableData tableData : tableDataList) {
            if (StringUtils.isBlank((CharSequence)tableData.getData())) {
                rowsFromTable.add(formDbRows.get(tableData.getEntryId()));
                continue;
            }
            rowsFromTable.add(DataEntitySerializer.deserializerFromListString((IDataEntityType)prop.getItemType(), (String)tableData.getData(), (DataEntityDeserializerOption)option));
        }
        DynamicObject parentObj = this.getRootDataEntity();
        for (DynamicObject dynamicObject : rowsFromTable) {
            dynamicObject.setParent((Object)parentObj);
        }
        this.refProvide.fillReferenceData(rowsFromTable.toArray(new Object[rowsFromTable.size()]), prop.getItemType());
        Map<Integer, DynamicObject> rowsFromLocal = this.localEntryRowCahe.get(prop.getName());
        if (rowsFromLocal == null) {
            rowsFromLocal = new HashMap<Integer, DynamicObject>();
            this.localEntryRowCahe.put(prop.getName(), rowsFromLocal);
        }
        ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(tableDataList.size());
        for (int i = 0; i < tableDataList.size(); ++i) {
            int seq = tableDataList.get(i).getSeq();
            DynamicObject entryRow = rowsFromLocal.get(seq - 1);
            if (entryRow == null) {
                entryRow = (DynamicObject)rowsFromTable.get(i);
                rowsFromLocal.put(seq - 1, entryRow);
            }
            entryRow.set("seq", (Object)seq);
            arrayList.add(entryRow);
        }
        if (!formDbRows.isEmpty()) {
            this.getTable().updateRowsFromDb((ICollectionProperty)prop, formDbRows.values().toArray(new DynamicObject[0]));
        }
        return arrayList;
    }

    private Map<Integer, DynamicObject> upLocaleBeforeInsert(String entryKey, int rowIndex, int length) {
        Map<Integer, DynamicObject> mapRows = this.localEntryRowCahe.get(entryKey);
        if (mapRows == null) {
            mapRows = new HashMap<Integer, DynamicObject>(16);
            this.localEntryRowCahe.put(entryKey, mapRows);
        }
        HashMap<Integer, DynamicObject> tempMap = new HashMap<Integer, DynamicObject>(mapRows);
        mapRows.clear();
        for (Map.Entry entry : tempMap.entrySet()) {
            if ((Integer)entry.getKey() < rowIndex) {
                mapRows.put((Integer)entry.getKey(), (DynamicObject)entry.getValue());
                continue;
            }
            int row = (Integer)entry.getKey() + length;
            DynamicObject entryRow = (DynamicObject)entry.getValue();
            entryRow.set("seq", (Object)(row + 1));
            mapRows.put(row, (DynamicObject)entry.getValue());
        }
        return mapRows;
    }

    private Map<Integer, DynamicObject> upLocaleAfterDelete(String entryKey, int rowIndex, int length) {
        Map<Integer, DynamicObject> mapRows = this.localEntryRowCahe.get(entryKey);
        if (mapRows == null) {
            mapRows = new HashMap<Integer, DynamicObject>(16);
            this.localEntryRowCahe.put(entryKey, mapRows);
        }
        HashMap<Integer, DynamicObject> tempMap = new HashMap<Integer, DynamicObject>(mapRows);
        for (int i = 0; i < length; ++i) {
            tempMap.remove(rowIndex + i);
        }
        mapRows.clear();
        for (Map.Entry entry : tempMap.entrySet()) {
            if ((Integer)entry.getKey() < rowIndex) {
                mapRows.put((Integer)entry.getKey(), (DynamicObject)entry.getValue());
                continue;
            }
            int row = (Integer)entry.getKey() - length;
            DynamicObject entryRow = (DynamicObject)entry.getValue();
            entryRow.set("seq", (Object)(row + 1));
            mapRows.put(row, (DynamicObject)entry.getValue());
        }
        return mapRows;
    }

    private void addPkSnapshot(DynamicObject rootDataEntity, List<DynamicObject> entryRows) {
        if (entryRows.isEmpty()) {
            return;
        }
        PkSnapshotSet rootSnapshotSet = rootDataEntity.getDataEntityState().getPkSnapshotSet();
        if (rootSnapshotSet == null) {
            return;
        }
        HashMap<String, PkSnapshot> rootSnapshotMap = new HashMap<String, PkSnapshot>(rootSnapshotSet.Snapshots.size());
        for (PkSnapshot pkSnapshot : rootSnapshotSet.Snapshots) {
            rootSnapshotMap.put(pkSnapshot.TableName, pkSnapshot);
        }
        HashSet<Object> entryOids = null;
        String entryTable = entryRows.get(0).getDynamicObjectType().getAlias();
        PkSnapshot entrySnapshot = (PkSnapshot)rootSnapshotMap.get(entryTable);
        if (entrySnapshot == null) {
            entryOids = new HashSet<Object>(0);
        } else {
            entryOids = new HashSet(entrySnapshot.Oids.length);
            for (Object oid : entrySnapshot.Oids) {
                entryOids.add(oid);
            }
        }
        for (DynamicObject entryRow : entryRows) {
            Object entryId;
            PkSnapshotSet entrySnapshotSet = entryRow.getDataEntityState().getPkSnapshotSet();
            if (entrySnapshotSet == null || !entryOids.add(entryId = entryRow.getPkValue())) continue;
            for (PkSnapshot fromEntryPkSnapshot : entrySnapshotSet.Snapshots) {
                PkSnapshot fromRootSnapshot = (PkSnapshot)rootSnapshotMap.get(fromEntryPkSnapshot.TableName);
                if (fromRootSnapshot != null) {
                    this.margePkSnapshot(fromRootSnapshot, fromEntryPkSnapshot, entryRow);
                    continue;
                }
                fromRootSnapshot = this.copyPkSnapshot(fromEntryPkSnapshot, entryRow);
                rootSnapshotSet.Snapshots.add(fromRootSnapshot);
                rootSnapshotMap.put(fromEntryPkSnapshot.TableName, fromRootSnapshot);
            }
        }
    }

    private void margePkSnapshot(PkSnapshot fromRootSnapshot, PkSnapshot fromEntryPkSnapshot, DynamicObject entryRow) {
        fromRootSnapshot.Oids = this.copyArrays(fromRootSnapshot.Oids, fromEntryPkSnapshot.Oids);
        fromRootSnapshot.Opids = this.copyOpids(fromRootSnapshot, fromEntryPkSnapshot, entryRow);
    }

    private PkSnapshot copyPkSnapshot(PkSnapshot fromEntryPkSnapshot, DynamicObject entryRow) {
        PkSnapshot fromRootSnapshot = new PkSnapshot();
        fromRootSnapshot.TableName = fromEntryPkSnapshot.TableName;
        fromRootSnapshot.Oids = this.copyArrays(null, fromEntryPkSnapshot.Oids);
        fromRootSnapshot.Opids = this.copyOpids(fromRootSnapshot, fromEntryPkSnapshot, entryRow);
        fromRootSnapshot.setLoaded(true);
        return fromRootSnapshot;
    }

    private Object[] copyOpids(PkSnapshot fromRootSnapshot, PkSnapshot fromEntryPkSnapshot, DynamicObject entryRow) {
        if (fromRootSnapshot.Opids == null) {
            return fromRootSnapshot.Opids;
        }
        if (!this.isEntryWithOpids(fromEntryPkSnapshot.TableName)) {
            return fromRootSnapshot == null ? null : fromRootSnapshot.Opids;
        }
        Object[] opidsFromEntry = null;
        if (fromEntryPkSnapshot.Opids != null) {
            opidsFromEntry = fromEntryPkSnapshot.Opids;
        } else {
            opidsFromEntry = new Object[fromEntryPkSnapshot.Oids.length];
            Object entryId = entryRow.getPkValue();
            for (int i = 0; i < fromEntryPkSnapshot.Oids.length; ++i) {
                opidsFromEntry[i] = entryId;
            }
        }
        return this.copyArrays(fromRootSnapshot == null ? null : fromRootSnapshot.Opids, opidsFromEntry);
    }

    private boolean isEntryWithOpids(String tableName) {
        DbMetadataTable table;
        if (this.dbMetadataDatabase == null) {
            RefObject tempRef_db = new RefObject((Object)this.dbMetadataDatabase);
            DataEntityTypeMap map = DataEntityTypeMap.Build((IDataEntityType)this.dt, (RefObject)tempRef_db);
            this.dbMetadataDatabase = (DbMetadataDatabase)tempRef_db.argvalue;
        }
        return (table = (DbMetadataTable)this.dbMetadataDatabase.getTables().get(tableName)) != null && table.getParentRelation() != null && table.getParentRelation().getParentTable().getParentRelation() != null && table.getDataEntityTypeMap().getDataEntityType() instanceof IEntryType;
    }

    private Object[] copyArrays(Object[] arr1, Object[] arr2) {
        if (arr1 == null && arr2 == null) {
            return null;
        }
        if (arr1 == null) {
            return Arrays.copyOf(arr2, arr2.length);
        }
        if (arr2 == null) {
            return Arrays.copyOf(arr1, arr1.length);
        }
        Object[] arr3 = Arrays.copyOf(arr1, arr1.length + arr2.length);
        for (int i = 0; i < arr2.length; ++i) {
            arr3[arr1.length + i] = arr2[i];
        }
        return arr3;
    }

    private void checkEntryInfoStartIndex(DynamicObject root) {
        if (root == null) {
            return;
        }
        if (root.getDataEntityState().getEntryInfos() == null) {
            return;
        }
        for (Map.Entry entry : root.getDataEntityState().getEntryInfos().entrySet()) {
            EntryInfo entryInfo = (EntryInfo)entry.getValue();
            if (entryInfo.getStartRowIndex() <= 0) continue;
            DynamicProperty prop = this.dt.getProperty((String)entry.getKey());
            throw new KDException(new ErrorCode(this.getClass().getSimpleName() + ".checkSeq.03", String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u3010%s\u3011\u6267\u884c\u4e86\u7ffb\u9875\u64cd\u4f5c\uff0c\u4e0d\u77e5\u662f\u4ec0\u4e48\u5730\u65b9\u505a\u4e86\u7ffb\u9875\u3002\u4f46\u5982\u679c\u7ee7\u7eed\u7f16\u8f91\u5e76\u4fdd\u5b58\uff0c\u4f1a\u81ea\u52a8\u5220\u9664\u7b2c\u4e00\u6279\u6240\u6709\u5206\u5f55\u884c\uff0c\u4ece\u800c\u5bfc\u81f4\u6570\u636e\u4e22\u5931\u3002\u8bf7\u653e\u5f03\u672c\u6b21\u4fee\u6539\uff0c\u91cd\u65b0\u6253\u5f00\u5355\u636e\u8fdb\u884c\u7f16\u8f91\uff0c\u62b1\u6b49\u3002", (String)"RedisModelCache_4", (String)"bos-entity-core", (Object[])new Object[0]), prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString())), new Object[0]);
        }
    }

    private void checkDelEntryRows(DynamicObject root, EntryProp entryProp, DynamicObjectCollection entryRows) {
        PkSnapshotSet rootSnapshotSet = root.getDataEntityState().getPkSnapshotSet();
        if (rootSnapshotSet == null) {
            return;
        }
        PkSnapshot entryPkSnapshot = null;
        String tableName = entryProp.getDynamicCollectionItemPropertyType().getAlias();
        for (Object pkSnapshot : rootSnapshotSet.Snapshots) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)((PkSnapshot)pkSnapshot).TableName, (CharSequence)tableName)) continue;
            entryPkSnapshot = pkSnapshot;
            break;
        }
        if (entryPkSnapshot == null || entryPkSnapshot.Oids == null) {
            return;
        }
        HashSet<Object> entryids = new HashSet<Object>(entryRows.size());
        for (DynamicObject entryRow : entryRows) {
            entryids.add(entryRow.getPkValue());
        }
        ArrayList<Object> delEntryIds = new ArrayList<Object>(entryPkSnapshot.Oids.length);
        for (Object oid : entryPkSnapshot.Oids) {
            if (entryids.contains(oid)) continue;
            delEntryIds.add(oid);
        }
        if (!delEntryIds.isEmpty()) {
            this.getTable().checkEntryDelRows((ICollectionProperty)entryProp, delEntryIds);
        }
    }

    private boolean isFilter(String entryKey) {
        Map cacheVals = cache.getAll(TableModelCache.getCacheType(this.pageId));
        String key_filter = entryKey + "." + CACHE_KEY_FILTER;
        String cacheVal_filter = (String)cacheVals.get(key_filter);
        String key_orderfields = entryKey + "." + CACHE_KEY_ORDER_FIELDS;
        String cacheVal_orderfields = (String)cacheVals.get(key_orderfields);
        return StringUtils.isNotBlank((CharSequence)cacheVal_filter) || StringUtils.isNotBlank((CharSequence)cacheVal_orderfields);
    }

    private void filterSplitEntry(EntryProp prop, DynamicObject rootDataEntity, EntryQueryParam queryParam) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"filterSplitEntry");){
            span.addTag(SPAN_DT_NAME, prop.getName());
            Map cacheVals = cache.getAll(TableModelCache.getCacheType(this.pageId));
            String key_filter = prop.getName() + "." + CACHE_KEY_FILTER;
            String cacheVal_filter = (String)cacheVals.get(key_filter);
            String key_orderfields = prop.getName() + "." + CACHE_KEY_ORDER_FIELDS;
            String cacheVal_orderfields = (String)cacheVals.get(key_orderfields);
            String key_queryparam = prop.getName() + "." + CACHE_KEY_QUERYPARAM;
            ModelDataTable.EntryQueryParser parser = new ModelDataTable.EntryQueryParser(this.dt, queryParam);
            parser.setTop(ModelDataTable.getMaxFilterRows());
            parser.parse();
            if (StringUtils.isBlank((CharSequence)parser.getFormula()) && parser.getSortFields().isEmpty()) {
                if (StringUtils.isNotBlank((CharSequence)cacheVal_filter) || StringUtils.isNotBlank((CharSequence)cacheVal_orderfields)) {
                    this.getTable().resetFilterRows(prop);
                }
                HashMap<String, String> map = new HashMap<String, String>(2);
                map.put(key_filter, "");
                map.put(key_orderfields, "");
                map.put(key_queryparam, "");
                cache.put(TableModelCache.getCacheType(this.pageId), map);
                return;
            }
            this.getTable().resetFilterRows(prop);
            this.getTable().filterFromDb(prop, rootDataEntity.getPkValue(), parser);
            this.getTable().filterFromTemp(prop, parser);
            this.getTable().sortFilterRows(prop, parser);
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put(key_filter, parser.getFormula());
            map.put(key_orderfields, parser.getOrderByDbTable());
            map.put(key_queryparam, SerializationUtils.toJsonString((Object)queryParam));
            cache.put(TableModelCache.getCacheType(this.pageId), map);
        }
    }

    private void insertRowToDynamicCollection(DynamicObjectCollection cols, int row, DynamicObject entryRow) {
        DynamicProperty seqProp = cols.getDynamicObjectType().getProperty("seq");
        boolean success = false;
        for (int index = row; index >= 0; --index) {
            int seq;
            if (index >= cols.size() || (seq = ((Integer)seqProp.getValueFast(cols.get(index))).intValue()) >= row + 1 || index >= row) continue;
            cols.add(index + 1, entryRow);
            success = true;
            break;
        }
        if (!success) {
            cols.add((Object)entryRow);
        }
    }

    private void delRowFromDynamicCollection(DynamicObjectCollection cols, int[] rows) {
        HashSet<Integer> delSeqs = new HashSet<Integer>(rows.length);
        for (int row : rows) {
            delSeqs.add(row + 1);
        }
        int[] sorted_rows = Arrays.copyOf(rows, rows.length);
        Arrays.sort(sorted_rows);
        DynamicProperty seqProp = cols.getDynamicObjectType().getProperty("seq");
        for (int index = sorted_rows[sorted_rows.length - 1]; index >= 0; --index) {
            int seq;
            if (index < cols.size() && delSeqs.remove(seq = ((Integer)seqProp.getValueFast(cols.get(index))).intValue())) {
                cols.remove(index);
            }
            if (delSeqs.isEmpty()) break;
        }
    }

    private static String getCacheType(String pageId) {
        return String.format("%s.tablemodelcache.%s", CacheKeyUtil.getAcctId(), pageId);
    }

    private String getTableName() {
        return this.getTable().getTableName();
    }

    private String getEntryPkField() {
        return this.getTable().getEntryPkField();
    }

    private void addCommonTag(EntityTraceSpan span, String entryKey) {
        if (StringUtils.isNotEmpty((CharSequence)entryKey)) {
            span.addTag(SPAN_DT_NAME, this.dt.getName() + "." + entryKey);
        } else {
            span.addTag(SPAN_DT_NAME, this.dt.getName());
        }
        span.addLocaleTag(SPAN_ROOTDATAENTITY, (Object)this.rootDataEntity);
        span.addLocaleTag(SPAN_DT, (Object)this.dt);
    }
}

