/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.datamodel;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.EntryInfo;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ITreeEntryProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.orm.util.CollectionUtils;

public final class DirtyManager {
    private static final String SPAN_TYPE_DATAMODEL = "datamodel";
    private static final String KEY_ENTRY_SEQ = "seq";
    private static final String BOS_ENTITY_CORE = "bos-entity-core";
    private AbstractFormDataModel _model;
    private List<String> changeDescList = new ArrayList<String>(1);

    public DirtyManager(AbstractFormDataModel model) {
        this._model = model;
    }

    public AbstractFormDataModel getModel() {
        return this._model;
    }

    public void release() {
        this._model = null;
    }

    public void clearDirty() {
        this.clearDataEntityDirty(this._model.getDataEntity(true));
    }

    public void clearDirty(DynamicObject activeRow) {
        this.clearDataEntityDirty(activeRow);
    }

    public void clearDirty(String entityKey, int row) {
        IDataEntityProperty property = this._model.getProperty(entityKey);
        this.clearRowDirty(property, row);
    }

    public boolean isDirty() {
        return this.isDirty(this._model.getDataEntity(true));
    }

    public boolean isDirty(DynamicObject activeRow, IDataEntityProperty keyProp) {
        return !this.canRemove(activeRow, keyProp);
    }

    private boolean isDirty(DynamicObject dataEntity) {
        if (dataEntity == null) {
            return false;
        }
        if (this.isDirtySimpleProp(dataEntity)) {
            return true;
        }
        IDataEntityType dt = dataEntity.getDataEntityType();
        for (IComplexProperty property : dt.getProperties().getComplexProperties(false)) {
            Object tempVar2 = property.getValueFast((Object)dataEntity);
            DynamicObject value = (DynamicObject)(tempVar2 instanceof DynamicObject ? tempVar2 : null);
            if (!this.isDirty(value)) continue;
            return true;
        }
        for (IComplexProperty property : dt.getProperties().getCollectionProperties(false)) {
            if (!this.isDirtyCollectionProp(dataEntity, (ICollectionProperty)property)) continue;
            return true;
        }
        return false;
    }

    private boolean isDirtySimpleProp(DynamicObject dataEntity) {
        DataEntityState state = dataEntity.getDataEntityState();
        return state.getFromDatabase() ? state.getDataEntityDirty() : state.getDataEntityDirty() && state.isBizChanged() && !this.isSeqChangedOnly(dataEntity);
    }

    private boolean isDirtyCollectionProp(DynamicObject dataEntity, ICollectionProperty property) {
        Object tempVar3 = dataEntity.getDataStorage().getLocalValue((IDataEntityProperty)property);
        if (tempVar3 == null) {
            return false;
        }
        Iterable enumerable = (Iterable)(tempVar3 instanceof Iterable ? tempVar3 : null);
        if (enumerable == null) {
            return false;
        }
        for (Object item : enumerable) {
            DynamicObject value = (DynamicObject)(item instanceof DynamicObject ? item : null);
            if (!this.isDirty(value)) continue;
            return true;
        }
        return false;
    }

    private void clearDataEntityDirty(DynamicObject dataEntity) {
        if (dataEntity != null) {
            DynamicObject value;
            IDataEntityType dt = dataEntity.getDataEntityType();
            if (!dataEntity.getDataEntityState().getFromDatabase()) {
                dataEntity.getDataEntityState().setBizChanged(false);
            }
            for (IComplexProperty property : dt.getProperties().getComplexProperties(false)) {
                Object tempVar = property.getValueFast((Object)dataEntity);
                value = (DynamicObject)(tempVar instanceof DynamicObject ? tempVar : null);
                this.clearDataEntityDirty(value);
            }
            for (IComplexProperty property : dt.getProperties().getCollectionProperties(false)) {
                Iterable enumerable;
                Object tempVar2 = dataEntity.getDataStorage().getLocalValue((IDataEntityProperty)property);
                if (tempVar2 == null) continue;
                if (property instanceof MulBasedataProp && !(property.getParent() instanceof MainEntityType)) {
                    this.clearMulBasedataPropDirty((MulBasedataProp)property, (DynamicObjectCollection)tempVar2, false);
                }
                if ((enumerable = (Iterable)(tempVar2 instanceof Iterable ? tempVar2 : null)) == null) continue;
                for (Object item : enumerable) {
                    value = (DynamicObject)(item instanceof DynamicObject ? item : null);
                    this.clearDataEntityDirty(value);
                }
            }
        }
    }

    private void clearMulBasedataPropDirty(MulBasedataProp prop, DynamicObjectCollection cols, boolean value) {
        Object o = cols.getParent();
        if (o instanceof DynamicObject) {
            DynamicObject dynObject = (DynamicObject)o;
            dynObject.getDataEntityState().setBizChanged(prop.getOrdinal(), value);
        }
    }

    private void clearRowDirty(IDataEntityProperty entity, int row) {
        DynamicObjectCollection objs;
        if (entity == null) {
            return;
        }
        Object obj = ((ICollectionProperty)entity).getItemType().getProperties().size() == 0 ? this._model.getDataEntity(true) : ((objs = this._model.getEntityEntity(entity.getName())) == null || objs.size() == 0 ? null : (DynamicObject)objs.get(row));
        this.clearDataEntityDirty((DynamicObject)obj);
    }

    public void clearNoDataRow() {
        this.clearNoDataRow(false);
    }

    public void clearNoDataRow(boolean bForceClear) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_DATAMODEL, (String)"DirtyManager.clearNoDataRow");){
            MainEntityType mainType = this.getModel().getDataEntityType();
            span.addTag("entityNumber", mainType.getName());
            List entryEntitys = mainType.getProperties().getCollectionProperties(false);
            DynamicObject billObj = this._model.getDataEntity(true);
            for (IDataEntityProperty entityProp : entryEntitys) {
                Object rows = billObj.getDataStorage().getLocalValue(entityProp);
                if (rows == null) continue;
                this.clearNoDataRow(entityProp, (DynamicObjectCollection)rows, bForceClear, true);
            }
        }
    }

    private void clearNoDataRow(IDataEntityProperty entryProp, DynamicObjectCollection rows, boolean bForceClear, boolean forceSendAction) {
        EntryInfo entryInfo;
        Object item = null;
        boolean shouldReSortSeqField = false;
        if (entryProp == null || !(entryProp instanceof EntryProp)) {
            return;
        }
        if (entryProp instanceof LinkEntryProp) {
            return;
        }
        if (entryProp instanceof ITreeEntryProp) {
            return;
        }
        EntryType entity = (EntryType)((EntryProp)entryProp).getItemType();
        boolean isEntityMustInput = this.isEntityMustInput(entity);
        if (rows.size() == 1 && isEntityMustInput && !bForceClear) {
            List subEntryEntitys = entity.getProperties().getCollectionProperties(false);
            for (IDataEntityProperty subEntryProp : subEntryEntitys) {
                Object subRows = ((DynamicObject)rows.get(0)).getDataStorage().getLocalValue(subEntryProp);
                if (subRows == null) continue;
                this.clearNoDataRow(subEntryProp, (DynamicObjectCollection)subRows, bForceClear, true);
            }
            return;
        }
        DynamicProperty keyProp = null;
        if (StringUtils.isNotBlank((CharSequence)entity.getKeyField())) {
            keyProp = entity.getProperty(entity.getKeyField());
        }
        int currRowIndex = this.getModel().getEntryCurrentRowIndex(entryProp.getName());
        int removeFirstRowIndex = rows.size();
        DynamicObject removeFirstRow = null;
        ArrayList<Integer> removeRowIndexs = new ArrayList<Integer>(1);
        for (int i = rows.size() - 1; i >= 0; --i) {
            item = rows.get(i);
            DynamicObject itemDy = (DynamicObject)(item instanceof DynamicObject ? item : null);
            boolean canremove = this.canRemove(itemDy, (IDataEntityProperty)keyProp);
            if (canremove && rows.size() == 1 && isEntityMustInput && !bForceClear) {
                canremove = false;
            }
            if (canremove) {
                if (itemDy != null) {
                    removeFirstRow = itemDy;
                }
                removeRowIndexs.add(i);
                shouldReSortSeqField = true;
                removeFirstRowIndex = i;
                continue;
            }
            List subEntryEntitys = entity.getProperties().getCollectionProperties(false);
            for (IDataEntityProperty subEntryProp : subEntryEntitys) {
                Object subRows = ((DynamicObject)rows.get(i)).getDataStorage().getLocalValue(subEntryProp);
                if (subRows == null) continue;
                this.clearNoDataRow(subEntryProp, (DynamicObjectCollection)subRows, bForceClear, forceSendAction && i == currRowIndex);
            }
        }
        int pageStartIndex = 0;
        if (entity.getParent() instanceof MainEntityType && (entryInfo = ((DataEntityBase)rows.getParent()).getDataEntityState().getEntryInfo(entity.getName())) != null && entryInfo.getRowCount() != null) {
            pageStartIndex = entryInfo.getStartRowIndex();
        }
        if (!removeRowIndexs.isEmpty()) {
            int removesize = removeRowIndexs.size();
            if (rows.size() == removesize && isEntityMustInput && !bForceClear) {
                removesize = removeRowIndexs.size() - 1;
            }
            ArrayList<Integer> removeRowList = new ArrayList<Integer>(removesize);
            for (int i = removeRowIndexs.size() - removesize; i < removeRowIndexs.size(); ++i) {
                removeRowList.add((Integer)removeRowIndexs.get(removeRowIndexs.size() - i - 1) + pageStartIndex);
            }
            int[] rowIndexs = new int[removeRowList.size()];
            for (int i = 0; i < removeRowList.size(); ++i) {
                rowIndexs[i] = (Integer)removeRowList.get(i);
            }
            this.removeRow(rows, rowIndexs, removeFirstRow, entity, forceSendAction);
        }
        if ((removeFirstRowIndex += pageStartIndex) < currRowIndex) {
            if (rows.size() <= currRowIndex + pageStartIndex) {
                Map<String, Object> state = this.getModel().getEntryState(entryProp.getName());
                if (state != null) {
                    state.put("selRows", new int[0]);
                }
            } else {
                this.getModel().setEntryCurrentRowIndex(entryProp.getName(), currRowIndex, true);
            }
        }
        if (shouldReSortSeqField) {
            this.reSortSeqField(entity, rows, removeFirstRowIndex);
        }
    }

    private boolean isEntityMustInput(EntryType entity) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_DATAMODEL, (String)"DirtyManager.meetEntryMustInputCondition");){
            if (!entity.isMustIuput()) {
                boolean bl = false;
                return bl;
            }
            boolean isMustInput = true;
            Map mustInputMap = new HashMap(1);
            String mustInputCondition = entity.getMustInputCondition();
            if (!StringUtils.isBlank((CharSequence)mustInputCondition)) {
                mustInputMap = (Map)SerializationUtils.fromJsonString((String)mustInputCondition, Map.class);
            }
            if (!CollectionUtils.isEmpty(mustInputMap)) {
                if (span.isRealtime()) {
                    span.addLocaleTag("entry", (Object)String.format("%1$s(%2$s)", entity.getDisplayName().toString(), entity.getName()));
                    span.addLocaleTag("mustInputCondition", (Object)mustInputCondition);
                }
            } else {
                boolean bl = true;
                return bl;
            }
            String ruleCondition = (String)mustInputMap.get("RuleCondition");
            if (span.isRealtime()) {
                span.addLocaleTag("ruleCondition", (Object)ruleCondition);
            }
            MainEntityType mainEntityType = this.getModel().getDataEntityType();
            RowDataModel rowDataModel = new RowDataModel(mainEntityType.getName(), mainEntityType);
            ExpressionParameter parameter = new ExpressionParameter(ruleCondition, rowDataModel);
            parameter.setActiveRow((Object)this.getModel().getDataEntity());
            parameter.setRowIndex(0);
            Object exprValue = CalcExprParser.getExpressionValue((ExpressionParameter)parameter);
            if (span.isRealtime()) {
                span.addLocaleTag("exprValue", exprValue);
            }
            if (exprValue != null && !((Boolean)exprValue).booleanValue()) {
                isMustInput = false;
            }
            boolean bl = isMustInput;
            return bl;
        }
    }

    private boolean canRemove(DynamicObject activeRow, IDataEntityProperty keyProp) {
        Object value;
        if (activeRow == null || activeRow.getDataEntityState().getFromDatabase()) {
            return false;
        }
        if (keyProp != null && (value = keyProp.getValueFast((Object)activeRow)) != null) {
            if (value instanceof DynamicObject) {
                return false;
            }
            if (keyProp instanceof IValidatorHanlder ? !((IValidatorHanlder)keyProp).getValueComparator().compareValue(value) : StringUtils.isNotBlank((Object)value)) {
                return false;
            }
        }
        if (activeRow.getDataEntityState().getDataEntityDirty() && (activeRow.getDataEntityState().isPushChanged() || activeRow.getDataEntityState().isBizChanged() && !this.isSeqChangedOnly(activeRow))) {
            return false;
        }
        return this.collPropertyCanRemove(activeRow);
    }

    private boolean collPropertyCanRemove(DynamicObject activeRow) {
        boolean result = true;
        block0: for (ICollectionProperty property : activeRow.getDataEntityType().getProperties().getCollectionProperties(false)) {
            Object tempVar;
            DynamicObjectCollection subRows;
            EntryType subEntity;
            DynamicProperty keyProp = null;
            if (property instanceof EntryProp && StringUtils.isNotBlank((CharSequence)(subEntity = (EntryType)((EntryProp)property).getItemType()).getKeyField())) {
                keyProp = subEntity.getProperty(subEntity.getKeyField());
            }
            if ((subRows = (DynamicObjectCollection)((tempVar = activeRow.getDataStorage().getLocalValue((IDataEntityProperty)property)) instanceof DynamicObjectCollection ? tempVar : null)) == null || subRows.size() <= 0) continue;
            for (DynamicObject subRow : subRows) {
                if (this.canRemove(subRow, (IDataEntityProperty)keyProp)) continue;
                result = false;
                continue block0;
            }
        }
        return result;
    }

    private void removeRow(DynamicObjectCollection rows, int[] rowIndexs, DynamicObject activeRow, EntryType entity, boolean forceSendAction) {
        if (entity == null) {
            for (int i = rowIndexs.length; i > 0; --i) {
                rows.remove(rowIndexs[i - 1]);
            }
        } else {
            int newRow = 0;
            int currentRow = 0;
            String parentEntityKey = entity.getParent().getName();
            if (entity.getParent() instanceof EntryType) {
                currentRow = this._model.getEntryCurrentRowIndex(parentEntityKey);
                DynamicObject parentRow = (DynamicObject)activeRow.getParent();
                if (this._model.useTableCache()) {
                    newRow = parentRow.getInt(KEY_ENTRY_SEQ) - 1;
                } else {
                    DynamicObjectCollection parentRows = this._model.getEntityEntity(parentEntityKey);
                    newRow = parentRows.getStartRowIndex() + parentRows.indexOf((Object)parentRow);
                }
                if (currentRow != newRow) {
                    this._model.setEntryCurrentRowIndex(parentEntityKey, newRow);
                }
            }
            if (forceSendAction) {
                this._model.deleteEntryRows(entity.getName(), rowIndexs);
            } else {
                this._model.beginInit();
                this._model.deleteEntryRows(entity.getName(), rowIndexs);
                this._model.endInit();
            }
            if (newRow != currentRow) {
                this._model.setEntryCurrentRowIndex(parentEntityKey, currentRow);
            }
        }
    }

    private void reSortSeqField(EntryType entity, DynamicObjectCollection rows, int rowIndex) {
        DynamicProperty seqProp = entity.getProperty(KEY_ENTRY_SEQ);
        if (seqProp == null) {
            return;
        }
        for (int i = rowIndex; i < rows.size(); ++i) {
            DynamicObject obj;
            DynamicObject dynamicObject = obj = rows.get(i) instanceof DynamicObject ? (DynamicObject)rows.get(i) : null;
            if (obj == null) continue;
            seqProp.setValueFast((Object)obj, (Object)(i + 1));
        }
    }

    public boolean isBizChanged() {
        this.changeDescList.clear();
        DynamicObject dataEntity = this._model.getDataEntity();
        if (dataEntity == null) {
            return false;
        }
        DataEntityState state = dataEntity.getDataEntityState();
        boolean bizChanged = false;
        if (state.isBizChanged()) {
            bizChanged = true;
            String changePropNames = this.buildDirtyPropNames(null, dataEntity);
            if (StringUtils.isNotBlank((CharSequence)changePropNames)) {
                String changeDesc = String.format(ResManager.loadKDString((String)"\u5355\u636e\u5934\u53d8\u52a8\u5b57\u6bb5\uff1a%s", (String)"DirtyManager_0", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), changePropNames);
                this.changeDescList.add(changeDesc);
            }
            if (!this.changeDescList.isEmpty()) {
                return true;
            }
        }
        if ((dataEntity = this._model.getDataEntity(true)).getDataEntityState().getRemovedItems().booleanValue()) {
            bizChanged = true;
            String changeDesc = ResManager.loadKDString((String)"\u5355\u636e\u4f53\u5206\u5f55\u884c\u88ab\u5220\u9664", (String)"DirtyManager_1", (String)BOS_ENTITY_CORE, (Object[])new Object[0]);
            this.changeDescList.add(changeDesc);
            return true;
        }
        bizChanged = this.isBizChanged(dataEntity) || bizChanged;
        return bizChanged;
    }

    private boolean isMulbasedataChanged(DynamicObject dataEntity) {
        IDataEntityType dt = dataEntity.getDataEntityType();
        boolean bizChanged = dataEntity.getDataEntityState().isBizChanged();
        for (ICollectionProperty property : dt.getProperties().getCollectionProperties(false)) {
            if (!(property instanceof MulBasedataProp) || !this.isMulBaseDataChanged(dataEntity, (MulBasedataProp)property)) continue;
            bizChanged = true;
        }
        return bizChanged;
    }

    private boolean isBizChanged(DynamicObject dataEntity) {
        IDataEntityType dt = dataEntity.getDataEntityType();
        boolean bizChanged = dataEntity.getDataEntityState().isBizChanged();
        for (ICollectionProperty property : dt.getProperties().getCollectionProperties(false)) {
            Object propValue;
            if (property instanceof MulBasedataProp) {
                if (!this.isMulBaseDataChanged(dataEntity, (MulBasedataProp)property)) continue;
                bizChanged = true;
                continue;
            }
            if (property instanceof LinkEntryProp || property instanceof DynamicLocaleProperty || (propValue = dataEntity.getDataStorage().getLocalValue((IDataEntityProperty)property)) == null) continue;
            DynamicObjectCollection entrys = (DynamicObjectCollection)propValue;
            for (int index = 0; index < entrys.size(); ++index) {
                DynamicObject item = (DynamicObject)entrys.get(index);
                if (!this.isBizChanged(item)) continue;
                if (this.changeDescList.size() >= 5) {
                    this.changeDescList.add(ResManager.loadKDString((String)"......", (String)"DirtyManager_6", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
                    return true;
                }
                bizChanged = true;
                String entryName = property instanceof DynamicCollectionProperty && ((DynamicCollectionProperty)property).getDisplayName() != null ? ((DynamicCollectionProperty)property).getDisplayName().toString() : property.getName();
                String changePropName = this.buildDirtyPropNames((IDataEntityProperty)property, item);
                if (!StringUtils.isNotBlank((CharSequence)changePropName)) continue;
                String changeDesc = String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u53d8\u52a8\u5b57\u6bb5\uff1a%3$s", (String)"DirtyManager_2", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), entryName, entrys.getStartRowIndex() + index + 1, changePropName);
                this.changeDescList.add(changeDesc);
            }
        }
        return bizChanged;
    }

    private boolean isMulBaseDataChanged(DynamicObject obj, MulBasedataProp prop) {
        Object localValue = obj.getDataStorage().getLocalValue((IDataEntityProperty)prop);
        if (localValue == null) {
            return false;
        }
        DynamicObjectCollection cols = (DynamicObjectCollection)localValue;
        boolean changed = false;
        if (obj.getDataEntityState().getRemovedItems().booleanValue()) {
            IDataEntityType parent = prop.getParent();
            if (parent instanceof SubEntryType) {
                DynamicObject parentObj = (DynamicObject)obj.getParent();
                if (parent.getParent().getProperties().containsKey((Object)KEY_ENTRY_SEQ) && parent.getProperties().containsKey((Object)KEY_ENTRY_SEQ) && parentObj != null) {
                    this.changeDescList.add(String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c%3$s\u6570\u636e\u88ab\u5220\u9664\uff0c\u5bf9\u5e94\u7236\u5355\u636e\u4f53\u7b2c%s\u884c", (String)"DirtyManager_5", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), parent.getDisplayName().toString(), obj.get(KEY_ENTRY_SEQ), prop.getDisplayName(), parentObj.get(KEY_ENTRY_SEQ)));
                }
            } else if (parent instanceof EntryType && parent.getProperties().containsKey((Object)KEY_ENTRY_SEQ)) {
                this.changeDescList.add(String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c%3$s\u6570\u636e\u88ab\u5220\u9664", (String)"DirtyManager_4", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), parent.getDisplayName().toString(), obj.get(KEY_ENTRY_SEQ), prop.getDisplayName()));
            }
            return true;
        }
        for (DynamicObject col : cols) {
            if (!col.getDataEntityState().isBizChanged()) continue;
            changed = true;
            break;
        }
        if (!changed) {
            return false;
        }
        Iterator parent = prop.getParent();
        if (parent instanceof SubEntryType) {
            DynamicObject parentObj = (DynamicObject)obj.getParent();
            if (parent.getParent().getProperties().containsKey((Object)KEY_ENTRY_SEQ) && parent.getProperties().containsKey((Object)KEY_ENTRY_SEQ) && parentObj != null) {
                this.changeDescList.add(String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u53d8\u52a8\u5b57\u6bb5\uff1a%3$s\uff0c\u5bf9\u5e94\u7236\u5355\u636e\u4f53\u7b2c%4$s\u884c", (String)"DirtyManager_3", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), parent.getDisplayName().toString(), obj.get(KEY_ENTRY_SEQ), prop.getDisplayName(), parentObj.get(KEY_ENTRY_SEQ)));
            }
        } else if (parent instanceof EntryType) {
            if (parent.getProperties().containsKey((Object)KEY_ENTRY_SEQ)) {
                this.changeDescList.add(String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u53d8\u52a8\u5b57\u6bb5\uff1a%3$s", (String)"DirtyManager_2", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), parent.getDisplayName().toString(), obj.get(KEY_ENTRY_SEQ), prop.getDisplayName()));
            }
        } else {
            this.changeDescList.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u5934\u53d8\u52a8\u5b57\u6bb5\uff1a%s", (String)"DirtyManager_0", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), prop.getDisplayName()));
        }
        return changed;
    }

    private boolean isSeqChangedOnly(DynamicObject dataEntity) {
        if (dataEntity == null) {
            return false;
        }
        int propCount = 0;
        boolean seqChanged = false;
        for (IDataEntityProperty prop : dataEntity.getDataEntityState().getBizChangedProperties()) {
            ++propCount;
            seqChanged = seqChanged || StringUtils.equalsIgnoreCase((CharSequence)prop.getName(), (CharSequence)KEY_ENTRY_SEQ);
        }
        return propCount == 1 && seqChanged;
    }

    public void setBizChanged(boolean value) {
        DynamicObject dataEntity = this._model.getDataEntity();
        if (value) {
            dataEntity.getDataEntityState().setBizChanged(value);
        } else {
            dataEntity = this._model.getDataEntity(true);
            this.setBizChanged(dataEntity, value);
        }
    }

    private void setBizChanged(DynamicObject dataEntity, boolean value) {
        IDataEntityType dt = dataEntity.getDataEntityType();
        dataEntity.getDataEntityState().setBizChanged(value);
        for (ICollectionProperty property : dt.getProperties().getCollectionProperties(false)) {
            Object rows = dataEntity.getDataStorage().getLocalValue((IDataEntityProperty)property);
            if (rows == null) continue;
            if (property instanceof MulBasedataProp) {
                this.clearMulBasedataPropDirty((MulBasedataProp)property, (DynamicObjectCollection)rows, value);
            }
            for (DynamicObject item : (DynamicObjectCollection)rows) {
                this.setBizChanged(item, value);
            }
        }
    }

    private boolean isSkipNoField() {
        if (this._model == null) {
            return false;
        }
        Object skipNoField = this._model.getContextVariable("bos_datachanged_skipnofield");
        if (skipNoField instanceof Boolean) {
            return (Boolean)skipNoField;
        }
        return false;
    }

    public String getChangeDesc() {
        if (this.changeDescList.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)" \r\n", this.changeDescList);
    }

    private String buildDirtyPropNames(IDataEntityProperty entryProp, DynamicObject dataEntity) {
        ArrayList<IDataEntityProperty> dirtyProps = new ArrayList<IDataEntityProperty>(10);
        Iterator iterator = dataEntity.getDataEntityState().getBizChangedProperties().iterator();
        while (iterator.hasNext()) {
            IDataEntityProperty property;
            IDataEntityProperty property2 = property = (IDataEntityProperty)iterator.next();
            if (property instanceof PKFieldProp && property.getName().endsWith("_id")) {
                String bdPropName = property.getName().substring(0, property.getName().length() - 3);
                property2 = (IDataEntityProperty)property.getParent().getProperties().get((Object)bdPropName);
                if (entryProp instanceof MulBasedataProp) {
                    property2 = entryProp;
                }
                if (property2 == null) {
                    property2 = property;
                }
            }
            if (property instanceof BooleanProp && "isGroupNode".equals(property.getName())) continue;
            dirtyProps.add(property2);
        }
        dirtyProps.sort(new Comparator<IDataEntityProperty>(){

            @Override
            public int compare(IDataEntityProperty o1, IDataEntityProperty o2) {
                int f2;
                int f1 = o1 instanceof IFieldHandle ? 0 : 1;
                int n = f2 = o2 instanceof IFieldHandle ? 0 : 1;
                if (f1 != f2) {
                    return f1 - f2;
                }
                return o1.getOrdinal() - o2.getOrdinal();
            }
        });
        boolean isBill = this._model != null && this._model.getDataEntityType() != null && this._model.getDataEntityType() instanceof BillEntityType;
        boolean skipNoField = this.isSkipNoField();
        int i = 0;
        ArrayList<String> propNames = new ArrayList<String>();
        for (IDataEntityProperty property : dirtyProps) {
            if (i > 3) break;
            if (skipNoField && isBill && StringUtils.isBlank((CharSequence)property.getAlias()) || StringUtils.equalsIgnoreCase((CharSequence)property.getName(), (CharSequence)KEY_ENTRY_SEQ)) continue;
            if (property instanceof DynamicProperty && ((DynamicProperty)property).getDisplayName() != null) {
                propNames.add(((DynamicProperty)property).getDisplayName().toString());
            } else {
                propNames.add(property.getName());
            }
            ++i;
        }
        String separator = ResManager.loadKDString((String)"\uff0c", (String)"DirtyManager_7", (String)BOS_ENTITY_CORE, (Object[])new Object[0]);
        String result = StringUtils.join((Object[])propNames.toArray(), (String)separator);
        if (i > 3) {
            result = result + "...";
        }
        return result;
    }
}

