/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.OperateLog;
import kd.bos.entity.operate.OperateProgress;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.IOperationServicePlugIn;
import kd.bos.entity.plugin.KDOperationPlugIn;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeforeSaveAuditLogArg;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.plugin.args.ValidatePrefixArgs;
import kd.bos.entity.plugin.manager.IPluginManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.ProjectInitializerManager;
import kd.bos.script.ScriptExecutor;
import kd.sdk.kingscript.mixture.MixtureFactory;
import kd.sdk.kingscript.mixture.MixtureProxy;
import kd.sdk.kingscript.mixture.PluginMixtureProxy;

public class OperationServicePlugInProxy {
    private static final Log logger = LogFactory.getLog(OperationServicePlugInProxy.class);
    private static final String TRACETYPE_PLUGIN = "opplugin";
    private List<Map<String, Object>> pluginsMetas = null;
    protected List<IOperationServicePlugIn> plugIns = new ArrayList<IOperationServicePlugIn>();
    private ScriptExecutor scriptExecutor;
    private boolean splitPage;
    private OperateLog operateLog = OperateLog.get((boolean)false);
    protected static final long WARN_EXECUTE_TIME = 10L;
    private IPluginManager pluginManager;

    public OperateLog getOperateLog() {
        return this.operateLog;
    }

    public void setOperateLog(OperateLog operateLog) {
        this.operateLog = operateLog;
    }

    private void invokeMethod(Consumer<IOperationServicePlugIn> consumer, String methodName, Class<?> ... parameterTypes) {
        for (IOperationServicePlugIn pl : this.plugIns) {
            long beginTime = System.currentTimeMillis();
            String mothedName = pl.getClass().getName() + "." + methodName;
            this.getOperateLog().beginMothed(mothedName, null);
            consumer.accept(pl);
            long costTime = System.currentTimeMillis() - beginTime;
            if (costTime > 10L) {
                this.getOperateLog().endMothed(mothedName, null);
                continue;
            }
            this.getOperateLog().removeMothed(mothedName);
        }
    }

    public OperationServicePlugInProxy(List<Map<String, Object>> plugins) {
        this.pluginsMetas = plugins;
        for (Map<String, Object> ins : plugins) {
            IOperationServicePlugIn splugin;
            int type = (Integer)ins.get("type");
            String className = (String)ins.get("className");
            if (0 == type) {
                this.plugIns.add((IOperationServicePlugIn)TypesContainer.createInstance((String)className));
                continue;
            }
            if (1 == type) {
                try {
                    splugin = this.createScriptPlugin1(className);
                    if (splugin == null) continue;
                    this.plugIns.add(splugin);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (4 != type || !Plugin.enableRunKingScript()) continue;
            try {
                splugin = (IOperationServicePlugIn)MixtureFactory.createMixtureProxy((MixtureProxy)new PluginMixtureProxy(className, scriptPath -> ProjectInitializerManager.getEngineAutoDebug((String)scriptPath)));
                if (splugin == null) continue;
                this.plugIns.add(splugin);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public IOperationServicePlugIn createScriptPlugin(String scriptName) {
        return this.createScriptPlugin1(scriptName);
    }

    private IOperationServicePlugIn createScriptPlugin1(String scriptName) {
        String script = EntityMetadataCache.getPluginScripts((String)scriptName);
        this.scriptExecutor = ScriptExecutor.getOrCreate();
        this.scriptExecutor.init(ctx -> ctx.require(new String[]{KDOperationPlugIn.class.getName()}));
        this.scriptExecutor.begin();
        this.scriptExecutor.exec(new String[]{script});
        return (IOperationServicePlugIn)this.scriptExecutor.getContext().get("plugin");
    }

    public void destory() {
        if (this.scriptExecutor != null) {
            this.scriptExecutor.end();
        }
    }

    public void registerPlugIn(IOperationServicePlugIn plugIn) {
        this.plugIns.add(plugIn);
    }

    public void printPluginList() {
        StringBuilder sb = new StringBuilder();
        if (this.pluginsMetas == null || this.pluginsMetas.isEmpty()) {
            sb.append("register plugIns: empty");
        } else {
            sb.append("register plugIns: \r\n");
            for (Map<String, Object> ins : this.pluginsMetas) {
                int type = (Integer)ins.get("type");
                String className = (String)ins.get("className");
                if (0 == type) {
                    sb.append("JavaClass ");
                } else if (1 == type) {
                    sb.append("JavaScript ");
                }
                sb.append(className).append(" \r\n");
            }
        }
        if (this.plugIns == null || this.plugIns.isEmpty()) {
            sb.append("run plugIns: empty");
        } else {
            sb.append("run plugIns: ");
            for (IOperationServicePlugIn plugIn : this.plugIns) {
                sb.append("\r\n").append(plugIn.getClass().getName());
            }
        }
        this.getOperateLog().info(sb.toString());
    }

    public void setContext(MainEntityType billEntityType, Map<String, Object> operateMeta, OperateOption option) {
        for (IOperationServicePlugIn plugIn : this.plugIns) {
            plugIn.setContext(billEntityType, operateMeta, option);
        }
    }

    public void setProgress(OperateProgress operateProgress) {
        for (IOperationServicePlugIn plugIn : this.plugIns) {
            plugIn.setOperateProgress(operateProgress);
        }
    }

    public boolean isSplitPage() {
        return this.splitPage;
    }

    public void setSplitPage(boolean splitPage) {
        this.splitPage = splitPage;
    }

    public void fireInitialize(InitOperationArgs e) {
        for (IOperationServicePlugIn p : this.plugIns) {
            EntityTraceSpan span = EntityTracer.create((String)TRACETYPE_PLUGIN, (String)String.format("%s.initialize", p.getClass().getName()));
            Throwable throwable = null;
            try {
                p.initialize(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void setSubEntityType(EntityType entityType) {
        for (IOperationServicePlugIn iOperationServicePlugIn : this.plugIns) {
        }
    }

    public void fireOnAddValidators(AddValidatorsEventArgs e) {
        this.invokeMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)TRACETYPE_PLUGIN, (String)String.format("%s.onAddValidators", plugin.getClass().getName()));){
                plugin.onAddValidators(e);
            }
        }, "onAddValidators", AddValidatorsEventArgs.class);
    }

    public void firePreparePropertys(PreparePropertysEventArgs e) {
        this.invokeMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)TRACETYPE_PLUGIN, (String)String.format("%s.onPreparePropertys", plugin.getClass().getName()));){
                plugin.onPreparePropertys(e);
            }
        }, "onPreparePropertys", PreparePropertysEventArgs.class);
    }

    public void fireBeforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.invokeMethod(plugin -> {
            if (!this.isSplitPage() || plugin.isSupportSplitPageMode()) {
                try (EntityTraceSpan span = EntityTracer.create((String)TRACETYPE_PLUGIN, (String)String.format("%s.beforeExecuteOperationTransaction", plugin.getClass().getName(), EntityTraceHint.getHintLinkAPM()));){
                    plugin.beforeExecuteOperationTransaction(e);
                    if (e.isCancel() && StringUtils.isBlank((CharSequence)e.getCancelPlugName())) {
                        e.setCancelPlugName(plugin.getClass().getName());
                    }
                }
            }
        }, "beforeExecuteOperationTransaction", BeforeOperationArgs.class);
    }

    public void fireBeginOperationTransaction(BeginOperationTransactionArgs e) {
        this.invokeMethod(plugin -> {
            if (!this.isSplitPage() || plugin.isSupportSplitPageMode()) {
                try (EntityTraceSpan span = EntityTracer.create((String)TRACETYPE_PLUGIN, (String)String.format("%s.beginOperationTransaction", plugin.getClass().getName(), EntityTraceHint.getHintLinkAPM()));){
                    plugin.beginOperationTransaction(e);
                }
            }
        }, "beginOperationTransaction", BeginOperationTransactionArgs.class);
    }

    public void fireEndOperationTransaction(EndOperationTransactionArgs e) {
        this.invokeMethod(plugin -> {
            if (!this.isSplitPage() || plugin.isSupportSplitPageMode()) {
                try (EntityTraceSpan span = EntityTracer.create((String)TRACETYPE_PLUGIN, (String)String.format("%s.endOperationTransaction", plugin.getClass().getName(), EntityTraceHint.getHintLinkAPM()));){
                    plugin.endOperationTransaction(e);
                }
            }
        }, "endOperationTransaction", EndOperationTransactionArgs.class);
    }

    public void fireRollbackOperation(RollbackOperationArgs e) {
        this.invokeMethod(plugin -> {
            if (!this.isSplitPage() || plugin.isSupportSplitPageMode()) {
                try (EntityTraceSpan span = EntityTracer.create((String)TRACETYPE_PLUGIN, (String)String.format("%s.rollbackOperation", plugin.getClass().getName()));){
                    plugin.rollbackOperation(e);
                }
            }
        }, "rollbackOperation", RollbackOperationArgs.class);
    }

    public void fireAfterExecuteOperationTransaction(AfterOperationArgs e) {
        this.invokeMethod(plugin -> {
            if (!this.isSplitPage() || plugin.isSupportSplitPageMode()) {
                try (EntityTraceSpan span = EntityTracer.create((String)TRACETYPE_PLUGIN, (String)String.format("%s.afterExecuteOperationTransaction", plugin.getClass().getName(), EntityTraceHint.getHintLinkAPM()));){
                    plugin.afterExecuteOperationTransaction(e);
                }
            }
        }, "afterExecuteOperationTransaction", AfterOperationArgs.class);
    }

    public void fireInitializeOperationResult(OperationResult e) {
        for (IOperationServicePlugIn plugIn : this.plugIns) {
            EntityTraceSpan span = EntityTracer.create((String)TRACETYPE_PLUGIN, (String)String.format("%s.initializeOperationResult", plugIn.getClass().getName()));
            Throwable throwable = null;
            try {
                plugIn.initializeOperationResult(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void fireReturnOperation(ReturnOperationArgs e) {
        this.invokeMethod(plugin -> {
            if (!this.isSplitPage() || plugin.isSupportSplitPageMode()) {
                try (EntityTraceSpan span = EntityTracer.create((String)TRACETYPE_PLUGIN, (String)String.format("%s.onReturnOperation", plugin.getClass().getName()));){
                    plugin.onReturnOperation(e);
                }
            }
        }, "onReturnOperation", ReturnOperationArgs.class);
    }

    public void fireBeforeSaveAuditLog(BeforeSaveAuditLogArg beforeSaveAuditLog) {
        this.invokeMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)TRACETYPE_PLUGIN, (String)String.format("%s.beforeSaveAuditLog", plugin.getClass().getName()));){
                plugin.beforeSaveAuditLog(beforeSaveAuditLog);
            }
        }, "beforeSaveAuditLog", BeforeSaveAuditLogArg.class);
    }

    public void fireValidatePrefix(ValidatePrefixArgs validatePrefixArgs) {
        this.invokeMethod(plugin -> {
            try (EntityTraceSpan span = EntityTracer.create((String)TRACETYPE_PLUGIN, (String)String.format("%s.validatePrefix", plugin.getClass().getName()));){
                plugin.validatePrefix(validatePrefixArgs);
            }
        }, "validatePrefix", ValidatePrefixArgs.class);
    }
}

