/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.report;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportBatchLoadInfo;
import kd.bos.entity.report.ReportBatchQueryInfo;
import kd.bos.entity.report.ReportBatchQueryResult;
import kd.bos.entity.report.ReportRowSet;
import kd.bos.entity.report.ReportTaskResult;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ReportByBatchTaskResult
extends ReportTaskResult
implements Serializable {
    private static final long serialVersionUID = -2719068354847018416L;
    private static final String SPAN_TYPE = "ReportByBatchTaskResult";
    private String pageId;
    @JsonIgnore
    private transient IReportCache reportCache;
    protected ReportBatchQueryInfo batchQueryInfo;
    private ReportBatchLoadInfo batchInfo;

    public ReportByBatchTaskResult(String pageId, String firstBatchDataSetCacheId, List<AbstractReportColumn> reportColumns, ReportBatchQueryInfo batchQueryInfo, ReportBatchLoadInfo batchInfo) {
        super(firstBatchDataSetCacheId, reportColumns);
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"<init>", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            this.pageId = pageId;
            this.batchQueryInfo = batchQueryInfo;
            this.batchInfo = batchInfo;
            batchInfo.setBatchCount(batchQueryInfo.getBatchCount());
            batchInfo.getBatchIndex2RowCounts().put(0, super.getRowCount());
            batchInfo.getBatchIndex2CachedDataSetIds().put(0, firstBatchDataSetCacheId);
            span.addLocaleTag("batchQueryInfo", (Object)batchQueryInfo);
        }
    }

    public ReportByBatchTaskResult(String pageId, String firstBatchDataSetCacheId, List<AbstractReportColumn> reportColumns, ReportBatchQueryInfo batchQueryInfo) {
        super(firstBatchDataSetCacheId, reportColumns);
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"<init>", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            this.pageId = pageId;
            this.batchQueryInfo = batchQueryInfo;
            this.batchInfo = new ReportBatchLoadInfo();
            this.batchInfo.setBatchCount(batchQueryInfo.getBatchCount());
            this.batchInfo.getBatchIndex2RowCounts().put(0, super.getRowCount());
            this.batchInfo.getBatchIndex2CachedDataSetIds().put(0, firstBatchDataSetCacheId);
            span.addLocaleTag("batchQueryInfo", (Object)batchQueryInfo);
        }
    }

    @Override
    public ReportRowSet getData(int start, int limit, String parentId) {
        return this.getData(start, limit, parentId, null);
    }

    @Override
    public ReportRowSet getData(int start, int limit, String parentId, Integer currentSeq) {
        if (this.isLoadFilter2ndResult()) {
            return super.getData(start, limit, parentId, currentSeq);
        }
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"getData", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            int batchIndex = this.parseBatchIndex(start, limit, parentId, currentSeq);
            String cachedDataSetId = this.batchInfo.getBatchIndex2CachedDataSetIds().get(batchIndex);
            CachedDataSet theBatchDataSet = Algo.getCacheDataSet((String)cachedDataSetId);
            RowMeta rowMeta = theBatchDataSet.getRowMeta();
            ArrayList<Row> rowData = new ArrayList<Row>(10);
            if (limit > 0) {
                int startIndexOfBatch = this.parseStartIndex(start, limit, parentId, currentSeq);
                if (theBatchDataSet.getRowCount() > 0) {
                    List<Row> allRowByParentId = this.getAllRowByParentId(startIndexOfBatch, limit, theBatchDataSet, parentId, currentSeq);
                    startIndexOfBatch = currentSeq == null && StringUtils.isNotBlank((CharSequence)parentId) && !StringUtils.equals((CharSequence)parentId, (CharSequence)"0") ? (startIndexOfBatch -= allRowByParentId.size()) : 0;
                    rowData.addAll(allRowByParentId);
                }
                int currBatchIndex = batchIndex;
                while (this.isAddNextBatch(parentId, rowData.size(), limit, currBatchIndex)) {
                    List<Row> nextBatchRowDatas = this.getNextBatchRowDatas(startIndexOfBatch, currBatchIndex + 1, limit - rowData.size(), parentId);
                    ++currBatchIndex;
                    if (nextBatchRowDatas == null || nextBatchRowDatas.size() == 0) continue;
                    rowData.addAll(nextBatchRowDatas);
                    if (currentSeq == null && StringUtils.isNotBlank((CharSequence)parentId) && !StringUtils.equals((CharSequence)parentId, (CharSequence)"0")) {
                        startIndexOfBatch -= nextBatchRowDatas.size();
                        continue;
                    }
                    startIndexOfBatch = 0;
                }
            }
            ReportRowSet reportRowSet = new ReportRowSet(rowMeta, rowData);
            return reportRowSet;
        }
    }

    private List<Row> getNextBatchRowDatas(int start, int batchIndex, int limit, String parentId) {
        String cachedDataSetId = this.batchInfo.getBatchIndex2CachedDataSetIds().get(batchIndex);
        if (cachedDataSetId == null) {
            return null;
        }
        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cachedDataSetId);
        List<Row> list = this.getAllRowByParentId(start, limit, cacheDataSet, parentId, null);
        return list;
    }

    protected CachedDataSet getDataSetExceptFirstBatch(int start, int limit) {
        int batchIndex = this.parseBatchIndex(start, limit, null, null);
        String cachedDatasetId = this.batchInfo.getBatchIndex2CachedDataSetIds().get(batchIndex);
        return Algo.getCacheDataSet((String)cachedDatasetId);
    }

    public int needFetchMore(int start, int limit, String parentId, Integer currentSeq) {
        int batchIdx;
        Tuple<Boolean, List<Integer>> enoughLoaded = this.enoughLoaded(start, limit, parentId, currentSeq);
        if (((Boolean)enoughLoaded.item1).booleanValue()) {
            return 0;
        }
        if (((List)enoughLoaded.item2).size() > 0 && (Integer)((List)enoughLoaded.item2).get(0) > 0) {
            return (Integer)((List)enoughLoaded.item2).get(0);
        }
        int loadMaxBatchIndex = 0;
        for (Integer batchIdx2 : this.batchInfo.getBatchIndex2RowCounts().keySet()) {
            loadMaxBatchIndex = Math.max(loadMaxBatchIndex, batchIdx2);
        }
        int maxBatchIndex = loadMaxBatchIndex;
        ArrayList<Integer> noDataBatchIdxs = this.batchInfo.getNoDataBatchIndexs();
        if (noDataBatchIdxs.size() > 0) {
            for (Integer noDataBatchIdx : noDataBatchIdxs) {
                maxBatchIndex = Math.max(maxBatchIndex, noDataBatchIdx);
            }
        }
        if ((batchIdx = maxBatchIndex + 1) > this.batchInfo.getBatchCount() - 1) {
            if (batchIdx == this.batchInfo.getBatchCount() && maxBatchIndex > loadMaxBatchIndex && !this.batchInfo.getBatchIndex2CachedDataSetIds().containsKey(loadMaxBatchIndex)) {
                return loadMaxBatchIndex;
            }
            return -1;
        }
        return batchIdx;
    }

    public int needFetchMore(int start, int limit) {
        return this.needFetchMore(start, limit, null, null);
    }

    protected Tuple<Boolean, List<Integer>> enoughLoaded(int start, int limit, String parentId, Integer currentSeq) {
        int batchIndex = this.parseBatchIndex(start, limit, parentId, currentSeq);
        ArrayList<Integer> batchIndexs = new ArrayList<Integer>(10);
        if (batchIndex < 0) {
            batchIndexs.add(-1);
            return new Tuple((Object)false, batchIndexs);
        }
        int rowCount = 0;
        boolean enough = false;
        for (Map.Entry<Integer, Integer> entry : this.batchInfo.getBatchIndex2RowCounts().entrySet()) {
            Integer k = entry.getKey();
            Integer v = entry.getValue();
            if ((rowCount += v.intValue()) >= start) {
                batchIndexs.add(k);
            }
            if (rowCount <= start + limit) continue;
            enough = true;
            break;
        }
        if (!enough || batchIndexs.size() == 0) {
            batchIndexs.clear();
            batchIndexs.add(-1);
            return new Tuple((Object)false, batchIndexs);
        }
        ArrayList<Integer> needLoadBatchIndexs = new ArrayList<Integer>(10);
        for (Integer index : batchIndexs) {
            if (this.batchInfo.getBatchIndex2CachedDataSetIds().containsKey(index)) continue;
            needLoadBatchIndexs.add(index);
        }
        if (needLoadBatchIndexs.size() > 0) {
            return new Tuple((Object)false, needLoadBatchIndexs);
        }
        return new Tuple((Object)true, batchIndexs);
    }

    public Tuple<Integer, Boolean> addBatchData(int start, int limit, int batchIndex, String parentId, Integer currentSeq, ReportBatchQueryResult result) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"addBatchData", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            span.addLocaleTag("start", (Object)start);
            span.addLocaleTag("limit", (Object)limit);
            span.addLocaleTag("batchIndex", (Object)batchIndex);
            span.addLocaleTag("cacheId", (Object)result.getCacheId());
            span.addLocaleTag("parentId", (Object)parentId);
        }
        if (StringUtils.isBlank((CharSequence)result.getCacheId())) {
            this.batchInfo.getNoDataBatchIndexs().add(batchIndex);
            return new Tuple((Object)0, (Object)true);
        }
        CachedDataSet cachedDataSet = Algo.getCacheDataSet((String)result.getCacheId());
        int rowCount = cachedDataSet.getRowCount();
        this.batchInfo.getBatchIndex2RowCounts().put(batchIndex, rowCount);
        this.batchInfo.getBatchIndex2CachedDataSetIds().put(batchIndex, result.getCacheId());
        if (cachedDataSet == null || cachedDataSet.getRowCount() == 0) {
            this.batchInfo.getNoDataBatchIndexs().add(batchIndex);
            return new Tuple((Object)0, (Object)true);
        }
        Tuple<Boolean, List<Integer>> enoughLoaded = this.enoughLoaded(start, limit, parentId, currentSeq);
        if (!((Boolean)enoughLoaded.item1).booleanValue()) {
            return new Tuple((Object)rowCount, (Object)true);
        }
        if (this.getRowCount() > this.batchQueryInfo.getMaxRowCountCached()) {
            Integer max = -1;
            Integer min = -1;
            Iterator batchIdxs = this.batchInfo.getBatchIndex2CachedDataSetIds().keySet().iterator();
            int batchIndex2Load = this.parseBatchIndex(start, limit, parentId, currentSeq);
            while (batchIdxs.hasNext()) {
                Integer integer = (Integer)batchIdxs.next();
                if (integer == 0 || integer == batchIndex2Load || integer == batchIndex || ((List)enoughLoaded.item2).contains(integer)) continue;
                max = Math.max(max, integer);
                min = Math.min(min, integer);
            }
            Integer toReleaseBatchIndex = 0;
            if ((max != -1 || min != -1) && (toReleaseBatchIndex = max == -1 ? min : (min == -1 ? max : (Math.abs(max - batchIndex2Load) > Math.abs(batchIndex2Load - min) ? max : min))) != batchIndex && toReleaseBatchIndex != batchIndex2Load) {
                String cached2Release = this.batchInfo.getBatchIndex2CachedDataSetIds().get(toReleaseBatchIndex);
                CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cached2Release);
                if (cacheDataSet != null) {
                    cacheDataSet.close();
                }
                this.batchInfo.getBatchIndex2CachedDataSetIds().remove(toReleaseBatchIndex);
            }
        }
        return new Tuple((Object)rowCount, (Object)false);
    }

    public Tuple<Integer, Boolean> addBatchData(int start, int limit, int batchIndex, String cacheId) {
        return this.addBatchData(start, limit, batchIndex, null, null, new ReportBatchQueryResult(cacheId));
    }

    protected int parseBatchIndex(int start, int limit, String parentId, Integer currentSeq) {
        int rowCount = 0;
        for (Map.Entry<Integer, Integer> entry : this.batchInfo.getBatchIndex2RowCounts().entrySet()) {
            Integer k = entry.getKey();
            Integer v = entry.getValue();
            if ((rowCount += v.intValue()) < start) continue;
            return k;
        }
        return -1;
    }

    protected int parseStartIndex(int start, int limit, String parentId, Integer currentSeq) {
        int rowCount = 0;
        for (Map.Entry<Integer, Integer> entry : this.batchInfo.getBatchIndex2RowCounts().entrySet()) {
            Integer k = entry.getKey();
            Integer v = entry.getValue();
            if ((rowCount += v.intValue()) < start) continue;
            return start - (rowCount - v);
        }
        return -1;
    }

    @Override
    public int getRowCount() {
        if (this.isLoadFilter2ndResult()) {
            return super.getRowCount();
        }
        return this.batchInfo.getLoadedRowCount();
    }

    @Override
    public int getTotalCount() {
        if (this.isLoadFilter2ndResult()) {
            return super.getRowCount();
        }
        return this.batchQueryInfo.getBatchBy().getRowCount();
    }

    private int getRowCountAccumulate2Batch(int batchIndex) {
        int rowCount = 0;
        for (Map.Entry<Integer, Integer> entry : this.batchInfo.getBatchIndex2RowCounts().entrySet()) {
            Integer k = entry.getKey();
            Integer v = entry.getValue();
            if (k > batchIndex) break;
            rowCount += v.intValue();
        }
        return rowCount;
    }

    @Override
    public void close() {
        super.close();
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"close", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            span.addLocaleTag("batchInfo", (Object)this.batchInfo);
            for (String cachedDataSetId : this.batchInfo.getBatchIndex2CachedDataSetIds().values()) {
                try {
                    Algo.removeCacheDataSet((String)cachedDataSetId);
                }
                catch (AlgoException e) {}
            }
            this.batchInfo.getBatchIndex2CachedDataSetIds().clear();
            this.batchInfo.getBatchIndex2RowCounts().clear();
            this.batchInfo.getNoDataBatchIndexs().clear();
        }
    }

    public ReportBatchLoadInfo getBatchLoadInfo() {
        return this.batchInfo;
    }

    protected boolean isAddNextBatch(String parentId, int currentCount, int limit, int currBatchIndex) {
        return currentCount < limit && currBatchIndex + 1 < this.batchInfo.getBatchCount();
    }

    protected List<Row> getAllRowByParentId(int startIndexOfThisBatch, int limit, CachedDataSet cachedDataSet, String parentId, Integer currentSeq) {
        return cachedDataSet.getList(startIndexOfThisBatch, limit);
    }
}

