/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.report;

import java.io.Serializable;
import java.util.List;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportServiceProxyPlugin;
import kd.bos.entity.report.ds.DataSource;
import kd.bos.entity.report.ds.DataSourceFactory;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ReportTaskParam
implements Serializable {
    private static final long serialVersionUID = -8843804660266054371L;
    private String reportName;
    private String filterEntityId;
    private transient ReportQueryParam queryParam;
    private String pluginClassName;
    private List<Plugin> pluginExtplugins;
    private String dataSource;
    private String queryDataSource;
    private List<AbstractReportColumn> columns;
    private Object otherParam;
    private boolean isReportTree_i = false;
    private boolean asyncTotal = false;
    private String taskId;
    private String taskType;
    private boolean isRelease;
    private List<Plugin> reportQueryPlugins;

    public ReportQueryParam getQueryParam() {
        return this.queryParam;
    }

    public void setQueryParam(ReportQueryParam queryParam) {
        this.queryParam = queryParam;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public String getFilterEntityId() {
        return this.filterEntityId;
    }

    public void setFilterEntityId(String filterEntityId) {
        this.filterEntityId = filterEntityId;
    }

    public String getPluginClassName() {
        return this.pluginClassName;
    }

    public void setPluginClassName(String pluginClassName) {
        this.pluginClassName = pluginClassName;
    }

    public List<Plugin> getReportQueryPlugins() {
        return this.reportQueryPlugins;
    }

    public void setReportQueryPlugins(List<Plugin> reportQueryPlugins) {
        this.reportQueryPlugins = reportQueryPlugins;
    }

    public List<Plugin> getPluginExtplugins() {
        return this.pluginExtplugins;
    }

    public void setPluginExtplugins(List<Plugin> pluginExtplugins) {
        this.pluginExtplugins = pluginExtplugins;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public DataSource getDataSource(ReportQueryParam queryParam, Object selectedObj) {
        return DataSourceFactory.createDataSource(this.reportName, queryParam, selectedObj, this.dataSource);
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public List<AbstractReportColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<AbstractReportColumn> columns) {
        this.columns = columns;
    }

    public Object getOtherParam() {
        return this.otherParam;
    }

    public void setOtherParam(Object otherParam) {
        this.otherParam = otherParam;
    }

    public boolean isReportTree() {
        return this.isReportTree_i;
    }

    public void setReportTree(boolean isReportTree) {
        this.isReportTree_i = isReportTree;
    }

    public String getQueryDataSource() {
        return this.queryDataSource;
    }

    public void setQueryDataSource(String queryDataSource) {
        this.queryDataSource = queryDataSource;
    }

    public boolean isAsyncTotal() {
        return this.asyncTotal;
    }

    public void setAsyncTotal(boolean asyncTotal) {
        this.asyncTotal = asyncTotal;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public boolean isRelease() {
        return this.isRelease;
    }

    public void setRelease(boolean release) {
        this.isRelease = release;
    }

    public IReportListDataPlugin initQueryPlugin() {
        String pluginClassName = this.getPluginClassName();
        if (StringUtils.isEmpty((CharSequence)pluginClassName) && CollectionUtils.isEmpty(this.getReportQueryPlugins())) {
            return null;
        }
        boolean useOldPlugin = false;
        if (CollectionUtils.isEmpty(this.getReportQueryPlugins())) {
            useOldPlugin = true;
        }
        if (!useOldPlugin) {
            String pluginStr = SerializationUtils.toJsonString((Object)this.getReportQueryPlugins().get(0));
            Plugin plugin = (Plugin)SerializationUtils.fromJsonString((String)pluginStr, Plugin.class);
            if (!StringUtils.isEmpty((CharSequence)pluginClassName) && !pluginClassName.equals(plugin.getClassName())) {
                useOldPlugin = true;
            }
        }
        if (!useOldPlugin) {
            ReportServiceProxyPlugin reportQueryProxy = new ReportServiceProxyPlugin(this.getReportQueryPlugins(), 0);
            return reportQueryProxy.getQueryPlugIns().get(0);
        }
        Class reportPluginClass = TypesContainer.getOrRegister((String)pluginClassName);
        try {
            return (IReportListDataPlugin)reportPluginClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new KDException((Throwable)e, BosErrorCode.reportPluginInitError, new Object[]{"initial class AbstractReportListDataPlugin failure"});
        }
    }

    public boolean existQueryPlugin() {
        return StringUtils.isNotBlank((CharSequence)this.getPluginClassName()) || !CollectionUtils.isEmpty(this.getReportQueryPlugins());
    }
}

