/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.report;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportResultReadOption;
import kd.bos.entity.report.ReportRowSet;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ReportTaskResult
implements Serializable {
    private static final Log log = LogFactory.getLog(ReportTaskResult.class);
    private static final long serialVersionUID = 2456597746141314702L;
    private static final String SPAN_TYPE = "ReportList";
    private String resultId;
    private int rowCount;
    private List<AbstractReportColumn> reportColumns;
    private String filter2ndResultId;
    private int filter2ndRowCount;
    private Map<String, Object> filter2ndSummaryValueMap;
    private List<String> summaryTitleFields = new ArrayList<String>();
    private Map<String, Object> summaryValueMap;
    private static final String BOS_ENTITY_CORE = "bos-entity-core";

    public ReportTaskResult(String resultId, List<AbstractReportColumn> reportColumns) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"ReportTaskResult.<init>", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            this.resultId = resultId;
            this.reportColumns = reportColumns;
            this.rowCount = this.getDataSet().getRowCount();
            span.addLocaleTag("resultId", (Object)resultId);
            span.addLocaleTag("rowCount", (Object)this.rowCount);
            span.addLocaleTag("reportColumns", reportColumns);
        }
    }

    public void addSummaryTitleField(String summaryTitleField) {
        this.summaryTitleFields.add(summaryTitleField);
    }

    public List<String> getSummaryTitleFields() {
        return this.summaryTitleFields;
    }

    public void setSummaryTitleFields(List<String> summaryTitleFields) {
        this.summaryTitleFields = summaryTitleFields;
    }

    public List<AbstractReportColumn> getReportColumns() {
        return this.reportColumns;
    }

    public List<ReportColumn> getReportColumnList() {
        ArrayList<ReportColumn> cols = new ArrayList<ReportColumn>();
        this.setReportColumns(this.reportColumns, cols);
        return cols;
    }

    private void setReportColumns(List<AbstractReportColumn> acols, List<ReportColumn> cols) {
        for (AbstractReportColumn acol : acols) {
            if (acol instanceof ReportColumn) {
                cols.add((ReportColumn)acol);
                continue;
            }
            if (!(acol instanceof ReportColumnGroup)) continue;
            this.setReportColumns(((ReportColumnGroup)acol).getChildren(), cols);
        }
    }

    public Map<String, Object> getSummaryValueMap() {
        if (StringUtils.isNotBlank((CharSequence)this.filter2ndResultId) && ReportResultReadOption.isRead2ndFilterData()) {
            return this.filter2ndSummaryValueMap;
        }
        return this.summaryValueMap;
    }

    public void setSummaryValueMap(Map<String, Object> summaryValueMap) {
        this.summaryValueMap = summaryValueMap;
    }

    public ReportRowSet getData(int start, int limit) {
        return this.getData(start, limit, null);
    }

    public ReportRowSet getData(int start, int limit, String parentId) {
        return this.getData(start, limit, parentId, null);
    }

    public ReportRowSet getData(int start, int limit, String parentId, Integer currentSeq) {
        CachedDataSet dataSet = null;
        dataSet = this.isLoadFilter2ndResult() ? this.getFilter2ndDataSet() : this.getDataSet();
        return this.getData(start, limit, parentId, currentSeq, dataSet);
    }

    private ReportRowSet getData(int start, int limit, String parentId, Integer currentSeq, CachedDataSet dataSet) {
        RowMeta rowMeta = dataSet.getRowMeta();
        List<Object> rowData = null;
        if (limit > 0) {
            if (StringUtils.isBlank((CharSequence)parentId)) {
                rowData = dataSet.getList(start, limit);
            } else {
                List<Row> rows = this.getAllRowByParentId(start, limit, dataSet, parentId, currentSeq);
                if (currentSeq != null) {
                    start = 0;
                }
                rowData = rows.size() < start ? null : (rows.size() > limit + start ? rows.subList(start, limit + start) : rows.subList(start, rows.size()));
            }
        }
        return new ReportRowSet(rowMeta, rowData);
    }

    private List<Row> getAllRowByParentId(int start, int limit, CachedDataSet dataSet, String parentId, Integer currentSeq) {
        int startIndex = 0;
        int realLimit = limit;
        if (currentSeq != null) {
            startIndex = currentSeq;
        } else {
            realLimit = start + limit;
        }
        int readCount = 1000;
        if (limit > readCount) {
            readCount = limit;
        }
        ArrayList<Row> allRows = new ArrayList<Row>(limit);
        HashSet<String> allPIds = new HashSet<String>(limit);
        while (allRows.size() < realLimit && startIndex < this.rowCount) {
            List list = dataSet.getList(startIndex, readCount);
            for (Row row : list) {
                if (allRows.size() == 0 && !StringUtils.equals((CharSequence)parentId, (CharSequence)row.getString("pid"))) continue;
                if (StringUtils.equals((CharSequence)parentId, (CharSequence)row.getString("pid"))) {
                    allRows.add(row);
                } else if (!allPIds.contains(row.getString("pid"))) {
                    return allRows;
                }
                allPIds.add(row.getString("rowid"));
            }
            startIndex += readCount;
        }
        return allRows;
    }

    public int getRowCount() {
        if (this.isLoadFilter2ndResult()) {
            return this.filter2ndRowCount;
        }
        return this.rowCount;
    }

    public int getTotalCount() {
        return this.getRowCount();
    }

    public String getResultId() {
        if (this.isLoadFilter2ndResult()) {
            return this.filter2ndResultId;
        }
        return this.resultId;
    }

    private CachedDataSet getDataSet() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"ReportTaskResult.getDataSet", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            span.addTag("resultId", this.resultId);
            CachedDataSet cachedDataSet = Algo.getCacheDataSet((String)this.resultId);
            return cachedDataSet;
        }
    }

    protected boolean isLoadFilter2ndResult() {
        return StringUtils.isNotBlank((CharSequence)this.filter2ndResultId) && ReportResultReadOption.isRead2ndFilterData();
    }

    public String getFilter2ndResultId() {
        return this.filter2ndResultId;
    }

    public String getBeforeFilterResultId() {
        return this.resultId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CachedDataSet getFilter2ndDataSet() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"ReportTaskResult.getFilter2ndDataSet", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            span.addTag("filter2ndResultId", this.filter2ndResultId);
            CachedDataSet cachedDataSet = Algo.getCacheDataSet((String)this.filter2ndResultId);
            return cachedDataSet;
        }
        catch (AlgoException e) {
            String message = e.getMessage();
            log.error("\u62a5\u8868\u4e8c\u6b21\u67e5\u8be2/\u8fc7\u6ee4\u62a5\u9519", (Throwable)e);
            if (!message.startsWith("Cache dataset not found or timed out: ")) throw new KDBizException(message);
            message = ResManager.loadKDString((String)"\u754c\u9762\u8bbf\u95ee\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u6216\u5237\u65b0\u3002", (String)"ReportTaskResult_0", (String)BOS_ENTITY_CORE, (Object[])new Object[0]);
            throw new KDBizException(message);
        }
    }

    public void setFilter2ndResult(String dataSetCacheId, int rowCount, Map<String, Object> summaryValueMap) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"ReportTaskResult.setFilter2ndResult", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            span.addLocaleTag("dataSetCacheId", (Object)dataSetCacheId);
            span.addLocaleTag("rowCount", (Object)rowCount);
            span.addLocaleTag("summaryValueMap", summaryValueMap);
            if (StringUtils.isNotBlank((CharSequence)this.filter2ndResultId)) {
                Algo.removeCacheDataSet((String)this.filter2ndResultId);
                span.addLocaleTag("release.old.filter2ndResultId", (Object)this.filter2ndResultId);
            }
            this.filter2ndResultId = dataSetCacheId;
            this.filter2ndRowCount = rowCount;
            this.filter2ndSummaryValueMap = summaryValueMap;
        }
    }

    public void coverCacheResult(ReportTaskResult oldCacheResult) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"ReportTaskResult.coverCacheResult", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            if (StringUtils.isNotBlank((CharSequence)oldCacheResult.resultId) && !StringUtils.equals((CharSequence)oldCacheResult.resultId, (CharSequence)this.resultId)) {
                Algo.removeCacheDataSet((String)oldCacheResult.resultId);
                span.addLocaleTag("release.old.resultId", (Object)oldCacheResult.resultId);
            }
            if (StringUtils.isNotBlank((CharSequence)oldCacheResult.filter2ndResultId) && !StringUtils.equals((CharSequence)oldCacheResult.filter2ndResultId, (CharSequence)this.filter2ndResultId)) {
                Algo.removeCacheDataSet((String)oldCacheResult.filter2ndResultId);
                span.addLocaleTag("release.old.filter2ndResultId", (Object)oldCacheResult.filter2ndResultId);
            }
            span.addLocaleTag("cover.new.resultId", (Object)this.resultId);
            span.addLocaleTag("cover.new.filter2ndResultId", (Object)this.filter2ndResultId);
        }
    }

    public void close() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"ReportTaskResult.close", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            span.addLocaleTag("resultId", (Object)this.resultId);
            span.addLocaleTag("filter2ndResultId", (Object)this.filter2ndResultId);
            if (StringUtils.isNotBlank((CharSequence)this.filter2ndResultId)) {
                Algo.removeCacheDataSet((String)this.filter2ndResultId);
            }
            if (StringUtils.isNotBlank((CharSequence)this.resultId)) {
                Algo.removeCacheDataSet((String)this.resultId);
            }
        }
    }
}

