/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.report.ds;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.formula.FormulaEngine;
import kd.bos.fs.util.StringUtils;

public class DSHelper {
    private static final Pattern pattern = Pattern.compile("(?<=\\$\\()(.+?)(?=\\))");
    private static final Map<String, String> dataTypeMap = new HashMap<String, String>();
    private static final String DECIMAL = "decimal";

    protected static boolean pass(ReportQueryParam queryParam, String formula) {
        if (StringUtils.isEmpty((String)formula) || queryParam == null || queryParam.getFilter() == null) {
            return true;
        }
        formula = formula.trim();
        Object[] vars = FormulaEngine.extractVariables((String)formula);
        Arrays.sort(vars);
        HashMap<Object, Object> formulaCtx = new HashMap<Object, Object>(32);
        for (int i = 0; i < vars.length; ++i) {
            Object var = vars[i];
            Object val = queryParam.getFilter().getValue((String)var);
            if (val instanceof ILocaleString) {
                val = ((ILocaleString)val).getDefaultItem();
            }
            formulaCtx.put(var, val);
        }
        Object val = FormulaEngine.execExcelFormula((String)formula, formulaCtx);
        boolean pass = true;
        if (val instanceof Boolean) {
            pass = (Boolean)val;
        }
        return pass;
    }

    public static String calQueryField(ReportQueryParam queryParam, String queryField) {
        Matcher matcher = pattern.matcher(queryField);
        if (matcher.find()) {
            String filterVal = matcher.group(0);
            int start = matcher.start();
            StringBuilder select = new StringBuilder();
            select.append(queryField.substring(0, start - 2));
            int end = matcher.end();
            Object val = DSHelper.getValue(queryParam, filterVal);
            select.append(" ").append(val).append(" ");
            select.append(queryField.substring(end + 1));
            return DSHelper.calQueryField(queryParam, select.toString());
        }
        return queryField;
    }

    private static Object getValue(ReportQueryParam queryParam, String queryField) {
        String[] fields = queryField.split("\\.");
        FilterInfo filter = queryParam.getFilter();
        Object val = null;
        for (int i = 0; i < fields.length; ++i) {
            if (val == null) {
                val = filter.getValue(fields[i]);
            } else if (val instanceof DynamicObject) {
                val = ((DynamicObject)val).get(fields[i]);
            }
            if (!(val instanceof ILocaleString)) continue;
            val = ((ILocaleString)val).getDefaultItem();
        }
        return val;
    }

    protected static DynamicObject toDynamicObject(String value, MainEntityType entityType) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)entityType);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        return (DynamicObject)jser.deserializeFromString(value, null);
    }

    protected static String getDataTypeMap(String dataType) {
        return dataTypeMap.get(dataType);
    }

    static {
        dataTypeMap.put("text", "string");
        dataTypeMap.put("picture", "string");
        dataTypeMap.put("integer", "integer");
        dataTypeMap.put("date", "date");
        dataTypeMap.put("boolean", "boolean");
        dataTypeMap.put(DECIMAL, DECIMAL);
        dataTypeMap.put("amount", DECIMAL);
        dataTypeMap.put("basedata", "long");
        dataTypeMap.put("flex", "long");
        dataTypeMap.put("user", "long");
        dataTypeMap.put("currency", "long");
        dataTypeMap.put("id", "long");
    }
}

