/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.report.ds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ds.AbstractDataSource;
import kd.bos.entity.report.ds.DSHelper;
import kd.bos.entity.report.ds.FilterField;
import kd.bos.entity.report.ds.SelectField;
import kd.bos.formula.FormulaEngine;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class EntityDS
extends AbstractDataSource {
    private static final String MASTER_ID = "masterid";
    private String entityId;
    private boolean groupBy = false;
    private List<SelectField> selectFieldList = new ArrayList<SelectField>();
    private List<SelectField> NULLFieldList = new ArrayList<SelectField>();
    private List<FilterField> filterFieldList = new ArrayList<FilterField>();

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public boolean isGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(boolean groupBy) {
        this.groupBy = groupBy;
    }

    public List<SelectField> getSelectFieldList() {
        return this.selectFieldList;
    }

    public void addSelectField(SelectField field) {
        this.selectFieldList.add(field);
    }

    public List<FilterField> getFilterFieldList() {
        return this.filterFieldList;
    }

    public void addFilterField(FilterField field) {
        this.filterFieldList.add(field);
    }

    @Override
    protected void init(DynamicObject dsObj, List<AbstractDataSource> dsList, ReportQueryParam queryParam, Object selectedObj, String reportName) {
        super.init(dsObj, dsList, queryParam, selectedObj, reportName);
        String data = dsObj.getString("data");
        if (!StringUtils.isEmpty((String)data)) {
            MainEntityType entity = EntityMetadataCache.getDataEntityType((String)"ide_entityds");
            DynamicObject obj = DSHelper.toDynamicObject(data, entity);
            this.setEntityId((String)obj.get("entity_Id"));
            this.setGroupBy(obj.getBoolean("groupquery"));
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getEntityId());
            this.initSelectField(obj, entityType);
            this.initFilterField(obj, entityType);
        }
    }

    protected void initSelectField(DynamicObject obj, MainEntityType entityType) {
        DynamicObjectCollection dsColl = obj.getDynamicObjectCollection("selectentry");
        for (DynamicObject f : dsColl) {
            SelectField sf = new SelectField();
            sf.setFieldName(f.getString("fieldname"));
            sf.setDisplayname(f.getString("displayname"));
            sf.setFieldType(f.getString("datatype"));
            String cond = f.getString("scond");
            if (!DSHelper.pass(this.getQueryParam(), cond)) {
                this.NULLFieldList.add(sf);
                continue;
            }
            String queryField = f.getString("queryfield");
            queryField = this.getFieldName(entityType, queryField);
            sf.setQueryfield(queryField);
            sf.setGroupType(f.getString("grouptpye"));
            if ("date".equals(f.getString("datatype"))) {
                sf.setQueryfield("to_date(to_char(" + queryField + ",'yyyy-MM-dd'))");
            } else {
                sf.setQueryfield(queryField);
            }
            this.addSelectField(sf);
        }
    }

    protected void initFilterField(DynamicObject obj, MainEntityType entityType) {
        DynamicObjectCollection dsColl = obj.getDynamicObjectCollection("filterentry");
        for (DynamicObject f : dsColl) {
            String cond = f.getString("fcond");
            if (!DSHelper.pass(this.getQueryParam(), cond)) continue;
            FilterField sf = new FilterField();
            String filterField = f.getString("filterfield");
            filterField = this.getFieldName(entityType, filterField);
            sf.setFilterFiled(filterField);
            sf.setCompare(f.getString("compare"));
            String val = f.getString("filtervalue");
            if (StringUtils.isEmpty((String)val)) continue;
            if ("$SELECTED_NODE".equals(val)) {
                Object otherParam;
                if (this.getSelectedObj() != null && (otherParam = this.getOtherParamObj()) != null) {
                    sf.setFilterValue(otherParam);
                    sf.setValueType(2);
                }
            } else if (val.startsWith("#")) {
                sf.setFilterValue(val.substring(1));
                sf.setValueType(2);
            } else {
                sf.setFilterValue(val);
            }
            this.addFilterField(sf);
        }
    }

    private Object getOtherParamObj() {
        if (this.getSelectedObj() == null) {
            return null;
        }
        HashSet<Object> selObj = this.getSelectedObj();
        DynamicObjectCollection selColl = null;
        if (selObj instanceof DynamicObject) {
            selColl = new DynamicObjectCollection();
            selColl.add((Object)((DynamicObject)selObj));
        } else if (selObj instanceof DynamicObjectCollection) {
            selColl = (DynamicObjectCollection)selObj;
        }
        if (selColl != null) {
            DynamicObjectType entityType = selColl.getDynamicObjectType();
            DataEntityPropertyCollection props = selColl.getDynamicObjectType().getProperties();
            HashSet<Object> kSet = new HashSet<Object>();
            for (DynamicObject o : selColl) {
                kSet.add(o.getPkValue());
            }
            if (!props.containsKey((Object)"parent")) {
                selObj = kSet;
            } else {
                HashSet<Object> pkSet;
                HashSet<Object> idSet;
                block36: {
                    idSet = new HashSet<Object>();
                    pkSet = new HashSet<Object>();
                    if (props.containsKey((Object)MASTER_ID)) {
                        try (DataSet mSet = ORM.create().queryDataSet("report-entityds", entityType.getName(), MASTER_ID, new QFilter("id", "in", kSet).toArray());){
                            while (mSet.hasNext()) {
                                pkSet.add(mSet.next().getLong(MASTER_ID));
                            }
                            try (DataSet iSet = ORM.create().queryDataSet("report-entityds", entityType.getName(), "id,isleaf", new QFilter(MASTER_ID, "in", pkSet).toArray());){
                                pkSet.clear();
                                while (iSet.hasNext()) {
                                    Row obj = iSet.next();
                                    if (obj.getBoolean("isleaf").booleanValue()) {
                                        idSet.add(obj.getLong("id"));
                                        continue;
                                    }
                                    pkSet.add(obj.getLong("id"));
                                }
                                break block36;
                            }
                        }
                    }
                    idSet.addAll(kSet);
                    pkSet.addAll(kSet);
                }
                Set<Object> leafData = this.getLeafData(entityType.getName(), pkSet);
                idSet.addAll(leafData);
                selObj = idSet;
            }
        }
        return selObj;
    }

    private Set<Object> getLeafData(String entityNumber, Set<Object> pkSet) {
        DynamicObjectCollection children = ORM.create().query(entityNumber, "id,isleaf", new QFilter[]{new QFilter("parent", "in", pkSet)});
        HashSet<Object> idSet = new HashSet<Object>();
        HashSet<Object> pSet = new HashSet<Object>();
        for (DynamicObject child : children) {
            if (child.getBoolean("isleaf")) {
                idSet.add(child.getPkValue());
                continue;
            }
            pSet.add(child.getPkValue());
        }
        if (!pSet.isEmpty()) {
            Set<Object> set = this.getLeafData(entityNumber, pSet);
            idSet.addAll(set);
        }
        return idSet;
    }

    @Override
    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        HashMap<String, SelectField> fieldMap = new HashMap<String, SelectField>(32);
        for (SelectField field : this.selectFieldList) {
            fieldMap.put(field.getFieldName(), field);
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.entityId);
        this.setReportColumnProp(columns, fieldMap, entityType);
        return columns;
    }

    private void setReportColumnProp(List<AbstractReportColumn> acols, Map<String, SelectField> fieldMap, MainEntityType entityType) {
        for (AbstractReportColumn acol : acols) {
            if (acol instanceof ReportColumn) {
                DynamicProperty prop;
                ReportColumn col = (ReportColumn)acol;
                SelectField field = fieldMap.get(col.getFieldKey());
                if (field == null || !((prop = entityType.getProperty(field.getFieldName())) instanceof BasedataProp)) continue;
                BasedataProp p = (BasedataProp)prop;
                col.setEntityId(p.getBaseEntityId());
                continue;
            }
            if (!(acol instanceof ReportColumnGroup)) continue;
            this.setReportColumnProp(((ReportColumnGroup)acol).getChildren(), fieldMap, entityType);
        }
    }

    @Override
    public DataSet createDataSet() {
        ORM orm = ORM.create();
        StringBuilder selectFields = new StringBuilder();
        for (SelectField f : this.selectFieldList) {
            if (selectFields.length() > 0) {
                selectFields.append(",");
            }
            selectFields.append(f.getQueryfield()).append(" ").append(f.getFieldName());
        }
        List<QFilter> qfilters = this.getQFilter(this.getQueryParam());
        QFilter commFilter = this.getQueryParam().getFilter().getCommFilter(this.getEntityId());
        if (commFilter != null) {
            qfilters.add(commFilter);
        }
        DataSet ds = orm.queryDataSet(this.getReportName(), this.getEntityId(), selectFields.toString(), qfilters.toArray(new QFilter[0]));
        if (this.isGroupBy()) {
            HashMap<String, String> spf = new HashMap<String, String>();
            ArrayList<String> gpf = new ArrayList<String>();
            for (SelectField selectField : this.selectFieldList) {
                String string = selectField.getGroupType();
                if (StringUtils.isEmpty((String)string)) {
                    gpf.add(selectField.getFieldName());
                    continue;
                }
                spf.put(selectField.getFieldName(), string);
            }
            GroupbyDataSet gpds = ds.groupBy(gpf.toArray(new String[0]));
            for (Map.Entry entry : spf.entrySet()) {
                String fName = (String)entry.getKey();
                String gpType = (String)entry.getValue();
                if ("1".equals(gpType)) {
                    gpds = gpds.sum(fName);
                    continue;
                }
                if ("2".equals(gpType)) {
                    gpds = gpds.count(fName);
                    continue;
                }
                if ("3".equals(gpType)) {
                    gpds = gpds.max(fName);
                    continue;
                }
                if ("4".equals(gpType)) {
                    gpds = gpds.min(fName);
                    continue;
                }
                if (!"5".equals(gpType)) continue;
                gpds = gpds.avg(fName);
            }
            ds = gpds.finish();
        }
        if (!this.NULLFieldList.isEmpty()) {
            ArrayList<String> sel = new ArrayList<String>(20);
            for (SelectField f : this.selectFieldList) {
                sel.add(f.getFieldName());
            }
            for (SelectField f : this.NULLFieldList) {
                String string = DSHelper.getDataTypeMap(f.getFieldType());
                sel.add("cast(NULL as " + string + ") as " + f.getFieldName());
            }
            ds = ds.select(sel.toArray(new String[0]));
        }
        return ds;
    }

    private String getFieldName(MainEntityType entityType, String queryField) {
        String[] vars;
        for (String var : vars = this.getVars(queryField)) {
            String v = var.split("\\.")[0];
            IDataEntityProperty prop = entityType.findProperty(v);
            if (prop == null) continue;
            for (IDataEntityType parent = prop.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.getName().equals(this.getEntityId())) continue;
                queryField = parent.getName() + "." + queryField;
            }
        }
        return queryField;
    }

    private String[] getVars(String formula) {
        Object[] vars = FormulaEngine.extractVariables((String)formula);
        Arrays.sort(vars);
        return vars;
    }

    private QFilter getQFilter(FilterField f, Object filterVal) {
        if ("like".equals(f.getCompare())) {
            return new QFilter(f.getFilterFiled(), f.getCompare(), (Object)("%" + filterVal + "%"));
        }
        if ("Like".equals(f.getCompare())) {
            return new QFilter(f.getFilterFiled(), f.getCompare(), (Object)(filterVal + "%"));
        }
        if ("lIKE".equals(f.getCompare())) {
            return new QFilter(f.getFilterFiled(), f.getCompare(), (Object)("%" + filterVal));
        }
        return new QFilter(f.getFilterFiled(), f.getCompare(), filterVal);
    }

    private List<QFilter> getQFilter(ReportQueryParam queryParam) {
        ArrayList<QFilter> qfilter = new ArrayList<QFilter>();
        if (this.filterFieldList.isEmpty() || queryParam.getFilter() == null) {
            return qfilter;
        }
        FilterInfo filter = queryParam.getFilter();
        for (FilterField f : this.filterFieldList) {
            Object filterVal;
            if (f.getValueType() == 2) {
                String valStr;
                if (f.getFilterValue() instanceof String && (valStr = ((String)f.getFilterValue()).trim()).startsWith("[") && valStr.endsWith("]")) {
                    String[] vals = valStr.substring(1, valStr.length() - 1).split(",");
                    f.setFilterValue(Arrays.asList(vals));
                }
                if (f.getFilterValue() instanceof Set || f.getFilterValue() instanceof List) {
                    f.setCompare("in");
                }
                qfilter.add(this.getQFilter(f, f.getFilterValue()));
                continue;
            }
            if (f.getValueType() != 1 || (filterVal = this.getFilterValue(filter, (String)f.getFilterValue())) == null) continue;
            if (filterVal instanceof DynamicObject) {
                filterVal = ((DynamicObject)filterVal).getPkValue();
                qfilter.add(new QFilter(f.getFilterFiled(), f.getCompare(), filterVal));
                continue;
            }
            if (filterVal instanceof DynamicObjectCollection) {
                ArrayList<Object> pkValues = new ArrayList<Object>();
                for (DynamicObject dynamicObject : (DynamicObjectCollection)filterVal) {
                    pkValues.add(dynamicObject.getPkValue());
                }
                qfilter.add(new QFilter(f.getFilterFiled(), "in", pkValues));
                continue;
            }
            if ((!(filterVal instanceof String) || StringUtils.isEmpty((String)((String)filterVal))) && filterVal instanceof String) continue;
            qfilter.add(this.getQFilter(f, filterVal));
        }
        return qfilter;
    }

    private Object getFilterValue(FilterInfo filter, String filterField) {
        if (filterField == null) {
            return null;
        }
        String[] fields = filterField.split("\\.");
        Object val = filter.getValue(fields[0]);
        if (fields.length > 1 && val instanceof DynamicObject) {
            val = this.getValue((DynamicObject)val, Arrays.copyOfRange(fields, 1, fields.length));
        }
        return val;
    }

    private Object getValue(DynamicObject obj, String[] fields) {
        Object value = obj.get(fields[0]);
        if (fields.length > 1 && value instanceof DynamicObject) {
            return this.getValue(obj, Arrays.copyOfRange(fields, 1, fields.length));
        }
        return value;
    }
}

