/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.report.ds;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ds.AbstractDataSource;
import kd.bos.entity.report.ds.DSHelper;
import kd.bos.entity.report.ds.SelectField;
import kd.bos.entity.report.ds.SortField;
import kd.bos.fs.util.StringUtils;

public class SortDS
extends AbstractDataSource {
    private String ds;
    private List<SelectField> selectFieldList = new ArrayList<SelectField>();
    private List<SortField> sortFieldList = new ArrayList<SortField>();

    @Override
    protected void init(DynamicObject dsObj, List<AbstractDataSource> dsList, ReportQueryParam queryParam, Object selectedObj, String reportName) {
        super.init(dsObj, dsList, queryParam, selectedObj, reportName);
        String data = dsObj.getString("data");
        if (!StringUtils.isEmpty((String)data)) {
            MainEntityType entity = EntityMetadataCache.getDataEntityType((String)"ide_sortds");
            DynamicObject obj = DSHelper.toDynamicObject(data, entity);
            this.ds = obj.getString("ds");
            this.initSelectField(obj);
            this.initSortField(obj);
        }
    }

    protected void initSelectField(DynamicObject obj) {
        DynamicObjectCollection dsColl = obj.getDynamicObjectCollection("selectentry");
        for (DynamicObject f : dsColl) {
            SelectField sf = new SelectField();
            sf.setFieldName(f.getString("fieldname"));
            sf.setDisplayname(f.getString("displayname"));
            sf.setQueryfield(f.getString("queryfield"));
            sf.setFieldType(f.getString("datatype"));
            this.addSelectField(sf);
        }
    }

    protected void initSortField(DynamicObject obj) {
        DynamicObjectCollection dsColl = obj.getDynamicObjectCollection("orderentry");
        for (DynamicObject f : dsColl) {
            SortField sf = new SortField();
            sf.setSortField(f.getString("orderfield"));
            sf.setSortType(f.getString("ordertype"));
            this.addSortField(sf);
        }
    }

    private void addSelectField(SelectField field) {
        this.selectFieldList.add(field);
    }

    private void addSortField(SortField field) {
        this.sortFieldList.add(field);
    }

    @Override
    public DataSet createDataSet() {
        AbstractDataSource ds = this.getDS();
        if (ds == null) {
            return null;
        }
        DataSet set = ds.getDataSet();
        ArrayList<String> sortFields = new ArrayList<String>(20);
        for (SortField sortField : this.sortFieldList) {
            sortFields.add(sortField.getSortField() + " " + sortField.getSortType());
        }
        set = set.orderBy(sortFields.toArray(new String[0]));
        ArrayList<String> selector = new ArrayList<String>(20);
        Pattern pattern = Pattern.compile("lastrow(\\s*)\\(");
        for (SelectField selectField : this.selectFieldList) {
            String str = selectField.getQueryfield();
            Matcher m = pattern.matcher(str);
            while (m.find()) {
                StringBuilder select = new StringBuilder();
                select.append(str.substring(0, m.start()));
                int beginIndex = m.end();
                int endIndex = str.indexOf(")", beginIndex);
                String field = str.substring(beginIndex, endIndex);
                String fieldType = StringUtils.isEmpty((String)field) ? DSHelper.getDataTypeMap(selectField.getFieldType()) : this.getFieldType(field);
                select.append("cast(PreRowValue(").append(field).append(") as ").append(fieldType).append(")");
                select.append(str.substring(endIndex + 1));
                str = select.toString();
                m = pattern.matcher(str);
            }
            selector.add(str + " as " + selectField.getFieldName());
        }
        return set.select(selector.toArray(new String[0]));
    }

    private String getFieldType(String fieldName) {
        for (SelectField selectField : this.selectFieldList) {
            if (!selectField.getFieldName().equals(fieldName)) continue;
            String fieldType = selectField.getFieldType();
            return DSHelper.getDataTypeMap(fieldType);
        }
        return null;
    }

    private AbstractDataSource getDS() {
        if (StringUtils.isEmpty((String)this.ds)) {
            return null;
        }
        for (AbstractDataSource ds : this.getDSList()) {
            if (!ds.getNumber().equals(this.ds)) continue;
            return ds;
        }
        return null;
    }
}

