/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.report.parser;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.parser.IParser;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateParser
implements IParser {
    public QFilter buildQFilterByFilterItem(FilterItemInfo filterItem) {
        QFilter qfilter = null;
        Date minDateTime = null;
        Date maxDateTime = null;
        if ("TODAY".equals(filterItem.getCompareType())) {
            minDateTime = this.addDays(0);
            maxDateTime = this.addDays(1);
        }
        if ("THISWEEK".equals(filterItem.getCompareType())) {
            minDateTime = KDDateUtils.getTheWeekStart((int)0, (Date)this.getBaseToday());
            maxDateTime = KDDateUtils.getTheWeekEnd((int)0, (Date)this.getBaseToday());
        }
        if ("THISMONTH".equals(filterItem.getCompareType())) {
            minDateTime = KDDateUtils.getTheMonthStart((int)0, (Date)this.getBaseToday());
            maxDateTime = KDDateUtils.getTheMonthEnd((int)0, (Date)this.getBaseToday());
        }
        if ("LASTMONTH".equals(filterItem.getCompareType())) {
            minDateTime = KDDateUtils.getTheMonthStart((int)-1, (Date)this.getBaseToday());
            maxDateTime = KDDateUtils.getTheMonthEnd((int)-1, (Date)this.getBaseToday());
        }
        if ("LASTTHREEMONTH".equals(filterItem.getCompareType())) {
            minDateTime = this.getTheMonthWithoutOffsetStart(-3);
            maxDateTime = this.addDays(1);
        }
        if ("BETWEEN".equals(filterItem.getCompareType())) {
            List list = (List)filterItem.getValue();
            minDateTime = this.convertStrToDate(list.get(0).toString());
            maxDateTime = this.convertStrToDate(list.get(1).toString());
        }
        qfilter = new QFilter(filterItem.getPropName(), ">=", (Object)minDateTime).and(new QFilter(filterItem.getPropName(), "<", (Object)maxDateTime));
        return qfilter;
    }

    Date getBaseToday() {
        return KDDateUtils.today();
    }

    Date addDays(int diff) {
        return DateUtils.addDays((Date)this.getBaseToday(), (int)diff);
    }

    Date getTheMonthWithoutOffsetStart(int diff) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this.getBaseToday());
        ((Calendar)calendar).add(2, diff);
        return calendar.getTime();
    }

    private Date convertStrToDate(String str) {
        try {
            return KDDateUtils.parseDateTime((String)str);
        }
        catch (KDBizException exp) {
            return KDDateUtils.parseDate((String)str);
        }
    }
}

