/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation;

import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.IOperationServicePlugIn;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidatePriority;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.service.operation.plugin.DeleteRefStatusOpPlugin;
import kd.bos.service.operation.validate.BaseDataDeleteValidator;
import kd.bos.service.operation.validate.DeleteEmptyIdValidator;
import kd.bos.servicehelper.operation.RecordSaveFormServiceHelper;

public class Delete
extends EntityOperateService {
    private DeleteEmptyIdValidator deleteEmptyIdValidator;

    @Override
    public void initialize(MainEntityType entityType, String operationKey, DynamicObject[] dataEntities) {
        super.initialize(entityType, operationKey, dataEntities);
        if (entityType instanceof BasedataEntityType) {
            DeleteRefStatusOpPlugin deleteRefStatusPlugin = new DeleteRefStatusOpPlugin();
            deleteRefStatusPlugin.setContext(entityType, this.operateMetaMap, this.getOption());
            this.getPlugInProxy().registerPlugIn((IOperationServicePlugIn)deleteRefStatusPlugin);
        }
    }

    @Override
    public OperationResult excute(Object[] ids) throws Exception {
        this.getDeleteEmptyIdValidator().setIdCount(ids.length);
        return super.excute(ids);
    }

    @Override
    protected void beforeCallOperationTransaction(DynamicObject[] objs) {
        super.beforeCallOperationTransaction(objs);
    }

    @Override
    protected void executeOperate(DynamicObject[] objs) {
        Object[] pks = new Object[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            pks[i] = objs[i].getPkValue();
        }
        BusinessDataWriter.delete((IDataEntityType)this.billEntityType, (Object[])pks);
    }

    @Override
    protected DynamicObject[] callOperation(DynamicObject[] objs) {
        DynamicObject[] objects = super.callOperation(objs);
        return objects;
    }

    @Override
    protected void callOperationTransaction(DynamicObject[] objs) throws Exception {
        super.callOperationTransaction(objs);
        if (this.getBillEntityType() != null && this.getBillEntityType().getName() != null) {
            RecordSaveFormServiceHelper.recordSaveFormToCache((String)this.getBillEntityType().getName());
        }
    }

    @Override
    protected void release() {
        super.release();
    }

    @Override
    protected void rollback(DynamicObject[] objs, Exception ex) {
        super.rollback(objs, ex);
    }

    @Override
    protected void addDefaultValidator(List<AbstractValidator> validators) {
        super.addDefaultValidator(validators);
        if (this.billEntityType instanceof BasedataEntityType) {
            String entityKey = this.billEntityType.getName();
            String operateName = (String)((Map)this.operateMetaMap.get("name")).get(ResManager.getLanguage());
            String operateType = (String)this.operateMetaMap.get("type");
            BaseDataDeleteValidator validator = new BaseDataDeleteValidator();
            validator.setValidatePriority(ValidatePriority.Last);
            validator.setOption(this.getOption());
            validator.setEntityType((BasedataEntityType)this.billEntityType);
            validator.setEntityKey(entityKey);
            validator.setOperationName(operateName);
            validator.setOperateKey(this.operationKey);
            validator.setOperateType(operateType);
            validators.add(validator);
        }
        validators.add(this.getDeleteEmptyIdValidator());
    }

    private DeleteEmptyIdValidator getDeleteEmptyIdValidator() {
        if (this.deleteEmptyIdValidator == null) {
            this.deleteEmptyIdValidator = new DeleteEmptyIdValidator();
        }
        return this.deleteEmptyIdValidator;
    }
}

