/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DBRoute;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.IOperationServicePlugIn;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.service.operation.StatusConvertOperateService;
import kd.bos.service.operation.plugin.MasterIdSetValuePlugin;
import kd.bos.service.operation.plugin.MulilangTextSetValuePlugin;
import kd.bos.service.operation.plugin.UpdateEntrySummaryPlugin;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class Draft
extends StatusConvertOperateService {
    protected Map<DynamicObject, Boolean> dynamicObjectFromDbMap = new HashMap<DynamicObject, Boolean>();

    @Override
    public void initialize(MainEntityType entityType, String operationKey, DynamicObject[] dataEntites) {
        super.initialize(entityType, operationKey, dataEntites);
        if (entityType instanceof BasedataEntityType) {
            MasterIdSetValuePlugin plugin = new MasterIdSetValuePlugin();
            plugin.setContext(entityType, this.operateMetaMap, this.getOption());
            this.getPlugInProxy().registerPlugIn((IOperationServicePlugIn)plugin);
        }
        RefObject opValue = new RefObject();
        this.getOption().tryGetVariableValue("mulilangtext.emptyfill.enable", opValue);
        if (Boolean.parseBoolean((String)opValue.getValue())) {
            MulilangTextSetValuePlugin langPlugin = new MulilangTextSetValuePlugin();
            langPlugin.setContext(entityType, this.operateMetaMap, this.getOption());
            this.getPlugInProxy().registerPlugIn((IOperationServicePlugIn)langPlugin);
        }
        boolean updateEntrySummaryEnable = Boolean.parseBoolean(this.getOption().getVariableValue("updateEntrySummaryEnable", String.valueOf(false)));
        if (entityType instanceof BillEntityType && updateEntrySummaryEnable) {
            UpdateEntrySummaryPlugin updateSummaryPlugin = new UpdateEntrySummaryPlugin();
            updateSummaryPlugin.setContext(entityType, this.operateMetaMap, this.getOption());
            this.getPlugInProxy().registerPlugIn((IOperationServicePlugIn)updateSummaryPlugin);
        }
    }

    @Override
    protected void preparePropertys(Object[] ids, List<String> fieldKeys) {
        super.preparePropertys(ids, fieldKeys);
    }

    @Override
    protected void beforeCallOperationTransaction(DynamicObject[] objs) {
        DBRoute rt = new DBRoute(this.getBillEntityType().getDBRouteKey());
        SequenceReader seqReader = new SequenceReader(rt);
        seqReader.autoSetPrimaryKey((Object[])objs, (IDataEntityType)this.subEntityType);
        super.beforeCallOperationTransaction(objs);
    }

    @Override
    protected void afterUpdateBillStatus(DynamicObject[] objs) {
        super.afterUpdateBillStatus(objs);
    }

    @Override
    protected void executeOperate(DynamicObject[] objs) {
        SaveServiceHelper.save((DynamicObject[])objs, (OperateOption)this.getOption());
        Arrays.stream(objs).forEach(dynamicObject -> this.dynamicObjectFromDbMap.put((DynamicObject)dynamicObject, dynamicObject.getDataEntityState().getFromDatabase()));
    }

    @Override
    protected DynamicObject[] callOperation(DynamicObject[] objs) {
        DynamicObject[] objects = super.callOperation(objs);
        return objects;
    }

    @Override
    protected void callOperationTransaction(DynamicObject[] objs) throws Exception {
        super.callOperationTransaction(objs);
    }

    @Override
    protected void release() {
        super.release();
    }

    @Override
    protected void rollback(DynamicObject[] objs, Exception ex) {
        super.rollback(objs, ex);
    }

    @Override
    protected void updateBillSysField(DynamicObject[] objs) {
        super.updateBillSysField(objs);
        this.updateModifier(objs);
    }

    @Override
    protected boolean isSplitPage(DynamicObject[] dataEntities) {
        return false;
    }

    @Override
    protected String getLogOperateName(DynamicObject dynamicObject) {
        String opName = null;
        Boolean fromDB = this.dynamicObjectFromDbMap.get(dynamicObject);
        opName = fromDB == null ? this.getOpName() : (fromDB != false ? ResManager.loadKDString((String)"\u4fee\u6539\u4fdd\u5b58", (String)"Draft_1", (String)"bos-mservice-operation", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u65b0\u589e\u4fdd\u5b58", (String)"Draft_0", (String)"bos-mservice-operation", (Object[])new Object[0]));
        return opName;
    }

    @Override
    protected MultiLangEnumBridge getOpLogName(DynamicObject dynamicObject) {
        MultiLangEnumBridge multiLangOpName = null;
        Boolean fromDB = this.dynamicObjectFromDbMap.get(dynamicObject);
        if (fromDB == null) {
            return null;
        }
        multiLangOpName = fromDB != false ? new MultiLangEnumBridge("\u4fee\u6539\u4fdd\u5b58", "Draft_1", "bos-mservice-operation") : new MultiLangEnumBridge("\u65b0\u589e\u4fdd\u5b58", "Draft_0", "bos-mservice-operation");
        return multiLangOpName;
    }
}

